/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="The flood algorithm uses an declining flood peak to accpect new solutions (*shudder* check inital flood peak and drain very carefully!).")
public class FloodAlgorithm
extends AbstractOptimizer
implements Serializable {
    private int multiRuns = 100;
    private int fitnessCalls = 100;
    private int fitnessCallsNeeded = 0;
    GAIndividualBinaryData bestIndividual;
    GAIndividualBinaryData testIndividual;
    public double initialFloodPeak = 2000.0;
    public double currentFloodPeak;
    public double drainRate = 1.0;

    public FloodAlgorithm() {
        this.population = new Population();
        this.population.setTargetSize(10);
    }

    public FloodAlgorithm(FloodAlgorithm a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.initialFloodPeak = a.initialFloodPeak;
        this.drainRate = a.drainRate;
    }

    @Override
    public Object clone() {
        return new FloodAlgorithm(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.optimizationProblem.evaluate(this.population);
        this.currentFloodPeak = this.initialFloodPeak;
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.optimizationProblem.evaluate(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
        this.currentFloodPeak = this.initialFloodPeak;
    }

    @Override
    public void optimize() {
        int i;
        Population original = (Population)this.population.clone();
        for (i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)this.population.get(i);
            double tmpD = indy.getMutationProbability();
            indy.setMutationProbability(1.0);
            indy.mutate();
            indy.setMutationProbability(tmpD);
        }
        this.optimizationProblem.evaluate(this.population);
        for (i = 0; i < this.population.size(); ++i) {
            double[] fitness = ((AbstractEAIndividual)this.population.get(i)).getFitness();
            if (!(fitness[0] > this.currentFloodPeak)) continue;
            this.population.remove(i);
            this.population.add(i, original.get(i));
        }
        this.currentFloodPeak -= this.drainRate;
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private double calculateDelta(AbstractEAIndividual org, AbstractEAIndividual mut) {
        double result = 0.0;
        double[] fitOrg = org.getFitness();
        double[] fitMut = mut.getFitness();
        for (int i = 0; i < fitOrg.length; ++i) {
            result += fitOrg[i] - fitMut[i];
        }
        return result;
    }

    public void defaultInit() {
        this.fitnessCallsNeeded = 0;
        this.bestIndividual = new GAIndividualBinaryData();
        this.bestIndividual.defaultInit(this.optimizationProblem);
    }

    public void defaultOptimize() {
        for (int i = 0; i < this.fitnessCalls; ++i) {
            this.testIndividual = (GAIndividualBinaryData)this.bestIndividual.clone();
            this.testIndividual.defaultMutate();
            if (this.testIndividual.defaultEvaulateAsMiniBits() < this.bestIndividual.defaultEvaulateAsMiniBits()) {
                this.bestIndividual = this.testIndividual;
            }
            this.fitnessCallsNeeded = i;
            if (this.bestIndividual.defaultEvaulateAsMiniBits() != 0.0) continue;
            i = this.fitnessCalls + 1;
        }
    }

    public static void main() {
        FloodAlgorithm program = new FloodAlgorithm();
        int TmpMeanCalls = 0;
        int TmpMeanFitness = 0;
        for (int i = 0; i < program.multiRuns; ++i) {
            program.defaultInit();
            program.defaultOptimize();
            TmpMeanCalls += program.fitnessCallsNeeded;
            TmpMeanFitness = (int)((double)TmpMeanFitness + program.bestIndividual.defaultEvaulateAsMiniBits());
        }
        System.out.println("(" + program.multiRuns + "/" + program.fitnessCalls + ") Mean Fitness : " + (TmpMeanFitness /= program.multiRuns) + " Mean Calls needed: " + (TmpMeanCalls /= program.multiRuns));
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = this.population.size() > 1 ? result + "Multi(" + this.population.size() + ")-Start Hill Climbing:\n" : result + "Simulated Annealing:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "MS-FA";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public double getInitialFloodPeak() {
        return this.initialFloodPeak;
    }

    public void setInitialFloodPeak(double pop) {
        this.initialFloodPeak = pop;
    }

    public String initialFloodPeakTipText() {
        return "Set the initial flood peak.";
    }

    public double getDrainRate() {
        return this.drainRate;
    }

    @Parameter(description="Set the drain rate that reduces the current flood level each generation.")
    public void setDrainRate(double a) {
        this.drainRate = a;
        if (this.drainRate < 0.0) {
            this.drainRate = 0.0;
        }
    }
}

