/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.operator.selection.SelectXProbRouletteWheel;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="This is a basic generational Genetic Algorithm.")
public class GeneticAlgorithm
extends AbstractOptimizer
implements Serializable {
    private InterfaceSelection parentSelection = new SelectXProbRouletteWheel();
    private InterfaceSelection partnerSelection = new SelectRandom();
    private boolean useElitism = true;
    private int plague = 0;
    private int numberOfPartners = 1;

    public GeneticAlgorithm() {
    }

    public GeneticAlgorithm(GeneticAlgorithm ga) {
        this.population = (Population)ga.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)ga.optimizationProblem.clone();
        this.plague = ga.plague;
        this.numberOfPartners = ga.numberOfPartners;
        this.useElitism = ga.useElitism;
        this.parentSelection = (InterfaceSelection)ga.parentSelection.clone();
        this.partnerSelection = (InterfaceSelection)ga.partnerSelection.clone();
    }

    @Override
    public Object clone() {
        return new GeneticAlgorithm(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.optimizationProblem.initializePopulation(this.population);
            this.population.initialize();
            this.evaluatePopulation(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    private Population generateChildren() {
        Population result = this.population.cloneWithoutInds();
        this.parentSelection.prepareSelection(this.population);
        this.partnerSelection.prepareSelection(this.population);
        Population parents = this.parentSelection.selectFrom(this.population, this.population.getTargetSize());
        if (parents.getEAIndividual(0).getMutationOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getMutationOperator())).adaptAfterSelection(this.population, parents);
        }
        if (parents.getEAIndividual(0).getCrossoverOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getCrossoverOperator())).adaptAfterSelection(this.population, parents);
        }
        for (int i = 0; i < parents.size(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)parents.get(i);
            if (tmpIndy == null) {
                System.out.println("Individual null " + i + " Population size: " + parents.size());
            }
            if (this.population == null) {
                System.out.println("population null " + i);
            }
            AbstractEAIndividual[] offSprings = tmpIndy.mateWith(this.partnerSelection.findPartnerFor(tmpIndy, this.population, this.numberOfPartners));
            offSprings[0].mutate();
            result.add(i, offSprings[0]);
        }
        this.evaluatePopulation(result);
        if (parents.getEAIndividual(0).getMutationOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getMutationOperator())).adaptGenerational(this.population, parents, result, true);
        }
        if (parents.getEAIndividual(0).getCrossoverOperator() instanceof InterfaceAdaptOperatorGenerational) {
            ((InterfaceAdaptOperatorGenerational)((Object)parents.getEAIndividual(0).getCrossoverOperator())).adaptGenerational(this.population, parents, result, true);
        }
        return result;
    }

    @Override
    public void optimize() {
        Population nextGeneration = this.generateChildren();
        if (this.useElitism) {
            AbstractEAIndividual elite = this.population.getBestEAIndividual();
            if (elite != null) {
                this.population = nextGeneration;
                this.population.remove(0);
                this.population.add(elite);
            }
        } else {
            this.population = nextGeneration;
        }
        if (this.plague > 0) {
            for (int i = 0; i < this.plague; ++i) {
                if (this.population.size() <= 2) continue;
                this.population.remove(this.population.getWorstEAIndividual());
            }
            this.population.setTargetSize(this.population.size());
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Genetic Algorithm:\n";
        result = result + "Using:\n";
        result = result + " Population Size    = " + this.population.getTargetSize() + "/" + this.population.size() + "\n";
        result = result + " Parent Selection   = " + this.parentSelection.getClass().toString() + "\n";
        result = result + " Partner Selection  = " + this.partnerSelection.getClass().toString() + "\n";
        result = result + " Number of Partners = " + this.numberOfPartners + "\n";
        result = result + " Elitism            = " + this.useElitism + "\n";
        result = result + "=> The Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        return result;
    }

    @Override
    public String getName() {
        return "Genetic Algorithm";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    @Parameter(description="Choose a parent selection method.")
    public void setParentSelection(InterfaceSelection selection) {
        this.parentSelection = selection;
    }

    public InterfaceSelection getParentSelection() {
        return this.parentSelection;
    }

    @Parameter(description="Enable/disable elitism.")
    public void setElitism(boolean elitism) {
        this.useElitism = elitism;
    }

    public boolean getElitism() {
        return this.useElitism;
    }

    @Parameter(name="partners", description="The number of mating partners needed to create offsprings.")
    public void setNumberOfPartners(int partners) {
        if (partners < 0) {
            partners = 0;
        }
        this.numberOfPartners = partners;
    }

    public int getNumberOfPartners() {
        return this.numberOfPartners;
    }

    @Parameter(description="Choose a selection method for selecting recombination partners for given parents.")
    public void setPartnerSelection(InterfaceSelection selection) {
        this.partnerSelection = selection;
    }

    public InterfaceSelection getPartnerSelection() {
        return this.partnerSelection;
    }
}

