/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The Hill Climber uses the default EA mutation and initializing operators. If the population size is bigger than one a multi-start Hill Climber is performed.")
public class HillClimbing
extends AbstractOptimizer
implements Serializable {
    private InterfaceMutation mutator = null;

    public HillClimbing() {
        this.population = new Population();
        this.population.setTargetSize(10);
    }

    public HillClimbing(HillClimbing a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
    }

    @Override
    public Object clone() {
        return new HillClimbing(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.optimizationProblem.evaluate(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.optimizationProblem.evaluate(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void optimize() {
        int i;
        Population original = (Population)this.population.clone();
        for (i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)this.population.get(i);
            double tmpD = indy.getMutationProbability();
            indy.setMutationProbability(1.0);
            if (this.mutator == null) {
                indy.mutate();
            } else {
                this.mutator.mutate(indy);
            }
            indy.setMutationProbability(tmpD);
        }
        this.optimizationProblem.evaluate(this.population);
        for (i = 0; i < this.population.size(); ++i) {
            if (!((AbstractEAIndividual)original.get(i)).isDominatingDebConstraints((AbstractEAIndividual)this.population.get(i))) continue;
            this.population.set(i, (AbstractEAIndividual)original.get(i));
        }
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    public InterfaceMutation getMutationOperator() {
        return this.mutator;
    }

    public void setMutationOperator(InterfaceMutation mute) {
        this.mutator = mute;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = this.population.size() > 1 ? result + "Multi(" + this.population.size() + ")-Start Hill Climbing:\n" : result + "Hill Climbing:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "MS-HC";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }
}

