/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.operator.migration.InterfaceMigration;
import eva2.optimization.operator.migration.SOBestMigration;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.F1Problem;
import eva2.problems.F8Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;

@Description(value="This is an island model EA distributing the individuals across several (remote) CPUs for optimization.")
public class IslandModelEA
implements InterfacePopulationChangedEventListener,
InterfaceOptimizer,
Serializable {
    private Population population = new Population();
    private InterfaceOptimizer optimizer = new GeneticAlgorithm();
    private InterfaceMigration migration = new SOBestMigration();
    private InterfaceOptimizationProblem optimizationProblem = new F8Problem();
    private int migrationRate = 10;
    private boolean heterogeneousProblems = false;
    private int numLocalCPUs = 1;
    private boolean numLocalOnly = false;
    private transient InterfaceOptimizer[] islands;
    private boolean logLocalChanges = true;
    private boolean show = false;
    private transient Plot plot = null;
    private transient String identifier = "";
    private transient InterfacePopulationChangedEventListener populationChangedEventListener;

    public IslandModelEA() {
    }

    public IslandModelEA(IslandModelEA a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.optimizer = (InterfaceOptimizer)a.optimizer.clone();
        this.migration = (InterfaceMigration)a.migration.clone();
        this.migrationRate = a.migrationRate;
        this.heterogeneousProblems = a.heterogeneousProblems;
        this.numLocalCPUs = a.numLocalCPUs;
        this.numLocalOnly = a.numLocalOnly;
    }

    @Override
    public Object clone() {
        return new IslandModelEA(this);
    }

    @Override
    public void initialize() {
        if (this.show && this.plot == null) {
            double[] tmpD = new double[]{0.0, 0.0};
            this.plot = new Plot("Island Model EA", "FitnessCalls", "Fitness", tmpD, tmpD);
        }
        this.population.clear();
        this.population.initialize();
        this.optimizer.initialize();
        this.optimizer.setProblem(this.optimizationProblem);
        this.optimizer.setPopulation((Population)this.population.clone());
        Object myLocal = null;
        if (this.numLocalOnly) {
            this.islands = new InterfaceOptimizer[this.numLocalCPUs];
            for (int i = 0; i < this.numLocalCPUs; ++i) {
                this.islands[i] = (InterfaceOptimizer)this.optimizer.clone();
                this.islands[i].initialize();
                if (!this.logLocalChanges) continue;
                this.islands[i].addPopulationChangedEventListener(this);
            }
        }
        this.migration.initializeMigration(this.islands);
        this.population.incrGeneration();
        for (int i = 0; i < this.islands.length; ++i) {
            Population pop = (Population)this.islands[i].getPopulation().clone();
            this.population.addPopulation(pop);
            this.population.incrFunctionCallsBy(pop.getFunctionCalls());
            if (this.islands[i].getPopulation().getGeneration() == this.population.getGeneration()) continue;
            System.err.println("Error, inconsistent generations!");
        }
        this.firePropertyChangedEvent("NextGenerationPerformed", this.optimizer.getPopulation());
    }

    @Override
    public void initializeByPopulation(Population tpop, boolean reset) {
        if (this.show && this.plot == null) {
            double[] tmpD = new double[]{0.0, 0.0};
            this.plot = new Plot("Island Model EA", "FitnessCalls", "Fitness", tmpD, tmpD);
        }
        this.population = (Population)tpop.clone();
        if (reset) {
            this.population.initialize();
            this.population.incrGeneration();
        }
        this.optimizer.initialize();
        this.optimizer.setProblem(this.optimizationProblem);
        Object myLocal = null;
        if (this.numLocalOnly) {
            this.islands = new InterfaceOptimizer[this.numLocalCPUs];
            for (int i = 0; i < this.numLocalCPUs; ++i) {
                this.islands[i] = (InterfaceOptimizer)this.optimizer.clone();
                this.islands[i].initialize();
                if (!this.logLocalChanges) continue;
                this.islands[i].addPopulationChangedEventListener(this);
            }
        }
        this.migration.initializeMigration(this.islands);
        for (int i = 0; i < this.islands.length; ++i) {
            Population pop = (Population)this.islands[i].getPopulation().clone();
            this.population.addPopulation(pop);
            this.population.incrFunctionCallsBy(pop.getFunctionCalls());
        }
        this.firePropertyChangedEvent("NextGenerationPerformed", this.optimizer.getPopulation());
    }

    @Override
    public void optimize() {
        int i;
        for (i = 0; i < this.islands.length; ++i) {
            if (this.islands[i].getPopulation().size() > 0) {
                this.islands[i].optimize();
                continue;
            }
            this.islands[i].getPopulation().incrGeneration();
        }
        this.population.incrGeneration();
        if (this.population.getGeneration() % this.migrationRate == 0) {
            this.communicate();
        }
        if (this.heterogeneousProblems) {
            for (i = 0; i < this.islands.length; ++i) {
                this.islands[i].getProblem().evaluate(this.islands[i].getPopulation());
            }
        }
        System.gc();
    }

    private void communicate() {
        int i;
        boolean allReachedG = false;
        int G = this.population.getGeneration();
        while (!allReachedG) {
            allReachedG = true;
            String gen = "[";
            for (i = 0; i < this.islands.length; ++i) {
                gen = gen + this.islands[i].getPopulation().getGeneration() + "; ";
                if (this.islands[i].getPopulation().getGeneration() == G) continue;
                allReachedG = false;
            }
            if (allReachedG) continue;
            System.out.println("Waiting...." + gen + "] ?= " + G);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                System.err.println("Error in sleep of XThread");
            }
        }
        this.population.clear();
        this.population.setFunctionCalls(0);
        for (i = 0; i < this.islands.length; ++i) {
            Population pop = (Population)this.islands[i].getPopulation().clone();
            this.population.addPopulation(pop);
            this.population.incrFunctionCallsBy(pop.getFunctionCalls());
        }
        this.firePropertyChangedEvent("NextGenerationPerformed", this.optimizer.getPopulation());
        double plotValue = this.optimizationProblem.getDoublePlotValue(this.population);
        if (this.show) {
            this.plot.setConnectedPoint(this.population.getFunctionCalls(), plotValue, 0);
        }
        this.migration.migrate(this.islands);
    }

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        this.populationChangedEventListener = ea;
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.populationChangedEventListener == ea) {
            this.populationChangedEventListener = null;
            return true;
        }
        return false;
    }

    protected void firePropertyChangedEvent(String name, Population population) {
        if (this.populationChangedEventListener != null) {
            this.populationChangedEventListener.registerPopulationStateChanged(this, name);
        }
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        this.optimizer.setProblem(problem);
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Island Model Evolutionary Algorithm:\n";
        result = result + "Using:\n";
        result = result + " Migration Strategy    = " + this.migration.getClass().toString() + "\n";
        result = result + " Migration rate        = " + this.migrationRate + "\n";
        result = result + " Local only       = " + this.numLocalOnly + "\n";
        result = result + " Het. Problems         = " + this.heterogeneousProblems + "\n";
        if (this.heterogeneousProblems) {
            result = result + " Heterogenuous Optimizers: \n";
            for (int i = 0; i < this.islands.length; ++i) {
                result = result + this.islands[i].getStringRepresentation() + "\n";
            }
        } else {
            result = result + " Homogeneous Optimizer = " + this.optimizer.getClass().toString() + "\n";
            result = result + this.optimizer.getStringRepresentation() + "\n";
        }
        return result;
    }

    public static void main(String[] args) {
        IslandModelEA imea = new IslandModelEA();
        imea.show = true;
        imea.numLocalOnly = false;
        imea.optimizationProblem = new F8Problem();
        ((F1Problem)imea.optimizationProblem).setEAIndividual(new ESIndividualDoubleData());
        imea.migrationRate = 15;
        imea.initialize();
        while (imea.getPopulation().getFunctionCalls() < 25000) {
            imea.optimize();
        }
        System.out.println("System.exit(0);");
    }

    public InterfaceOptimizer[] getOptimizers() {
        return this.islands;
    }

    public void setHeterogeneousProblems(boolean t) {
        this.heterogeneousProblems = t;
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        InterfaceOptimizer opt = (InterfaceOptimizer)source;
        int sourceID = 12;
        double cFCOpt = opt.getPopulation().getFunctionCalls();
        double plotValue = this.optimizationProblem.getDoublePlotValue(opt.getPopulation());
        if (this.show) {
            this.plot.setConnectedPoint(cFCOpt, plotValue, sourceID + 1);
        }
    }

    @Override
    public String getName() {
        return "IslandEA";
    }

    public void setLocalOnly(boolean b) {
        this.numLocalOnly = b;
    }

    public String localOnlyTipText() {
        return "Toggle between usage of local CPUs and remote servers.";
    }

    public boolean getShow() {
        return this.show;
    }

    public void setShow(boolean b) {
        this.show = b;
        this.logLocalChanges = b;
    }

    public String showTipText() {
        return "This will show the local performance.";
    }

    public InterfaceOptimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(InterfaceOptimizer b) {
        this.optimizer = b;
    }

    public String optimizerTipText() {
        return "Choose a population based optimizing technique to use.";
    }

    public InterfaceMigration getMigrationStrategy() {
        return this.migration;
    }

    public void setMigrationStrategy(InterfaceMigration b) {
        this.migration = b;
    }

    public String migrationStrategyTipText() {
        return "Choose a migration strategy to use.";
    }

    public int getMigrationRate() {
        return this.migrationRate;
    }

    public void setMigrationRate(int b) {
        this.migrationRate = b;
    }

    public String migrationRateTipText() {
        return "Set the migration rate for communication between islands.";
    }

    public String serversTipText() {
        return "Choose and manage the servers (only active in parallelized mode).";
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    @Override
    public void setPopulation(Population pop) {
        this.population = pop;
    }

    public String populationTipText() {
        return "(Defunct)";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setNumberLocalCPUs(int n) {
        if (n >= 1) {
            this.numLocalCPUs = n;
        } else {
            System.err.println("Number of CPUs must be at least 1!");
        }
    }

    public String numberLocalCPUsTipText() {
        return "Set the number of local CPUS (>=1, only used in local mode).";
    }
}

