/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.tools.Pair;
import eva2.tools.math.SpecialFunction;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

@Description(value="Modified implementation of the Linkage Tree Genetic Algorithm.")
public class MLTGA
extends AbstractOptimizer
implements Serializable,
InterfacePopulationChangedEventListener {
    private static final Logger LOGGER = Logger.getLogger(MLTGA.class.getName());
    private int probDim = 8;
    private int fitCrit = -1;
    private int popSize = 50;
    private AbstractEAIndividual template = null;
    private int generationCycle = 500;
    private boolean elitism = true;

    public MLTGA() {
    }

    public MLTGA(MLTGA l) {
        this.probDim = l.probDim;
        this.popSize = l.popSize;
        this.population = (Population)l.population.clone();
        this.optimizationProblem = (AbstractOptimizationProblem)l.optimizationProblem.clone();
        this.template = (AbstractEAIndividual)this.template.clone();
    }

    @Override
    public Object clone() {
        return new MLTGA(this);
    }

    @Override
    public String getName() {
        return "Mutating Linkage Tree Genetic Algorithm";
    }

    private void defaultInit() {
        if (this.population == null) {
            this.population = new Population(this.popSize);
        } else {
            this.population.setTargetPopSize(this.popSize);
        }
        this.template = ((AbstractOptimizationProblem)this.optimizationProblem).getIndividualTemplate();
        if (!(this.template instanceof InterfaceDataTypeBinary)) {
            LOGGER.log(Level.WARNING, "Requiring binary data!");
        } else {
            Object dim = BeanInspector.callIfAvailable(this.optimizationProblem, "getProblemDimension", null);
            if (dim == null) {
                LOGGER.log(Level.WARNING, "Couldn't get problem dimension!");
            }
            this.probDim = (Integer)dim;
            ((InterfaceDataTypeBinary)((Object)this.template)).setBinaryGenotype(new BitSet(this.probDim));
        }
        this.population.addPopulationChangedEventListener(this);
        this.population.setNotifyEvalInterval(this.generationCycle);
    }

    private static BitSet getBinaryData(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceGAIndividual) {
            return ((InterfaceGAIndividual)((Object)indy)).getBGenotype();
        }
        if (indy instanceof InterfaceDataTypeBinary) {
            return ((InterfaceDataTypeBinary)((Object)indy)).getBinaryData();
        }
        throw new RuntimeException("Unable to get binary representation for " + indy.getClass());
    }

    @Override
    public void initialize() {
        this.defaultInit();
        this.optimizationProblem.initializePopulation(this.population);
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private void evaluatePopulation(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.evaluate(pop.getEAIndividual(i));
        }
    }

    private void evaluate(AbstractEAIndividual indy) {
        if (indy == null) {
            LOGGER.log(Level.WARNING, "tried to evaluate null");
            return;
        }
        this.optimizationProblem.evaluate(indy);
        this.population.incrFunctionCalls();
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        if (reset) {
            this.initialize();
        } else {
            this.defaultInit();
            this.population = pop;
        }
    }

    private Stack<Set<Integer>> buildLinkageTree() {
        Stack<Set<Integer>> linkageTree = new Stack<Set<Integer>>();
        Stack<Set<Integer>> workingTree = new Stack<Set<Integer>>();
        for (int i = 0; i < this.probDim; ++i) {
            HashSet<Integer> s1 = new HashSet<Integer>();
            HashSet<Integer> s2 = new HashSet<Integer>();
            s1.add(i);
            s2.add(i);
            linkageTree.add(s1);
            workingTree.add(s2);
        }
        while (workingTree.size() > 1) {
            Pair<Set<Integer>, Set<Integer>> toCluster = this.findNearestClusters(workingTree);
            ((Set)toCluster.head).addAll((Collection)toCluster.tail);
            workingTree.remove(toCluster.tail);
            linkageTree.add((Set<Integer>)toCluster.head);
        }
        return linkageTree;
    }

    private Pair<Set<Integer>, Set<Integer>> findNearestClusters(Stack<Set<Integer>> stack) {
        Set bestI = new HashSet();
        Set bestJ = new HashSet();
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < stack.size(); ++i) {
            Set s1 = (Set)stack.get(i);
            for (int j = i + 1; j < stack.size(); ++j) {
                Set s2 = (Set)stack.get(j);
                double currDist = this.calculateDistance(s1, s2);
                if (!(currDist < bestScore)) continue;
                bestI = s1;
                bestJ = s2;
                bestScore = currDist;
            }
        }
        return new Pair<Set<Integer>, Set<Integer>>(bestI, bestJ);
    }

    private double calculateDistance(Set<Integer> s1, Set<Integer> s2) {
        double entropy1 = this.calculateEntropy(s1);
        double entropy2 = this.calculateEntropy(s2);
        HashSet<Integer> combined = new HashSet<Integer>();
        combined.addAll(s1);
        combined.addAll(s2);
        double entropy3 = this.calculateEntropy(combined);
        return 2.0 - (entropy1 + entropy2) / entropy3;
    }

    private double calculateEntropy(Set<Integer> s) {
        double entropy = 0.0;
        for (int i = 0; i <= 1; ++i) {
            int count = 0;
            for (int k = 0; k < this.popSize; ++k) {
                BitSet b = MLTGA.getBinaryData(this.population.getEAIndividual(k));
                boolean addCount = true;
                for (Integer value : s) {
                    if (b.get(value) == (i == 1)) continue;
                    addCount = false;
                    break;
                }
                if (addCount) {
                    ++count;
                }
                addCount = true;
            }
            entropy += (double)count * SpecialFunction.logb(count, 2.0);
            count = 0;
        }
        return entropy;
    }

    @Override
    public void optimize() {
        ((AbstractOptimizationProblem)this.optimizationProblem).evaluatePopulationStart(this.population);
        Stack<Set<Integer>> linkageTree = this.buildLinkageTree();
        Population newPop = new Population(this.popSize);
        if (this.elitism) {
            AbstractEAIndividual firstIndy = this.population.getBestEAIndividual();
            AbstractEAIndividual firstNewIndy = this.buildNewIndy(firstIndy, linkageTree);
            newPop.add(firstNewIndy);
        }
        for (int i = 0; i < this.popSize; ++i) {
            if (this.elitism && i == 0) continue;
            Population indies = this.population.getRandNIndividuals(1);
            AbstractEAIndividual newIndy = this.buildNewIndy(indies.getEAIndividual(0), linkageTree);
            newPop.add(newIndy);
        }
        this.population.clear();
        this.population.addAll(newPop);
        ((AbstractOptimizationProblem)this.optimizationProblem).evaluatePopulationEnd(this.population);
    }

    private AbstractEAIndividual buildNewIndy(AbstractEAIndividual indy, Stack<Set<Integer>> linkageTree) {
        for (Set set : linkageTree) {
            BitSet gen = MLTGA.getBinaryData(indy);
            BitSet newGene = (BitSet)gen.clone();
            for (Integer flipID : set) {
                newGene.flip(flipID);
            }
            AbstractEAIndividual newIndy = (AbstractEAIndividual)this.template.clone();
            ((InterfaceDataTypeBinary)((Object)newIndy)).setBinaryGenotype(newGene);
            this.evaluate(newIndy);
            if (!(newIndy.getFitness(0) < indy.getFitness(0))) continue;
            indy = newIndy;
        }
        return indy;
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.population);
    }

    public boolean getElitism() {
        return this.elitism;
    }

    public void setElitism(boolean b) {
        this.elitism = b;
    }

    public String elitismTipText() {
        return "use elitism?";
    }

    @Override
    public String getStringRepresentation() {
        return "Linkage Tree GA";
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.compareTo("FunCallIntervalReached") == 0) {
            this.population.setFunctionCalls(((Population)source).getFunctionCalls());
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    public static void main(String[] args) {
        MLTGA ltga = new MLTGA();
        ltga.initialize();
        ltga.optimize();
        System.out.println(ltga.popSize);
        Population p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
        ltga.optimize();
        p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
        ltga.optimize();
        p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
        ltga.optimize();
        p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
        ltga.optimize();
        p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
        ltga.optimize();
        p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
        ltga.optimize();
        p = ltga.getPopulation();
        System.out.println(p.getFunctionCalls() + "\t" + p.size());
        System.out.println(p.getBestEAIndividual().getStringRepresentation());
    }
}

