/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceLocalSearchable;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;
import java.util.Hashtable;

@Description(value="This is a basic generational Memetic Algorithm. Local search steps are performed on a selected subset of individuals after certain numbers of global search iterations. Note that the problem class must implement InterfaceLocalSearchable.")
public class MemeticAlgorithm
implements InterfaceOptimizer,
Serializable {
    private static final long serialVersionUID = -1730086430763348568L;
    private int localSearchSteps = 1;
    private int subsetsize = 5;
    private int globalSearchIterations = 1;
    private boolean lamarckism = true;
    private String identifier = "";
    private InterfaceOptimizationProblem optimizationProblem = new F1Problem();
    private InterfaceOptimizer globalOptimizer = new GeneticAlgorithm();
    private InterfaceSelection selectorPlug = new SelectBestIndividuals();
    private transient InterfacePopulationChangedEventListener populationChangedEventListener;

    public MemeticAlgorithm() {
    }

    public MemeticAlgorithm(MemeticAlgorithm a) {
        this.optimizationProblem = (InterfaceLocalSearchable)a.optimizationProblem.clone();
        this.globalOptimizer = a.globalOptimizer;
        this.selectorPlug = a.selectorPlug;
        this.identifier = a.identifier;
        this.localSearchSteps = a.localSearchSteps;
        this.subsetsize = a.subsetsize;
        this.globalSearchIterations = a.globalSearchIterations;
        this.lamarckism = a.lamarckism;
    }

    @Override
    public Object clone() {
        return new MemeticAlgorithm(this);
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.setPopulation((Population)pop.clone());
        if (reset) {
            this.getPopulation().initialize();
            this.optimizationProblem.evaluate(this.getPopulation());
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void initialize() {
        this.globalOptimizer.setProblem(this.optimizationProblem);
        this.globalOptimizer.initialize();
        this.evaluatePopulation(this.globalOptimizer.getPopulation());
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    @Override
    public void optimize() {
        this.globalOptimizer.optimize();
        if (this.globalSearchIterations > 0 && this.globalOptimizer.getPopulation().getGeneration() % this.globalSearchIterations == 0 && this.localSearchSteps > 0 && this.optimizationProblem instanceof InterfaceLocalSearchable) {
            int i;
            Population gop = this.globalOptimizer.getPopulation();
            Population subset = this.selectorPlug.selectFrom(gop, this.subsetsize);
            Population subsetclone = new Population();
            for (int i2 = 0; i2 < subset.size(); ++i2) {
                subsetclone.add((AbstractEAIndividual)((AbstractEAIndividual)subset.get(i2)).clone());
            }
            if (subset.size() != this.subsetsize) {
                System.err.println("ALERT! identical individual instances in subset");
            }
            Hashtable<AbstractEAIndividual, AbstractEAIndividual> antilamarckismcache = new Hashtable<AbstractEAIndividual, AbstractEAIndividual>();
            if (!this.lamarckism) {
                for (int i3 = 0; i3 < subset.size(); ++i3) {
                    AbstractEAIndividual indy = (AbstractEAIndividual)subset.get(i3);
                    AbstractEAIndividual indyclone = (AbstractEAIndividual)subsetclone.get(i3);
                    antilamarckismcache.put(indy, indyclone);
                }
            }
            double cost = ((InterfaceLocalSearchable)this.optimizationProblem).getLocalSearchStepFunctionCallEquivalent();
            for (i = 0; i < this.localSearchSteps; ++i) {
                ((InterfaceLocalSearchable)this.optimizationProblem).doLocalSearch(subsetclone);
            }
            this.optimizationProblem.evaluate(subsetclone);
            if (this.lamarckism) {
                gop.removeAll(subset);
                gop.addPopulation(subsetclone);
            } else {
                for (i = 0; i < subset.size(); ++i) {
                    AbstractEAIndividual indy = (AbstractEAIndividual)subset.get(i);
                    try {
                        AbstractEAIndividual newindy = (AbstractEAIndividual)antilamarckismcache.get(indy);
                        indy.setFitness(newindy.getFitness());
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("individual not found in antilamarckismcache");
                    }
                }
            }
            gop.setFunctionCalls(gop.getFunctionCalls() + (int)Math.round((double)this.localSearchSteps * cost * (double)subset.size()));
            this.setPopulation(gop);
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        this.populationChangedEventListener = ea;
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.populationChangedEventListener == ea) {
            this.populationChangedEventListener = null;
            return true;
        }
        return false;
    }

    protected void firePropertyChangedEvent(String name) {
        if (this.populationChangedEventListener != null) {
            this.populationChangedEventListener.registerPopulationStateChanged(this, name);
        }
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        this.globalOptimizer.setProblem(this.optimizationProblem);
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Memetic Algorithm:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.globalOptimizer.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "MemeticAlgorithm";
    }

    @Override
    public Population getPopulation() {
        return this.globalOptimizer.getPopulation();
    }

    @Override
    public void setPopulation(Population pop) {
        this.globalOptimizer.setPopulation(pop);
    }

    public void setGlobalOptimizer(InterfaceOptimizer globalOptimizer) {
        this.globalOptimizer = globalOptimizer;
        this.globalOptimizer.setProblem(this.getProblem());
        this.initialize();
    }

    public InterfaceOptimizer getGlobalOptimizer() {
        return this.globalOptimizer;
    }

    public String globalOptimizerTipText() {
        return "Choose the global optimization strategy to use.";
    }

    public void setLocalSearchSteps(int localSearchSteps) {
        this.localSearchSteps = localSearchSteps;
    }

    public int getLocalSearchSteps() {
        return this.localSearchSteps;
    }

    public String localSearchStepsTipText() {
        return "Choose the number of local search steps to perform per selected individual.";
    }

    public void setGlobalSearchIterations(int globalSearchSteps) {
        this.globalSearchIterations = globalSearchSteps;
    }

    public int getGlobalSearchIterations() {
        return this.globalSearchIterations;
    }

    public String globalSearchIterationsTipText() {
        return "Choose the interval between the application of the local search.";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setSubsetsize(int subsetsize) {
        this.subsetsize = subsetsize;
    }

    public int getSubsetsize() {
        return this.subsetsize;
    }

    public String subsetsizeTipText() {
        return "Choose the number of individuals to be locally optimized.";
    }

    public void setLamarckism(boolean lamarckism) {
        this.lamarckism = lamarckism;
    }

    public String lamarckismTipText() {
        return "Toggle between Lamarckism and the Baldwin Effect.";
    }

    public boolean isLamarckism() {
        return this.lamarckism;
    }

    public InterfaceSelection getSubSetSelector() {
        return this.selectorPlug;
    }

    public void setSubSetSelector(InterfaceSelection selectorPlug) {
        this.selectorPlug = selectorPlug;
    }

    public String subSetSelectorTipText() {
        return "Selection method to select the subset on which local search is to be performed.";
    }
}

