/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The Monte Carlo Search repeatively creates random individuals and stores the best individuals found.")
public class MonteCarloSearch
extends AbstractOptimizer
implements Serializable {
    private int multiRuns = 100;
    private int fitnessCalls = 100;
    private int fitnessCallsNeeded = 0;
    private GAIndividualBinaryData bestIndividual;

    public MonteCarloSearch() {
        this.population = new Population();
        this.population.setTargetSize(50);
    }

    public MonteCarloSearch(MonteCarloSearch a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
    }

    @Override
    public Object clone() {
        return new MonteCarloSearch(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.optimizationProblem.evaluate(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.optimizationProblem.evaluate(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void optimize() {
        int i;
        Population original = (Population)this.population.clone();
        for (i = 0; i < this.population.size(); ++i) {
            this.population.getEAIndividual(i).defaultInit(null);
        }
        this.population.setFunctionCalls(original.getFunctionCalls());
        this.optimizationProblem.evaluate(this.population);
        for (i = 0; i < this.population.size(); ++i) {
            if (!((AbstractEAIndividual)original.get(i)).isDominatingDebConstraints((AbstractEAIndividual)this.population.get(i))) continue;
            this.population.remove(i);
            this.population.add(i, original.get(i));
        }
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    public void defaultInit() {
        this.fitnessCallsNeeded = 0;
        this.bestIndividual = new GAIndividualBinaryData();
        this.bestIndividual.defaultInit(this.optimizationProblem);
    }

    public void defaultOptimize() {
        for (int i = 0; i < this.fitnessCalls; ++i) {
            GAIndividualBinaryData testIndividial = new GAIndividualBinaryData();
            testIndividial.defaultInit(this.optimizationProblem);
            if (testIndividial.defaultEvaulateAsMiniBits() < this.bestIndividual.defaultEvaulateAsMiniBits()) {
                this.bestIndividual = testIndividial;
            }
            this.fitnessCallsNeeded = i;
            if (this.bestIndividual.defaultEvaulateAsMiniBits() != 0.0) continue;
            i = this.fitnessCalls + 1;
        }
    }

    public static void main(String[] args) {
        MonteCarloSearch program = new MonteCarloSearch();
        int TmpMeanCalls = 0;
        int TmpMeanFitness = 0;
        for (int i = 0; i < program.multiRuns; ++i) {
            program.defaultInit();
            program.defaultOptimize();
            TmpMeanCalls += program.fitnessCallsNeeded;
            TmpMeanFitness = (int)((double)TmpMeanFitness + program.bestIndividual.defaultEvaulateAsMiniBits());
        }
        System.out.println("(" + program.multiRuns + "/" + program.fitnessCalls + ") Mean Fitness : " + (TmpMeanFitness /= program.multiRuns) + " Mean Calls needed: " + (TmpMeanCalls /= program.multiRuns));
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Monte-Carlo Search:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "MCS";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }
}

