/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.archiving.ArchivingNSGAIISMeasure;
import eva2.optimization.operator.mutation.MutateESCovarianceMatrixAdaptionPlus;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.HashMap;

@Description(value="A multi-objective CMA-ES variant after Igel, Hansen and Roth 2007 (EC 15(1),1-28).")
public class MultiObjectiveCMAES
extends AbstractOptimizer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int lambda = 1;
    private int lambdaMO = 1;

    public MultiObjectiveCMAES() {
        this.population = new Population(this.lambdaMO);
    }

    public MultiObjectiveCMAES(MultiObjectiveCMAES a) {
        this.optimizationProblem = (AbstractOptimizationProblem)a.optimizationProblem.clone();
        this.setPopulation((Population)a.population.clone());
        this.lambda = a.lambda;
    }

    @Override
    public MultiObjectiveCMAES clone() {
        return new MultiObjectiveCMAES(this);
    }

    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        Population pop = this.getPopulation();
        return new SolutionSet(pop, pop);
    }

    @Override
    public String getName() {
        return "(1+" + this.lambda + ") MO-CMA-ES";
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder strB = new StringBuilder(200);
        strB.append("(1+" + this.lambda + ") MO-CMA-ES:\nOptimization Problem: ");
        strB.append(this.optimizationProblem.getStringRepresentationForProblem(this));
        strB.append("\n");
        strB.append(this.population.getStringRepresentation());
        return strB.toString();
    }

    @Override
    public void initialize() {
        this.population.setTargetSize(this.lambdaMO);
        this.optimizationProblem.initializePopulation(this.population);
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.setPopulation(pop);
        if (reset) {
            this.optimizationProblem.initializePopulation(this.population);
            this.optimizationProblem.evaluate(this.population);
        }
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
    }

    @Override
    public void optimize() {
        AbstractEAIndividual indy;
        int j;
        HashMap<Long, CounterClass> SuccessCounterMap = new HashMap<Long, CounterClass>();
        for (int j2 = 0; j2 < this.lambdaMO && j2 < this.population.size(); ++j2) {
            this.population.getEAIndividual(j2).putData("Parent", this.population.getEAIndividual(j2));
            SuccessCounterMap.put(this.population.getEAIndividual(j2).getIndyID(), new CounterClass(0));
        }
        Population children = new Population(this.lambdaMO * this.lambda);
        children.setGeneration(this.population.getGeneration());
        for (int j3 = 0; j3 < children.getTargetSize(); ++j3) {
            AbstractEAIndividual parent = this.population.getEAIndividual(j3 % this.lambdaMO);
            AbstractEAIndividual indy2 = (AbstractEAIndividual)parent.clone();
            indy2.mutate();
            indy2.putData("Parent", parent);
            children.add(indy2);
        }
        this.evaluatePopulation(children);
        this.population.addPopulation(children);
        ArchivingNSGAIISMeasure dummyArchive = new ArchivingNSGAIISMeasure();
        Population[] store = dummyArchive.getNonDominatedSortedFronts(this.population);
        store = dummyArchive.getNonDominatedSortedFronts(this.population);
        ((ArchivingNSGAII)dummyArchive).calculateCrowdingDistance(store);
        for (j = 0; j < this.population.size(); ++j) {
            AbstractEAIndividual parent = (AbstractEAIndividual)this.population.getEAIndividual(j).getData("Parent");
            if (this.population.getEAIndividual(j) != parent) {
                int parentParetoLevel = (Integer)parent.getData("ParetoLevel");
                double parentSMeasure = (Double)parent.getData("HyperCube");
                int childParetoLevel = (Integer)this.population.getEAIndividual(j).getData("ParetoLevel");
                double childSMeasure = (Double)this.population.getEAIndividual(j).getData("HyperCube");
                if (childParetoLevel >= parentParetoLevel && (childParetoLevel != parentParetoLevel || !(childSMeasure > parentSMeasure))) continue;
                ++((CounterClass)SuccessCounterMap.get((Object)Long.valueOf((long)parent.getIndyID()))).value;
                continue;
            }
            ((CounterClass)SuccessCounterMap.get((Object)Long.valueOf((long)parent.getIndyID()))).seen = true;
        }
        this.population.clear();
        for (int i = 0; i < store.length; ++i) {
            if (this.population.size() + store[i].size() <= this.lambdaMO) {
                this.population.addPopulation(store[i]);
                continue;
            }
            while (store[i].size() > 0 && this.population.size() < this.lambdaMO) {
                indy = store[i].getEAIndividual(0);
                double bestMeasure = (Double)indy.getData("HyperCube");
                for (int j4 = 1; j4 < store[i].size(); ++j4) {
                    if (!(bestMeasure < (Double)store[i].getEAIndividual(j4).getData("HyperCube"))) continue;
                    bestMeasure = (Double)store[i].getEAIndividual(j4).getData("HyperCube");
                    indy = store[i].getEAIndividual(j4);
                }
                this.population.add(indy);
                store[i].removeMember(indy);
            }
        }
        for (j = 0; j < this.population.size(); ++j) {
            indy = this.population.getEAIndividual(j);
            if (!(indy.getMutationOperator() instanceof MutateESCovarianceMatrixAdaptionPlus)) continue;
            AbstractEAIndividual parent = (AbstractEAIndividual)indy.getData("Parent");
            MutateESCovarianceMatrixAdaptionPlus muta = (MutateESCovarianceMatrixAdaptionPlus)indy.getMutationOperator();
            double rate = (double)((CounterClass)SuccessCounterMap.get((Object)Long.valueOf((long)parent.getIndyID()))).value / (double)this.lambda;
            if (indy != parent) {
                muta.updateCovariance();
            }
            muta.updateStepSize(rate);
        }
        for (j = 0; j < children.size(); ++j) {
            children.getEAIndividual(j).putData("Parent", null);
        }
        this.population.incrFunctionCallsBy(children.size());
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void setPopulation(Population pop) {
        this.population = pop;
        this.population.setNotifyEvalInterval(1);
        this.lambdaMO = this.population.getTargetSize();
    }

    public int getLambda() {
        return this.lambda;
    }

    public void setLambda(int mLambda) {
        this.lambda = mLambda;
    }

    class CounterClass {
        public int value;
        public boolean seen = false;

        public CounterClass(int i) {
            this.value = i;
        }
    }
}

