/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.archiving.InformationRetrievalInserting;
import eva2.optimization.operator.archiving.InterfaceArchiving;
import eva2.optimization.operator.archiving.InterfaceInformationRetrieval;
import eva2.optimization.operator.selection.SelectMONonDominated;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.FM0Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;

@Description(value="This is a general Multi-objective Evolutionary Optimization Framework.")
public class MultiObjectiveEA
implements InterfaceOptimizer,
Serializable {
    private InterfaceOptimizer optimizer = new GeneticAlgorithm();
    private InterfaceArchiving archiver = new ArchivingNSGAII();
    private InterfaceInformationRetrieval informationRetrieval = new InformationRetrievalInserting();
    private InterfaceOptimizationProblem optimizationProblem = new FM0Problem();
    private String identifier = "";
    private transient InterfacePopulationChangedEventListener populationChangedEventListener;

    public MultiObjectiveEA() {
        this.optimizer.getPopulation().setTargetSize(100);
        ((GeneticAlgorithm)this.optimizer).setParentSelection(new SelectMONonDominated());
        ((GeneticAlgorithm)this.optimizer).setPartnerSelection(new SelectMONonDominated());
    }

    public MultiObjectiveEA(MultiObjectiveEA a) {
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.optimizer = (InterfaceOptimizer)a.optimizer.clone();
        this.archiver = (InterfaceArchiving)a.archiver.clone();
        this.informationRetrieval = (InterfaceInformationRetrieval)a.informationRetrieval.clone();
    }

    public MultiObjectiveEA(InterfaceOptimizer subOpt, InterfaceArchiving archiving, int archiveSize, InterfaceInformationRetrieval infoRetrieval, AbstractOptimizationProblem problem) {
        this.setOptimizer(subOpt);
        this.setArchivingStrategy(archiving);
        this.setArchiveSize(archiveSize);
        this.setInformationRetrieval(infoRetrieval);
        this.setProblem(problem);
    }

    @Override
    public Object clone() {
        return new MultiObjectiveEA(this);
    }

    @Override
    public void initialize() {
        this.optimizer.initialize();
        this.archiver.addElementsToArchive(this.optimizer.getPopulation());
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.optimizer.initializeByPopulation(pop, reset);
        this.archiver.addElementsToArchive(this.optimizer.getPopulation());
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void optimize() {
        this.optimizer.optimize();
        this.archiver.addElementsToArchive(this.optimizer.getPopulation());
        this.informationRetrieval.retrieveInformationFrom(this.optimizer.getPopulation());
        System.gc();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private double[][] showMay(Population pop) {
        Population tmp = new Population();
        tmp.addPopulation(pop);
        if (pop.getArchive() != null) {
            tmp.addPopulation(pop.getArchive());
        }
        double[][] fitness = new double[tmp.size()][];
        for (int i = 0; i < tmp.size(); ++i) {
            fitness[i] = ((AbstractEAIndividual)tmp.get(i)).getFitness();
        }
        double[] minY = fitness[0];
        double[] maxY = fitness[0];
        for (int i = 1; i < fitness.length; ++i) {
            if (minY[0] > fitness[i][0]) {
                minY = fitness[i];
            }
            if (!(maxY[1] > fitness[i][1])) continue;
            maxY = fitness[i];
        }
        double[][] result = new double[][]{minY, maxY};
        return result;
    }

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        this.populationChangedEventListener = ea;
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.populationChangedEventListener == ea) {
            this.populationChangedEventListener = null;
            return true;
        }
        return false;
    }

    protected void firePropertyChangedEvent(String name) {
        if (this.populationChangedEventListener != null) {
            this.populationChangedEventListener.registerPopulationStateChanged(this, name);
        }
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        this.optimizer.setProblem(problem);
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Multi-Objective Evolutionary Algorithm:\n";
        result = result + "Using:\n";
        result = result + " Archiving Strategy    = " + this.archiver.getClass().toString() + "\n";
        result = result + " Information Retrieval = " + this.informationRetrieval.getClass().toString() + "\n";
        result = result + " Information Retrieval = " + this.getClass().toString() + "\n";
        result = result + " Optimizer             = " + this.optimizer.getClass().toString() + "\n";
        result = result + this.optimizer.getStringRepresentation() + "\n";
        return result;
    }

    @Override
    public String getName() {
        return "MOEA";
    }

    @Override
    public Population getPopulation() {
        return this.optimizer.getPopulation();
    }

    @Override
    public void setPopulation(Population pop) {
        this.optimizer.setPopulation(pop);
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation(), ArchivingNSGAII.getNonDominatedSortedFront(this.getPopulation().getArchive()).getSortedPop(new EAIndividualComparator(0)));
    }

    public InterfaceOptimizer getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(InterfaceOptimizer b) {
        this.optimizer = b;
    }

    public String optimizerTipText() {
        return "Choose a population based optimizing technique to use.";
    }

    public InterfaceArchiving getArchivingStrategy() {
        return this.archiver;
    }

    public void setArchivingStrategy(InterfaceArchiving b) {
        this.archiver = b;
    }

    public String archivingStrategyTipText() {
        return "Choose the archiving strategy.";
    }

    public InterfaceInformationRetrieval getInformationRetrieval() {
        return this.informationRetrieval;
    }

    public void setInformationRetrieval(InterfaceInformationRetrieval b) {
        this.informationRetrieval = b;
    }

    public String informationRetrievalTipText() {
        return "Choose the Information Retrieval strategy.";
    }

    public int getArchiveSize() {
        Population archive = this.optimizer.getPopulation().getArchive();
        if (archive == null) {
            archive = new Population();
            this.optimizer.getPopulation().SetArchive(archive);
        }
        return archive.getTargetSize();
    }

    public void setArchiveSize(int b) {
        Population archive = this.optimizer.getPopulation().getArchive();
        if (archive == null) {
            archive = new Population();
            this.optimizer.getPopulation().SetArchive(archive);
        }
        archive.setTargetSize(b);
    }

    public String archiveSizeTipText() {
        return "Choose the size of the archive.";
    }
}

