/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="The Nelder-Mead simplex search algorithm for local search. Reflection on bounds may be used for constraint handling.")
public class NelderMeadSimplex
extends AbstractOptimizer
implements Serializable,
InterfacePopulationChangedEventListener {
    private int populationSize = 100;
    private int generationCycle = 50;
    private int fitIndex = 0;
    private boolean checkConstraints = true;

    public NelderMeadSimplex() {
        this.setPopulation(new Population(this.populationSize));
    }

    public NelderMeadSimplex(int popSize) {
        this.populationSize = popSize;
        this.setPopulation(new Population(this.populationSize));
    }

    public NelderMeadSimplex(NelderMeadSimplex a) {
        this.optimizationProblem = (AbstractOptimizationProblem)a.optimizationProblem.clone();
        this.setPopulation((Population)a.population.clone());
        this.populationSize = a.populationSize;
        this.generationCycle = a.generationCycle;
    }

    @Override
    public NelderMeadSimplex clone() {
        return new NelderMeadSimplex(this);
    }

    public boolean setProblemAndPopSize(InterfaceOptimizationProblem problem) {
        this.setProblem(problem);
        if (this.optimizationProblem instanceof AbstractProblemDouble) {
            this.setPopulationSize(problem.getProblemDimension() + 1);
            return true;
        }
        Object ret = BeanInspector.callIfAvailable(problem, "getProblemDimension", null);
        if (ret != null) {
            this.setPopulationSize((Integer)ret + 1);
            return true;
        }
        return false;
    }

    protected double[] calcChallengeVect(double[] centroid, double[] refX) {
        double[] r = new double[centroid.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = 2.0 * centroid[i] - refX[i];
        }
        return r;
    }

    protected boolean firstIsBetter(double[] first, double[] second) {
        return first[this.fitIndex] < second[this.fitIndex];
    }

    protected boolean firstIsBetterEqual(double[] first, double[] second) {
        return first[this.fitIndex] <= second[this.fitIndex];
    }

    protected boolean firstIsBetter(AbstractEAIndividual first, AbstractEAIndividual second) {
        return this.firstIsBetter(first.getFitness(), second.getFitness());
    }

    protected boolean firstIsBetterEqual(AbstractEAIndividual first, AbstractEAIndividual second) {
        return this.firstIsBetterEqual(first.getFitness(), second.getFitness());
    }

    public AbstractEAIndividual simplexStep(Population subpop) {
        subpop.setSortingFitnessCriterion(this.fitIndex);
        Population bestpop = subpop.getBestNIndividuals(subpop.size() - 1, this.fitIndex);
        AbstractEAIndividual worst = subpop.getWorstEAIndividual(this.fitIndex);
        AbstractEAIndividual best = subpop.getBestEAIndividual(this.fitIndex);
        double[][] range = ((InterfaceDataTypeDouble)((Object)worst)).getDoubleRange();
        double[] x_worst = ((InterfaceDataTypeDouble)((Object)worst)).getDoubleData();
        int dim = x_worst.length;
        double[] centroid = new double[dim];
        for (int i = 0; i < bestpop.size(); ++i) {
            for (int j = 0; j < dim; ++j) {
                AbstractEAIndividual bestIndi = (AbstractEAIndividual)bestpop.getIndividual(i);
                double[] bestIndyPos = ((InterfaceDataTypeDouble)((Object)bestIndi)).getDoubleDataWithoutUpdate();
                int n = j;
                centroid[n] = centroid[n] + bestIndyPos[j] / (double)bestpop.size();
            }
        }
        double[] r = this.calcChallengeVect(centroid, x_worst);
        if (this.checkConstraints && !Mathematics.isInRange(r, range)) {
            Mathematics.reflectBounds(r, range);
        }
        AbstractEAIndividual reflectedInd = this.createEvalIndy(bestpop, r);
        this.population.incrFunctionCalls();
        if (this.firstIsBetter(best, reflectedInd) && this.firstIsBetter(reflectedInd, bestpop.getWorstEAIndividual(this.fitIndex))) {
            return reflectedInd;
        }
        if (this.firstIsBetter(reflectedInd, best)) {
            double[] e = new double[dim];
            for (int i = 0; i < dim; ++i) {
                e[i] = 3.0 * centroid[i] - 2.0 * x_worst[i];
            }
            if (this.checkConstraints && !Mathematics.isInRange(e, range)) {
                Mathematics.projectToRange(e, range);
            }
            AbstractEAIndividual e_ind = this.createEvalIndy(bestpop, e);
            this.population.incrFunctionCalls();
            if (this.firstIsBetter(e_ind, reflectedInd)) {
                return e_ind;
            }
            return reflectedInd;
        }
        if (this.firstIsBetterEqual(bestpop.getWorstEAIndividual(this.fitIndex), reflectedInd)) {
            double[] c = new double[dim];
            for (int i = 0; i < dim; ++i) {
                c[i] = 0.5 * centroid[i] + 0.5 * x_worst[i];
            }
            if (this.checkConstraints && !Mathematics.isInRange(c, range)) {
                Mathematics.projectToRange(c, range);
            }
            AbstractEAIndividual c_ind = this.createEvalIndy(bestpop, c);
            this.population.incrFunctionCalls();
            if (this.firstIsBetterEqual(c_ind, worst)) {
                return c_ind;
            }
        }
        return null;
    }

    private AbstractEAIndividual createEvalIndy(Population pop, double[] newGenotype) {
        AbstractEAIndividual e_ind = (AbstractEAIndividual)((AbstractEAIndividual)pop.getIndividual(1)).clone();
        ((InterfaceDataTypeDouble)((Object)e_ind)).setDoubleGenotype(newGenotype);
        e_ind.resetConstraintViolation();
        this.optimizationProblem.evaluate(e_ind);
        if (e_ind.getFitness(0) < 6000.0) {
            this.optimizationProblem.evaluate(e_ind);
        }
        return e_ind;
    }

    @Override
    public String getName() {
        return "NelderMeadSimplex";
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder strB = new StringBuilder(200);
        strB.append("Nelder-Mead-Simplex Strategy:\nOptimization Problem: ");
        strB.append(this.optimizationProblem.getStringRepresentationForProblem(this));
        strB.append("\n");
        strB.append(this.population.getStringRepresentation());
        return strB.toString();
    }

    @Override
    public void initialize() {
        this.initializeByPopulation(this.population, true);
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.setPopulation(pop);
        pop.addPopulationChangedEventListener(this);
        if (reset) {
            this.optimizationProblem.initializePopulation(this.population);
            this.optimizationProblem.evaluate(this.population);
        }
    }

    @Override
    public void optimize() {
        int evalCntStart = this.population.getFunctionCalls();
        int evalsDone = 0;
        ((AbstractOptimizationProblem)this.optimizationProblem).evaluatePopulationStart(this.population);
        do {
            AbstractEAIndividual ind;
            if ((ind = this.simplexStep(this.population)) != null) {
                double[][] range;
                double[] x = ((InterfaceDataTypeDouble)((Object)ind)).getDoubleData();
                if (!Mathematics.isInRange(x, range = ((InterfaceDataTypeDouble)((Object)ind)).getDoubleRange())) {
                    System.err.println("WARNING: nelder mead step produced indy out of range!");
                }
                this.population.set(this.population.getIndexOfWorstIndividualNoConstr(this.fitIndex), ind, this.fitIndex);
                continue;
            }
            double[] u_1 = ((InterfaceDataTypeDouble)((Object)this.population.getBestEAIndividual(this.fitIndex))).getDoubleData();
            for (int j = 0; j < this.population.size(); ++j) {
                double[] c = ((InterfaceDataTypeDouble)((Object)this.population.getEAIndividual(j))).getDoubleData();
                for (int i = 0; i < c.length; ++i) {
                    c[i] = 0.5 * c[i] + 0.5 * u_1[i];
                }
                ((InterfaceDataTypeDouble)((Object)this.population.getEAIndividual(j))).setDoubleGenotype(c);
            }
            this.optimizationProblem.evaluate(this.population);
        } while ((evalsDone = this.population.getFunctionCalls() - evalCntStart) < this.generationCycle);
        ((AbstractOptimizationProblem)this.optimizationProblem).evaluatePopulationEnd(this.population);
        this.population.incrGeneration();
    }

    @Override
    public void setPopulation(Population pop) {
        this.population = pop;
        this.population.addPopulationChangedEventListener(this);
        this.population.setNotifyEvalInterval(this.populationSize);
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        Population pop = this.getPopulation();
        return new SolutionSet(pop, pop);
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    @Parameter(description="The population size should be adapted to the dimensions of the problem (e.g. n+1)")
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        if (this.population != null) {
            this.population.setTargetSize(populationSize);
            this.population.setNotifyEvalInterval(this.population.getTargetSize());
        }
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.compareTo("FunCallIntervalReached") == 0) {
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    public static NelderMeadSimplex createNelderMeadSimplex(AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        NelderMeadSimplex nms = new NelderMeadSimplex();
        nms.setProblemAndPopSize(problem);
        if (listener != null) {
            nms.addPopulationChangedEventListener(listener);
        }
        nms.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(nms.getPopulation(), "");
        }
        return nms;
    }

    public static NelderMeadSimplex createNelderMeadSimplexLocal(AbstractOptimizationProblem problem, AbstractEAIndividual candidate, double perturbationRatio, InterfacePopulationChangedEventListener listener) {
        Population initialPop;
        problem.initializeProblem();
        NelderMeadSimplex nms = new NelderMeadSimplex();
        nms.setProblemAndPopSize(problem);
        if (perturbationRatio <= 0.0) {
            initialPop = new Population(nms.getPopulationSize());
            problem.initializePopulation(initialPop);
            initialPop.set(0, candidate);
        } else {
            double[][] range = ((InterfaceDataTypeDouble)((Object)candidate)).getDoubleRange();
            if (range.length != nms.getPopulationSize() - 1) {
                System.err.println("Unexpected population size for nelder mead!");
            }
            initialPop = NelderMeadSimplex.createNMSPopulation(candidate, perturbationRatio, range, true);
        }
        if (listener != null) {
            nms.addPopulationChangedEventListener(listener);
        }
        nms.initializeByPopulation(initialPop, false);
        return nms;
    }

    public static Population createNMSPopulation(AbstractEAIndividual candidate, double perturbRelative, double[][] range, boolean includeCand) {
        Population initPop = new Population();
        if (includeCand) {
            initPop.add(candidate);
        }
        if (perturbRelative >= 1.0 || perturbRelative <= 0.0) {
            System.err.println("Warning: perturbation ratio should lie between 0 and 1! (NelderMeadSimplex:createNMSPopulation)");
        }
        NelderMeadSimplex.addPerturbedPopulation(perturbRelative, initPop, range, candidate);
        return initPop;
    }

    private static void addPerturbedPopulation(double perturbationRatio, Population initialPop, double[][] range, AbstractEAIndividual candidate) {
        AbstractEAIndividual indy = (AbstractEAIndividual)candidate.clone();
        for (int i = 0; i < range.length; ++i) {
            double curPerturb = (range[i][1] - range[i][0]) * perturbationRatio;
            double[] dat = ((InterfaceDataTypeDouble)((Object)indy)).getDoubleData();
            dat[i] = dat[i] == range[i][1] ? Math.max(dat[i] - curPerturb, range[i][0]) : Math.min(dat[i] + curPerturb, range[i][1]);
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(dat);
            indy.resetConstraintViolation();
            initialPop.add((AbstractEAIndividual)indy.clone());
        }
        initialPop.synchSize();
    }

    public void setGenerationCycle(int generationCycle) {
        this.generationCycle = generationCycle;
    }

    public boolean isCheckRange() {
        return this.checkConstraints;
    }

    @Parameter(description="Mark to check range constraints by reflection/projection")
    public void setCheckRange(boolean checkRange) {
        this.checkConstraints = checkRange;
    }

    public int getCritIndex() {
        return this.fitIndex;
    }

    @Parameter(description="For multi-criterial problems, set the index of the fitness to be used in 0..n-1. Default is 0")
    public void setCritIndex(int fitIndex) {
        this.fitIndex = fitIndex;
    }
}

