/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class NicheGraph
implements Serializable {
    protected TreeMap<String, TreeSet<String>> graphTable;
    protected HashSet<String> set;

    public NicheGraph() {
        this.graphTable = new TreeMap();
        this.set = new HashSet();
    }

    public NicheGraph(NicheGraph o) {
        this.graphTable = (TreeMap)o.graphTable.clone();
        this.set = (HashSet)o.set.clone();
    }

    public Object clone() {
        return new NicheGraph(this);
    }

    public void addVertex(String v) {
        if (!this.containsVertex(v)) {
            this.graphTable.put(v, new TreeSet());
        }
    }

    public void addEdge(String v1, String v2) {
        if (!this.containsVertex(v1)) {
            this.addVertex(v1);
        }
        if (!this.containsVertex(v2)) {
            this.addVertex(v2);
        }
        this.graphTable.get(v1).add(v2);
        this.graphTable.get(v2).add(v1);
    }

    public boolean containsVertex(String v) {
        return this.graphTable.containsKey(v);
    }

    public Iterable<String> getVertexIterator() {
        return this.graphTable.keySet();
    }

    public Iterable<String> getNeighborIterator(String v) {
        return this.graphTable.get(v);
    }

    public void runBFS(String r) {
        this.set = new HashSet();
        LinkedList<String> q = new LinkedList<String>();
        q.offer(r);
        this.set.add(r);
        while (!q.isEmpty()) {
            String v = (String)q.poll();
            for (String w : this.getNeighborIterator(v)) {
                if (this.set.contains(w)) continue;
                q.offer(w);
                this.set.add(w);
            }
        }
    }

    public List<Set<String>> getConnectedComponents() {
        ArrayList<Set<String>> l = new ArrayList<Set<String>>();
        for (String v : this.getVertexIterator()) {
            if (this.isComponent(v, l)) continue;
            this.runBFS(v);
            l.add(this.set);
        }
        return l;
    }

    private boolean isComponent(String v, ArrayList<Set<String>> l) {
        for (Set<String> set : l) {
            if (!set.contains(v)) continue;
            return true;
        }
        return false;
    }
}

