/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.OptimizerFactory;
import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.TopoPlot;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.enums.PSOTopology;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.nichepso.absorption.EuclideanDiversityAbsorptionStrategy;
import eva2.optimization.operator.nichepso.absorption.InterfaceAbsorptionStrategy;
import eva2.optimization.operator.nichepso.absorption.StandardAbsorptionStrategy;
import eva2.optimization.operator.nichepso.deactivation.InterfaceDeactivationStrategy;
import eva2.optimization.operator.nichepso.deactivation.StandardDeactivationStrategy;
import eva2.optimization.operator.nichepso.merging.InterfaceMergingStrategy;
import eva2.optimization.operator.nichepso.merging.ScatterMergingStrategy;
import eva2.optimization.operator.nichepso.merging.StandardMergingStrategy;
import eva2.optimization.operator.nichepso.subswarmcreation.InterfaceSubswarmCreationStrategy;
import eva2.optimization.operator.nichepso.subswarmcreation.StandardSubswarmCreationStrategy;
import eva2.optimization.operator.paramcontrol.LinearParamAdaption;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.ParameterControlManager;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.ParticleSubSwarmOptimization;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.FM0Problem;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.chart2d.DElement;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconContent;
import eva2.tools.chart2d.DPointIconCross;
import eva2.tools.chart2d.DPointIconPoint;
import eva2.tools.chart2d.DPointIconText;
import eva2.tools.chart2d.DPointSet;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;

@Description(value="A Niching Particle Swarm Optimizer")
public class NichePSO
extends AbstractOptimizer
implements InterfaceAdditionalPopulationInformer,
Serializable {
    private static final long serialVersionUID = 2036532085674554490L;
    protected int mainSwarmSize = 75;
    protected double maxAllowedSwarmRadius = 1.0E-4;
    protected PSOTopology mainSwarmTopology = PSOTopology.grid;
    protected int mainSwarmTopologyRange = 0;
    private ParticleSwarmOptimization.PSOType mainSwarmAlgoType = ParticleSwarmOptimization.PSOType.Inertness;
    protected ParameterControlManager paramControl = new ParameterControlManager();
    boolean returnRepresentativeSolutionsOnly = true;
    boolean partlyInactive = false;
    private boolean verbose = false;
    transient boolean log = false;
    transient boolean plotFinal = false;
    protected boolean plot = false;
    protected boolean useSinglePlotWindow = true;
    transient boolean savePlots = false;
    protected int showCycle = 10;
    protected transient String dirForCurrentExperiment = "unset";
    protected ParticleSubSwarmOptimization mainSwarm = new ParticleSubSwarmOptimization();
    protected Vector<ParticleSubSwarmOptimization> subSwarms = new Vector();
    protected ParticleSubSwarmOptimization subswarmOptimizerTemplate = new ParticleSubSwarmOptimization();
    protected Vector<int[]> indicesToReinit = null;
    protected InterfaceDeactivationStrategy deactivationStrategy = new StandardDeactivationStrategy();
    protected InterfaceMergingStrategy mergingStrategy = new StandardMergingStrategy();
    protected InterfaceAbsorptionStrategy absorptionStrategy = new StandardAbsorptionStrategy();
    protected InterfaceSubswarmCreationStrategy subswarmCreationStrategy = new StandardSubswarmCreationStrategy();
    protected InterfaceOptimizationProblem optimizationProblem = new FM0Problem();
    protected transient BufferedWriter outputFile = null;
    protected transient TopoPlot topoPlot;
    protected transient boolean showNextPlot = false;
    protected transient boolean deactivationOccured = false;
    protected transient boolean mergingOccurd = false;
    protected transient boolean absorbtionOccurd = false;
    protected transient boolean creationOccurd = false;
    protected transient Vector<ParticleSubSwarmOptimization> deactivatedSwarm;
    protected transient Vector<ParticleSubSwarmOptimization> borg;
    protected transient Vector<ParticleSubSwarmOptimization> others;
    protected transient Vector<AbstractEAIndividual> borgbest;
    protected transient Vector<AbstractEAIndividual> othersbest;
    protected transient Vector<AbstractEAIndividual> indytoabsorb;
    protected transient Vector<AbstractEAIndividual> indyconverged;
    protected transient Vector<AbstractEAIndividual> convergedneighbor;
    public static final String stdDevKey = "StdDevKey";
    public static final String fitArchiveKey = "FitnessArchiveKey";
    public static final int defaultFitStdDevHorizon = 3;

    public NichePSO() {
        if (this.log) {
            this.initLogFile();
        }
        this.initMainSwarm();
        this.initSubswarmOptimizerTemplate();
        this.hideHideable();
    }

    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "subswarmCreationStrategy", false);
        GenericObjectEditor.setHideProperty(this.getClass(), "mergingStrategy", false);
        GenericObjectEditor.setHideProperty(this.getClass(), "absorptionStrategy", false);
        GenericObjectEditor.setHideProperty(this.getClass(), "maxAllowedSwarmRadius", false);
    }

    public NichePSO(NichePSO a) {
        this.mainSwarmSize = a.mainSwarmSize;
        this.maxAllowedSwarmRadius = a.maxAllowedSwarmRadius;
        this.mainSwarmTopology = a.mainSwarmTopology;
        this.mainSwarmTopologyRange = a.mainSwarmTopologyRange;
        this.mainSwarmAlgoType = a.mainSwarmAlgoType;
        this.paramControl = (ParameterControlManager)a.paramControl.clone();
        this.returnRepresentativeSolutionsOnly = a.returnRepresentativeSolutionsOnly;
        this.partlyInactive = a.partlyInactive;
        this.verbose = a.verbose;
        this.log = a.log;
        this.useSinglePlotWindow = a.useSinglePlotWindow;
        this.savePlots = a.savePlots;
        this.showCycle = a.showCycle;
        this.setDirForCurrentExperiment(a.getDirForCurrentExperiment());
        this.setMainSwarm((ParticleSubSwarmOptimization)a.getMainSwarm().clone());
        this.setSubSwarms((Vector)a.getSubSwarms().clone());
        this.setSubswarmOptimizerTemplate((ParticleSubSwarmOptimization)a.getSubswarmOptimizerTemplate().clone());
        this.deactivationStrategy = (InterfaceDeactivationStrategy)a.deactivationStrategy.clone();
        this.mergingStrategy = (InterfaceMergingStrategy)a.mergingStrategy.clone();
        this.absorptionStrategy = (InterfaceAbsorptionStrategy)a.absorptionStrategy.clone();
        this.subswarmCreationStrategy = (InterfaceSubswarmCreationStrategy)a.subswarmCreationStrategy.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
    }

    @Override
    public Object clone() {
        return new NichePSO(this);
    }

    protected void initMainSwarm() {
        this.setMainSwarmSize(this.mainSwarmSize);
        this.getMainSwarm().setProblem(this.optimizationProblem);
        this.getMainSwarm().SetMaxAllowedSwarmRadius(this.maxAllowedSwarmRadius);
        this.getMainSwarm().getPopulation().setGeneration(0);
        this.getMainSwarm().setGcpso(false);
        this.getMainSwarm().setParameterControl(new ParamAdaption[]{NichePSO.getDefaultInertnessAdaption()});
        this.getMainSwarm().setAlgoType(this.mainSwarmAlgoType);
        this.setMainSwarmAlgoType(this.mainSwarmAlgoType);
        this.getMainSwarm().setTopology(this.mainSwarmTopology);
        this.getMainSwarm().setTopologyRange(this.mainSwarmTopologyRange);
    }

    public static ParamAdaption getDefaultInertnessAdaption() {
        return new LinearParamAdaption("inertnessOrChi", 0.7, 0.2);
    }

    protected void initSubswarmOptimizerTemplate() {
        this.getSubswarmOptimizerTemplate().setProblem(this.optimizationProblem);
        this.getSubswarmOptimizerTemplate().SetMaxAllowedSwarmRadius(this.maxAllowedSwarmRadius);
        this.getSubswarmOptimizerTemplate().setGcpso(true);
        this.getSubswarmOptimizerTemplate().setRho(0.1);
        this.getSubswarmOptimizerTemplate().setAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        this.getSubswarmOptimizerTemplate().setInertnessOrChi(0.7298437881283576);
        this.getSubswarmOptimizerTemplate().setPhi1(2.05);
        this.getSubswarmOptimizerTemplate().setPhi2(2.05);
    }

    public ParticleSubSwarmOptimization getNewSubSwarmOptimizer() {
        ParticleSubSwarmOptimization template = (ParticleSubSwarmOptimization)this.getSubswarmOptimizerTemplate().clone();
        template.setProblem(this.optimizationProblem);
        return template;
    }

    @Override
    public void initialize() {
        this.initMainSwarm();
        this.getMainSwarm().initialize();
        this.setSubSwarms(new Vector<ParticleSubSwarmOptimization>());
        this.indicesToReinit = null;
        if (this.isPlot()) {
            this.initPlotSwarm();
        }
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.getMainSwarm().initializeByPopulation(pop, reset);
        this.initSubswarmOptimizerTemplate();
    }

    @Override
    public void optimize() {
        if (this.isVerbose()) {
            Population pop = this.getPopulation();
            System.out.println("pop bef: " + pop.size() + " " + pop.getFunctionCalls());
        }
        if (this.getMainSwarm().getPopulation().size() == 0) {
            if (this.isVerbose()) {
                System.out.print("MainSwarm size is 0\n");
            }
            this.getMainSwarm().getPopulation().incrGeneration();
        } else {
            this.getMainSwarm().optimize();
        }
        this.maybeReinitIndies();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization subswarm = this.getSubSwarms().get(i);
            if (!subswarm.isActive()) continue;
            subswarm.optimize();
        }
        this.deactivateSubSwarmsIfPossible();
        this.mergeSubswarmsIfPossible();
        this.absorbParticlesIfPossible();
        this.createSubswarmIfPossible();
        this.firePropertyChangedEvent("NextGenerationPerformed");
        if (this.isVerbose()) {
            Population pop = this.getPopulation();
            System.out.println("pop aft: " + pop.size() + " " + pop.getFunctionCalls());
        }
        if (this.isPlot()) {
            this.doPlot();
        }
        this.deactivationOccured = false;
        this.deactivatedSwarm = new Vector();
        this.mergingOccurd = false;
        this.borg = new Vector();
        this.others = new Vector();
        this.borgbest = new Vector();
        this.othersbest = new Vector();
        this.absorbtionOccurd = false;
        this.indytoabsorb = new Vector();
        this.creationOccurd = false;
        this.indyconverged = new Vector();
        this.convergedneighbor = new Vector();
    }

    protected void maybeReinitIndies() {
        if (this.indicesToReinit != null && this.indicesToReinit.size() > 0) {
            this.getMainSwarm().reinitIndividuals(this.indicesToReinit);
            this.indicesToReinit.clear();
        }
    }

    public void scheduleNewParticlesToPopulation(int[] particleIndices) {
        if (particleIndices != null) {
            if (this.indicesToReinit == null) {
                this.indicesToReinit = new Vector();
            }
            this.indicesToReinit.add(particleIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPlot() {
        boolean bl = this.showNextPlot = this.deactivationOccured || this.mergingOccurd || this.absorbtionOccurd || this.creationOccurd;
        if (this.getMainSwarm().getPopulation().getGeneration() % this.getShowCycle() == 0) {
            if (this.mergingOccurd) {
                this.plotMainSwarm(false);
                this.plotMergingCondition();
                if (this.savePlots) {
                    String generation = String.valueOf(this.getMainSwarm().getPopulation().getGeneration());
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
            }
            Class<?> ignored = this.topoPlot.getClass();
            synchronized (ignored) {
                this.plotMainSwarm(false);
                this.plotSubSwarms();
            }
            if (this.savePlots) {
                String gen = String.valueOf(this.getMainSwarm().getPopulation().getGeneration());
            } else {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.showNextPlot = false;
        }
    }

    protected void deactivationEventFor(ParticleSubSwarmOptimization subswarm) {
        if (this.isVerbose()) {
            System.out.println("deactivating subswarm");
        }
        this.deactivatedSwarm.add(subswarm);
        this.deactivationOccured = true;
    }

    protected void deactivateSubSwarmsIfPossible() {
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
            if (!this.getDeactivationStrategy().shouldDeactivateSubswarm(currentsubswarm)) continue;
            if (this.isVerbose()) {
                System.out.println("deactivation in NPSO!");
            }
            this.deactivationEventFor(currentsubswarm);
            this.scheduleNewParticlesToPopulation(this.getDeactivationStrategy().deactivateSubswarm(currentsubswarm, this.getMainSwarm()));
        }
    }

    protected double getAvgActiveSubSwarmSize() {
        double avgSize = 0.0;
        int actCnt = 0;
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
            if (!currentsubswarm.isActive()) continue;
            ++actCnt;
            avgSize += (double)currentsubswarm.population.size();
        }
        if (actCnt > 0) {
            return avgSize / (double)actCnt;
        }
        return 0.0;
    }

    protected int countActiveSubswarms() {
        int actCnt = 0;
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
            if (!currentsubswarm.isActive()) continue;
            ++actCnt;
        }
        return actCnt;
    }

    protected void mergingEventFor(int i, int j) {
        if (this.isVerbose()) {
            System.out.print("merge condition \n");
        }
        ParticleSubSwarmOptimization borg = this.getSubSwarms().get(i);
        ParticleSubSwarmOptimization others = this.getSubSwarms().get(j);
        this.borg.add((ParticleSubSwarmOptimization)borg.clone());
        this.others.add((ParticleSubSwarmOptimization)others.clone());
        this.mergingOccurd = true;
        this.borgbest.add(borg.bestIndividual);
        this.othersbest.add(others.bestIndividual);
    }

    protected void mergeSubswarmsIfPossible() {
        boolean runagain = false;
        if (this.isVerbose()) {
            System.out.println("possibly merging " + this.getSubSwarms().size() + " subswarms...");
        }
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            for (int j = i + 1; j < this.getSubSwarms().size(); ++j) {
                if (!this.getMergingStrategy().shouldMergeSubswarms(this.getSubSwarms().get(i), this.getSubSwarms().get(j))) continue;
                if (this.isVerbose()) {
                    System.out.println("Merging in NPSO!");
                }
                this.mergingEventFor(i, j);
                this.getMergingStrategy().mergeSubswarms(i, j, this.getSubSwarms(), this.getMainSwarm());
                runagain = true;
                --j;
            }
        }
        if (runagain) {
            this.mergeSubswarmsIfPossible();
        }
    }

    protected void absorbtionEventFor(AbstractEAIndividual indy, ParticleSubSwarmOptimization subswarm) {
        if (this.isVerbose()) {
            System.out.print("Absorbtion \n");
        }
        this.absorbtionOccurd = true;
        this.indytoabsorb.add(indy);
    }

    protected void absorbParticlesIfPossible() {
        boolean runagain = false;
        block0: for (int i = 0; i < this.getMainSwarm().getPopulation().size(); ++i) {
            AbstractEAIndividual currentindy = this.getMainSwarm().getPopulation().getEAIndividual(i);
            for (int j = 0; j < this.getSubSwarms().size(); ++j) {
                ParticleSubSwarmOptimization currentsubwarm = this.getSubSwarms().get(j);
                if (!this.getAbsorptionStrategy().shouldAbsorbParticleIntoSubswarm(currentindy, currentsubwarm, this.getMainSwarm())) continue;
                if (this.isVerbose()) {
                    System.out.println("Absorbing particle (NPSO)");
                }
                this.absorbtionEventFor(currentindy, currentsubwarm);
                this.getAbsorptionStrategy().absorbParticle(currentindy, currentsubwarm, this.getMainSwarm());
                --i;
                runagain = true;
                continue block0;
            }
        }
        if (runagain) {
            this.absorbParticlesIfPossible();
        }
    }

    protected void subswarmCreationEventFor(AbstractEAIndividual currentindy, ParticleSubSwarmOptimization subswarm) {
        if (this.isVerbose()) {
            System.out.print("creating subswarm\n");
        }
        this.creationOccurd = true;
        this.indyconverged.add(currentindy);
        for (int i = 0; i < subswarm.getPopulation().size(); ++i) {
            AbstractEAIndividual indy = subswarm.getPopulation().getEAIndividual(i);
            if (indy.getIndyID() == currentindy.getIndyID()) continue;
            this.convergedneighbor.add(indy);
        }
    }

    protected void createSubswarmIfPossible() {
        for (int i = 0; i < this.getMainSwarm().getPopulation().size(); ++i) {
            AbstractEAIndividual currentindy = this.getMainSwarm().getPopulation().getEAIndividual(i);
            if (!this.getSubswarmCreationStrategy().shouldCreateSubswarm(currentindy, this.getMainSwarm())) continue;
            if (this.isVerbose()) {
                System.out.println("Creating sub swarm (NPSO)");
            }
            ParticleSubSwarmOptimization newSubswarm = this.getNewSubSwarmOptimizer();
            this.getSubswarmCreationStrategy().createSubswarm(newSubswarm, currentindy, this.getMainSwarm());
            this.subswarmCreationEventFor(currentindy, newSubswarm);
            this.getSubSwarms().add(newSubswarm);
            i = 0;
        }
    }

    @Override
    public void setPopulation(Population pop) {
        this.getMainSwarm().setPopulation(pop);
    }

    public Population getActivePopulation() {
        Population metapop = (Population)this.getMainSwarm().getPopulation().clone();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
            if (!currentsubswarm.isActive()) continue;
            Population currentsubswarmpop = (Population)currentsubswarm.getPopulation().clone();
            metapop.addPopulation(currentsubswarmpop);
        }
        metapop.setGeneration(this.getMainSwarm().getPopulation().getGeneration());
        int calls = this.getMainSwarm().getPopulation().getFunctionCalls();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
            calls += currentsubswarm.getPopulation().getFunctionCalls();
        }
        metapop.setFunctionCalls(calls);
        metapop.synchSize();
        return metapop;
    }

    @Override
    public Population getPopulation() {
        int i;
        boolean activeOnly = true;
        Population metapop = this.getMainSwarm().getPopulation().cloneWithoutInds();
        metapop.ensureCapacity(this.getMainSwarmSize());
        metapop.addPopulation(this.getMainSwarm().getPopulation());
        int activeCnt = 0;
        for (int i2 = 0; i2 < this.getSubSwarms().size(); ++i2) {
            if (this.getSubSwarms().get(i2).isActive()) {
                ++activeCnt;
                metapop.addPopulation(this.getSubSwarms().get(i2).getPopulation());
                continue;
            }
            if (activeOnly) continue;
            metapop.addPopulation(this.getSubSwarms().get(i2).getPopulation());
        }
        if (this.isVerbose()) {
            System.out.println("Active populations: " + activeCnt);
        }
        metapop.setGeneration(this.getMainSwarm().getPopulation().getGeneration());
        int calls = this.getMainSwarm().getPopulation().getFunctionCalls();
        for (i = 0; i < this.getSubSwarms().size(); ++i) {
            calls += this.getSubSwarms().get(i).getPopulation().getFunctionCalls();
        }
        metapop.setFunctionCalls(calls);
        if (metapop.size() == 0) {
            System.err.println("NichePSO ERROR! " + metapop.getFunctionCalls());
            for (i = this.getSubSwarms().size() - 1; i >= 0 && metapop.size() < this.mainSwarmSize; --i) {
                metapop.addPopulation(this.getSubSwarms().get(i).getPopulation());
            }
        }
        return metapop;
    }

    public String populationTipText() {
        return "please use mainSwarmSize to set the population size";
    }

    @Override
    public SolutionSet getAllSolutions() {
        if (this.returnRepresentativeSolutionsOnly) {
            Population sols = this.getSubswarmRepresentatives(false);
            Population metapop = this.getPopulation();
            sols.setFunctionCalls(metapop.getFunctionCalls());
            sols.setGeneration(metapop.getGeneration());
            return new SolutionSet(metapop, sols);
        }
        Population metapop = this.getPopulation();
        Population sols = new Population();
        for (int i = 0; i < metapop.size(); ++i) {
            AbstractEAIndividual indy = metapop.getEAIndividual(i);
            AbstractEAIndividual pbest = (AbstractEAIndividual)indy.getData("PersonalBestKey");
            sols.add(pbest);
        }
        sols.setFunctionCalls(metapop.getFunctionCalls());
        sols.setGeneration(metapop.getFunctionCalls());
        return new SolutionSet(sols);
    }

    public AbstractEAIndividual getGlobalBestSolution() {
        Population metapop = this.getPopulation();
        if (metapop.size() == 0) {
            System.out.println("getGlobalBestSolution: all swarms are empty ");
            return null;
        }
        AbstractEAIndividual gbest = (AbstractEAIndividual)metapop.getEAIndividual(0).getData("PersonalBestKey");
        for (int i = 1; i < metapop.size(); ++i) {
            AbstractEAIndividual currentPBest = (AbstractEAIndividual)metapop.getEAIndividual(i).getData("PersonalBestKey");
            if (!currentPBest.isDominating(gbest)) continue;
            gbest = currentPBest;
        }
        return gbest;
    }

    public Population getSubswarmRepresentatives(boolean onlyInactive) {
        Population representatives = new Population(this.getSubSwarms().size() + 1);
        Vector<ParticleSubSwarmOptimization> subSwarms = this.getSubSwarms();
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            if (onlyInactive && subSwarms.get(i).isActive()) continue;
            representatives.add((AbstractEAIndividual)subSwarms.get((int)i).bestIndividual.clone());
        }
        if (!onlyInactive && this.getMainSwarm().getPopulation().size() != 0) {
            representatives.add((AbstractEAIndividual)this.getMainSwarm().bestIndividual.clone());
        }
        return representatives;
    }

    public void setMainSwarmSize(int size) {
        this.mainSwarmSize = size;
        this.getMainSwarm().getPopulation().setTargetSize(size);
    }

    public int getMainSwarmSize() {
        return this.mainSwarmSize;
    }

    public String mainSwarmSizeTipText() {
        return "sets the initial size of the mainswarm population";
    }

    public void setMaxAllowedSwarmRadius(double val) {
        this.maxAllowedSwarmRadius = val;
        this.getMainSwarm().SetMaxAllowedSwarmRadius(val);
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            this.getSubSwarms().get(i).SetMaxAllowedSwarmRadius(val);
        }
        this.getSubswarmOptimizerTemplate().SetMaxAllowedSwarmRadius(val);
    }

    public double getMaxAllowedSwarmRadius() {
        return this.maxAllowedSwarmRadius;
    }

    public String maxAllowedSwarmRadiusTipText() {
        return "no subswarm radius is allowed to (formally) exceed this threshold (see help for details)";
    }

    public double getMainSwarmInitialVelocity() {
        return this.mainSwarm.getInitialVelocity();
    }

    public void setMainSwarmInitialVelocity(double v) {
        this.mainSwarm.setInitialVelocity(v);
    }

    public String mainSwarmInitialVelocityTipText() {
        return "The initial velocity (normed by search range) for the main swarm.";
    }

    public String mainSwarmPhi1TipText() {
        return "weights the cognitive component for the PSO used to train the main swarm";
    }

    public void setMainSwarmTopologyTag(int mainSwarmTopologyTag) {
        this.mainSwarmTopology = PSOTopology.getFromId(mainSwarmTopologyTag);
    }

    public PSOTopology getMainSwarmTopology() {
        return this.mainSwarm.topology;
    }

    public void setMainSwarmTopology(PSOTopology t) {
        this.mainSwarm.topology = t;
        this.mainSwarmTopology = t;
        GenericObjectEditor.setHideProperty(this.getClass(), "mainSwarmTopologyRange", this.mainSwarmTopology == PSOTopology.multiSwarm);
    }

    public int getMainSwarmTopologyRange() {
        return this.mainSwarmTopologyRange;
    }

    public void setMainSwarmTopologyRange(int mainSwarmTopologyRange) {
        this.mainSwarmTopologyRange = mainSwarmTopologyRange;
    }

    public ParticleSwarmOptimization.PSOType getMainSwarmAlgoType() {
        if (this.mainSwarmAlgoType != this.getMainSwarm().getAlgoType()) {
            System.err.println("Error in NichePSO:getMainSwarmAlgoType() !!");
        }
        return this.getMainSwarm().getAlgoType();
    }

    public void setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType st) {
        this.getMainSwarm().setAlgoType(st);
        this.mainSwarmAlgoType = st;
    }

    public String[] getGOEPropertyUpdateLinks() {
        return new String[]{"mainSwarmAlgoType", "mainSwarmInertness", "mainSwarmPhi1", "mainSwarmInertness", "mainSwarmPhi2", "mainSwarmInertness"};
    }

    public boolean isReturnRepresentativeSolutionsOnly() {
        return this.returnRepresentativeSolutionsOnly;
    }

    public void SetReturnRepresentativeSolutionsOnly(boolean returnRepresentativeSolutionsOnly) {
        this.returnRepresentativeSolutionsOnly = returnRepresentativeSolutionsOnly;
    }

    public void SetPartlyInactive(boolean val) {
        this.partlyInactive = val;
    }

    public boolean isPartlyInactive() {
        return this.partlyInactive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String verboseTipText() {
        return "activate to print additional information to the console during optimization";
    }

    public boolean isLog() {
        return this.log;
    }

    public void SetLog(boolean log) {
        this.log = log;
    }

    public boolean isPlotFinal() {
        return this.plotFinal;
    }

    public void SetPlotFinal(boolean plotFinal) {
        this.plotFinal = plotFinal;
    }

    public void setPlot(boolean plot) {
        this.plot = plot;
    }

    public boolean isPlot() {
        return this.plot;
    }

    public String plotTipText() {
        return "toggles the plot window";
    }

    public boolean isUseSinglePlotWindow() {
        return this.useSinglePlotWindow;
    }

    public void setUseSinglePlotWindow(boolean useSinglePlotWindow) {
        this.useSinglePlotWindow = useSinglePlotWindow;
    }

    public String useSinglePlotWindowTipText() {
        return "deactivate to open a new window for every plot";
    }

    public boolean isSavePlots() {
        return this.savePlots;
    }

    public void SetSavePlots(boolean savePlots) {
        this.savePlots = savePlots;
    }

    public void setShowCycle(int showCycle) {
        this.showCycle = showCycle;
    }

    public int getShowCycle() {
        return this.showCycle;
    }

    public String showCycleTipText() {
        return "sets the interval (in generations) used to update the plot window";
    }

    public String getDirForCurrentExperiment() {
        return this.dirForCurrentExperiment;
    }

    public void setDirForCurrentExperiment(String dirForCurrentExperiment) {
        this.dirForCurrentExperiment = dirForCurrentExperiment;
    }

    public void setMainSwarm(ParticleSubSwarmOptimization mainSwarm) {
        this.mainSwarm = mainSwarm;
    }

    public ParticleSubSwarmOptimization getMainSwarm() {
        return this.mainSwarm;
    }

    public String mainSwarmInertnessTipText() {
        return "sets the inertness weight used for the PSO to train the main swarm (see help for details)";
    }

    public void setSubSwarms(Vector<ParticleSubSwarmOptimization> subSwarms) {
        this.subSwarms = subSwarms;
    }

    public Vector<ParticleSubSwarmOptimization> getSubSwarms() {
        return this.subSwarms;
    }

    public void setSubswarmOptimizerTemplate(ParticleSubSwarmOptimization subswarmOptimizerTemplate) {
        this.subswarmOptimizerTemplate = subswarmOptimizerTemplate;
    }

    public ParticleSubSwarmOptimization getSubswarmOptimizerTemplate() {
        return this.subswarmOptimizerTemplate;
    }

    public String subswarmOptimizerTemplateTipText() {
        return "sets the optimizer used to train the subswarms";
    }

    public void setDeactivationStrategy(InterfaceDeactivationStrategy deactivationStrategy) {
        this.deactivationStrategy = deactivationStrategy;
    }

    public InterfaceDeactivationStrategy getDeactivationStrategy() {
        return this.deactivationStrategy;
    }

    public String deactivationStrategyTipText() {
        return "sets the strategy used to deactivate subswarms";
    }

    public void setMergingStrategy(InterfaceMergingStrategy mergingStrategy) {
        this.mergingStrategy = mergingStrategy;
    }

    public InterfaceMergingStrategy getMergingStrategy() {
        return this.mergingStrategy;
    }

    public String mergingStrategyTipText() {
        return "sets the strategy used to merge subswarms";
    }

    public void setAbsorptionStrategy(InterfaceAbsorptionStrategy absorptionStrategy) {
        this.absorptionStrategy = absorptionStrategy;
    }

    public InterfaceAbsorptionStrategy getAbsorptionStrategy() {
        return this.absorptionStrategy;
    }

    public String absorptionStrategyTipText() {
        return "sets the strategy used to absorb main swarm particles into a subswarm";
    }

    public void setSubswarmCreationStrategy(InterfaceSubswarmCreationStrategy subswarmCreationStrategy) {
        this.subswarmCreationStrategy = subswarmCreationStrategy;
    }

    public InterfaceSubswarmCreationStrategy getSubswarmCreationStrategy() {
        return this.subswarmCreationStrategy;
    }

    public String subswarmCreationStrategyTipText() {
        return "sets the strategy to create subswarms from the main swarm";
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        this.getMainSwarm().setProblem(problem);
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            this.getSubSwarms().get(i).setProblem(problem);
        }
        this.getSubswarmOptimizerTemplate().setProblem(problem);
    }

    public double getAveDistToNeighborInMainswarm() {
        return this.getMainSwarm().getAveDistToNeighbor();
    }

    public double[] getFitDevsInMain() {
        double[] res = new double[this.getMainSwarm().getPopulation().size()];
        for (int i = 0; i < this.getMainSwarm().getPopulation().size(); ++i) {
            AbstractEAIndividual indy = this.getMainSwarm().getPopulation().getEAIndividual(i);
            res[i] = (Double)indy.getData(stdDevKey);
        }
        return res;
    }

    public double getMedian(double[] vals) {
        double result;
        Arrays.sort(vals);
        if (vals.length % 2 == 0) {
            int mid1 = vals.length / 2 - 1;
            int mid2 = vals.length / 2;
            result = 0.5 * (vals[mid1] + vals[mid2]);
        } else {
            int mid = (vals.length + 1) / 2 - 1;
            result = vals[mid];
        }
        return result;
    }

    public double getMedianSubswarmSize() {
        if (this.getSubSwarms().size() == 0) {
            return 0.0;
        }
        double[] size = new double[this.getSubSwarms().size()];
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            if (this.getSubSwarms().get(i) == null) {
                System.out.println("getMedianSubswarmSize: subSwarms has null objects - why ?");
                break;
            }
            size[i] = this.getSubSwarms().get(i).getPopulation().size();
        }
        return this.getMedian(size);
    }

    public double getMeanSubswarmSize() {
        double mean = 0.0;
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            mean += (double)this.getSubSwarms().get(i).getPopulation().size();
        }
        return mean /= (double)this.getSubSwarms().size();
    }

    public double getMaxSubswarmSize() {
        double max = 0.0;
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            if (!((double)this.getSubSwarms().get(i).getPopulation().size() > max)) continue;
            max = this.getSubSwarms().get(i).getPopulation().size();
        }
        return max;
    }

    public double getMeanSubswarmDistanceNormalised() {
        double meanDist = 0.0;
        int pairs = 0;
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            for (int j = i + 1; j < this.getSubSwarms().size(); ++j) {
                ParticleSubSwarmOptimization sub1 = this.getSubSwarms().get(i);
                ParticleSubSwarmOptimization sub2 = this.getSubSwarms().get(j);
                meanDist += this.getMainSwarm().distance(sub1.getGBestIndividual(), sub2.getGBestIndividual());
                ++pairs;
            }
        }
        meanDist /= (double)pairs;
        return meanDist /= this.getMainSwarm().maxPosDist;
    }

    public double getMeanSubswarmDiversityNormalised() {
        double meanDiv = 0.0;
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentSubswarm = this.getSubSwarms().get(i);
            meanDiv += currentSubswarm.getEuclideanDiversity();
        }
        meanDiv /= (double)this.getSubSwarms().size();
        return meanDiv /= this.getMainSwarm().maxPosDist;
    }

    @Override
    public String getName() {
        return "NichePSO-" + this.getMainSwarmSize();
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "niching particle swarm optimization. This algorithm optimizes multiple optima of an multimodal objective function in parallel.\n";
        return result;
    }

    public String getSubswarmRepresentativesAsString(boolean onlyInactive) {
        String result = "\nSubswarmRepresentatives: \n";
        Population reps = this.getSubswarmRepresentatives(onlyInactive);
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            result = result + reps.getEAIndividual(i).getStringRepresentation() + "\n";
        }
        return result;
    }

    public String getPerformanceAsString() {
        if (!(this.optimizationProblem instanceof InterfaceMultimodalProblem)) {
            System.out.println("getPerformanceAsString: problem not instanceof InterfaceMultimodalProblem");
            return "";
        }
        String result = "Performance (#Optima found, Max Peak Ratio, which optima are found): \n";
        Population elitepop = this.getSubswarmRepresentatives(false);
        if (this.optimizationProblem instanceof InterfaceMultimodalProblem) {
            result = result + ((InterfaceMultimodalProblemKnown)((Object)this.optimizationProblem)).getNumberOfFoundOptima(elitepop);
            result = result + "(" + ((InterfaceMultimodalProblemKnown)((Object)this.optimizationProblem)).getRealOptima().size() + ")\t";
            result = result + ((InterfaceMultimodalProblemKnown)((Object)this.optimizationProblem)).getMaximumPeakRatio(elitepop) + "\t";
            result = result + "\n";
        }
        return result;
    }

    public String getReport() {
        String result = "";
        result = "Generations: " + this.getPopulation().getGeneration();
        result = result + " FunctionCalls: " + this.getPopulation().getFunctionCalls();
        result = result + " MainSwarmSize: " + this.getMainSwarm().getPopulation().size();
        result = result + " Subswarms: ";
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            result = result + "(" + i + ")" + this.getSubSwarms().get(i).getPopulation().size() + " ";
        }
        result = result + "SwarmSize: " + this.getPopulation().size();
        result = result + "\n";
        return result;
    }

    protected void initLogFile() {
        if (this.getDirForCurrentExperiment().equals("unset")) {
            System.out.println("initLogFile: no directory for output specified, please use setDirForCurrentExperiment first");
            return;
        }
        File outputPath = new File(this.getDirForCurrentExperiment() + "\\NichePSO-LogFiles\\");
        if (!outputPath.exists()) {
            outputPath.mkdirs();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd'_'HH.mm.ss'_'E");
        String startDate = formatter.format(new Date());
        String name = "NichePSO-LogFile__" + startDate + ".dat";
        File f = new File(outputPath, name);
        try {
            if (this.outputFile != null) {
                this.outputFile.close();
            }
            this.outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not open output file! Filename: " + name);
        }
        catch (IOException e) {
            System.out.println("Could not close old output file! Filename: " + name);
        }
    }

    protected void writeToLogFile(String line) {
        String write = line + "\n";
        if (this.outputFile == null) {
            return;
        }
        try {
            this.outputFile.write(write, 0, write.length());
            this.outputFile.flush();
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
    }

    public AbstractEAIndividual getIndyByParticleIndexAndPopulation(Population pop, Integer index) {
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            if (index.intValue() != indy.getIndividualIndex()) continue;
            return indy;
        }
        return null;
    }

    public AbstractEAIndividual getIndyByParticleIndex(Integer index) {
        AbstractEAIndividual indy = null;
        Population pop = this.getMainSwarm().getPopulation();
        indy = this.getIndyByParticleIndexAndPopulation(pop, index);
        if (indy != null) {
            return indy;
        }
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            pop = this.getSubSwarms().get(i).getPopulation();
            indy = this.getIndyByParticleIndexAndPopulation(pop, index);
            if (indy == null) continue;
            return indy;
        }
        return null;
    }

    protected AbstractEAIndividual getIndyWithMinStdDev() {
        Population mainpop = this.getMainSwarm().getPopulation();
        if (mainpop.size() == 0) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        int minindex = 0;
        for (int i = 0; i < mainpop.size(); ++i) {
            AbstractEAIndividual tmpIndy1 = (AbstractEAIndividual)mainpop.get(i);
            Double da = (Double)tmpIndy1.getData(stdDevKey);
            if (!(da < min)) continue;
            min = da;
            minindex = i;
        }
        return (AbstractEAIndividual)mainpop.get(minindex);
    }

    protected void initPlotSwarm() {
        double[] a = new double[]{0.0, 0.0};
        this.topoPlot = new TopoPlot("NichePSO-MainSwarm", "x", "y", a, a);
        this.topoPlot.setParams(60, 60);
        if (this.optimizationProblem instanceof Interface2DBorderProblem) {
            this.topoPlot.setTopology((Interface2DBorderProblem)((Object)this.optimizationProblem));
        }
    }

    protected void cleanPlotSwarm() {
        DElement[] elements = this.topoPlot.getFunctionArea().getDElements();
        int lastIndex = elements.length - 1;
        DElement last = elements[lastIndex];
        while (last instanceof DPointSet || last instanceof DPoint || last instanceof DPointIcon) {
            this.topoPlot.getFunctionArea().removeDElement(last);
            last = elements[--lastIndex];
        }
    }

    protected void plotAllStdDevsInMainSwarm() {
        Population mainpop = this.getMainSwarm().getPopulation();
        for (int i = 0; i < mainpop.size(); ++i) {
            AbstractEAIndividual indy = mainpop.getEAIndividual(i);
            Integer index = indy.getIndividualIndex();
            String id = "(" + index.toString() + ") ";
            InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)mainpop.get(i);
            DPoint point = new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]);
            Double da = (Double)((AbstractEAIndividual)((Object)tmpIndy1)).getData(stdDevKey);
            double d = da;
            String ds = String.format("%6.2f", d);
            DPointIconText icon = new DPointIconText(id + ds);
            icon.setIcon(new DPointIconCircle());
            point.setIcon(icon);
            this.topoPlot.getFunctionArea().addDElement(point);
        }
    }

    protected void plotMinStdDevInMainSwarm() {
        AbstractEAIndividual indy = this.getIndyWithMinStdDev();
        InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)((Object)indy);
        Double da = (Double)indy.getData(stdDevKey);
        double min = da;
        DPoint point = new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]);
        String ds = String.format("%6.2f", min);
        DPointIconText icon = new DPointIconText(ds);
        icon.setIcon(new DPointIconCircle());
        point.setIcon(icon);
        this.topoPlot.getFunctionArea().addDElement(point);
    }

    protected void plotBoundStdDevInMainSwarm(double boundary) {
        Population mainpop = this.getMainSwarm().getPopulation();
        for (int i = 0; i < mainpop.size(); ++i) {
            AbstractEAIndividual indy = mainpop.getEAIndividual(i);
            Integer index = indy.getIndividualIndex();
            String id = "(" + index.toString() + ") ";
            InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)mainpop.get(i);
            DPoint point = new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]);
            Double da = (Double)((AbstractEAIndividual)((Object)tmpIndy1)).getData(stdDevKey);
            double d = da;
            String ds = String.format("%6.2f", d);
            DPointIconText icon = new DPointIconText(id + ds);
            icon.setIcon(new DPointIconCircle());
            point.setIcon(icon);
            if (!(d < boundary)) continue;
            this.topoPlot.getFunctionArea().addDElement(point);
        }
    }

    protected void plotCircleForIndy(int index, String text) {
        AbstractEAIndividual indy = this.getIndyByParticleIndex(index);
        InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)((Object)indy);
        DPoint point = new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]);
        DPointIconText icon = new DPointIconText(text);
        icon.setIcon(new DPointIconCircle());
        point.setIcon(icon);
        this.topoPlot.getFunctionArea().addDElement(point);
    }

    protected void plotCircleForIndy(AbstractEAIndividual indy, String text) {
        InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)((Object)indy);
        DPoint point = new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]);
        DPointIconText icon = new DPointIconText(text);
        icon.setIcon(new DPointIconCircle());
        point.setIcon(icon);
        this.topoPlot.getFunctionArea().addDElement(point);
    }

    protected void plotMainSwarm(boolean withIDs) {
        if (this.optimizationProblem instanceof Interface2DBorderProblem) {
            int i;
            DPointSet popRep = new DPointSet();
            this.cleanPlotSwarm();
            Population mainpop = this.getMainSwarm().getPopulation();
            for (i = 0; i < mainpop.size(); ++i) {
                InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)mainpop.get(i);
                popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
            }
            this.topoPlot.getFunctionArea().addDElement(popRep);
            if (withIDs) {
                for (i = 0; i < this.getMainSwarm().getPopulation().size(); ++i) {
                    AbstractEAIndividual currentindy = this.getMainSwarm().getPopulation().getEAIndividual(i);
                    int particleindex = currentindy.getIndividualIndex();
                    AbstractEAIndividual leader = (AbstractEAIndividual)currentindy.getData("MultiSwarmType");
                    int leaderIndex = 0;
                    if (leader != null) {
                        leaderIndex = leader.getIndividualIndex();
                    }
                    if (currentindy.getData("newParticleFlag") != null) {
                        this.plotCircleForIndy(currentindy, particleindex + " reinit");
                        currentindy.putData("newParticleFlag", null);
                        continue;
                    }
                    String info = particleindex + " (" + leaderIndex + ")";
                    this.plotCircleForIndy(currentindy, info);
                }
            }
        }
    }

    protected void plotSubSwarmsWithIndizes(boolean plotActive, boolean plotInactive) {
        for (int i = 0; i < this.getSubSwarms().size(); ++i) {
            ParticleSubSwarmOptimization currentsub = this.getSubSwarms().get(i);
            if (!currentsub.isActive() && plotInactive) {
                this.plotCircleForIndy(currentsub.bestIndividual, String.valueOf(i) + "[I]");
            }
            if (!currentsub.isActive() || !plotActive) continue;
            this.plotCircleForIndy(currentsub.bestIndividual, String.valueOf(i));
        }
    }

    protected void plotAbsorptionCondition() {
        for (int i = 0; i < this.indytoabsorb.size(); ++i) {
            AbstractEAIndividual indy = this.indytoabsorb.get(i);
            int particleIndex = indy.getIndividualIndex();
            this.plotCircleForIndy(this.indytoabsorb.get(i), String.valueOf(particleIndex) + " absorption");
        }
    }

    protected void plotMergingCondition() {
        for (int i = 0; i < this.borg.size(); ++i) {
            this.plotSwarmToMerge(this.borg.get(i), i);
            this.plotSwarmToMerge(this.others.get(i), i);
        }
        this.plotAbsorptionCondition();
    }

    protected void plotSwarmToMerge(ParticleSubSwarmOptimization swarm, int index) {
        InterfaceDataTypeDouble tmpIndy1;
        int j;
        Population swarmpop = swarm.getPopulation();
        InterfaceDataTypeDouble best = (InterfaceDataTypeDouble)((Object)swarm.bestIndividual);
        DPointSet popRep = new DPointSet();
        for (j = 0; j < swarmpop.size(); ++j) {
            popRep.setConnected(false);
            tmpIndy1 = (InterfaceDataTypeDouble)swarmpop.get(j);
            popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
        }
        this.topoPlot.getFunctionArea().addDElement(popRep);
        if (!swarm.isActive()) {
            this.plotCircleForIndy((AbstractEAIndividual)((Object)best), "[I]-Merging " + String.valueOf(index));
        } else {
            this.plotCircleForIndy((AbstractEAIndividual)((Object)best), this.getMaxStdDevFromSwarmAsString(swarm) + "-Merging " + String.valueOf(index));
        }
        popRep = new DPointSet();
        for (j = 0; j < swarmpop.size(); ++j) {
            tmpIndy1 = (InterfaceDataTypeDouble)swarmpop.get(j);
            popRep.setConnected(true);
            popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
            popRep.addDPoint(new DPoint(best.getDoubleData()[0], best.getDoubleData()[1]));
        }
        this.topoPlot.getFunctionArea().addDElement(popRep);
    }

    protected void plotSubSwarms() {
        if (this.optimizationProblem instanceof Interface2DBorderProblem) {
            for (int i = 0; i < this.getSubSwarms().size(); ++i) {
                InterfaceDataTypeDouble tmpIndy1;
                int j;
                ParticleSubSwarmOptimization currentsubswarm = this.getSubSwarms().get(i);
                Population currentsubswarmpop = currentsubswarm.getPopulation();
                InterfaceDataTypeDouble best = (InterfaceDataTypeDouble)((Object)currentsubswarm.bestIndividual);
                DPointSet popRep = new DPointSet();
                for (j = 0; j < currentsubswarmpop.size(); ++j) {
                    popRep.setConnected(false);
                    tmpIndy1 = (InterfaceDataTypeDouble)currentsubswarmpop.get(j);
                    popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
                }
                this.topoPlot.getFunctionArea().addDElement(popRep);
                if (!currentsubswarm.isActive()) {
                    this.plotCircleForIndy((AbstractEAIndividual)((Object)best), "[I]");
                } else {
                    if (!this.getSubswarmOptimizerTemplate().isGcpso()) {
                        // empty if block
                    }
                    if (this.getSubswarmOptimizerTemplate().isGcpso()) {
                        String rhoAsString = String.format("%6.3f", currentsubswarm.getRho());
                        if (currentsubswarm.gbestParticle != null) {
                            // empty if block
                        }
                    }
                }
                popRep = new DPointSet();
                for (j = 0; j < currentsubswarmpop.size(); ++j) {
                    tmpIndy1 = (InterfaceDataTypeDouble)currentsubswarmpop.get(j);
                    popRep.setConnected(true);
                    popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
                    popRep.addDPoint(new DPoint(best.getDoubleData()[0], best.getDoubleData()[1]));
                }
                this.topoPlot.getFunctionArea().addDElement(popRep);
            }
        }
    }

    protected String getMaxStdDevFromSwarmAsString(ParticleSubSwarmOptimization swarm) {
        double max = -1.0;
        for (int i = 0; i < swarm.getPopulation().size(); ++i) {
            AbstractEAIndividual currentindy = swarm.getPopulation().getEAIndividual(i);
            Double da = (Double)currentindy.getData(stdDevKey);
            double d = da;
            if (!(d > max)) continue;
            max = d;
        }
        String ds = String.format("%6.3f", max);
        return ds;
    }

    protected void plotAdditionalInfo() {
        int i;
        if (this.mergingOccurd) {
            for (i = 0; i < this.borgbest.size(); ++i) {
                this.plotCircleForIndy(this.borgbest.get(i), "merging " + i);
                this.plotCircleForIndy(this.othersbest.get(i), "merging " + i);
            }
        }
        if (this.absorbtionOccurd) {
            for (i = 0; i < this.indytoabsorb.size(); ++i) {
                AbstractEAIndividual indy = this.indytoabsorb.get(i);
                int particleIndex = indy.getIndividualIndex();
                this.plotCircleForIndy(indy, particleIndex + " absorbed");
            }
        }
        if (this.creationOccurd) {
            for (i = 0; i < this.indyconverged.size(); ++i) {
                int convergedIndex = this.indyconverged.get(i).getIndividualIndex();
                int convergedneighborIndex = this.convergedneighbor.get(i).getIndividualIndex();
                this.plotCircleForIndy(this.indyconverged.get(i), "converged " + convergedIndex);
                this.plotCircleForIndy(this.convergedneighbor.get(i), "neighbor " + convergedneighborIndex);
            }
        }
        if (this.deactivationOccured) {
            for (i = 0; i < this.deactivatedSwarm.size(); ++i) {
                this.plotCircleForIndy(this.deactivatedSwarm.get((int)i).bestIndividual, "   deac");
            }
        }
    }

    protected void plotSwarm(ParticleSubSwarmOptimization swarm, String text) {
        for (int i = 0; i < swarm.getPopulation().size(); ++i) {
            AbstractEAIndividual currentindy = swarm.getPopulation().getEAIndividual(i);
            this.plotCircleForIndy(currentindy, text);
        }
    }

    protected void plotTraceIndy(int particleIndex) {
        AbstractEAIndividual indy = this.getIndyByParticleIndex(particleIndex);
        String text = "";
        double[] vel = (double[])indy.getData("velocity");
        String xv = String.format("%6.2f", vel[0]);
        String yv = String.format("%6.2f", vel[1]);
        text = xv + " " + yv;
        this.plotCircleForIndy(indy, text);
    }

    protected void plotStatusForIndy(AbstractEAIndividual indy) {
        InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)((Object)indy);
        DPoint point = new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]);
        DPointIconText icon = new DPointIconText("");
        icon.setIcon(new DPointIconPoint());
        point.setIcon(icon);
        this.topoPlot.getFunctionArea().addDElement(point);
        if (indy.getData("oldPosition") != null) {
            double[] oldpos = (double[])indy.getData("oldPosition");
            point = new DPoint(oldpos[0], oldpos[1]);
            icon = new DPointIconText("");
            icon.setIcon(new DPointIconCross());
            point.setIcon(icon);
            this.topoPlot.getFunctionArea().addDElement(point);
        }
        double[] pbestpos = (double[])indy.getData("BestPosition");
        point = new DPoint(pbestpos[0], pbestpos[1]);
        icon = new DPointIconText("");
        icon.setIcon(new DPointIconCircle());
        point.setIcon(icon);
        this.topoPlot.getFunctionArea().addDElement(point);
        double[] neighbourBestPos = (double[])indy.getData("neighbourBestPos");
        point = new DPoint(neighbourBestPos[0], neighbourBestPos[1]);
        icon = new DPointIconText("");
        icon.setIcon(new DPointIconContent());
        point.setIcon(icon);
        this.topoPlot.getFunctionArea().addDElement(point);
    }

    protected String getCurrentDateAsString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd'_'HH.mm.ss'_'E");
        String date = formatter.format(new Date());
        return date;
    }

    public static OptimizationParameters nichePSO(AbstractOptimizationProblem problem, long randSeed, InterfaceTerminator term) {
        NichePSO npso = new NichePSO();
        npso.setMainSwarmSize(75);
        return OptimizerFactory.makeParams((InterfaceOptimizer)npso, 75, problem, randSeed, term);
    }

    public static OptimizationParameters stdNPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        return NichePSO.stdNPSO(null, problem, randSeed, evalCnt);
    }

    public static OptimizationParameters starNPSO(AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        return NichePSO.starNPSO(null, problem, randSeed, evalCnt);
    }

    public static OptimizationParameters stdNPSO(NichePSO npso, AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        if (npso == null) {
            npso = new NichePSO();
        }
        int popSize = 100;
        npso.setMainSwarmSize(popSize);
        npso.setDeactivationStrategy(new StandardDeactivationStrategy(1.0E-5));
        npso.setMergingStrategy(new StandardMergingStrategy(0.001));
        npso.setAbsorptionStrategy(new StandardAbsorptionStrategy());
        npso.setSubswarmCreationStrategy(new StandardSubswarmCreationStrategy(1.0E-4));
        npso.setMaxAllowedSwarmRadius(1.0E-4);
        npso.setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        npso.getMainSwarm().setPhi1(1.2);
        npso.getMainSwarm().setPhi2(0.0);
        npso.setMainSwarmTopologyTag(0);
        npso.setMainSwarmTopologyRange(0);
        npso.mainSwarmAlgoType = ParticleSwarmOptimization.PSOType.Inertness;
        npso.getMainSwarm().setParameterControl(new ParamAdaption[]{NichePSO.getDefaultInertnessAdaption()});
        npso.getSubswarmOptimizerTemplate().setGcpso(true);
        npso.getSubswarmOptimizerTemplate().setRho(0.1);
        npso.getSubswarmOptimizerTemplate().setAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        npso.getSubswarmOptimizerTemplate().setConstriction(2.05, 2.05);
        return OptimizerFactory.makeParams((InterfaceOptimizer)npso, popSize, problem, randSeed, (InterfaceTerminator)new EvaluationTerminator(evalCnt));
    }

    public static OptimizationParameters starNPSO(NichePSO npso, AbstractOptimizationProblem problem, long randSeed, int evalCnt) {
        NichePSO.starNPSO(npso, evalCnt);
        return OptimizerFactory.makeParams((InterfaceOptimizer)npso, npso.getMainSwarmSize(), problem, randSeed, (InterfaceTerminator)new EvaluationTerminator(evalCnt));
    }

    public static NichePSO starNPSO(NichePSO npso, int evalCnt) {
        if (npso == null) {
            npso = new NichePSO();
        }
        int popSize = 200;
        npso.setMainSwarmSize(popSize);
        npso.setDeactivationStrategy(new StandardDeactivationStrategy());
        npso.setMergingStrategy(new ScatterMergingStrategy(0.001));
        npso.setAbsorptionStrategy(new EuclideanDiversityAbsorptionStrategy(0.1));
        npso.setSubswarmCreationStrategy(new StandardSubswarmCreationStrategy(1.0E-4));
        npso.setMaxAllowedSwarmRadius(1.0E-4);
        npso.getMainSwarm().setAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        npso.setMainSwarmAlgoType(ParticleSwarmOptimization.PSOType.Inertness);
        npso.getMainSwarm().setPhi1(1.2);
        npso.setMainSwarmTopologyTag(0);
        npso.setMainSwarmTopologyRange(0);
        npso.mainSwarmAlgoType = ParticleSwarmOptimization.PSOType.Inertness;
        npso.getMainSwarm().setParameterControl(new ParamAdaption[]{NichePSO.getDefaultInertnessAdaption()});
        npso.getSubswarmOptimizerTemplate().setGcpso(true);
        npso.getSubswarmOptimizerTemplate().setRho(0.01);
        npso.getSubswarmOptimizerTemplate().setAlgoType(ParticleSwarmOptimization.PSOType.Constriction);
        npso.getSubswarmOptimizerTemplate().setConstriction(2.05, 2.05);
        return npso;
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"mainSwarmSize", "numActSpec", "avgSpecSize", "numArchived", "archivedMedCorr", "archivedMeanDist", "mainSwarmInertness"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"Size of the main swarm of explorers", "Number of sub-swarms currently active", "Average sub-swarm size", "The number of stored potential local optima", "The median correlation of stored solutions", "The mean distance of stored solutions", "Current inertness of the main swarm"};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        int actSwarms = this.countActiveSubswarms();
        double avgSpSize = this.getAvgActiveSubSwarmSize();
        Population inactives = this.getSubswarmRepresentatives(true);
        double medCor = inactives.getCorrelations()[3];
        double meanDist = inactives.getPopulationMeasures()[0];
        return new Object[]{this.getMainSwarm().getPopulation().size(), actSwarms, avgSpSize, this.getNumArchived(), medCor, meanDist, this.getMainSwarm().getInertnessOrChi()};
    }

    protected int getNumArchived() {
        return this.getSubSwarms().size() - this.countActiveSubswarms();
    }

    public Object[] getParamControl() {
        List<Object> ctrlbls = ParameterControlManager.listOfControllables(this);
        ctrlbls.add(this.paramControl);
        return ctrlbls.toArray();
    }

    public ParamAdaption[] getParameterControl() {
        return this.paramControl.getSingleAdapters();
    }

    @Parameter(description="You may define dynamic paramter control strategies using the parameter name.")
    public void setParameterControl(ParamAdaption[] paramControl) {
        this.paramControl.setSingleAdapters(paramControl);
    }
}

