/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.mutation.MutateESCorrVector;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectParticleWheel;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;

@Description(value="This is a Particle Filter Algorithm.")
public class ParticleFilterOptimization
extends AbstractOptimizer
implements Serializable {
    private InterfaceSelection parentSelection = new SelectParticleWheel(0.5);
    private boolean withShow = false;
    private double mutationSigma = 0.01;
    private double randomImmigrationQuota = 0.05;
    private double initialVelocity = 0.02;
    private double rotationDeg = 20.0;
    private int popSize = 300;
    private int sleepTime = 0;
    private transient int indCount = 0;
    transient Plot myPlot = null;

    public ParticleFilterOptimization() {
        if (this.withShow) {
            this.setWithShow(true);
        }
    }

    public ParticleFilterOptimization(double vInit, double mute, double immiQuote, double rotDeg, double selScaling) {
        this.mutationSigma = mute;
        this.initialVelocity = vInit;
        this.randomImmigrationQuota = immiQuote;
        this.rotationDeg = rotDeg;
        this.parentSelection = new SelectParticleWheel(selScaling);
        if (this.withShow) {
            this.setWithShow(true);
        }
    }

    public ParticleFilterOptimization(ParticleFilterOptimization a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.parentSelection = (InterfaceSelection)a.parentSelection.clone();
        if (a.withShow) {
            this.setWithShow(true);
        }
    }

    public void hideHideable() {
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
    }

    @Override
    public Object clone() {
        return new ParticleFilterOptimization(this);
    }

    @Override
    public void initialize() {
        if (this.initialVelocity <= 0.0) {
            ((AbstractOptimizationProblem)this.optimizationProblem).getIndividualTemplate().setMutationOperator(new MutateESFixedStepSize(this.mutationSigma));
        } else {
            ((AbstractOptimizationProblem)this.optimizationProblem).getIndividualTemplate().setMutationOperator(new MutateESCorrVector(this.mutationSigma, this.initialVelocity, this.rotationDeg));
        }
        this.population.setTargetSize(this.popSize);
        this.optimizationProblem.initializePopulation(this.population);
        this.setWithShow(this.withShow);
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        if (reset) {
            this.population.initialize();
            this.evaluatePopulation(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    private Population evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
        return population;
    }

    protected Population resample(Population pop) {
        boolean doImmigr = false;
        this.parentSelection.prepareSelection(pop);
        int targetSize = this.population.getTargetSize();
        if (this.randomImmigrationQuota > 0.0) {
            if (this.randomImmigrationQuota > 1.0) {
                System.err.println("Error, invalid immigration quota!");
            } else {
                targetSize = (int)((double)this.population.getTargetSize() * (1.0 - this.randomImmigrationQuota));
                if ((targetSize = Math.max(1, targetSize)) < this.population.getTargetSize()) {
                    doImmigr = true;
                }
            }
        }
        Population parents = (Population)this.parentSelection.selectFrom(pop, targetSize).clone();
        if (doImmigr) {
            int i = 0;
            while (i + parents.getTargetSize() < pop.getTargetSize()) {
                AbstractEAIndividual immi = (AbstractEAIndividual)pop.getEAIndividual(0).clone();
                immi.initialize(this.getProblem());
                parents.add(immi);
                ++i;
            }
            parents.synchSize();
        }
        parents.setFunctionCalls(pop.getFunctionCalls());
        parents.setGeneration(pop.getGeneration());
        if (this.withShow) {
            this.drawPop(parents, 3, true);
        }
        return parents;
    }

    protected void predict(Population pop) {
        this.indCount = 0;
        if (this.withShow) {
            this.drawPop(pop, 0, false);
        }
        for (int i = 0; i < pop.getTargetSize(); ++i) {
            this.applyMotionModel((AbstractEAIndividual)pop.get(i), 0.0);
            ++this.indCount;
        }
        if (this.withShow) {
            this.drawPop(pop, 1, false);
        }
    }

    private void drawPop(Population pop, int graphLabel, boolean useCircles) {
        if (this.myPlot != null) {
            if (graphLabel < 0) {
                graphLabel = this.indCount;
            }
            for (int i = 0; i < pop.size(); ++i) {
                InterfaceDataTypeDouble endy = (InterfaceDataTypeDouble)((Object)pop.getEAIndividual(i));
                double[] curPosition = endy.getDoubleData();
                if (useCircles) {
                    this.myPlot.getFunctionArea().drawCircle("", curPosition, graphLabel);
                    continue;
                }
                this.myPlot.setUnconnectedPoint(curPosition[0], curPosition[1], graphLabel);
            }
        }
    }

    protected void applyMotionModel(AbstractEAIndividual indy, double noise) {
        indy.mutate();
        indy.resetFitness(0.0);
    }

    @Override
    public void optimize() {
        Population nextGeneration = this.resample(this.population);
        if (this.sleepTime > 0) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.withShow) {
            this.clearPlot();
        }
        this.predict(nextGeneration);
        this.population = this.evaluatePopulation(nextGeneration);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        if (problem instanceof AbstractOptimizationProblem) {
            ((AbstractOptimizationProblem)problem).informAboutOptimizer(this);
        }
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder strB = new StringBuilder(200);
        strB.append("Particle Filter:\nOptimization Problem: ");
        strB.append(this.optimizationProblem.getStringRepresentationForProblem(this));
        strB.append("\n");
        strB.append(this.population.getStringRepresentation());
        return strB.toString();
    }

    @Override
    public String getName() {
        return "PF";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setParentSelection(InterfaceSelection selection) {
        this.parentSelection = selection;
    }

    public InterfaceSelection getParentSelection() {
        return this.parentSelection;
    }

    public String parentSelectionTipText() {
        return "Choose a parent selection method.";
    }

    public boolean isWithShow() {
        return this.withShow;
    }

    public Plot getPlot() {
        return this.myPlot;
    }

    protected void clearPlot() {
        if (this.myPlot != null) {
            this.myPlot.clearAll();
            double[][] range = null;
            if (this.population != null && this.population.size() > 0) {
                range = ((InterfaceDataTypeDouble)this.population.get(0)).getDoubleRange();
            }
            if (range != null) {
                this.myPlot.setCornerPoints(range, 0);
            }
        }
    }

    public void setWithShow(boolean withShow) {
        this.withShow = withShow;
        if (!this.withShow) {
            this.myPlot = null;
        } else {
            Object range;
            if (this.population != null && this.population.size() > 0) {
                range = ((InterfaceDataTypeDouble)this.population.get(0)).getDoubleRange();
            } else {
                range = new double[2][];
                range[0] = new double[2];
                range[0][0] = 0.0;
                range[0][1] = 0.0;
                range[1] = range[0];
            }
            this.myPlot = new Plot("PF", "x1", "x2", range[0], range[1]);
        }
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public double getMutationSigma() {
        return this.mutationSigma;
    }

    public void setMutationSigma(double mutationSigma) {
        this.mutationSigma = mutationSigma;
    }

    public String mutationSigmaTipText() {
        return "The (fixed) mutation step for the gaussian motion model";
    }

    public double getRndImmigrQuota() {
        return this.randomImmigrationQuota;
    }

    public void setRndImmigrQuota(double randomImmigrationQuota) {
        this.randomImmigrationQuota = randomImmigrationQuota;
    }

    public String rndImmigrQuotaTipText() {
        return "The give ratio of the population will be reinitialized randomly in every iteration.";
    }

    public double getInitialVelocity() {
        return this.initialVelocity;
    }

    public void setInitialVelocity(double initialVelocity) {
        this.initialVelocity = initialVelocity;
    }

    public String initialVelocityTipText() {
        return "If > 0, a linear motion model will be applied, otherwise the gaussian model";
    }

    public double getRotationDeg() {
        return this.rotationDeg;
    }

    public void setRotationDeg(double rotationDeg) {
        this.rotationDeg = rotationDeg;
    }

    public int getPopSize() {
        return this.popSize;
    }

    public void setPopSize(int popSize) {
        this.popSize = popSize;
        this.population.setTargetSize(popSize);
    }
}

