/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.ParticleSwarmOptimizationGCPSO;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import java.util.Vector;

public class ParticleSubSwarmOptimization
extends ParticleSwarmOptimizationGCPSO {
    protected double maxAllowedSwarmRadiusNormal;
    public static boolean hideFromGOE = true;
    protected boolean active;
    protected double maxPosDist;
    private int particleIndexCounter;
    private int fitnessArchiveSize = 15;

    public ParticleSubSwarmOptimization() {
        this.updateMaxPosDist();
        this.maxAllowedSwarmRadiusNormal = 0.1;
        this.active = true;
        this.particleIndexCounter = this.getPopulation().size();
    }

    public ParticleSubSwarmOptimization(ParticleSubSwarmOptimization a) {
        super(a);
        if (a.bestIndividual != null) {
            this.bestIndividual = (AbstractEAIndividual)a.bestIndividual.clone();
        }
        this.maxAllowedSwarmRadiusNormal = a.maxAllowedSwarmRadiusNormal;
        this.active = a.active;
        this.maxPosDist = a.maxPosDist;
        this.particleIndexCounter = a.particleIndexCounter;
        this.fitnessArchiveSize = a.fitnessArchiveSize;
    }

    @Override
    public Object clone() {
        return new ParticleSubSwarmOptimization(this);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initIndividuals();
        this.updateMBestIndividual();
        this.updateMaxPosDist();
        this.particleIndexCounter = this.getPopulation().size();
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        super.initializeByPopulation(pop, reset);
        this.initIndividuals();
        this.updateMBestIndividual();
        this.updateMaxPosDist();
        this.particleIndexCounter = this.getPopulation().size();
    }

    protected void initIndividuals() {
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = this.population.getEAIndividual(i);
            ParticleSubSwarmOptimization.initSubSwarmDefaultsOf(indy);
        }
    }

    public static void initSubSwarmDefaultsOf(AbstractEAIndividual indy) {
        ParticleSubSwarmOptimization.initFitnessArchiveOf(indy);
        ParticleSubSwarmOptimization.initFitnessStdDevOf(indy);
        ParticleSubSwarmOptimization.initPersonalBestOf(indy);
        ParticleSubSwarmOptimization.initPBestImprInARowOf(indy);
    }

    public static void initFitnessArchiveOf(AbstractEAIndividual indy) {
        Vector<Double> vec = new Vector<Double>();
        double scalarFitness = ParticleSubSwarmOptimization.sum(indy.getFitness());
        vec.add(scalarFitness);
        indy.putData("FitnessArchiveKey", vec);
    }

    public static void initFitnessStdDevOf(AbstractEAIndividual indy) {
        indy.putData("StdDevKey", Double.POSITIVE_INFINITY);
    }

    public static void initPBestImprInARowOf(AbstractEAIndividual indy) {
        indy.putData("PBestImprovementsInARow", 0);
    }

    public static void initPersonalBestOf(AbstractEAIndividual indy) {
        AbstractEAIndividual newpbest = (AbstractEAIndividual)indy.clone();
        newpbest.putData("PersonalBestKey", null);
        indy.putData("PersonalBestKey", newpbest);
    }

    @Override
    public void optimize() {
        super.optimize();
        this.updateFitnessArchives();
        this.updateFitnessStdDev();
        this.updatePersonalBest();
        this.updateMBestIndividual();
    }

    public void reinitIndividuals(Vector<int[]> indicesToReinit) {
        for (int[] indices : indicesToReinit) {
            this.addNewParticlesToPopulation(indices);
        }
    }

    private int[] getNextIndices(int num) {
        int[] indices = new int[num];
        for (int i = 0; i < num; ++i) {
            indices[i] = this.particleIndexCounter++;
        }
        return indices;
    }

    public void reinitIndividuals(int numIndies) {
        this.addNewParticlesToPopulation(this.getNextIndices(numIndies));
    }

    protected AbstractEAIndividual getIndyByParticleIndexAndPopulation(Population pop, Integer index) {
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            if (index.intValue() != indy.getIndividualIndex()) continue;
            return indy;
        }
        return null;
    }

    @Override
    protected void addSortedIndicesTo(Object[] sortedPopulation, Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            int origIndex = ((AbstractEAIndividual)sortedPopulation[i]).getIndividualIndex();
            AbstractEAIndividual indy = this.getIndyByParticleIndexAndPopulation(pop, origIndex);
            indy.putData("sortedParticleIndex", i);
        }
    }

    public void populationSizeHasChanged() {
        this.updateMBestIndividual();
    }

    protected void updateMBestIndividual() {
        if (this.getPopulation().size() == 0) {
            return;
        }
        AbstractEAIndividual bestindy = this.getPopulation().getBestEAIndividual();
        AbstractEAIndividual bestindypbest = (AbstractEAIndividual)bestindy.getData("PersonalBestKey");
        this.bestIndividual = (AbstractEAIndividual)bestindypbest.clone();
        for (int i = 0; i < this.getPopulation().size(); ++i) {
            AbstractEAIndividual currentindy = this.getPopulation().getEAIndividual(i);
            AbstractEAIndividual currentindypbest = (AbstractEAIndividual)currentindy.getData("PersonalBestKey");
            if (!currentindypbest.isDominating(this.bestIndividual)) continue;
            this.bestIndividual = (AbstractEAIndividual)currentindypbest.clone();
        }
    }

    public void updateFitnessArchives() {
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = this.population.getEAIndividual(i);
            Vector fitArchive_old = (Vector)indy.getData("FitnessArchiveKey");
            double scalarFitness = ParticleSubSwarmOptimization.sum(indy.getFitness());
            Double fitness = scalarFitness;
            Vector fitArchive_new = new Vector();
            int end = fitArchive_old.size();
            int start = 0;
            if (end >= this.fitnessArchiveSize) {
                start = end - this.fitnessArchiveSize;
            }
            for (int j = start; j < end; ++j) {
                fitArchive_new.add(fitArchive_old.get(j));
            }
            fitArchive_new.add(fitness);
            indy.putData("FitnessArchiveKey", fitArchive_new);
        }
    }

    public void updateFitnessStdDev() {
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual currentindy = this.population.getEAIndividual(i);
            Vector fitnessArchive = (Vector)currentindy.getData("FitnessArchiveKey");
            double sd = ParticleSubSwarmOptimization.stdDev(fitnessArchive, 3);
            currentindy.putData("StdDevKey", sd);
        }
    }

    public void updatePersonalBest() {
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual pbest;
            AbstractEAIndividual currentindy = this.population.getEAIndividual(i);
            if (currentindy.isDominating(pbest = (AbstractEAIndividual)currentindy.getData("PersonalBestKey"))) {
                ParticleSubSwarmOptimization.initPersonalBestOf(currentindy);
                Integer counter = (Integer)currentindy.getData("PBestImprovementsInARow");
                counter = counter + 1;
                currentindy.putData("PBestImprovementsInARow", counter);
                continue;
            }
            ParticleSubSwarmOptimization.initPBestImprInARowOf(currentindy);
        }
    }

    public void updateMaxPosDist() {
        AbstractOptimizationProblem prob = (AbstractOptimizationProblem)this.optimizationProblem;
        AbstractEAIndividual template = prob.getIndividualTemplate();
        if (template == null) {
            System.out.println("Problem does not implement getIndividualTemplate, updateMaxPosDist could not infer dimensions");
            return;
        }
        if (!(template instanceof ESIndividualDoubleData) && !(template instanceof InterfaceDataTypeDouble)) {
            System.out.println("Problem does not use ESIndividualDoubleData or InterfaceDataTypeDouble. UpdateMaxPosDist could not infer dimensions.");
            return;
        }
        double[][] range = null;
        range = template instanceof ESIndividualDoubleData ? ((ESIndividualDoubleData)template).getDoubleRange() : ((InterfaceDataTypeDouble)((Object)template)).getDoubleRange();
        double[] minValInDim = new double[range.length];
        double[] maxValInDim = new double[range.length];
        for (int i = 0; i < minValInDim.length; ++i) {
            minValInDim[i] = range[i][0];
            maxValInDim[i] = range[i][1];
        }
        this.maxPosDist = Mathematics.euclideanDist(minValInDim, maxValInDim);
    }

    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        return EuclideanMetric.euclideanDistance(AbstractEAIndividual.getDoublePositionShallow(indy1), AbstractEAIndividual.getDoublePositionShallow(indy2));
    }

    protected static double mean(Vector<Double> vec, int range) {
        if (vec.size() < range) {
            range = vec.size();
        }
        double sum = 0.0;
        for (int i = vec.size() - range; i < vec.size(); ++i) {
            sum += vec.get(i).doubleValue();
        }
        return sum / (double)range;
    }

    public static double stdDev(Vector<Double> vec, int range) {
        double ssum = 0.0;
        if (vec.size() - range < 0 || range < 2) {
            return Double.POSITIVE_INFINITY;
        }
        double mean = ParticleSubSwarmOptimization.mean(vec, range);
        for (int i = vec.size() - range; i < vec.size(); ++i) {
            ssum += Math.pow(vec.get(i) - mean, 2.0);
        }
        double result = Math.sqrt(ssum / (double)(range - 1));
        return result;
    }

    private static double sum(double[] fitness) {
        double ret = 0.0;
        for (double d : fitness) {
            ret += d;
        }
        return ret;
    }

    public double interpreteAsNormalisedSwarmRadius(double normalisedRadius) {
        if (normalisedRadius > 1.0 || normalisedRadius < 0.0) {
            System.out.println("interpreteAsNormalisedSwarmRadius: Radius not normalised to [0,1]");
        }
        return normalisedRadius * this.maxPosDist;
    }

    private void addNewParticlesToPopulation(int[] particleIndices) {
        if (particleIndices == null) {
            throw new RuntimeException("Error, unable to use null index array (ParticleSubSwarmOptimization.addNewParticlesToPOpulation)");
        }
        Population tmp = new Population();
        tmp.setTargetSize(particleIndices.length);
        AbstractOptimizationProblem prob = (AbstractOptimizationProblem)this.optimizationProblem;
        AbstractEAIndividual template = prob.getIndividualTemplate();
        for (int i = 0; i < tmp.getTargetSize(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)template.clone();
            tmpIndy.initialize(prob);
            tmp.add(tmpIndy);
        }
        tmp.initialize();
        ParticleSubSwarmOptimization tmpopt = new ParticleSubSwarmOptimization();
        tmpopt.setProblem(this.optimizationProblem);
        tmpopt.evaluatePopulation(tmp);
        tmpopt.initializeByPopulation(tmp, false);
        if (particleIndices != null) {
            for (int i = 0; i < tmpopt.getPopulation().size(); ++i) {
                AbstractEAIndividual indy = tmpopt.getPopulation().getEAIndividual(i);
                indy.setIndividualIndex(particleIndices[i]);
                indy.putData("newParticleFlag", Boolean.TRUE);
            }
        }
        this.addPopulation(tmpopt);
        this.populationSizeHasChanged();
    }

    public void addPopulation(ParticleSubSwarmOptimization pop) {
        this.addPopulation(pop.getPopulation());
    }

    public void addPopulation(Population pop) {
        this.population.addPopulation(pop);
        this.population.incrFunctionCallsBy(pop.getFunctionCalls());
    }

    public boolean addIndividual(IndividualInterface ind) {
        return this.population.addIndividual(ind);
    }

    public boolean add(Object o) {
        return this.addIndividual((IndividualInterface)o);
    }

    public void add(AbstractEAIndividual indy) {
        this.addIndividual(indy);
    }

    public boolean removeSubIndividual(IndividualInterface ind) {
        return this.population.removeMember(ind);
    }

    public void removeSubPopulation(Population pop, boolean allowMissing) {
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            if (this.removeSubIndividual(indy) || allowMissing) continue;
            throw new RuntimeException("Warning, assumed sub population was not contained (ParticleSubSwarmOptimization).");
        }
    }

    @Override
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        this.updateMaxPosDist();
    }

    public double getSwarmRadius() {
        if (this.getPopulation().size() == 0 || this.getPopulation().size() == 1) {
            return 0.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = this.population.getEAIndividual(i);
            double sqrdDist = EuclideanMetric.squaredEuclideanDistance(AbstractEAIndividual.getDoublePositionShallow(this.bestIndividual), AbstractEAIndividual.getDoublePositionShallow(indy));
            if (!(sqrdDist > max)) continue;
            max = sqrdDist;
        }
        return Math.sqrt(max);
    }

    public double getBoundSwarmRadius() {
        double maxAllowedSwarmRadiusAbs = this.getMaxAllowedSwarmRadiusAbs();
        return Math.min(this.getSwarmRadius(), maxAllowedSwarmRadiusAbs);
    }

    public double getMaxAllowedSwarmRadiusAbs() {
        return this.interpreteAsNormalisedSwarmRadius(this.maxAllowedSwarmRadiusNormal);
    }

    public double getAveDistToNeighbor() {
        Population pop = this.getPopulation();
        double sum = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            AbstractEAIndividual neigbor = this.getMemberNeighbor(indy);
            if (neigbor == null) {
                return -1.0;
            }
            sum += this.distance(indy, neigbor);
        }
        return sum / (double)pop.size();
    }

    public double getEuclideanDiversity() {
        double meanDistanceFromGBestPos = 0.0;
        AbstractEAIndividual gbest = this.getGBestIndividual();
        for (int i = 0; i < this.getPopulation().size(); ++i) {
            AbstractEAIndividual indy = this.getPopulation().getEAIndividual(i);
            meanDistanceFromGBestPos += this.distance(gbest, indy);
        }
        return meanDistanceFromGBestPos /= (double)this.getPopulation().size();
    }

    public void SetMaxAllowedSwarmRadius(double maxAllowedSwarmRadius) {
        this.maxAllowedSwarmRadiusNormal = maxAllowedSwarmRadius;
    }

    public double getMaxAllowedSwarmRadius() {
        return this.maxAllowedSwarmRadiusNormal;
    }

    public void SetActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public AbstractEAIndividual getMemberNeighbor(AbstractEAIndividual indy) {
        if (this.getPopulation().size() == 0) {
            System.out.println("getNeighbor: swarm empty");
            return null;
        }
        if (this.getPopulation().size() == 1) {
            return null;
        }
        int index = -1;
        double mindist = Double.POSITIVE_INFINITY;
        boolean found = false;
        for (int i = 0; i < this.getPopulation().size(); ++i) {
            AbstractEAIndividual currentindy = this.getPopulation().getEAIndividual(i);
            if (indy.getIndyID() != currentindy.getIndyID()) {
                double dist = this.distance(indy, currentindy);
                if (!(dist < mindist)) continue;
                mindist = dist;
                index = i;
                continue;
            }
            found = true;
        }
        if (!found) {
            System.err.println("getNeighbor: particle searching for neighbor is not part of the swarm");
        }
        return this.getPopulation().getEAIndividual(index);
    }

    public AbstractEAIndividual getGBestIndividual() {
        return this.bestIndividual;
    }

    public AbstractEAIndividual getParticleWithWorstPBestButNot(AbstractEAIndividual indyToExclude) {
        Population pop = this.getPopulation();
        if (pop.size() < 2) {
            System.out.println("getParticleWithWorstPBestButNot: Population < 2 - returning null");
            return null;
        }
        AbstractEAIndividual indyWithWorstPBest = pop.getEAIndividual(0);
        if (indyWithWorstPBest == indyToExclude) {
            indyWithWorstPBest = pop.getEAIndividual(1);
        }
        AbstractEAIndividual worstPBest = (AbstractEAIndividual)indyWithWorstPBest.getData("PersonalBestKey");
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual currentindy = pop.getEAIndividual(i);
            AbstractEAIndividual currentpbest = (AbstractEAIndividual)currentindy.getData("PersonalBestKey");
            if (currentindy == indyToExclude || !worstPBest.isDominating(currentpbest)) continue;
            indyWithWorstPBest = currentindy;
            worstPBest = currentpbest;
        }
        return indyWithWorstPBest;
    }

    public int getFitnessArchiveSize() {
        return this.fitnessArchiveSize;
    }

    public void setFitnessArchiveSize(int fitnessArchiveSize) {
        this.fitnessArchiveSize = fitnessArchiveSize;
    }

    public String fitnessArchiveSizeTipText() {
        return "The number of fitness values stored per individual for deactivation strategies.";
    }
}

