/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import Jama.Matrix;
import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.Plot;
import eva2.gui.plot.TopoPlot;
import eva2.optimization.enums.PSOTopology;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.operator.paramcontrol.ParameterControlManager;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceProblemDouble;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointSet;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

@Description(value="Particle Swarm Optimization by Kennedy and Eberhart.")
public class ParticleSwarmOptimization
extends AbstractOptimizer
implements Serializable,
InterfaceAdditionalPopulationInformer {
    Object[] sortedPop = null;
    protected AbstractEAIndividual bestIndividual = null;
    protected boolean checkRange = true;
    protected boolean checkSpeedLimit = false;
    protected boolean useAlternative = false;
    protected PSOTopology topology = PSOTopology.grid;
    protected PSOType algType;
    protected int topologyRange = 2;
    protected double initialVelocity = 0.2;
    protected double speedLimit = 0.1;
    protected double phi1 = 2.05;
    protected double phi2 = 2.05;
    protected double swarmRadius = 0.2;
    protected int maxSubSwarmSize = 0;
    protected int minSubSwarmSize = 2;
    protected int treeStruct = 1;
    protected boolean wrapTopology = true;
    protected int treeLevels;
    protected int treeOrphans;
    protected int treeLastFullLevelNodeCnt;
    protected int dmsRegroupInterval = 10;
    private transient Vector<int[]> dmsLinks = null;
    protected ParameterControlManager paramControl = new ParameterControlManager();
    protected double inertnessOrChi = 0.73;
    protected double reduceSpeed = 0.8;
    private double reduceSpeedOnConstViolation = 0.5;
    public static final int defaultType = 0;
    public static final int resetType = 99;
    static final transient String partTypeKey = "ParticleType";
    public static final transient String partBestPosKey = "BestPosition";
    static final transient String partBestFitKey = "BestFitness";
    public static final transient String partVelKey = "Velocity";
    static final transient String multiSwTypeKey = "MultiSwarmType";
    static final transient String multiSwSizeKey = "MultiSwarmSize";
    static final transient String indexKey = "particleIndex";
    static final transient String sortedIndexKey = "sortedParticleIndex";
    static final transient String dmsGroupIndexKey = "dmsGroupIndex";
    protected String indentifier = "";
    private transient TopoPlot topoPlot = null;
    protected int sleepTime = 0;
    private transient double[] tracedVelocity = null;
    private int emaPeriods = 0;
    protected transient boolean show = false;
    protected transient Plot plot;
    private boolean externalInitialPop = false;
    private static String lastSuccessKey = "successfulUpdate";

    public ParticleSwarmOptimization() {
        this.topology = PSOTopology.grid;
        this.algType = PSOType.Constriction;
        this.setConstriction(this.getPhi1(), this.getPhi2());
        this.hideHideable();
    }

    public ParticleSwarmOptimization(ParticleSwarmOptimization a) {
        this.topology = a.topology;
        this.algType = a.algType;
        this.population = (Population)a.population.clone();
        this.optimizationProblem = a.optimizationProblem;
        this.indentifier = a.indentifier;
        this.initialVelocity = a.initialVelocity;
        this.speedLimit = a.speedLimit;
        this.phi1 = a.phi1;
        this.phi2 = a.phi2;
        this.inertnessOrChi = a.inertnessOrChi;
        this.topologyRange = a.topologyRange;
        this.paramControl = (ParameterControlManager)a.paramControl.clone();
    }

    public ParticleSwarmOptimization(int popSize, double p1, double p2, PSOTopology topo, int topoRange) {
        this();
        this.algType = PSOType.Constriction;
        this.population = new Population(popSize);
        this.setPhiValues(p1, p2);
        this.topologyRange = topoRange;
        this.topology = topo;
    }

    @Override
    public Object clone() {
        return new ParticleSwarmOptimization(this);
    }

    public void hideHideable() {
        this.setCheckSpeedLimit(this.checkSpeedLimit);
        this.setTopology(this.getTopology());
    }

    @Override
    public void initialize() {
        if (this.plot != null) {
            this.plot = null;
        }
        if (this.topoPlot != null) {
            this.topoPlot = null;
        }
        this.tracedVelocity = null;
        if (!this.externalInitialPop) {
            this.optimizationProblem.initializePopulation(this.population);
        }
        this.initDefaults(this.population);
        this.evaluatePopulation(this.population);
        if (this.bestIndividual == null) {
            this.bestIndividual = this.population.getBestEAIndividual();
        }
        this.initializeByPopulation(null, false);
        this.externalInitialPop = false;
    }

    public static void initIndividualDefaults(AbstractEAIndividual indy, double initialV) {
        double[] writeData = Mathematics.randomVector(((InterfaceDataTypeDouble)((Object)indy)).getDoubleData().length, 1.0);
        double relSpeed = Mathematics.getRelativeLength(writeData, ((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange());
        for (int j = 0; j < writeData.length; ++j) {
            writeData[j] = writeData[j] / relSpeed * initialV;
        }
        indy.putData(partTypeKey, 0);
        indy.putData(partVelKey, writeData);
    }

    protected static void initIndividualMemory(AbstractEAIndividual indy) {
        double[] tmpD = indy.getFitness();
        double[] writeData = new double[tmpD.length];
        System.arraycopy(tmpD, 0, writeData, 0, tmpD.length);
        indy.putData(partBestFitKey, writeData);
        tmpD = ((InterfaceDataTypeDouble)((Object)indy)).getDoubleData();
        writeData = new double[tmpD.length];
        System.arraycopy(tmpD, 0, writeData, 0, tmpD.length);
        indy.putData(partBestPosKey, writeData);
    }

    protected void traceEMA(Population population) {
        if (population.get(0) instanceof InterfaceDataTypeDouble) {
            if (population.getGeneration() == 0) {
                return;
            }
            double[] curAvVelAndSpeed = ParticleSwarmOptimization.getPopulationVelSpeed(population, 3, partVelKey, partTypeKey, 0);
            double[][] range = ((InterfaceDataTypeDouble)population.get(0)).getDoubleRange();
            if (this.tracedVelocity == null) {
                this.tracedVelocity = new double[((InterfaceDataTypeDouble)population.get(0)).getDoubleData().length];
                System.arraycopy(curAvVelAndSpeed, 0, this.tracedVelocity, 0, this.tracedVelocity.length);
            } else if (population.getGeneration() < this.emaPeriods) {
                this.addMovingAverage(this.tracedVelocity, curAvVelAndSpeed, 2.0 / (double)(population.getGeneration() + 1));
            } else {
                this.addMovingAverage(this.tracedVelocity, curAvVelAndSpeed, 2.0 / (double)(this.emaPeriods + 1));
            }
            if (this.show) {
                System.out.println(population.getGeneration() + " - abs avg " + curAvVelAndSpeed[curAvVelAndSpeed.length - 1] + ", vect " + Mathematics.getRelativeLength(curAvVelAndSpeed, range) + ", rel " + curAvVelAndSpeed[curAvVelAndSpeed.length - 1] / Mathematics.getRelativeLength(curAvVelAndSpeed, range));
            }
        }
    }

    private void addMovingAverage(double[] speedSoFar, double[] curAvSpeed, double alpha) {
        for (int i = 0; i < speedSoFar.length; ++i) {
            speedSoFar[i] = (1.0 - alpha) * speedSoFar[i] + alpha * curAvSpeed[i];
        }
    }

    public double[] getEMASpeed() {
        return this.tracedVelocity;
    }

    public double getRelativeEMASpeed(double[][] range) {
        return Mathematics.getRelativeLength(this.getEMASpeed(), range);
    }

    public static double[] getPopulationVelSpeed(Population pop, int calcModeSwitch, String velocityKey, String typeString, Object requiredType) {
        double[] velocity;
        boolean calcAbsSpeedAverage;
        AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(0);
        if (!(indy instanceof InterfaceDataTypeDouble)) {
            System.err.println("error, PSO needs individuals with double data!");
        }
        double[][] range = ((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange();
        int retSize = 0;
        boolean calcVectVelocity = (calcModeSwitch & 1) > 0;
        boolean bl = calcAbsSpeedAverage = (calcModeSwitch & 2) > 0;
        if ((calcModeSwitch & 3) == 0) {
            System.err.println("Error, switch must be 1, 2 or 3 (getPopulationVelSpeed)");
        }
        if ((velocity = (double[])indy.getData(velocityKey)) != null) {
            if (calcVectVelocity) {
                retSize += velocity.length;
            }
            if (calcAbsSpeedAverage) {
                ++retSize;
            }
            double[] ret = new double[retSize];
            double[] cumulVeloc = new double[velocity.length];
            double avSpeed = 0.0;
            for (int i = 0; i < cumulVeloc.length; ++i) {
                cumulVeloc[i] = 0.0;
            }
            int indCnt = 0;
            for (int i = 0; i < pop.size(); ++i) {
                indy = (AbstractEAIndividual)pop.get(i);
                if (!indy.hasData(velocityKey)) continue;
                velocity = (double[])indy.getData(velocityKey);
                if (velocity != null) {
                    if (typeString != null && !indy.getData(typeString).equals(requiredType)) continue;
                    ++indCnt;
                    if (calcVectVelocity) {
                        for (int j = 0; j < cumulVeloc.length; ++j) {
                            int n = j;
                            cumulVeloc[n] = cumulVeloc[n] + velocity[j];
                        }
                    }
                    if (!calcAbsSpeedAverage) continue;
                    avSpeed += Mathematics.getRelativeLength(velocity, range);
                    continue;
                }
                System.err.println("Error: Indy without velocity!! (getPopulationVelSpeed)");
            }
            if (calcVectVelocity) {
                for (int j = 0; j < cumulVeloc.length; ++j) {
                    ret[j] = cumulVeloc[j] / (double)indCnt;
                }
            }
            if (calcAbsSpeedAverage) {
                ret[ret.length - 1] = avSpeed /= (double)indCnt;
            }
            return ret;
        }
        System.err.println("warning, no speed in particle! (getPopulationVelocity)");
        return null;
    }

    protected boolean particleHasSpeed(AbstractEAIndividual indy) {
        return this.isParticleType(indy, 0);
    }

    protected boolean isParticleTypeByIndex(int index, int type) {
        return this.isParticleType((AbstractEAIndividual)this.population.get(index), type);
    }

    protected boolean isParticleType(AbstractEAIndividual indy, int type) {
        return (Integer)indy.getData(partTypeKey) == type;
    }

    public double[] getPopulationVelocity(Population pop) {
        return ParticleSwarmOptimization.getPopulationVelSpeed(pop, 1, partVelKey, partTypeKey, 0);
    }

    public double getPopulationAvgNormedVelocity(Population pop) {
        return ParticleSwarmOptimization.getPopulationVelSpeed(pop, 2, partVelKey, partTypeKey, 0)[0];
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        if (pop != null) {
            this.population = (Population)pop.clone();
            this.externalInitialPop = true;
        }
        if (reset) {
            this.population.initialize();
        }
        if (!this.defaultsDone(this.population.getEAIndividual(0))) {
            this.initDefaults(this.population);
        }
        if (reset) {
            this.evaluatePopulation(this.population);
        }
        for (int i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)this.population.get(i);
            if (!(indy instanceof InterfaceDataTypeDouble)) continue;
            ParticleSwarmOptimization.initIndividualMemory(indy);
        }
        this.bestIndividual = (AbstractEAIndividual)this.population.getBestEAIndividual().clone();
        if (reset) {
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
        this.treeLevels = 0;
        if (this.getTopology() == PSOTopology.hpso || this.getTopology() == PSOTopology.tree) {
            if (this.topologyRange < 2) {
                System.err.println("Error, tree/hpso requires topology range of at least 2!");
            } else {
                while (this.getMaxNodes(this.topologyRange, this.treeLevels) < this.population.size()) {
                    ++this.treeLevels;
                }
                this.treeOrphans = this.population.size() - this.getMaxNodes(this.topologyRange, this.treeLevels - 1);
                this.treeLastFullLevelNodeCnt = (int)Math.pow(this.topologyRange, this.treeLevels - 1);
            }
        }
        if (this.getTopology() == PSOTopology.dms) {
            this.dmsLinks = this.regroupSwarm(this.population, this.getTopologyRange());
        }
    }

    private boolean defaultsDone(AbstractEAIndividual indy) {
        return indy.hasData(partVelKey) && indy.hasData(indexKey);
    }

    protected void initDefaults(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(i);
            if (!(!(indy instanceof InterfaceDataTypeDouble) || this.externalInitialPop && this.defaultsDone(indy))) {
                ParticleSwarmOptimization.initIndividualDefaults(indy, this.initialVelocity);
            }
            indy.putData(indexKey, i);
            indy.setIndividualIndex(i);
        }
    }

    public int getMaxNodes(int branch, int depth) {
        int ret = (int)((Math.pow(branch, depth + 1) - 1.0) / (double)(branch - 1));
        return ret;
    }

    protected void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
        if (this.emaPeriods > 0) {
            this.traceEMA(population);
        }
    }

    public static void dumpPop(String prefix, Population pop) {
        if (prefix != null) {
            System.out.println(prefix);
        }
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            String info = ParticleSwarmOptimization.getParticleInfo(indy);
            System.out.println(info);
        }
    }

    public static String getParticleInfo(AbstractEAIndividual indy) {
        String str = AbstractEAIndividual.getDefaultStringRepresentation(indy);
        str = str + " / Vel: " + BeanInspector.toString(indy.getData(partVelKey));
        str = str + " / BestP: " + BeanInspector.toString(indy.getData(partBestPosKey));
        str = str + " / BestF: " + BeanInspector.toString(indy.getData(partBestFitKey));
        str = str + " / PType: " + indy.getData(partTypeKey);
        return str;
    }

    protected void compareAndSetAttractor(double[] attractorFit, double[] attractorPos, AbstractEAIndividual neighbourIndy, boolean useHistoric) {
        double[] neighbourPos;
        double[] neighbourFit;
        if (useHistoric) {
            neighbourFit = (double[])neighbourIndy.getData(partBestFitKey);
            neighbourPos = (double[])neighbourIndy.getData(partBestPosKey);
        } else {
            neighbourFit = neighbourIndy.getFitness();
            neighbourPos = ((InterfaceDataTypeDouble)((Object)neighbourIndy)).getDoubleData();
        }
        if (neighbourFit == null || attractorFit == null) {
            System.err.println("error!");
        }
        if (AbstractEAIndividual.isDominatingFitness(neighbourFit, attractorFit)) {
            System.arraycopy(neighbourFit, 0, attractorFit, 0, neighbourFit.length);
            System.arraycopy(neighbourPos, 0, attractorPos, 0, neighbourPos.length);
        }
    }

    protected void resetIndividual(AbstractEAIndividual indy) {
        ParticleSwarmOptimization.resetIndividual(indy, this.initialVelocity);
        this.plotIndy(((InterfaceDataTypeDouble)((Object)indy)).getDoubleData(), null, (Integer)indy.getData(indexKey));
    }

    public static void resetIndividual(AbstractEAIndividual indy, double initialV) {
        if (indy instanceof InterfaceDataTypeDouble) {
            indy.setParents(null);
            indy.defaultInit(null);
            indy.putData(partTypeKey, 0);
            ParticleSwarmOptimization.initIndividualDefaults(indy, initialV);
            ParticleSwarmOptimization.initIndividualMemory(indy);
        } else {
            System.err.println("error, double valued individuals required for PSO");
        }
    }

    protected void updateIndividual(int index, AbstractEAIndividual indy, Population pop) {
        if (indy instanceof InterfaceDataTypeDouble) {
            int type = (Integer)indy.getData(partTypeKey);
            switch (type) {
                case 99: {
                    this.resetIndividual(indy);
                    break;
                }
                case 0: {
                    this.defaultIndividualUpdate(index, indy, pop);
                    break;
                }
                default: {
                    System.err.println("particle type " + type + " unknown!");
                    break;
                }
            }
        } else {
            throw new RuntimeException("Could not perform PSO update, because individual is not instance of InterfaceESIndividual!");
        }
    }

    protected void defaultIndividualUpdate(int index, AbstractEAIndividual indy, Population pop) {
        InterfaceDataTypeDouble endy = (InterfaceDataTypeDouble)((Object)indy);
        indy.putData(partTypeKey, 0);
        double[] personalBestPos = (double[])indy.getData(partBestPosKey);
        double[] velocity = (double[])indy.getData(partVelKey);
        double[] curPosition = endy.getDoubleData();
        double[][] range = endy.getDoubleRange();
        double[] neighbourBestPos = this.findNeighbourhoodOptimum(index, pop);
        double[] curVelocity = this.updateVelocity(index, velocity, personalBestPos, curPosition, neighbourBestPos, range);
        if (this.checkSpeedLimit) {
            this.enforceSpeedLimit(curVelocity, range, this.getSpeedLimit(index));
        }
        if (this.checkRange) {
            this.ensureConstraints(curPosition, curVelocity, range);
        }
        this.plotIndy(curPosition, curVelocity, (Integer)indy.getData(indexKey));
        this.updatePosition(indy, curVelocity, curPosition, range);
        this.resetFitness(indy);
    }

    protected void plotIndy(double[] curPosition, double[] curVelocity, int index) {
        if (this.show) {
            if (curVelocity == null) {
                this.plot.setUnconnectedPoint(curPosition[0], curPosition[1], index);
            } else {
                this.plot.setConnectedPoint(curPosition[0], curPosition[1], index);
                this.plot.setConnectedPoint(curPosition[0] + curVelocity[0], curPosition[1] + curVelocity[1], index);
            }
        }
    }

    protected void updateSwarmMemory(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(i);
            if (this.isIndividualToUpdate(indy)) {
                this.updateIndProps(indy, indy);
                indy.putData(lastSuccessKey, indy.getData(partVelKey));
                continue;
            }
            indy.putData(lastSuccessKey, null);
        }
    }

    protected void resetFitness(AbstractEAIndividual indy) {
        indy.resetFitness(0.0);
        indy.resetConstraintViolation();
    }

    protected void updateIndProps(AbstractEAIndividual trgIndy, AbstractEAIndividual srcIndy) {
        trgIndy.putData(partBestFitKey, srcIndy.getFitness().clone());
        trgIndy.putData(partBestPosKey, ((InterfaceDataTypeDouble)((Object)srcIndy)).getDoubleData());
    }

    protected boolean isIndividualToUpdate(AbstractEAIndividual indy) {
        double[] bestFitness = (double[])indy.getData(partBestFitKey);
        return AbstractEAIndividual.isDominatingFitnessNotEqual(indy.getFitness(), bestFitness);
    }

    protected double[] updateVelocity(int index, double[] lastVelocity, double[] personalBestPos, double[] curPosition, double[] neighbourBestPos, double[][] range) {
        double[] curVelocity = new double[lastVelocity.length];
        double[] accel = this.useAlternative ? this.getAccelerationAlternative(index, personalBestPos, neighbourBestPos, curPosition, range) : this.getAcceleration(personalBestPos, neighbourBestPos, curPosition, range);
        for (int i = 0; i < lastVelocity.length; ++i) {
            curVelocity[i] = this.inertnessOrChi * lastVelocity[i];
            int n = i;
            curVelocity[n] = curVelocity[n] + accel[i];
        }
        return curVelocity;
    }

    protected double[] getAcceleration(double[] personalBestPos, double[] neighbourBestPos, double[] curPosition, double[][] range) {
        double[] accel = new double[curPosition.length];
        for (int i = 0; i < personalBestPos.length; ++i) {
            accel[i] = 0.0;
            double chi = this.algType == PSOType.Constriction ? this.inertnessOrChi : 1.0;
            accel[i] = this.phi1 * chi * RNG.randomDouble(0.0, 1.0) * (personalBestPos[i] - curPosition[i]);
            int n = i;
            accel[n] = accel[n] + this.phi2 * chi * RNG.randomDouble(0.0, 1.0) * (neighbourBestPos[i] - curPosition[i]);
        }
        return accel;
    }

    protected double[] getAccelerationAlternative(int index, double[] personalBestPos, double[] neighbourBestPos, double[] curPosition, double[][] range) {
        double[] accel = this.getAcceleration(personalBestPos, neighbourBestPos, curPosition, range);
        double[] successfulVel = this.getSuccessfulVel(index);
        if (successfulVel != null) {
            Mathematics.vvAdd(accel, successfulVel, accel);
            Mathematics.svMult(0.5, accel, accel);
        }
        return accel;
    }

    private double[] getSuccessfulVel(int index) {
        return (double[])this.population.getEAIndividual(index).getData(lastSuccessKey);
    }

    protected Matrix getOrientedGaussianRandomVectorB(Matrix dir, double scale) {
        double len = dir.norm2();
        int dim = dir.getRowDimension();
        Matrix resVec = new Matrix(dim, 1);
        Matrix randVec = new Matrix(dim, 1);
        if (len > 0.0) {
            randVec.set(0, 0, ParticleSwarmOptimization.project(0.0, len, len / 2.0 + RNG.gaussianDouble(len / 2.0)));
            for (int i = 1; i < dim; ++i) {
                randVec.set(i, 0, ParticleSwarmOptimization.project(-len / 2.0, len / 2.0, RNG.gaussianDouble(len / (scale * 2.0))));
            }
            Matrix rotation = Mathematics.getRotationMatrix(dir);
            rotation = rotation.transpose();
            resVec = rotation.times(randVec);
        }
        return resVec;
    }

    protected double[] getGaussianVector(double[] mean, double dev) {
        double[] res = new double[mean.length];
        RNG.gaussianVector(dev, res, false);
        Mathematics.vvAdd(mean, res, res);
        return res;
    }

    public static double project(double min, double max, double val) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    protected void printMatrix(Matrix M) {
        for (int i = 0; i < M.getRowDimension(); ++i) {
            for (int j = 0; j < M.getColumnDimension(); ++j) {
                System.out.print(" " + M.get(i, j));
            }
            System.out.println("");
        }
    }

    protected double[] findNeighbourhoodOptimum(int index, Population pop) {
        double[] localBestPosition = null;
        double[] localBestFitness = null;
        AbstractEAIndividual indy = pop.getEAIndividual(index);
        boolean useHistoric = true;
        int sortedIndex = -1;
        localBestFitness = (double[])((double[])indy.getData(partBestFitKey)).clone();
        localBestPosition = (double[])((double[])indy.getData(partBestPosKey)).clone();
        AbstractEAIndividual bestIndy = useHistoric ? this.bestIndividual : pop.getBestEAIndividual();
        switch (this.topology) {
            case linear: {
                for (int x = -this.topologyRange; x <= this.topologyRange; ++x) {
                    int tmpIndex = this.wrapTopology ? (index + x + pop.size()) % pop.size() : index + x;
                    if (x == 0 || tmpIndex < 0 || tmpIndex >= pop.size()) continue;
                    this.compareAndSetAttractor(localBestFitness, localBestPosition, (AbstractEAIndividual)pop.get(tmpIndex), useHistoric);
                }
                break;
            }
            case grid: {
                int corner = 1 + (int)Math.sqrt(pop.size());
                for (int x = -this.topologyRange; x <= this.topologyRange; ++x) {
                    for (int y = -this.topologyRange; y <= this.topologyRange; ++y) {
                        int tmpIndex = index + x + y * corner;
                        if (this.wrapTopology) {
                            tmpIndex = (tmpIndex + pop.size()) % pop.size();
                        }
                        if (x == index || tmpIndex < 0 || tmpIndex >= pop.size()) continue;
                        this.compareAndSetAttractor(localBestFitness, localBestPosition, (AbstractEAIndividual)pop.get(tmpIndex), useHistoric);
                    }
                }
                break;
            }
            case star: {
                this.compareAndSetAttractor(localBestFitness, localBestPosition, bestIndy, useHistoric);
                break;
            }
            case multiSwarm: {
                AbstractEAIndividual leader = (AbstractEAIndividual)indy.getData(multiSwTypeKey);
                if (leader != null) {
                    if (leader == indy && (Integer)indy.getData(multiSwSizeKey) < this.minSubSwarmSize) {
                        this.compareAndSetAttractor(localBestFitness, localBestPosition, bestIndy, useHistoric);
                        break;
                    }
                    this.compareAndSetAttractor(localBestFitness, localBestPosition, leader, false);
                    break;
                }
                System.err.println("no leader present!");
                break;
            }
            case tree: {
                int k;
                sortedIndex = (Integer)((AbstractEAIndividual)this.sortedPop[index]).getData(sortedIndexKey);
                if (sortedIndex > 0) {
                    k = this.getParentIndex(this.topologyRange, sortedIndex, pop.size());
                    this.compareAndSetAttractor(localBestFitness, localBestPosition, (AbstractEAIndividual)this.sortedPop[k], useHistoric);
                }
                if (this.treeStruct != 1) break;
                if (this.isComplete(sortedIndex, pop.size())) {
                    k = this.topologyRange * sortedIndex + 1;
                    for (int i = 0; i < this.topologyRange; ++i) {
                        this.compareAndSetAttractor(localBestFitness, localBestPosition, (AbstractEAIndividual)this.sortedPop[k + i], useHistoric);
                    }
                } else {
                    int numOrphs;
                    if (!this.isIncomplete(sortedIndex, pop.size()) || (numOrphs = this.numOrphans(sortedIndex, pop.size())) <= 0) break;
                    k = this.indexOfFirstOrphan(sortedIndex, pop.size());
                    for (int i = 0; i < numOrphs; ++i) {
                        this.compareAndSetAttractor(localBestFitness, localBestPosition, (AbstractEAIndividual)this.sortedPop[k], useHistoric);
                        k += this.treeLastFullLevelNodeCnt;
                    }
                }
                break;
            }
            case hpso: {
                if (index < 0) break;
                int k = this.getParentIndex(this.topologyRange, index, pop.size());
                indy = (AbstractEAIndividual)pop.get(k);
                System.arraycopy(indy.getData(partBestFitKey), 0, localBestFitness, 0, localBestFitness.length);
                System.arraycopy(indy.getData(partBestPosKey), 0, localBestPosition, 0, localBestPosition.length);
                break;
            }
            case random: {
                for (int i = 0; i < this.topologyRange; ++i) {
                    indy = (AbstractEAIndividual)pop.get(RNG.randomInt(0, pop.size() - 1));
                    this.compareAndSetAttractor(localBestFitness, localBestPosition, indy, useHistoric);
                }
                break;
            }
            case dms: {
                int groupIndex = (Integer)pop.getEAIndividual(index).getData(dmsGroupIndexKey);
                int[] groupLinks = this.dmsLinks.get(groupIndex);
                for (int i = 0; i < groupLinks.length; ++i) {
                    if (groupLinks[i] == index) continue;
                    indy = pop.getEAIndividual(groupLinks[i]);
                    this.compareAndSetAttractor(localBestFitness, localBestPosition, indy, useHistoric);
                }
                break;
            }
        }
        return localBestPosition;
    }

    protected int getParentIndex(int branch, int index, int popSize) {
        int k;
        if (this.isOrphan(index, popSize)) {
            k = popSize - this.treeOrphans - this.treeLastFullLevelNodeCnt;
            k += (index - popSize + this.treeOrphans) % this.treeLastFullLevelNodeCnt;
        } else {
            k = (index - 1) / branch;
        }
        return k;
    }

    protected boolean isOrphan(int index, int popSize) {
        return index >= popSize - this.treeOrphans;
    }

    protected boolean isComplete(int index, int popSize) {
        return index < popSize - this.treeOrphans - this.treeLastFullLevelNodeCnt;
    }

    protected boolean isIncomplete(int index, int popSize) {
        return index < popSize - this.treeOrphans && index >= popSize - this.treeOrphans - this.treeLastFullLevelNodeCnt;
    }

    protected int numOrphans(int index, int popSize) {
        if (this.isIncomplete(index, popSize)) {
            int k = this.treeOrphans / this.treeLastFullLevelNodeCnt;
            if (index - (popSize - this.treeOrphans - this.treeLastFullLevelNodeCnt) >= this.treeOrphans % this.treeLastFullLevelNodeCnt) {
                return k;
            }
            return k + 1;
        }
        return -1;
    }

    protected int indexOfFirstOrphan(int index, int popSize) {
        if (this.isIncomplete(index, popSize)) {
            int k = popSize - this.treeOrphans + (index - (popSize - this.treeOrphans - this.treeLastFullLevelNodeCnt));
            return k;
        }
        return -1;
    }

    protected void updatePosition(AbstractEAIndividual indy, double[] curVelocity, double[] curPosition, double[][] range) {
        double[] newPosition = new double[curPosition.length];
        for (int i = 0; i < curPosition.length; ++i) {
            newPosition[i] = curPosition[i] + curVelocity[i];
        }
        if (this.checkRange && this.isOutOfRange(newPosition, range)) {
            System.err.println("error, individual violates constraints!");
        }
        if (indy instanceof InterfaceDataTypeDouble) {
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(newPosition);
        } else {
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(newPosition);
            if (!this.checkRange) {
                System.err.println("warning, checkbounds will be forced by InterfaceESIndividual!");
            }
        }
        indy.putData(partVelKey, curVelocity);
    }

    protected boolean isOutOfRange(double[] pos, double[][] range) {
        boolean violatesRange = false;
        for (int i = 0; i < pos.length && !violatesRange; ++i) {
            violatesRange = pos[i] < range[i][0] || pos[i] > range[i][1];
        }
        return violatesRange;
    }

    protected void enforceSpeedLimit(double[] curVelocity, double[][] range, double speedLim) {
        while (Mathematics.getRelativeLength(curVelocity, range) > speedLim) {
            int i = 0;
            while (i < curVelocity.length) {
                int n = i++;
                curVelocity[n] = curVelocity[n] * this.reduceSpeed;
            }
        }
    }

    protected void ensureConstraints(double[] pos, double[] velocity, double[][] range) {
        int i;
        double[] newPos = new double[pos.length];
        for (i = 0; i < pos.length; ++i) {
            newPos[i] = pos[i] + velocity[i];
        }
        if (this.isOutOfRange(pos, range)) {
            System.err.println("warning, ensureConstraints called with already violating position (PSO)... reinitializing particle.");
            for (i = 0; i < pos.length; ++i) {
                if (Mathematics.isInRange(pos[i], range[i][0], range[i][1])) continue;
                pos[i] = RNG.randomDouble(range[i][0], range[i][1]);
            }
        }
        for (i = 0; i < pos.length; ++i) {
            if (Mathematics.isInRange(newPos[i], range[i][0], range[i][1])) continue;
            if (pos[i] == range[i][0] || pos[i] == range[i][1]) {
                int n = i;
                velocity[n] = velocity[n] * this.reduceSpeedOnConstViolation;
                if (pos[i] == range[i][0] && newPos[i] < range[i][0] || pos[i] == range[i][1] && newPos[i] > range[i][1]) {
                    int n2 = i;
                    velocity[n2] = velocity[n2] * -1.0;
                }
                newPos[i] = pos[i] + velocity[i];
            } else {
                velocity[i] = newPos[i] < range[i][0] ? range[i][0] - pos[i] : range[i][1] - pos[i];
                newPos[i] = pos[i] + velocity[i];
                if (newPos[i] < range[i][0] || newPos[i] > range[i][1]) {
                    int n = i;
                    velocity[n] = velocity[n] * 0.999;
                    newPos[i] = pos[i] + velocity[i];
                }
            }
            while (newPos[i] < range[i][0] || newPos[i] > range[i][1]) {
                int n = i;
                velocity[n] = velocity[n] * this.reduceSpeedOnConstViolation;
                newPos[i] = pos[i] + velocity[i];
            }
        }
        if (this.isOutOfRange(newPos, range)) {
            System.err.println("narg, still out of range");
        }
    }

    @Override
    public void optimize() {
        this.startOptimize();
        this.updatePopulation();
        this.evaluatePopulation(this.population);
        this.updateSwarmMemory(this.population);
        this.logBestIndividual();
        this.firePropertyChangedEvent("NextGenerationPerformed");
        if (this.sleepTime > 0) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void maybeClearPlot() {
        if (this.population.getGeneration() % 23 == 0 && this.isShow() && this.plot != null) {
            this.plot.clearAll();
            InterfaceDataTypeDouble indy = (InterfaceDataTypeDouble)this.population.get(0);
            double[][] range = indy.getDoubleRange();
            this.plot.setCornerPoints(range, 0);
        }
    }

    protected void startOptimize() {
        if (this.show) {
            this.show();
        }
        this.sortedPop = null;
    }

    protected void logBestIndividual() {
        if (this.population.getBestEAIndividual().isDominatingDebConstraints(this.bestIndividual)) {
            this.bestIndividual = (AbstractEAIndividual)this.population.getBestEAIndividual().clone();
            this.bestIndividual.putData(partBestFitKey, this.bestIndividual.getFitness().clone());
            this.bestIndividual.putData(partBestPosKey, ((InterfaceDataTypeDouble)((Object)this.bestIndividual)).getDoubleData());
        }
    }

    protected void updatePopulation() {
        this.updateTopology(this.population);
        for (int i = 0; i < this.population.size(); ++i) {
            this.updateIndividual(i, (AbstractEAIndividual)this.population.get(i), this.population);
        }
        if (this.show && this.optimizationProblem instanceof Interface2DBorderProblem) {
            DPointSet popRep = new DPointSet();
            double[] a = new double[]{0.0, 0.0};
            if (this.topoPlot == null) {
                this.topoPlot = new TopoPlot("CBN-Species", "x", "y", a, a);
                this.topoPlot.setParams(60, 60);
                this.topoPlot.setTopology((Interface2DBorderProblem)((Object)this.optimizationProblem));
            }
            for (int i = 0; i < this.population.size(); ++i) {
                InterfaceDataTypeDouble tmpIndy1 = (InterfaceDataTypeDouble)this.population.get(i);
                popRep.addDPoint(new DPoint(tmpIndy1.getDoubleData()[0], tmpIndy1.getDoubleData()[1]));
            }
            this.topoPlot.getFunctionArea().addDElement(popRep);
        }
    }

    protected void addSortedIndicesTo(Object[] sortedPopulation, Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            int origIndex = (Integer)((AbstractEAIndividual)sortedPopulation[i]).getData(indexKey);
            ((AbstractEAIndividual)pop.get(origIndex)).putData(sortedIndexKey, i);
        }
    }

    protected void updateTopology(Population pop) {
        if (this.topology == PSOTopology.dms && pop.getGeneration() % this.getDmsRegroupGens() == 0) {
            this.dmsLinks = this.regroupSwarm(pop, this.getTopologyRange());
        }
        if (this.topology == PSOTopology.multiSwarm || this.topology == PSOTopology.tree) {
            this.sortedPop = pop.toArray();
            if (this.topology == PSOTopology.multiSwarm || this.treeStruct >= 2) {
                Arrays.sort(this.sortedPop, new EAIndividualComparator());
            } else {
                Arrays.sort(this.sortedPop, new EAIndividualComparator(partBestFitKey));
            }
            this.addSortedIndicesTo(this.sortedPop, pop);
        }
        if (this.topology == PSOTopology.multiSwarm) {
            PhenotypeMetric metric = new PhenotypeMetric();
            Vector<AbstractEAIndividual> leaders = new Vector<AbstractEAIndividual>(pop.size());
            boolean found = false;
            boolean superfluous = false;
            for (int cur = 0; cur < pop.size(); ++cur) {
                found = false;
                superfluous = false;
                for (int i = 0; i < leaders.size(); ++i) {
                    double dist = metric.distance((AbstractEAIndividual)this.sortedPop[cur], (AbstractEAIndividual)leaders.get(i));
                    if (!(this.swarmRadius * 2.0 > dist)) continue;
                    int sSize = (Integer)((AbstractEAIndividual)leaders.get(i)).getData(multiSwSizeKey);
                    if (this.maxSubSwarmSize > 0 && sSize >= this.maxSubSwarmSize) {
                        superfluous = true;
                        found = true;
                        break;
                    }
                    found = true;
                    ((AbstractEAIndividual)this.sortedPop[cur]).putData(multiSwTypeKey, leaders.get(i));
                    ((AbstractEAIndividual)this.sortedPop[cur]).putData(multiSwSizeKey, -1);
                    ((AbstractEAIndividual)leaders.get(i)).putData(multiSwSizeKey, 1 + sSize);
                    break;
                }
                if (!found) {
                    leaders.add((AbstractEAIndividual)this.sortedPop[cur]);
                    ((AbstractEAIndividual)this.sortedPop[cur]).putData(multiSwTypeKey, this.sortedPop[cur]);
                    ((AbstractEAIndividual)this.sortedPop[cur]).putData(multiSwSizeKey, 1);
                    continue;
                }
                if (!superfluous) continue;
                ((AbstractEAIndividual)this.sortedPop[cur]).putData(partTypeKey, 99);
                ((AbstractEAIndividual)this.sortedPop[cur]).putData(multiSwTypeKey, this.sortedPop[cur]);
                ((AbstractEAIndividual)this.sortedPop[cur]).putData(multiSwSizeKey, 1);
            }
        }
        if (this.topology == PSOTopology.hpso) {
            EAIndividualComparator comp = new EAIndividualComparator(partBestFitKey);
            for (int i = 0; i < pop.size(); ++i) {
                int parentIndex = this.getParentIndex(this.topologyRange, i, pop.size());
                if (comp.compare(pop.get(i), pop.get(parentIndex)) >= 0) continue;
                AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(i);
                pop.set(i, (AbstractEAIndividual)pop.get(parentIndex));
                pop.set(parentIndex, indy);
            }
        }
    }

    private Vector<int[]> regroupSwarm(Population pop, int groupSize) {
        int numGroups = pop.size() / groupSize;
        int[] perm = RNG.randomPerm(pop.size());
        Vector<int[]> links = new Vector<int[]>(numGroups);
        for (int i = 0; i < numGroups; ++i) {
            if (i < numGroups - 1) {
                links.add(new int[groupSize]);
            } else {
                links.add(new int[pop.size() - groupSize * i]);
            }
            int[] group = links.get(i);
            for (int k = 0; k < group.length; ++k) {
                group[k] = perm[groupSize * i + k];
                pop.getEAIndividual(group[k]).putData(dmsGroupIndexKey, i);
            }
        }
        return links;
    }

    protected void show() {
        if (this.plot == null) {
            InterfaceDataTypeDouble indy = (InterfaceDataTypeDouble)this.population.get(0);
            double[][] range = indy.getDoubleRange();
            this.plot = new Plot("PSO " + this.population.getGeneration(), "x1", "x2", range[0], range[1]);
        }
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Particle Swarm Optimization:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "PSO-" + (Object)((Object)this.getTopology()) + this.getTopologyRange() + "_" + this.getPhi1() + "_" + this.getPhi2();
    }

    @Override
    public void setPopulation(Population pop) {
        super.setPopulation(pop);
        if (pop.size() > 0 && pop.size() != pop.getTargetSize()) {
            this.tracedVelocity = null;
            this.initializeByPopulation(null, false);
            this.bestIndividual = pop.getBestEAIndividual();
        } else {
            for (int i = 0; i < pop.size(); ++i) {
                AbstractEAIndividual indy = pop.getEAIndividual(i);
                if (indy == null) {
                    System.err.println("Error in PSO.setPopulation!");
                    continue;
                }
                if (indy.hasData(partTypeKey)) continue;
                ParticleSwarmOptimization.initIndividualDefaults(indy, this.initialVelocity);
                ParticleSwarmOptimization.initIndividualMemory(indy);
                indy.putData(indexKey, i);
                indy.setIndividualIndex(i);
            }
            this.bestIndividual = pop.getBestEAIndividual();
        }
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public AbstractEAIndividual getBestIndividual() {
        return this.bestIndividual;
    }

    public void setInitialVelocity(double f) {
        this.initialVelocity = f;
    }

    public double getInitialVelocity() {
        return this.initialVelocity;
    }

    public String initialVelocityTipText() {
        return "The initial velocity for each PSO particle.";
    }

    public void setSpeedLimit(double k) {
        if (k < 0.0) {
            k = 0.0;
        }
        if (k > 1.0) {
            k = 1.0;
        }
        this.speedLimit = k;
    }

    public double getSpeedLimit() {
        return this.speedLimit;
    }

    protected double getSpeedLimit(int index) {
        return this.speedLimit;
    }

    public String speedLimitTipText() {
        return "The speed limit in respect to the size of the search space [0,1].";
    }

    protected void setConstriction(double tau1, double tau2) {
        double pSum = tau1 + tau2;
        if (pSum <= 4.0) {
            System.err.println("error, invalid tauSum value in PSO::setConstriction");
        } else {
            if (this.getAlgoType() != PSOType.Constriction) {
                System.err.println("Warning, PSO algorithm variant constriction expected!");
            }
            this.phi1 = tau1;
            this.phi2 = tau2;
            this.setInertnessOrChi(2.0 / Math.abs(2.0 - pSum - Math.sqrt(pSum * pSum - 4.0 * pSum)));
        }
    }

    public void setInertnessOrChi(double k) {
        this.inertnessOrChi = k;
    }

    public double getInertnessOrChi() {
        return this.inertnessOrChi;
    }

    public String inertnessOrChiTipText() {
        return "Gives the speed decay of the previous velocity [0,1] in inertness mode or the chi value in constriction mode which is calculated from phi1 and phi2.";
    }

    @Parameter(description="Acceleration for the cognition model.")
    public void setPhi1(double l) {
        this.phi1 = l;
        if (this.algType == PSOType.Constriction) {
            this.setConstriction(this.getPhi1(), this.getPhi2());
        }
    }

    public double getPhi1() {
        return this.phi1;
    }

    @Parameter(description="Acceleration for the social model.")
    public void setPhi2(double l) {
        this.phi2 = l;
        if (this.algType == PSOType.Constriction) {
            this.setConstriction(this.getPhi1(), this.getPhi2());
        }
    }

    public double getPhi2() {
        return this.phi2;
    }

    public void setPhiValues(double phi1, double phi2) {
        this.phi1 = phi1;
        this.phi2 = phi2;
        if (this.algType == PSOType.Constriction) {
            this.setConstriction(phi1, phi2);
        }
    }

    public void setParameterValues(double phi1, double phi2, double inertness) {
        this.phi1 = phi1;
        this.phi2 = phi2;
        this.setInertnessOrChi(inertness);
    }

    @Parameter(description="Choose the topology type")
    public void setTopology(PSOTopology t) {
        this.topology = t;
        this.setGOEShowProperties(this.getClass());
    }

    public void setGOEShowProperties(Class<?> cls) {
        GenericObjectEditor.setShowProperty(cls, "topologyRange", this.topology == PSOTopology.linear || this.topology == PSOTopology.grid || this.topology == PSOTopology.random || this.topology == PSOTopology.tree || this.topology == PSOTopology.hpso || this.topology == PSOTopology.dms);
        GenericObjectEditor.setShowProperty(cls, "subSwarmRadius", this.topology == PSOTopology.multiSwarm);
        GenericObjectEditor.setShowProperty(cls, "maxSubSwarmSize", this.topology == PSOTopology.multiSwarm);
        GenericObjectEditor.setShowProperty(cls, "treeStruct", this.topology == PSOTopology.tree);
        GenericObjectEditor.setShowProperty(cls, "wrapTopology", this.topology == PSOTopology.linear || this.topology == PSOTopology.grid);
        GenericObjectEditor.setShowProperty(cls, "dmsRegroupGens", this.topology == PSOTopology.dms);
    }

    public PSOTopology getTopology() {
        return this.topology;
    }

    public void setAlgoType(PSOType s) {
        this.algType = s;
        if (this.algType == PSOType.Constriction) {
            this.setConstriction(this.getPhi1(), this.getPhi2());
        }
    }

    @Parameter(description="Choose the inertness or constriction method. Chi is calculated automatically in constriction.")
    public PSOType getAlgoType() {
        return this.algType;
    }

    @Parameter(description="The range of the neighborhood topology.")
    public void setTopologyRange(int s) {
        this.topologyRange = s;
    }

    public int getTopologyRange() {
        return this.topologyRange;
    }

    @Parameter(description="Toggle whether particles are allowed to leave the range.")
    public void setCheckRange(boolean s) {
        this.checkRange = s;
    }

    public boolean isCheckRange() {
        return this.checkRange;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
        if (!show) {
            this.plot = null;
        }
    }

    public String showTipText() {
        return "Activate for debugging in 2D";
    }

    public boolean isCheckSpeedLimit() {
        return this.checkSpeedLimit;
    }

    public void setCheckSpeedLimit(boolean checkSpeedLimit) {
        this.checkSpeedLimit = checkSpeedLimit;
        GenericObjectEditor.setHideProperty(this.getClass(), "speedLimit", !checkSpeedLimit);
    }

    public String checkSpeedLimitTipText() {
        return "if activated, the speed limit is enforced for the particles";
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public String sleepTimeTipText() {
        return "Sleep for a time between iterations - to be used with debugging and the show option.";
    }

    public double getSubSwarmRadius() {
        return this.swarmRadius;
    }

    public void setSubSwarmRadius(double radius) {
        this.swarmRadius = radius;
    }

    public String subSwarmRadiusTipText() {
        return "Define the maximum distance to a swarm leader in the multi-swarm variant";
    }

    public int getMaxSubSwarmSize() {
        return this.maxSubSwarmSize;
    }

    public void setMaxSubSwarmSize(int subSize) {
        this.maxSubSwarmSize = subSize;
    }

    public String maxSubSwarmSizeTipText() {
        return "Maximum size of a sub swarm. Violating particles will be reinitialized. 0 means no limit to the sub swarm size.";
    }

    public int getTreeStruct() {
        return this.treeStruct;
    }

    public void SetTreeStruct(int treeStruct) {
        this.treeStruct = treeStruct;
    }

    public boolean isWrapTopology() {
        return this.wrapTopology;
    }

    public void setWrapTopology(boolean wrapTopology) {
        this.wrapTopology = wrapTopology;
    }

    public String wrapTopologyTipText() {
        return "Wraps the topology to a ring structure";
    }

    protected int getEmaPeriods() {
        return this.emaPeriods;
    }

    protected void setEmaPeriods(int emaPeriods) {
        this.emaPeriods = emaPeriods;
    }

    public ParameterControlManager getParamControl() {
        return this.paramControl;
    }

    public ParamAdaption[] getParameterControl() {
        return this.paramControl.getSingleAdapters();
    }

    public void setParameterControl(ParamAdaption[] paramControl) {
        this.paramControl.setSingleAdapters(paramControl);
    }

    public String parameterControlTipText() {
        return "You may define dynamic paramter control strategies using the parameter name.";
    }

    protected Population getPersonalBestPos(Population population) {
        Population bests = new Population(population.size());
        AbstractEAIndividual indy = (AbstractEAIndividual)population.getEAIndividual(0).clone();
        if (!indy.hasData(partBestFitKey)) {
            return null;
        }
        for (int i = 0; i < population.size(); ++i) {
            double[] personalBestPos = (double[])population.getEAIndividual(i).getData(partBestPosKey);
            double[] personalBestfit = (double[])population.getEAIndividual(i).getData(partBestFitKey);
            double relDiff = personalBestfit[0] != 0.0 ? (personalBestfit[0] - ((InterfaceProblemDouble)((Object)this.optimizationProblem)).evaluate(personalBestPos)[0]) / personalBestfit[0] : personalBestfit[0] - ((InterfaceProblemDouble)((Object)this.optimizationProblem)).evaluate(personalBestPos)[0];
            if (Math.abs(relDiff) > 1.0E-20) {
                System.err.println("Warning: mismatching best fitness by " + relDiff);
                System.err.println("partInfo: " + i + " - " + ParticleSwarmOptimization.getParticleInfo(population.getEAIndividual(i)));
            }
            if (Math.abs(relDiff) > 1.0E-10) {
                System.err.println("partInfo: " + i + " - " + ParticleSwarmOptimization.getParticleInfo(population.getEAIndividual(i)));
                throw new RuntimeException("Mismatching best fitness!! " + personalBestfit[0] + " vs. " + ((InterfaceProblemDouble)((Object)this.optimizationProblem)).evaluate(personalBestPos)[0]);
            }
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(personalBestPos);
            indy.setFitness(personalBestfit);
            bests.add((AbstractEAIndividual)indy.clone());
        }
        return bests;
    }

    public int getDmsRegroupGens() {
        return this.dmsRegroupInterval;
    }

    public void setDmsRegroupGens(int dmsRegroupInterval) {
        this.dmsRegroupInterval = dmsRegroupInterval;
    }

    public String dmsRegroupGensTipText() {
        return "The number of generations after which new subswarms are randomly formed.";
    }

    @Override
    public String[] getAdditionalDataHeader() {
        if (this.emaPeriods > 0) {
            return new String[]{"meanEMASpeed", "meanCurSpeed"};
        }
        return new String[]{"meanCurSpeed"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        if (this.emaPeriods > 0) {
            return new String[]{"Exponential moving average of the (range-relative) speed of all particles", "The mean (range-relative) current speed of all particles"};
        }
        return new String[]{"The mean (range-relative) current speed of all particles"};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(0);
        if (this.emaPeriods > 0) {
            double relSp = indy instanceof InterfaceDataTypeDouble ? this.getRelativeEMASpeed(((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange()) : Double.NaN;
            return new Object[]{relSp, this.getPopulationAvgNormedVelocity((Population)pop)};
        }
        return new Object[]{this.getPopulationAvgNormedVelocity((Population)pop)};
    }

    public static enum PSOType {
        Inertness,
        Constriction;

    }
}

