/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;

@Description(value="Guaranteed Convergence Particle Swarm Optimiser (GCPSO) as proposed by F. van den Bergh.")
public class ParticleSwarmOptimizationGCPSO
extends ParticleSwarmOptimization {
    protected boolean gcpso;
    protected int sc;
    protected int fc;
    protected double rhoIncreaseFactor;
    protected double rhoDecreaseFactor;
    protected int gbestParticleIndex = -1;
    protected boolean gbestParticleHasChanged;
    protected int numOfSuccesses;
    protected int numOfFailures;
    protected AbstractEAIndividual gbestParticle;
    private double rho;
    protected int getAccelerationForGlobalBestParticleCounter = 0;

    public ParticleSwarmOptimizationGCPSO() {
        this.setGcpso(true);
        this.gbestParticleIndex = -1;
        this.gbestParticleHasChanged = false;
        this.numOfSuccesses = 0;
        this.numOfFailures = 0;
        this.setRho(1.0);
        this.SetSc(15);
        this.SetFc(5);
        this.SetRhoIncreaseFactor(2.0);
        this.SetRhoDecreaseFactor(0.5);
    }

    public ParticleSwarmOptimizationGCPSO(ParticleSwarmOptimizationGCPSO a) {
        super(a);
        this.setGcpso(a.gcpso);
        this.gbestParticleIndex = a.gbestParticleIndex;
        if (a.gbestParticle != null) {
            this.gbestParticle = (AbstractEAIndividual)a.gbestParticle.clone();
            double[] aFitness = (double[])a.gbestParticle.getData("BestFitness");
            this.gbestParticle.putData("BestFitness", aFitness.clone());
        }
        this.gbestParticleHasChanged = a.gbestParticleHasChanged;
        this.numOfSuccesses = a.numOfSuccesses;
        this.numOfFailures = a.numOfFailures;
        this.setRho(a.getRho());
        this.SetSc(a.getSc());
        this.SetFc(a.getFc());
        this.SetRhoIncreaseFactor(a.getRhoIncreaseFactor());
        this.SetRhoDecreaseFactor(a.getRhoDecreaseFactor());
    }

    @Override
    public void optimize() {
        super.optimize();
        this.updateGCPSOMember();
    }

    @Override
    protected double[] updateVelocity(int index, double[] lastVelocity, double[] personalBestPos, double[] curPosition, double[] neighbourBestPos, double[][] range) {
        double[] curVelocity = new double[lastVelocity.length];
        double[] accel = this.useAlternative ? this.getAccelerationAlternative(index, personalBestPos, neighbourBestPos, curPosition, range) : (index == this.gbestParticleIndex && this.isGcpso() ? this.getAccelerationForGlobalBestParticle(personalBestPos, neighbourBestPos, curPosition, range) : this.getAcceleration(personalBestPos, neighbourBestPos, curPosition, range));
        for (int i = 0; i < lastVelocity.length; ++i) {
            curVelocity[i] = this.inertnessOrChi * lastVelocity[i];
            int n = i;
            curVelocity[n] = curVelocity[n] + accel[i];
        }
        return curVelocity;
    }

    private double[] getAccelerationForGlobalBestParticle(double[] personalBestPos, double[] neighbourBestPos, double[] curPosition, double[][] range) {
        ++this.getAccelerationForGlobalBestParticleCounter;
        double[] accel = new double[curPosition.length];
        int i = 0;
        while (i < personalBestPos.length) {
            accel[i] = -curPosition[i] + personalBestPos[i];
            int n = i++;
            accel[n] = accel[n] + this.getRho() * (1.0 - 2.0 * RNG.randomDouble(0.0, 1.0));
        }
        return accel;
    }

    protected int getIndexOfGlobalBestParticle() {
        if (this.getPopulation().size() == 0) {
            System.out.println("getIndexOfGlobalBestParticle error: no particle in population");
            return -1;
        }
        int index = 0;
        double[] gbestFitness = (double[])this.getPopulation().getEAIndividual(0).getData("BestFitness");
        for (int i = 1; i < this.getPopulation().size(); ++i) {
            AbstractEAIndividual indy = this.getPopulation().getEAIndividual(i);
            double[] currentBestFitness = (double[])indy.getData("BestFitness");
            if (!AbstractEAIndividual.isDominatingFitness(currentBestFitness, gbestFitness)) continue;
            gbestFitness = currentBestFitness;
            index = i;
        }
        return index;
    }

    protected void updateGCPSOMember() {
        int index = this.getIndexOfGlobalBestParticle();
        if (index != this.gbestParticleIndex) {
            this.gbestParticleHasChanged = true;
            this.gbestParticleIndex = index;
        } else {
            this.gbestParticleHasChanged = false;
        }
        if (this.gbestParticle == null) {
            AbstractEAIndividual gbestParticleCurrent = this.getPopulation().getEAIndividual(this.gbestParticleIndex);
            this.gbestParticle = (AbstractEAIndividual)gbestParticleCurrent.clone();
        }
        AbstractEAIndividual gbestParticleOld = this.gbestParticle;
        double[] gbestParticleFitnessOld = (double[])gbestParticleOld.getData("BestFitness");
        AbstractEAIndividual gbestParticleCurrent = this.getPopulation().getEAIndividual(this.gbestParticleIndex);
        double[] gbestParticleFitnessCurrent = (double[])gbestParticleCurrent.getData("BestFitness");
        if (AbstractEAIndividual.isDominatingFitnessNotEqual(gbestParticleFitnessCurrent, gbestParticleFitnessOld)) {
            ++this.numOfSuccesses;
            this.numOfFailures = 0;
        } else {
            ++this.numOfFailures;
            this.numOfSuccesses = 0;
        }
        this.gbestParticle = (AbstractEAIndividual)gbestParticleCurrent.clone();
        if (this.numOfSuccesses > this.getSc()) {
            this.setRho(this.getRhoIncreaseFactor() * this.getRho());
        }
        if (this.numOfFailures > this.getFc()) {
            this.setRho(this.getRhoDecreaseFactor() * this.getRho());
        }
    }

    public void setGcpso(boolean gcpso) {
        this.gcpso = gcpso;
    }

    public boolean isGcpso() {
        return this.gcpso;
    }

    public String gcpsoTipText() {
        return "deactivate to use the standard PSO by Kennedy and Eberhart";
    }

    public void SetSc(int sc) {
        this.sc = sc;
    }

    public int getSc() {
        return this.sc;
    }

    public void SetFc(int fc) {
        this.fc = fc;
    }

    public int getFc() {
        return this.fc;
    }

    public void SetRhoIncreaseFactor(double rhoIncreaseFactor) {
        this.rhoIncreaseFactor = rhoIncreaseFactor;
    }

    public double getRhoIncreaseFactor() {
        return this.rhoIncreaseFactor;
    }

    public void SetRhoDecreaseFactor(double rhoDecreaseFactor) {
        this.rhoDecreaseFactor = rhoDecreaseFactor;
    }

    public double getRhoDecreaseFactor() {
        return this.rhoDecreaseFactor;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public String rhoTipText() {
        return "controls the initial radius of a random search in an area surrounding the global best position of the swarm";
    }

    public double getRho() {
        return this.rho;
    }
}

