/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.PBILPopulation;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.B1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;
import java.util.logging.Logger;

@Description(value="The Population based incremental learning is based on a statistical distribution of bit positions. Please note: This optimizer requires a binary genotype!")
public class PopulationBasedIncrementalLearning
extends AbstractOptimizer
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(PopulationBasedIncrementalLearning.class.getName());
    private InterfaceOptimizationProblem optimizationProblem = new B1Problem();
    private boolean useElitism = true;
    private InterfaceSelection selectionOperator = new SelectBestIndividuals();
    private transient String identifier = "";
    private transient InterfacePopulationChangedEventListener populationChangedEventListener;
    private Population population = new PBILPopulation();
    private double learningRate = 0.04;
    private double mutationRate = 0.5;
    private double mutateSigma = 0.01;
    private int numberOfPositiveSamples = 1;
    private double[] initialProbabilities = ((PBILPopulation)this.population).getProbabilityVector();

    public PopulationBasedIncrementalLearning() {
    }

    public PopulationBasedIncrementalLearning(PopulationBasedIncrementalLearning a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.learningRate = a.learningRate;
        this.mutationRate = a.mutationRate;
        this.mutateSigma = a.mutateSigma;
        this.numberOfPositiveSamples = a.numberOfPositiveSamples;
        this.useElitism = a.useElitism;
        this.selectionOperator = (InterfaceSelection)a.selectionOperator.clone();
    }

    @Override
    public Object clone() {
        return new PopulationBasedIncrementalLearning(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        if (this.initialProbabilities != null && this.initialProbabilities.length == ((PBILPopulation)this.population).getProbabilityVector().length) {
            ((PBILPopulation)this.population).setProbabilityVector(this.initialProbabilities);
        } else if (this.initialProbabilities != null) {
            System.err.println("Warning: initial probability vector doesnt match in length!");
        }
        this.evaluatePopulation(this.population);
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        if (!(pop.getEAIndividual(0) instanceof InterfaceGAIndividual)) {
            System.err.println("Error: PBIL only works with GAIndividuals!");
        }
        this.population = new PBILPopulation();
        this.population.addPopulation((Population)pop.clone());
        if (reset) {
            this.population.initialize();
            this.evaluatePopulation(this.population);
        }
        ((PBILPopulation)this.population).buildProbabilityVector();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private void evaluatePopulation(Population population) {
        this.optimizationProblem.evaluate(population);
        population.incrGeneration();
    }

    private Population generateChildren() {
        PBILPopulation result = (PBILPopulation)this.population.clone();
        this.selectionOperator.prepareSelection(this.population);
        Population examples = this.selectionOperator.selectFrom(this.population, this.numberOfPositiveSamples);
        result.learnFrom(examples, this.learningRate);
        result.mutateProbabilityVector(this.mutationRate, this.mutateSigma);
        result.initPBIL();
        return result;
    }

    @Override
    public void optimize() {
        Population nextGeneration = this.generateChildren();
        this.evaluatePopulation(nextGeneration);
        if (this.useElitism) {
            AbstractEAIndividual elite = this.population.getBestEAIndividual();
            this.population = nextGeneration;
            this.population.add(0, elite);
        } else {
            this.population = nextGeneration;
        }
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = problem;
        if (this.optimizationProblem instanceof AbstractOptimizationProblem && !(((AbstractOptimizationProblem)this.optimizationProblem).getIndividualTemplate() instanceof InterfaceGAIndividual)) {
            LOGGER.warning("PBIL only works with GAIndividuals!");
        }
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "Population Based Incremental Learning:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "PBIL";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public void setSelectionMethod(InterfaceSelection selection) {
        this.selectionOperator = selection;
    }

    public InterfaceSelection getSelectionMethod() {
        return this.selectionOperator;
    }

    public String selectionMethodTipText() {
        return "Choose a selection method.";
    }

    public void setElitism(boolean elitism) {
        this.useElitism = elitism;
    }

    public boolean getElitism() {
        return this.useElitism;
    }

    public String elitismTipText() {
        return "Enable/disable elitism.";
    }

    public void setLearningRate(double LearningRate) {
        this.learningRate = LearningRate;
        if (this.learningRate < 0.0) {
            this.learningRate = 0.0;
        }
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public String learningRateTipText() {
        return "The learing rate of PBIL.";
    }

    public void setMutationRate(double m) {
        this.mutationRate = m;
        if (this.mutationRate < 0.0) {
            this.mutationRate = 0.0;
        }
        if (this.mutationRate > 1.0) {
            this.mutationRate = 1.0;
        }
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public String mutationRateTipText() {
        return "The mutation rate of PBIL.";
    }

    public void setMutateSigma(double m) {
        this.mutateSigma = m;
        if (this.mutateSigma < 0.0) {
            this.mutateSigma = 0.0;
        }
    }

    public double getMutateSigma() {
        return this.mutateSigma;
    }

    public String mutateSigmaTipText() {
        return "Set the sigma for the mutation of the probability vector.";
    }

    public void setPositiveSamples(int PositiveSamples) {
        this.numberOfPositiveSamples = PositiveSamples;
        if (this.numberOfPositiveSamples < 1) {
            this.numberOfPositiveSamples = 1;
        }
    }

    public int getPositiveSamples() {
        return this.numberOfPositiveSamples;
    }

    public String positiveSamplesTipText() {
        return "The number of positive samples that update the PBIL vector.";
    }

    public double[] getInitialProbabilities() {
        return this.initialProbabilities;
    }

    public void setInitialProbabilities(double[] probabilities) {
        this.initialProbabilities = probabilities;
    }
}

