/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.OptimizerFactory;
import eva2.OptimizerRunnable;
import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.Pair;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="A scatter search variant after Rodiguez-Fernandez, J.Egea and J.Banga: Novel metaheuristic for parameter estimation in nonlinear dynamic biological systems, BMC Bioinf. 2006")
public class ScatterSearch
implements InterfaceOptimizer,
Serializable,
InterfacePopulationChangedEventListener {
    private transient InterfacePopulationChangedEventListener listener = null;
    private String identifier = "ScatterSearch";
    private AbstractOptimizationProblem optimizationProblem = new F1Problem();
    private Population oldRefSet;
    private Population refSet = new Population(10);
    private transient Population combinations = null;
    private AbstractEAIndividual template = null;
    private double[][] range = null;
    private int refSetSize = 10;
    private int poolSize = 100;
    private int intervals = 4;
    private int localSearchSteps = 100;
    private double localSearchFitnessFilter = 1.5;
    private int probDim = -1;
    private boolean firstTime = true;
    private int lastImprovementCount = 0;
    private LocalSearchMethod localSearchMethod = LocalSearchMethod.NelderMead;
    private int generationCycle = 50;
    private int fitCrit = -1;
    protected boolean checkRange = true;
    protected boolean doLocalSearch = false;
    private boolean relativeFitCriterion = false;
    private double nelderMeadInitPerturbation = 0.01;
    private double improvementEpsilon = 0.1;
    private double minDiversityEpsilon = 1.0E-4;

    public ScatterSearch() {
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
        this.hideHideable();
    }

    public ScatterSearch(ScatterSearch o) {
        this.refSet = (Population)o.refSet.clone();
        this.optimizationProblem = (AbstractOptimizationProblem)o.optimizationProblem.clone();
        this.template = (AbstractEAIndividual)o.template.clone();
        this.range = ((InterfaceDataTypeDouble)((Object)this.template)).getDoubleRange();
        this.refSetSize = o.refSetSize;
        this.poolSize = o.poolSize;
        this.intervals = o.intervals;
        this.localSearchSteps = o.localSearchSteps;
        this.localSearchFitnessFilter = o.localSearchFitnessFilter;
        this.probDim = o.probDim;
        this.firstTime = o.firstTime;
        this.lastImprovementCount = o.lastImprovementCount;
    }

    @Override
    public Object clone() {
        return new ScatterSearch(this);
    }

    public void hideHideable() {
        this.setLSShowProps();
        GenericObjectEditor.setHideProperty(this.getClass(), "population", true);
    }

    @Override
    @Hidden
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = (AbstractOptimizationProblem)problem;
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.refSet);
    }

    @Override
    public Population getPopulation() {
        return this.refSet;
    }

    @Override
    public void initialize() {
        this.defaultInit();
        this.initRefSet(this.diversify());
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.defaultInit();
        this.initRefSet(this.diversify(pop));
    }

    private void initRefSet(Population pop) {
        this.optimizationProblem.evaluate(pop);
        this.refSet = this.getRefSetFitBased(new Population(this.refSetSize), pop);
        this.refSet.incrFunctionCallsBy(pop.size());
        this.refSet.addPopulationChangedEventListener(this);
        this.refSet.setNotifyEvalInterval(this.generationCycle);
    }

    private void defaultInit() {
        this.firstTime = true;
        this.refSet = null;
        this.combinations = null;
        this.template = this.optimizationProblem.getIndividualTemplate();
        if (!(this.template instanceof InterfaceDataTypeDouble)) {
            System.err.println("Requiring double data!");
        } else {
            Object dim = BeanInspector.callIfAvailable(this.optimizationProblem, "getProblemDimension", null);
            if (dim == null) {
                System.err.println("Couldnt get problem dimension!");
            }
            this.probDim = (Integer)dim;
            this.range = ((InterfaceDataTypeDouble)((Object)this.template)).getDoubleRange();
        }
    }

    protected void firePropertyChangedEvent(String name) {
        if (this.listener != null) {
            this.listener.registerPopulationStateChanged(this, name);
        }
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.compareTo("FunCallIntervalReached") == 0) {
            this.refSet.setFunctionCalls(((Population)source).getFunctionCalls());
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void optimize() {
        if (!this.firstTime && this.lastImprovementCount == 0) {
            this.refSet = this.regenerateRefSet();
        }
        this.firstTime = false;
        this.optimizationProblem.evaluatePopulationStart(this.refSet);
        int funCallsStart = this.refSet.getFunctionCalls();
        do {
            if (this.combinations == null || this.combinations.size() == 0) {
                this.combinations = this.generateCombinations(this.refSet);
                this.oldRefSet = (Population)this.refSet.clone();
                this.lastImprovementCount = 0;
            }
            if (this.combinations.size() <= 0) continue;
            this.updateRefSet(this.refSet, this.combinations, this.oldRefSet);
        } while (this.refSet.getFunctionCalls() - funCallsStart < this.generationCycle);
        this.optimizationProblem.evaluatePopulationEnd(this.refSet);
    }

    private boolean isDoLocalSolver(AbstractEAIndividual cand, Population refSet) {
        if (this.doLocalSearch) {
            if (this.relativeFitCriterion) {
                double fitRange = refSet.getWorstFitness()[0] - refSet.getBestFitness()[0];
                return cand.getFitness(0) < refSet.getBestFitness()[0] + fitRange * this.localSearchFitnessFilter;
            }
            return cand.getFitness(0) < this.localSearchFitnessFilter;
        }
        return false;
    }

    private Population regenerateRefSet() {
        Population diversifiedPop = this.diversify();
        int keep = this.refSetSize / 2;
        Population newRefSet = this.refSet.cloneWithoutInds();
        newRefSet.addAll(this.refSet.getBestNIndividuals(keep, this.fitCrit));
        int h = newRefSet.size();
        ArrayList<double[]> distVects = new ArrayList<double[]>();
        for (int i = 1; i < h; ++i) {
            distVects.add(this.getDiffVect(newRefSet.getEAIndividual(0), newRefSet.getEAIndividual(i)));
        }
        double maxSP = -1.0;
        int sel = -1;
        while (h < this.refSetSize) {
            for (int i = 0; i < diversifiedPop.size(); ++i) {
                double[] vP = this.calcVectP(diversifiedPop.getEAIndividual(i), newRefSet.getEAIndividual(0), distVects);
                double maxTmp = this.getMaxInVect(vP);
                if (i != 0 && !(maxTmp < maxSP)) continue;
                maxSP = maxTmp;
                sel = i;
            }
            AbstractEAIndividual winner = diversifiedPop.getEAIndividual(sel);
            this.optimizationProblem.evaluate(winner);
            newRefSet.add(winner);
            newRefSet.incrFunctionCalls();
            ++h;
            distVects.add(this.getDiffVect(newRefSet.getEAIndividual(0), winner));
            diversifiedPop.remove(sel);
        }
        return newRefSet;
    }

    private double getMaxInVect(double[] vals) {
        double dmax = vals[0];
        for (int j = 1; j < vals.length; ++j) {
            if (!(vals[j] > dmax)) continue;
            dmax = vals[j];
        }
        return dmax;
    }

    private double[] calcVectP(AbstractEAIndividual candidate, AbstractEAIndividual best, ArrayList<double[]> distVects) {
        double[] diff = this.getDiffVect(best, candidate);
        return this.multScalarTransposed(diff, distVects);
    }

    private double[] multScalarTransposed(double[] diff, ArrayList<double[]> distVects) {
        double[] res = new double[distVects.size()];
        for (int i = 0; i < distVects.size(); ++i) {
            res[i] = Mathematics.vvMult(diff, distVects.get(i));
        }
        return res;
    }

    private double[] getDiffVect(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double[] v1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleData();
        double[] v2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleData();
        return Mathematics.vvSub(v1, v2);
    }

    private void updateRefSet(Population refSet, Population candidates, Population oldRefSet) {
        int bestIndex = candidates.getIndexOfBestIndividualPrefFeasible();
        AbstractEAIndividual bestCand = candidates.getEAIndividual(bestIndex);
        AbstractEAIndividual worstRef = refSet.getWorstEAIndividual();
        if (this.isDoLocalSolver(bestCand, refSet)) {
            Pair<AbstractEAIndividual, Integer> lsRet = this.localSolver(bestCand, this.localSearchSteps);
            if ((double)(Math.abs(lsRet.tail() - this.localSearchSteps) / this.localSearchSteps) > 0.05) {
                System.err.println("Warning, more than 5% difference in local search step");
            }
            bestCand = lsRet.head();
            refSet.incrFunctionCallsBy(lsRet.tail());
        }
        if (bestCand.isDominatingEqual(worstRef)) {
            if (this.diversityCriterionFulfilled(bestCand, refSet, oldRefSet)) {
                int replIndex = refSet.indexOf(worstRef);
                refSet.set(replIndex, bestCand);
                ++this.lastImprovementCount;
            } else if (bestCand.isDominating(refSet.getBestEAIndividual())) {
                int closestIndex = this.getClosestIndy(bestCand, refSet);
                refSet.set(closestIndex, bestCand);
                ++this.lastImprovementCount;
            }
            candidates.remove(bestIndex);
        } else if (!this.doLocalSearch && bestCand.getFitness().length == 1) {
            candidates.clear();
        } else {
            candidates.remove(bestIndex);
        }
    }

    private Pair<AbstractEAIndividual, Integer> localSolver(AbstractEAIndividual cand, int hcSteps) {
        if (this.localSearchMethod == LocalSearchMethod.HillClimber) {
            return this.localSolverHC(cand, hcSteps);
        }
        return PostProcess.localSolverNMS(cand, hcSteps, this.nelderMeadInitPerturbation, this.optimizationProblem);
    }

    private Pair<AbstractEAIndividual, Integer> localSolverHC(AbstractEAIndividual cand, int hcSteps) {
        Population hcPop = new Population(1);
        hcPop.add(cand);
        int stepsDone = PostProcess.processWithHC(hcPop, this.optimizationProblem, hcSteps);
        return new Pair<AbstractEAIndividual, Integer>(hcPop.getEAIndividual(0), stepsDone);
    }

    private int getClosestIndy(AbstractEAIndividual indy, Population refSet) {
        double dist = PhenotypeMetric.dist(indy, refSet.getEAIndividual(0));
        int sel = 0;
        for (int i = 1; i < refSet.size(); ++i) {
            double tmpDst = PhenotypeMetric.dist(indy, refSet.getEAIndividual(i));
            if (!(tmpDst < dist)) continue;
            tmpDst = dist;
            sel = i;
        }
        return sel;
    }

    private boolean diversityCriterionFulfilled(AbstractEAIndividual cand, Population popCompGeno, Population popComPheno) {
        boolean minDistFulfilled;
        double minDist = PhenotypeMetric.dist(cand, popCompGeno.getEAIndividual(0));
        for (int i = 1; i < popCompGeno.size(); ++i) {
            minDist = Math.min(minDist, PhenotypeMetric.dist(cand, popCompGeno.getEAIndividual(i)));
        }
        boolean bl = minDistFulfilled = this.minDiversityEpsilon <= 0.0 || minDist > this.minDiversityEpsilon;
        if (minDistFulfilled && this.improvementEpsilon > 0.0) {
            boolean minImprovementFulfilled = cand.getFitness(0) < (1.0 - this.improvementEpsilon) * popComPheno.getBestEAIndividual().getFitness(0);
            return minImprovementFulfilled;
        }
        return minDistFulfilled;
    }

    private Population generateCombinations(Population refSet) {
        AbstractEAIndividual indy2;
        int j;
        AbstractEAIndividual indy1;
        int i;
        Population combs = new Population();
        Population refSorted = refSet.getBestNIndividuals(refSet.size(), this.fitCrit);
        int half = refSet.size() / 2;
        for (i = 0; i < half - 1; ++i) {
            indy1 = refSorted.getEAIndividual(i);
            for (j = i + 1; j < half; ++j) {
                indy2 = refSorted.getEAIndividual(j);
                combs.add(this.combineTypeOne(indy1, indy2));
                combs.add(this.combineTypeTwo(indy1, indy2));
                combs.add(this.combineTypeTwo(indy1, indy2));
                combs.add(this.combineTypeThree(indy1, indy2));
            }
        }
        for (i = 0; i < half; ++i) {
            indy1 = refSorted.getEAIndividual(i);
            for (j = half; j < refSet.size(); ++j) {
                indy2 = refSorted.getEAIndividual(j);
                combs.add(this.combineTypeOne(indy1, indy2));
                combs.add(this.combineTypeTwo(indy1, indy2));
                combs.add(this.combineTypeThree(indy1, indy2));
            }
        }
        for (i = half; i < refSet.size() - 1; ++i) {
            indy1 = refSorted.getEAIndividual(i);
            for (j = i + 1; j < refSet.size(); ++j) {
                indy2 = refSorted.getEAIndividual(j);
                combs.add(this.combineTypeTwo(indy1, indy2));
                if (RNG.flipCoin(0.5)) {
                    combs.add(this.combineTypeOne(indy1, indy2));
                    continue;
                }
                combs.add(this.combineTypeThree(indy1, indy2));
            }
        }
        return combs;
    }

    private AbstractEAIndividual combineTypeOne(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        return this.combine(indy1, indy2, true, false);
    }

    private AbstractEAIndividual combineTypeTwo(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        return this.combine(indy1, indy2, true, true);
    }

    private AbstractEAIndividual combineTypeThree(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        return this.combine(indy1, indy2, false, true);
    }

    private AbstractEAIndividual combine(AbstractEAIndividual indy1, AbstractEAIndividual indy2, boolean bFirst, boolean bAdd) {
        double[] combi;
        AbstractEAIndividual resIndy = (AbstractEAIndividual)indy1.clone();
        double[] v1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleData();
        double[] v2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleData();
        double[] dVect = RNG.randomDoubleArray(0.0, 1.0, this.probDim);
        for (int i = 0; i < this.probDim; ++i) {
            int n = i;
            dVect[n] = dVect[n] * ((v2[i] - v1[i]) / 2.0);
        }
        double[] candidate = bFirst ? v1 : v2;
        double[] dArray = combi = bAdd ? Mathematics.vvAdd(candidate, dVect) : Mathematics.vvSub(candidate, dVect);
        if (this.checkRange) {
            Mathematics.projectToRange(combi, this.range);
        }
        ((InterfaceDataTypeDouble)((Object)resIndy)).setDoubleGenotype(combi);
        this.optimizationProblem.evaluate(resIndy);
        this.refSet.incrFunctionCalls();
        return resIndy;
    }

    @Override
    public void setPopulation(Population pop) {
        this.refSet = pop;
    }

    private Population getRefSetFitBased(Population curRefSet, Population divPop) {
        int h = this.refSetSize / 2;
        curRefSet.addAll(divPop.getBestNIndividuals(h, this.fitCrit));
        Population rest = divPop.getWorstNIndividuals(this.refSetSize - h, this.fitCrit);
        double[][] distances = new double[rest.size()][this.refSetSize];
        for (int i = 0; i < distances.length; ++i) {
            for (int j = 0; j < h; ++j) {
                distances[i][j] = PhenotypeMetric.dist(rest.getEAIndividual(i), curRefSet.getEAIndividual(j));
            }
        }
        while (curRefSet.size() < this.refSetSize) {
            int sel = this.selectHighestMinDistance(distances, h);
            curRefSet.add(rest.getEAIndividual(sel));
            for (int i = 0; i < distances.length; ++i) {
                distances[i][h] = PhenotypeMetric.dist(rest.getEAIndividual(i), curRefSet.getEAIndividual(h));
            }
            distances[sel][0] = -1.0;
            ++h;
        }
        curRefSet.synchSize();
        return curRefSet;
    }

    private double getMinInCol(int col, int maxRow, double[][] vals) {
        double dmin = vals[col][0];
        if (dmin < 0.0) {
            return dmin;
        }
        for (int j = 1; j < maxRow; ++j) {
            if (!(vals[col][j] < dmin)) continue;
            dmin = vals[col][j];
        }
        return dmin;
    }

    private int selectHighestMinDistance(double[][] distances, int maxRow) {
        double highestMin = this.getMinInCol(0, maxRow, distances);
        int sel = 0;
        for (int i = 1; i < distances.length; ++i) {
            double dtmp = this.getMinInCol(i, maxRow, distances);
            if (!(dtmp > highestMin)) continue;
            highestMin = dtmp;
            sel = i;
        }
        return sel;
    }

    private Population diversify() {
        return this.diversify(new Population());
    }

    private Population diversify(Population pop) {
        int[][] freq = new int[this.probDim][this.intervals];
        if (pop.size() > 0) {
            for (int k = 0; k < pop.size(); ++k) {
                double[] params = ((InterfaceDataTypeDouble)((Object)pop.getEAIndividual(k))).getDoubleData();
                for (int j = 0; j < this.probDim; ++j) {
                    for (int iv = 0; iv < this.intervals; ++iv) {
                        if (!this.isInRangeInterval(params[j], j, iv)) continue;
                        int[] nArray = freq[j];
                        int n = iv;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.intervals; ++i) {
                pop.add(this.createDiagIndies(i));
                for (int j = 0; j < this.probDim; ++j) {
                    freq[j][i] = 1;
                }
            }
        }
        while (pop.size() < this.poolSize) {
            pop.add(this.createDiverseIndy(freq));
        }
        pop.setTargetSize(this.poolSize);
        return pop;
    }

    private AbstractEAIndividual createDiverseIndy(int[][] freq) {
        AbstractEAIndividual indy = (AbstractEAIndividual)this.template.clone();
        InterfaceDataTypeDouble dblIndy = (InterfaceDataTypeDouble)((Object)indy);
        double[] genes = dblIndy.getDoubleData();
        for (int i = 0; i < this.probDim; ++i) {
            int interv = this.selectInterv(i, freq);
            genes[i] = this.randInRangeInterval(i, interv);
            int[] nArray = freq[i];
            int n = interv;
            nArray[n] = nArray[n] + 1;
        }
        dblIndy.setDoubleGenotype(genes);
        return indy;
    }

    private double getFreqDepProb(int dim, int interv, int[][] freq) {
        double sum = 0.0;
        for (int k = 0; k < this.intervals; ++k) {
            sum += (double)freq[dim][k];
        }
        return (double)freq[dim][interv] / sum;
    }

    private int selectInterv(int dim, int[][] freq) {
        double sum;
        double[] probs = new double[this.intervals];
        for (int i = 0; i < this.intervals; ++i) {
            probs[i] = this.getFreqDepProb(dim, i, freq);
        }
        double rnd = RNG.randomDouble();
        int sel = 0;
        for (sum = probs[0]; sum < rnd; sum += probs[++sel]) {
        }
        if (sum >= 1.0000001) {
            System.err.println("Check this: sum>=1 in selectInterv");
        }
        return sel;
    }

    private AbstractEAIndividual createDiagIndies(int interval) {
        AbstractEAIndividual indy = (AbstractEAIndividual)this.template.clone();
        InterfaceDataTypeDouble dblIndy = (InterfaceDataTypeDouble)((Object)indy);
        double[] genes = dblIndy.getDoubleData();
        for (int i = 0; i < this.probDim; ++i) {
            genes[i] = this.randInRangeInterval(i, interval);
        }
        dblIndy.setDoubleGenotype(genes);
        return indy;
    }

    private boolean isInRangeInterval(double d, int dim, int interval) {
        double dimStep = (this.range[dim][1] - this.range[dim][0]) / (double)this.intervals;
        double lowB = this.range[dim][0] + dimStep * (double)interval;
        double upB = lowB + dimStep;
        return this.isInRange(d, lowB, upB);
    }

    private boolean isInRange(double d, double lowB, double upB) {
        return lowB <= d && d < upB;
    }

    private double randInRangeInterval(int dim, int interval) {
        double dimStep = (this.range[dim][1] - this.range[dim][0]) / (double)this.intervals;
        double lowB = this.range[dim][0] + dimStep * (double)interval;
        double upB = lowB + dimStep;
        return RNG.randomDouble(lowB, upB);
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public String getStringRepresentation() {
        return "ScatterSearch";
    }

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        this.listener = ea;
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.listener == ea) {
            this.listener = null;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "ScatterSearch";
    }

    private boolean useLSHC() {
        return this.localSearchMethod == LocalSearchMethod.NelderMead;
    }

    public boolean isDoLocalSearch() {
        return this.doLocalSearch;
    }

    @Parameter(description="Perform a local search step")
    public void setDoLocalSearch(boolean doLocalSearch) {
        this.doLocalSearch = doLocalSearch;
        this.setLSShowProps();
    }

    private void setLSShowProps() {
        GenericObjectEditor.setShowProperty(this.getClass(), "localSearchFitnessFilter", this.doLocalSearch);
        GenericObjectEditor.setShowProperty(this.getClass(), "localSearchSteps", this.doLocalSearch);
        GenericObjectEditor.setShowProperty(this.getClass(), "nelderMeadInitPerturbation", this.doLocalSearch && !this.useLSHC());
        GenericObjectEditor.setShowProperty(this.getClass(), "localSearchRelativeFilter", this.doLocalSearch);
        GenericObjectEditor.setShowProperty(this.getClass(), "localSearchMethod", this.doLocalSearch);
    }

    public int getRefSetSize() {
        return this.refSetSize;
    }

    @Parameter(description="Size of the reference set from which new candidates are created (similar to population size)")
    public void setRefSetSize(int refSetSize) {
        this.refSetSize = refSetSize;
    }

    public int getLocalSearchSteps() {
        return this.localSearchSteps;
    }

    @Parameter(description="Define the number of evaluations performed for one local search.")
    public void setLocalSearchSteps(int localSearchSteps) {
        this.localSearchSteps = localSearchSteps;
    }

    public double getLocalSearchFitnessFilter() {
        return this.localSearchFitnessFilter;
    }

    @Parameter(description="Local search is performed only if the fitness is better than this value (absolute crit) or by this factor * (worst-best) fitness (relative).")
    public void setLocalSearchFitnessFilter(double localSearchFitnessFilter) {
        this.localSearchFitnessFilter = localSearchFitnessFilter;
    }

    public static OptimizerRunnable createScatterSearch(int localSearchSteps, double localSearchFitnessFilter, double nmInitPerturb, boolean relativeFitCrit, int refSetSize, InterfaceTerminator term, String dataPrefix, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        OptimizationParameters params = ScatterSearch.specialSS(localSearchSteps, localSearchFitnessFilter, nmInitPerturb, relativeFitCrit, refSetSize, problem, term);
        OptimizerRunnable rnbl = new OptimizerRunnable((InterfaceOptimizationParameters)params, dataPrefix);
        return rnbl;
    }

    public static OptimizationParameters standardSS(AbstractOptimizationProblem problem) {
        return ScatterSearch.specialSS(0, 0.0, 0.1, true, 10, problem, new EvaluationTerminator(10000));
    }

    public static OptimizationParameters specialSS(int localSearchSteps, double localSearchFitnessFilter, double nmInitPerturb, boolean relativeFitCrit, int refSetSize, AbstractOptimizationProblem problem, InterfaceTerminator term) {
        ScatterSearch ss = new ScatterSearch();
        problem.initializeProblem();
        ss.setProblem(problem);
        ss.setRefSetSize(refSetSize);
        ss.setNelderMeadInitPerturbation(nmInitPerturb);
        ss.setLocalSearchRelativeFilter(relativeFitCrit);
        if (localSearchSteps > 0) {
            ss.setDoLocalSearch(true);
            ss.setLocalSearchSteps(localSearchSteps);
            ss.setLocalSearchFitnessFilter(localSearchFitnessFilter);
        } else {
            ss.setDoLocalSearch(false);
        }
        Population pop = new Population();
        pop.setTargetSize(refSetSize);
        pop.initialize();
        problem.initializePopulation(pop);
        ss.initializeByPopulation(pop, true);
        return OptimizerFactory.makeParams((InterfaceOptimizer)ss, pop, problem, 0L, term);
    }

    public boolean isLocalSearchRelativeFilter() {
        return this.relativeFitCriterion;
    }

    @Parameter(description="If selected, local search will be triggered by relative fitness, else by absolute")
    public void setLocalSearchRelativeFilter(boolean relativeFitCriterion) {
        this.relativeFitCriterion = relativeFitCriterion;
    }

    public double getNelderMeadInitPerturbation() {
        return this.nelderMeadInitPerturbation;
    }

    @Parameter(description="The relative range of the initial perturbation for creating the initial Nelder-Mead-Simplex")
    public void setNelderMeadInitPerturbation(double nelderMeadInitPerturbation) {
        this.nelderMeadInitPerturbation = nelderMeadInitPerturbation;
    }

    public LocalSearchMethod getLocalSearchMethod() {
        return this.localSearchMethod;
    }

    @Parameter(description="The local search method to use")
    public void setLocalSearchMethod(LocalSearchMethod localSearchMethod) {
        this.localSearchMethod = localSearchMethod;
        this.setLSShowProps();
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    @Parameter(description="The number of individuals created in the diversification step")
    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public double getImprovementEpsilon() {
        return this.improvementEpsilon;
    }

    @Parameter(description="Minimal relative fitness improvement for a candidate to enter the refSet - set to zero to deactivate.")
    public void setImprovementEpsilon(double improvementEpsilon) {
        this.improvementEpsilon = improvementEpsilon;
    }

    public double getMinDiversityEpsilon() {
        return this.minDiversityEpsilon;
    }

    @Parameter(description="Minimal distance to other individuals in the refSet for a candidate to enter the refSet - set to zero to deactivate.")
    public void setMinDiversityEpsilon(double minDiversityEpsilon) {
        this.minDiversityEpsilon = minDiversityEpsilon;
    }

    public static enum LocalSearchMethod {
        HillClimber,
        NelderMead;

    }
}

