/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The simulated annealing uses an additional cooling rate instead of a simple dominate criteria to accept worse solutions by chance.")
public class SimulatedAnnealing
extends AbstractOptimizer
implements Serializable {
    private int multiRuns = 100;
    private int fitnessCalls = 100;
    private int fitnessCallsNeeded = 0;
    GAIndividualBinaryData bestIndividual;
    GAIndividualBinaryData testIndividual;
    public double initialTemperature = 2.0;
    public double currentTemperature;
    public double alpha = 0.9;

    public SimulatedAnnealing() {
        this.population = new Population();
        this.population.setTargetSize(10);
    }

    public SimulatedAnnealing(SimulatedAnnealing a) {
        this.population = (Population)a.population.clone();
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.initialTemperature = a.initialTemperature;
        this.currentTemperature = a.currentTemperature;
        this.alpha = a.alpha;
    }

    @Override
    public Object clone() {
        return new SimulatedAnnealing(this);
    }

    @Override
    public void initialize() {
        this.optimizationProblem.initializePopulation(this.population);
        this.optimizationProblem.evaluate(this.population);
        this.currentTemperature = this.initialTemperature;
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.population = (Population)pop.clone();
        this.currentTemperature = this.initialTemperature;
        if (reset) {
            this.population.initialize();
            this.optimizationProblem.evaluate(this.population);
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    @Override
    public void optimize() {
        int i;
        Population original = (Population)this.population.clone();
        for (i = 0; i < this.population.size(); ++i) {
            AbstractEAIndividual indy = (AbstractEAIndividual)this.population.get(i);
            double tmpD = indy.getMutationProbability();
            indy.setMutationProbability(1.0);
            indy.mutate();
            indy.setMutationProbability(tmpD);
        }
        this.optimizationProblem.evaluate(this.population);
        for (i = 0; i < this.population.size(); ++i) {
            if (((AbstractEAIndividual)original.get(i)).isDominatingDebConstraints((AbstractEAIndividual)this.population.get(i))) {
                this.population.remove(i);
                this.population.add(i, original.get(i));
                continue;
            }
            double delta = this.calculateDelta((AbstractEAIndividual)original.get(i), (AbstractEAIndividual)this.population.get(i));
            if (!(Math.exp(-delta / this.currentTemperature) > (double)RNG.randomInt(0, 1))) continue;
            this.population.remove(i);
            this.population.add(i, original.get(i));
        }
        this.currentTemperature = this.alpha * this.currentTemperature;
        this.population.incrGeneration();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private double calculateDelta(AbstractEAIndividual org, AbstractEAIndividual mut) {
        double result = 0.0;
        double[] fitOrg = org.getFitness();
        double[] fitMut = mut.getFitness();
        for (int i = 0; i < fitOrg.length; ++i) {
            result += fitOrg[i] - fitMut[i];
        }
        return result;
    }

    public void defaultInit() {
        this.fitnessCallsNeeded = 0;
        this.bestIndividual = new GAIndividualBinaryData();
        this.bestIndividual.defaultInit(this.optimizationProblem);
    }

    public void defaultOptimize() {
        for (int i = 0; i < this.fitnessCalls; ++i) {
            this.testIndividual = (GAIndividualBinaryData)this.bestIndividual.clone();
            this.testIndividual.defaultMutate();
            if (this.testIndividual.defaultEvaulateAsMiniBits() < this.bestIndividual.defaultEvaulateAsMiniBits()) {
                this.bestIndividual = this.testIndividual;
            }
            this.fitnessCallsNeeded = i;
            if (this.bestIndividual.defaultEvaulateAsMiniBits() != 0.0) continue;
            i = this.fitnessCalls + 1;
        }
    }

    public static void main(String[] args) {
        SimulatedAnnealing program = new SimulatedAnnealing();
        int TmpMeanCalls = 0;
        int TmpMeanFitness = 0;
        for (int i = 0; i < program.multiRuns; ++i) {
            program.defaultInit();
            program.defaultOptimize();
            TmpMeanCalls += program.fitnessCallsNeeded;
            TmpMeanFitness = (int)((double)TmpMeanFitness + program.bestIndividual.defaultEvaulateAsMiniBits());
        }
        System.out.println("(" + program.multiRuns + "/" + program.fitnessCalls + ") Mean Fitness : " + (TmpMeanFitness /= program.multiRuns) + " Mean Calls needed: " + (TmpMeanCalls /= program.multiRuns));
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = this.population.size() > 1 ? result + "Multi(" + this.population.size() + ")-Start Hill Climbing:\n" : result + "Simulated Annealing:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "MS-SA";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public double getInitialTemperature() {
        return this.initialTemperature;
    }

    public void setInitialTemperature(double pop) {
        this.initialTemperature = pop;
    }

    public String initialTemperatureTipText() {
        return "Set the initial temperature.";
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double a) {
        this.alpha = a;
        if (this.alpha > 1.0) {
            this.alpha = 1.0;
        }
    }

    public String alphaTipText() {
        return "Set alpha, which is used to degrade the temperaure.";
    }
}

