/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.optimization.enums.PSOTopology;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.distancemetric.IndividualDataMetric;
import eva2.optimization.operator.paramcontrol.ParamAdaption;
import eva2.optimization.strategies.ClusterBasedNichingEA;
import eva2.optimization.strategies.ParticleSwarmOptimization;

public class SqPSO
extends ClusterBasedNichingEA {
    public SqPSO() {
        this(1.0E-10, 15, 15);
    }

    public SqPSO(double epsilonConv, int haltingWindow, int popSize) {
        this.setClusterDiffDist(Double.MAX_VALUE);
        this.setMaxSpeciesSize(-1);
        this.setDifferentiationCA(new ClusteringDensityBased(Double.MAX_VALUE, 1, new IndividualDataMetric("BestPosition")));
        this.setMergingCA(new ClusteringDensityBased(0.0, 0, new IndividualDataMetric("BestPosition")));
        this.setEpsilonBound(epsilonConv);
        this.setHaltingWindow(haltingWindow);
        this.setMaxSpeciesSize(popSize);
        this.setOptimizer(new ParticleSwarmOptimization(popSize, 2.05, 2.05, PSOTopology.grid, 2));
        ParamAdaption[] defAdpt = new ParamAdaption[]{};
        this.setParameterControl(defAdpt);
        this.setPopulationSize(popSize);
    }

    @Override
    public String getName() {
        return "SqPSO";
    }
}

