/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.tribes.TribesExplorer;
import eva2.optimization.strategies.tribes.TribesParam;
import eva2.optimization.strategies.tribes.TribesPosition;
import eva2.optimization.strategies.tribes.TribesSwarm;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.List;

@Description(value="TRIBES: a parameter free PSO implementation by Maurice Clerc.")
public class Tribes
implements InterfaceOptimizer,
Serializable {
    protected String identifier = "TRIBES";
    private transient InterfacePopulationChangedEventListener listener = null;
    protected AbstractOptimizationProblem optimizationProblem;
    protected Population population;
    public static int maxExplorerNb = 200;
    public static int maxMemoryNb = 300;
    public static int maxTribeNb = 300;
    public static int[] strategies = new int[10];
    public static int[] status = new int[9];
    public static boolean testBC = false;
    public static int adaptOption = 2;
    public static double blind = 0.0;
    public static boolean repel = false;
    private boolean checkConstraints = true;
    private static final long serialVersionUID = 1L;
    TribesSwarm swarm = null;
    private int iter;
    protected double objectiveFirstDim = 0.0;
    protected double[][] range;
    protected double[][] initRange;
    protected int notifyGenChangedEvery = 10;
    protected int problemDim;
    protected int adaptThreshold;
    protected int adaptMax;
    protected int adapt;
    protected int informOption;
    protected int initExplorerNb = 3;
    protected int rangeInitType = 1;
    private boolean show = false;
    protected transient Plot plot = null;

    @Override
    public Object clone() {
        return new Tribes(this);
    }

    public Tribes() {
        this.hideHideable();
    }

    public Tribes(Tribes other) {
        this.setProblem(other.getProblem());
        this.iter = other.iter;
        this.setObjectiveFirstDim(other.getObjectiveFirstDim());
        this.setDimension(other.range.length);
        this.setNotifyGenChangedEvery(other.getNotifyGenChangedEvery());
        this.range = (double[][])other.range.clone();
        this.problemDim = other.problemDim;
        this.adaptThreshold = other.adaptThreshold;
        this.adaptMax = other.adaptMax;
        this.adapt = other.adapt;
        this.informOption = other.informOption;
        this.swarm = other.swarm.clone();
        this.initExplorerNb = other.initExplorerNb;
        this.rangeInitType = other.rangeInitType;
        this.population = new Population(1);
        this.hideHideable();
    }

    @Override
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.optimizationProblem = (AbstractOptimizationProblem)problem;
        this.range = null;
        if (problem instanceof InterfaceHasInitRange) {
            this.initRange = (double[][])((InterfaceHasInitRange)((Object)problem)).getInitializationRange();
        }
        Population pop = new Population(1);
        problem.initializePopulation(pop);
        this.setPopulation(pop);
    }

    @Override
    public void initialize() {
        this.swarm = new TribesSwarm(this, this.range, this.initRange);
        this.iter = 0;
        this.adapt = 0;
        this.informOption = -1;
        this.population.clear();
        this.population.addAll(this.swarm.toPopulation());
        this.population.initialize();
        if (this.show) {
            this.show();
        }
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        this.setPopulation(pop);
    }

    public AbstractEAIndividual getBestInd() {
        TribesPosition bestMemPos = this.swarm.getBestMemory().getPos();
        AbstractEAIndividual bestExp = this.population.getBestEAIndividual();
        if (bestMemPos.firstIsBetter(bestMemPos.getFitness(), bestExp.getFitness())) {
            AbstractEAIndividual indy = (AbstractEAIndividual)bestExp.clone();
            indy.setFitness(bestMemPos.getFitness());
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(bestMemPos.getPos());
            return indy;
        }
        return bestExp;
    }

    @Override
    public void optimize() {
        int initOption = 0;
        if (this.iter == 0) {
            this.rangeInitType = this.initRange == null ? 0 : 1;
            this.swarm.generateSwarm(this.initExplorerNb, initOption, this.rangeInitType, this.optimizationProblem);
        }
        ++this.iter;
        this.optimizationProblem.evaluatePopulationStart(this.population);
        this.swarm.setSwarmSize();
        this.swarm.moveSwarm(this.range, new TribesParam(), this.informOption, this.optimizationProblem);
        if (adaptOption != 0) {
            if (adaptOption == 1) {
                this.adaptThreshold = this.iter - this.adapt;
                this.adaptMax = this.swarm.linkNb(this.swarm);
                if (this.adaptThreshold >= this.adaptMax && this.swarm.getBestMemory().getPrevPos().getTotalError() <= this.swarm.getBestMemory().getPos().getTotalError()) {
                    this.adapt = this.iter;
                    for (int i = 0; i < this.swarm.getTribeCnt(); ++i) {
                        this.swarm.reinitTribe(i, this.rangeInitType, this.optimizationProblem);
                    }
                }
            } else {
                this.adaptThreshold = this.iter - this.adapt;
                this.adaptMax = this.swarm.linkNb(this.swarm);
                if (this.adaptThreshold >= this.adaptMax) {
                    this.adapt = this.iter;
                    this.swarm.adaptSwarm(this.rangeInitType, this.optimizationProblem);
                }
            }
        }
        this.population.clear();
        this.population.addAll(this.swarm.toPopulation());
        if (this.show) {
            this.plotAll(this.population);
        }
        this.optimizationProblem.evaluatePopulationEnd(this.population);
        this.population.incrGeneration();
    }

    private void plotAll(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            double[] pos = ((TribesExplorer)pop.getEAIndividual(i)).getDoubleData();
            double[] vel = ((TribesExplorer)pop.getEAIndividual(i)).getVelocity();
            this.plotIndy(pos, vel, i);
        }
    }

    private void plotIndy(double[] curPosition, double[] curVelocity, int index) {
        if (this.show) {
            if (curVelocity == null) {
                this.plot.setUnconnectedPoint(curPosition[0], curPosition[1], index);
            } else {
                this.plot.setConnectedPoint(curPosition[0], curPosition[1], index);
                this.plot.setConnectedPoint(curPosition[0] + curVelocity[0], curPosition[1] + curVelocity[1], index);
            }
        }
    }

    protected void show() {
        if (this.plot == null) {
            this.plot = new Plot("TRIBES " + this.population.getGeneration(), "x1", "x2", this.range[0], this.range[1]);
        }
    }

    public static int particleNb(int D, int tribeNb) {
        return (int)Math.round((9.5 + 0.124 * (double)(D - 9)) / (double)tribeNb);
    }

    public void hideHideable() {
        GenericObjectEditor.setShowProperty(this.getClass(), "population", false);
    }

    @Override
    public void setPopulation(Population pop) {
        if (pop == null) {
            return;
        }
        this.population = pop;
        if (this.population.get(0) instanceof InterfaceDataTypeDouble) {
            this.range = ((InterfaceDataTypeDouble)this.population.get(0)).getDoubleRange();
            this.setDimension(this.range.length);
        } else {
            System.err.println("warning, TRIBES requires InterfaceESIndidivual instead of " + ((AbstractEAIndividual)this.population.get(0)).getClass() + ". Couldnt correctly initialize the problem range.");
        }
    }

    private void setDimension(int length) {
        this.problemDim = length;
        this.initialize();
    }

    public int getProblemDim() {
        return this.problemDim;
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        Population all = (Population)this.population.clone();
        List<TribesPosition> mems = this.swarm.collectMem();
        for (TribesPosition tp : mems) {
            all.add(this.positionToExplorer(tp));
        }
        all.setFunctionCalls(this.population.getFunctionCalls());
        all.setGeneration(this.population.getGeneration());
        return new SolutionSet(this.population, all);
    }

    protected TribesExplorer positionToExplorer(TribesPosition pos) {
        TribesExplorer tmp = (TribesExplorer)this.population.get(0);
        if (tmp == null) {
            System.err.println("Error in Tribes::positionToExplorer!");
        }
        TribesExplorer indy = tmp.clone();
        indy.clearPosVel();
        indy.setDoubleGenotype(pos.getPos());
        indy.setFitness(pos.getFitness());
        return indy;
    }

    @Override
    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        this.listener = ea;
    }

    @Override
    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.listener == ea) {
            this.listener = null;
            return true;
        }
        return false;
    }

    protected void firePropertyChangedEvent(String name) {
        if (this.listener != null) {
            this.listener.registerPopulationStateChanged(this, name);
        }
    }

    public boolean notifyAfter(int evals) {
        return evals % this.notifyGenChangedEvery == 0;
    }

    @Override
    public String getName() {
        return "TRIBES";
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.optimizationProblem;
    }

    @Override
    public String getStringRepresentation() {
        return "Not implemented";
    }

    public void incEvalCnt() {
        this.population.incrFunctionCalls();
        if (this.notifyAfter(this.population.getFunctionCalls())) {
            this.firePropertyChangedEvent("NextGenerationPerformed");
        }
    }

    public double getObjectiveFirstDim() {
        return this.objectiveFirstDim;
    }

    public void setObjectiveFirstDim(double objectiveFirstDim) {
        this.objectiveFirstDim = objectiveFirstDim;
    }

    public String objectiveFirstDimTipText() {
        return "TRIBES uses an error approximation based on the minimum objective value in the first dimension depending on the problem";
    }

    public int getNotifyGenChangedEvery() {
        return this.notifyGenChangedEvery;
    }

    public void setNotifyGenChangedEvery(int notifyGenChangedEvery) {
        this.notifyGenChangedEvery = notifyGenChangedEvery;
    }

    public String notifyGenChangedEveryTipText() {
        return "Mainly for the GUI: plot fitness every n evaluations";
    }

    public boolean isCheckConstraints() {
        return this.checkConstraints;
    }

    public void setCheckConstraints(boolean checkConstraints) {
        this.checkConstraints = checkConstraints;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
        if (!show) {
            this.plot = null;
        }
    }
}

