/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies;

import eva2.gui.PropertyDoubleArray;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.MOSOWeightedFitness;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.strategies.AbstractOptimizer;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.MultiObjectiveEA;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is Evolutionary Multi-Criteria Optimization Algorithm hybridized with Local Searchers to span the Pareto-Front.")
public class WingedMultiObjectiveEA
extends AbstractOptimizer
implements Serializable {
    private InterfaceOptimizer multiObjectiveEA = new MultiObjectiveEA();
    private InterfaceOptimizer singleObjectiveEA = new GeneticAlgorithm();
    private InterfaceOptimizer[] singleObjectiveOptimizers;
    private int migrationRate = 5;
    private int outputDimension = 2;

    public WingedMultiObjectiveEA() {
    }

    public WingedMultiObjectiveEA(WingedMultiObjectiveEA a) {
        this.optimizationProblem = (InterfaceOptimizationProblem)a.optimizationProblem.clone();
        this.multiObjectiveEA = (InterfaceOptimizer)a.multiObjectiveEA.clone();
        this.singleObjectiveEA = (InterfaceOptimizer)a.singleObjectiveEA.clone();
        if (a.singleObjectiveOptimizers != null) {
            this.singleObjectiveOptimizers = new InterfaceOptimizer[a.singleObjectiveOptimizers.length];
            for (int i = 0; i < this.singleObjectiveOptimizers.length; ++i) {
                this.singleObjectiveOptimizers[i] = (InterfaceOptimizer)a.singleObjectiveOptimizers[i].clone();
            }
        }
        this.migrationRate = a.migrationRate;
        this.population = (Population)a.population.clone();
    }

    @Override
    public Object clone() {
        return new WingedMultiObjectiveEA(this);
    }

    @Override
    public void initialize() {
        if (this.optimizationProblem instanceof AbstractMultiObjectiveOptimizationProblem) {
            AbstractMultiObjectiveOptimizationProblem tmpProb = (AbstractMultiObjectiveOptimizationProblem)this.optimizationProblem;
            int dim = this.outputDimension;
            this.multiObjectiveEA.setProblem((InterfaceOptimizationProblem)this.optimizationProblem.clone());
            this.multiObjectiveEA.initialize();
            this.singleObjectiveOptimizers = new InterfaceOptimizer[dim];
            for (int i = 0; i < dim; ++i) {
                AbstractMultiObjectiveOptimizationProblem tmpP = (AbstractMultiObjectiveOptimizationProblem)this.optimizationProblem.clone();
                double[] weights = new double[dim];
                for (int j = 0; j < dim; ++j) {
                    weights[j] = 0.0;
                }
                weights[i] = 1.0;
                PropertyDoubleArray tmpDA = new PropertyDoubleArray(weights);
                MOSOWeightedFitness tmpWF = new MOSOWeightedFitness();
                tmpWF.setWeights(tmpDA);
                tmpP.setMOSOConverter(tmpWF);
                this.singleObjectiveOptimizers[i] = (InterfaceOptimizer)this.singleObjectiveEA.clone();
                this.singleObjectiveOptimizers[i].setProblem(tmpP);
                this.singleObjectiveOptimizers[i].initialize();
            }
        } else {
            this.singleObjectiveEA.setProblem(this.optimizationProblem);
            this.singleObjectiveEA.initialize();
        }
        this.communicate();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void initializeByPopulation(Population pop, boolean reset) {
        if (this.optimizationProblem instanceof AbstractMultiObjectiveOptimizationProblem) {
            AbstractMultiObjectiveOptimizationProblem tmpProb = (AbstractMultiObjectiveOptimizationProblem)this.optimizationProblem;
            int dim = 2;
            this.multiObjectiveEA.setProblem((InterfaceOptimizationProblem)this.optimizationProblem.clone());
            this.multiObjectiveEA.initializeByPopulation(pop, reset);
            this.singleObjectiveOptimizers = new InterfaceOptimizer[dim];
            for (int i = 0; i < dim; ++i) {
                AbstractMultiObjectiveOptimizationProblem tmpP = (AbstractMultiObjectiveOptimizationProblem)this.optimizationProblem.clone();
                double[] weights = new double[dim];
                for (int j = 0; j < dim; ++j) {
                    weights[j] = 0.0;
                }
                weights[i] = 1.0;
                PropertyDoubleArray tmpDA = new PropertyDoubleArray(weights);
                MOSOWeightedFitness tmpWF = new MOSOWeightedFitness();
                tmpWF.setWeights(tmpDA);
                tmpP.setMOSOConverter(tmpWF);
                this.singleObjectiveOptimizers[i] = (InterfaceOptimizer)this.singleObjectiveEA.clone();
                this.singleObjectiveOptimizers[i].setProblem(tmpP);
                this.singleObjectiveOptimizers[i].initializeByPopulation(pop, reset);
            }
        } else {
            this.singleObjectiveEA.setProblem(this.optimizationProblem);
            this.singleObjectiveEA.initializeByPopulation(pop, reset);
        }
        this.communicate();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    @Override
    public void optimize() {
        this.multiObjectiveEA.optimize();
        for (int i = 0; i < this.singleObjectiveOptimizers.length; ++i) {
            this.singleObjectiveOptimizers[i].optimize();
        }
        this.population.incrGeneration();
        if (this.population.getGeneration() % this.migrationRate == 0) {
            this.communicate();
        }
        System.gc();
        this.firePropertyChangedEvent("NextGenerationPerformed");
    }

    private void communicate() {
        this.population.clear();
        this.population.setFunctionCalls(0);
        Population pop = (Population)this.multiObjectiveEA.getPopulation().clone();
        this.population.addPopulation(pop);
        this.population.incrFunctionCallsBy(pop.getFunctionCalls());
        for (int i = 0; i < this.singleObjectiveOptimizers.length; ++i) {
            pop = (Population)this.singleObjectiveOptimizers[i].getPopulation().clone();
            this.population.addPopulation(pop);
            this.population.incrFunctionCallsBy(pop.getFunctionCalls());
        }
        int oldFunctionCalls = this.population.getFunctionCalls();
        this.optimizationProblem.evaluate(this.population);
        this.population.setFunctionCalls(oldFunctionCalls);
        this.firePropertyChangedEvent("NextGenerationPerformed");
        this.migrate();
    }

    private void migrate() {
        AbstractEAIndividual[] bestIndys = new AbstractEAIndividual[this.outputDimension];
        for (int i = 0; i < this.outputDimension; ++i) {
            bestIndys[i] = (AbstractEAIndividual)((AbstractEAIndividual)this.population.get(0)).clone();
            double tmpF1 = bestIndys[i].getFitness(i);
            for (int j = 0; j < this.population.size(); ++j) {
                if (!(((AbstractEAIndividual)this.population.get(j)).getFitness(i) < tmpF1)) continue;
                bestIndys[i] = (AbstractEAIndividual)((AbstractEAIndividual)this.population.get(j)).clone();
                tmpF1 = bestIndys[i].getFitness(i);
            }
        }
        for (int i = 0; i < this.outputDimension; ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)bestIndys[i].clone();
            this.multiObjectiveEA.getProblem().evaluate(tmpIndy);
            this.multiObjectiveEA.getPopulation().set(i, tmpIndy);
            tmpIndy = (AbstractEAIndividual)bestIndys[i].clone();
            this.singleObjectiveOptimizers[i].getProblem().evaluate(tmpIndy);
            this.singleObjectiveOptimizers[i].getPopulation().set(0, bestIndys[i]);
        }
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "EMO:\n";
        result = result + "Optimization Problem: ";
        result = result + this.optimizationProblem.getStringRepresentationForProblem(this) + "\n";
        result = result + this.population.getStringRepresentation();
        return result;
    }

    @Override
    public String getName() {
        return "EMO-LS";
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    @Override
    public void setPopulation(Population pop) {
        this.population = pop;
    }

    public String populationTipText() {
        return "(Defunct)";
    }

    @Override
    public InterfaceSolutionSet getAllSolutions() {
        return new SolutionSet(this.getPopulation());
    }

    public InterfaceOptimizer getMOOptimizer() {
        return this.multiObjectiveEA;
    }

    public void setMOOptimizer(InterfaceOptimizer b) {
        this.multiObjectiveEA = b;
    }

    public String mOOptimizerTipText() {
        return "Choose a population based optimizing technique to use.";
    }

    public InterfaceOptimizer getSOOptimizer() {
        return this.singleObjectiveEA;
    }

    public void setSOOptimizer(InterfaceOptimizer b) {
        this.singleObjectiveEA = b;
    }

    public String sOOptimizerTipText() {
        return "Choose a population based optimizing technique to use.";
    }

    public int getMigrationRate() {
        return this.migrationRate;
    }

    public void setMigrationRate(int b) {
        this.migrationRate = b;
    }

    public String migrationRateTipText() {
        return "Choose a proper migration rate.";
    }
}

