/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies.tribes;

import eva2.optimization.strategies.Tribes;
import eva2.optimization.strategies.tribes.TribesExplorer;
import eva2.optimization.strategies.tribes.TribesMemory;
import eva2.optimization.strategies.tribes.TribesParam;
import eva2.optimization.strategies.tribes.TribesPosition;
import eva2.optimization.strategies.tribes.TribesSwarm;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import java.io.Serializable;

public class Tribe
implements Serializable {
    private static final long serialVersionUID = 739772857862893332L;
    int explorerNb;
    int memoryNb;
    TribesExplorer[] explorer = new TribesExplorer[Tribes.maxExplorerNb];
    TribesMemory[] memory = new TribesMemory[Tribes.maxMemoryNb];
    int shaman;
    int status;
    int worst;

    public int getNumExplorers() {
        return this.explorerNb;
    }

    public int getNumMemories() {
        return this.memoryNb;
    }

    public TribesExplorer[] getExplorers() {
        return this.explorer;
    }

    public TribesMemory[] getMemories() {
        return this.memory;
    }

    public void newTribe(int eNb, TribesExplorer[] expl, int mNb, TribesMemory[] memo) {
        int n;
        this.explorerNb = eNb;
        this.memoryNb = mNb;
        for (n = 0; n < this.explorerNb; ++n) {
            this.explorer[n] = expl[n].clone();
        }
        for (n = 0; n < this.memoryNb; ++n) {
            this.memory[n] = memo[n].clone();
        }
        for (n = 0; n < this.explorerNb; ++n) {
            this.explorer[n].contact = n;
        }
        this.statusTribe();
        this.findShaman();
    }

    public int moveTribe(double[][] range, TribesParam pb, int tribeRank, TribesSwarm swarm, int informOption, InterfaceOptimizationProblem prob) {
        int m;
        for (m = 0; m < this.memoryNb; ++m) {
            this.memory[m].setPrevPos(this.memory[m].getPos().clone());
            this.memory[m].status = 0;
        }
        for (int n = 0; n < this.explorerNb; ++n) {
            boolean eval = this.explorer[n].moveExplorer(tribeRank, n, swarm, informOption, prob);
            if (pb.constraint) {
                this.explorer[n].constraint(pb.gNb, pb.hNb, pb.ups);
            }
            this.explorer[n].confCoeffUpdate(this.explorer[n].confCoeff[0]);
            double f1 = this.explorer[n].position.getTotalError();
            m = this.explorer[n].contact;
            double f2 = this.memory[m].getPos().getTotalError();
            if (!(f1 < f2)) continue;
            this.memory[m].setPos(this.explorer[n].position.clone());
            this.memory[m].status = 1;
            if (!(f1 < this.memory[this.shaman].getPos().getTotalError())) continue;
            this.shaman = m;
        }
        this.statusTribe();
        return 0;
    }

    public void reinitTribe(TribesSwarm swarm, InterfaceOptimizationProblem prob, int initType) {
        int contact;
        int n;
        for (n = 0; n < this.explorerNb; ++n) {
            contact = this.explorer[n].contact;
            int option = RNG.randomInt(3);
            TribesSwarm emptySwarm = new TribesSwarm(null, swarm.getRange(), swarm.getInitRange());
            TribesPosition emptyPos = new TribesPosition(swarm.getProblemDim());
            this.explorer[n] = emptySwarm.generateExplorer(emptyPos, -1.0, option, -1, initType, prob, true);
            this.explorer[n].contact = contact;
        }
        for (n = 0; n < this.explorerNb; ++n) {
            contact = this.explorer[n].contact;
            if (contact == this.shaman) continue;
            this.memory[contact].setPos(this.explorer[n].position.clone());
            this.memory[contact].setPrevPos(this.explorer[n].position.clone());
            this.memory[contact].status = 0;
        }
        this.findShaman();
        this.statusTribe();
    }

    public void findShaman() {
        this.shaman = 0;
        if (this.memoryNb > 1) {
            for (int n = 1; n < this.memoryNb; ++n) {
                if (!(this.memory[n].getPos().getTotalError() < this.memory[this.shaman].getPos().getTotalError())) continue;
                this.shaman = n;
            }
        }
    }

    public void statusTribe() {
        int improvementNb = 0;
        for (int n = 0; n < this.memoryNb; ++n) {
            if (this.memory[n].status < 1) continue;
            ++improvementNb;
        }
        this.status = 0;
        this.status = improvementNb == 0 ? -1 : 1;
        if (this.status == 1) {
            this.status = RNG.randomInt() - 1;
        }
    }

    public void worstExplorer() {
        this.worst = 0;
        double f1 = this.memory[this.explorer[this.worst].contact].getPos().getTotalError();
        for (int m = 1; m < this.explorerNb; ++m) {
            double f2 = this.memory[this.explorer[m].contact].getPos().getTotalError();
            if (!(f2 > f1)) continue;
            this.worst = m;
            f1 = f2;
        }
    }

    public void deleteExplorer(int worstRank) {
        if (worstRank < this.explorerNb - 1) {
            for (int k = worstRank; k < this.explorerNb - 1; ++k) {
                this.explorer[k] = this.explorer[k + 1];
            }
        }
        --this.explorerNb;
    }

    public void migrateAccept(TribesExplorer explorerNew) {
        int contact;
        this.explorer[this.explorerNb] = explorerNew;
        this.explorer[this.explorerNb].contact = contact = RNG.randomInt(0, this.memoryNb - 1);
        if (explorerNew.position.getTotalError() < this.memory[contact].getPos().getTotalError()) {
            this.memory[contact].setPos(explorerNew.position.clone());
            this.memory[contact].status = 1;
        }
        ++this.explorerNb;
    }
}

