/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies.tribes;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.Tribes;
import eva2.optimization.strategies.tribes.TribesPosition;
import eva2.optimization.strategies.tribes.TribesSwarm;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;

public class TribesExplorer
extends AbstractEAIndividual
implements InterfaceDataTypeDouble {
    private static final long serialVersionUID = 1L;
    TribesPosition positionT_2;
    TribesPosition positionT_1;
    TribesPosition position;
    TribesPosition velocity;
    double[][] range = null;
    protected double objectiveValueFirstDim = 0.0;
    double[] confCoeff = new double[2];
    int contact;
    int[][] iGroup;
    int iGroupNb;
    int strategy;
    int status;
    int label;

    public TribesExplorer(double[][] range, double objFirstDim) {
        this.init(range.length, Tribes.maxTribeNb);
        this.setDoubleRange(range);
        this.objectiveValueFirstDim = objFirstDim;
    }

    public TribesExplorer(TribesExplorer expl) {
        this(expl.getDoubleRange(), expl.objectiveValueFirstDim);
        int n;
        for (n = 0; n < 2; ++n) {
            this.confCoeff[n] = expl.confCoeff[n];
        }
        this.contact = expl.contact;
        this.position = expl.position.clone();
        this.positionT_2 = expl.positionT_2 == null ? null : expl.positionT_2.clone();
        this.positionT_1 = expl.positionT_1 == null ? null : expl.positionT_1.clone();
        this.velocity = expl.velocity.clone();
        this.strategy = expl.strategy;
        this.status = expl.status;
        this.iGroupNb = expl.iGroupNb;
        for (n = 0; n < expl.iGroupNb; ++n) {
            this.iGroup[n][0] = expl.iGroup[n][0];
            this.iGroup[n][0] = expl.iGroup[n][0];
        }
    }

    public void init(int maxDimension, int maxTribeNb) {
        this.initPositions(maxDimension);
        this.iGroup = new int[maxTribeNb][2];
    }

    protected void initPositions(int maxDimension) {
        this.positionT_2 = new TribesPosition(maxDimension);
        this.positionT_1 = new TribesPosition(maxDimension);
        this.position = new TribesPosition(maxDimension);
        this.velocity = new TribesPosition(maxDimension);
    }

    @Override
    public double[] getFitness() {
        return this.position.getFitness();
    }

    @Override
    public double getFitness(int index) {
        return this.position.getFitness()[index];
    }

    @Override
    public void setFitness(double[] fitness) {
        this.position.fitness = fitness;
        super.setFitness(fitness);
        fitness[0] = fitness[0] - this.objectiveValueFirstDim;
        this.position.setTotalError();
    }

    @Override
    public void SetFitness(int index, double fitness) {
        super.SetFitness(index, fitness);
        if (index > this.position.fitness.length) {
            double[] newFit = new double[index + 1];
            System.arraycopy(this.position.fitness, 0, newFit, 0, this.position.fitness.length);
            this.position.fitness = newFit;
        }
        this.position.fitness[index] = index == 0 ? fitness - this.objectiveValueFirstDim : fitness;
        this.position.setTotalError();
    }

    @Override
    public TribesExplorer clone() {
        return new TribesExplorer(this);
    }

    public void clearPosVel() {
        this.initPositions(this.position.getMaxDimension());
    }

    public void informExplorer(int fromTribe, int rank, TribesSwarm swarm, int informOption) {
        int tribeRank = fromTribe;
        switch (informOption) {
            default: {
                System.err.println("moveExplorer error");
                break;
            }
            case -1: {
                this.iGroup[0][0] = tribeRank;
                this.iGroup[0][1] = swarm.tribes[tribeRank].shaman;
                int m = 1;
                for (int n = 0; n < swarm.tribeNb; ++n) {
                    if (n == fromTribe) continue;
                    this.iGroup[m][0] = n;
                    this.iGroup[m][1] = swarm.tribes[n].shaman;
                    ++m;
                }
            }
        }
    }

    public boolean moveExplorer(int fromTribe, int rank, TribesSwarm swarm, int informOption, InterfaceOptimizationProblem prob) {
        int i;
        boolean outH = false;
        this.statusExplorer();
        int statusTribe = fromTribe >= 0 ? swarm.tribes[fromTribe].status : -1;
        this.strategy(this.strategy, statusTribe);
        this.informExplorer(fromTribe, rank, swarm, informOption);
        this.positionT_2 = this.positionT_1;
        this.positionT_1 = this.position;
        this.changeVelocity(this.velocity, fromTribe, swarm, this.strategy, this.confCoeff);
        if (Tribes.repel && swarm.tribes[fromTribe].explorerNb > 2 && rank == swarm.tribes[fromTribe].worst) {
            for (i = 0; i < this.velocity.x.length; ++i) {
                this.velocity.x[i] = -this.velocity.x[i];
            }
        }
        for (i = 0; i < this.position.x.length; ++i) {
            int n = i;
            this.position.x[n] = this.position.x[n] + this.velocity.x[i];
        }
        if (swarm.masterTribe.isCheckConstraints()) {
            this.keepIn(this.range);
        } else {
            outH = false;
            for (i = 0; i < this.position.x.length; ++i) {
                if (!(this.position.x[i] < this.range[i][0]) && !(this.position.x[i] > this.range[i][1])) continue;
                outH = true;
                this.velocity.x[i] = -this.velocity.x[i];
            }
        }
        boolean fitnessEval = true;
        if (Tribes.blind > 0.0 && this.strategy == 6 && RNG.randomDouble() < Tribes.blind) {
            fitnessEval = false;
        }
        if (fitnessEval) {
            if (swarm.masterTribe.isCheckConstraints() || !outH) {
                prob.evaluate(this);
                swarm.masterTribe.incEvalCnt();
            } else {
                for (int n = 0; n < this.position.fitness.length; ++n) {
                    this.SetFitness(n, swarm.tribes[fromTribe].memory[this.contact].getPos().fitness[n] + this.keepInPenalty(this.range, this.position));
                }
            }
        }
        return fitnessEval;
    }

    public void statusExplorer() {
        double delta1 = this.positionT_1.getTotalError() - this.position.getTotalError();
        double delta2 = this.positionT_2.getTotalError() - this.positionT_1.getTotalError();
        int d1 = delta1 < 0.0 ? 0 : (delta1 > 0.0 ? 6 : 3);
        int d2 = delta2 < 0.0 ? 1 : (delta2 > 0.0 ? 3 : 2);
        this.status = d1 + d2;
        int n = this.status - 1;
        Tribes.status[n] = Tribes.status[n] + 1;
    }

    public void strategy(int strategyCurrent, int statusTribe) {
        this.strategy = strategyCurrent;
        switch (this.status) {
            default: {
                this.strategy = 1 + RNG.randomInt(3);
            }
            case 1: {
                this.strategy = 1 + RNG.randomInt(3);
                break;
            }
            case 2: {
                this.strategy = 1 + RNG.randomInt(3);
                break;
            }
            case 3: {
                this.strategy = 1 + RNG.randomInt(3);
                break;
            }
            case 4: {
                this.strategy = 1 + RNG.randomInt(3);
                break;
            }
            case 5: {
                this.strategy = 1 + RNG.randomInt(3);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (statusTribe != 1) break;
                this.strategy = RNG.randomInt(2);
                break;
            }
            case 8: {
                if (statusTribe != 1) break;
                this.strategy = RNG.randomInt(2);
                break;
            }
            case 9: {
                this.strategy = statusTribe == 1 ? RNG.randomInt(2) : (Tribes.blind > 0.0 ? 6 : 5);
            }
        }
        int n = this.strategy - 1;
        Tribes.strategies[n] = Tribes.strategies[n] + 1;
    }

    public void initExplorerSpace(double[][] range) {
        double r;
        for (int i = 0; i < range.length; ++i) {
            r = RNG.randomDouble();
            this.position.x[i] = range[i][0] + (range[i][1] - range[i][0]) * r;
        }
        this.confCoeff[0] = r = 1.0 / (2.0 * Math.log(2.0));
        this.confCoeff[1] = (r + 1.0) * (r + 2.0) / 4.0;
    }

    private double keepInPenalty(double[][] range, TribesPosition pos) {
        double penalty = 0.0;
        for (int d = 0; d < pos.x.length; ++d) {
            if (pos.x[d] < range[d][0]) {
                penalty = penalty + range[d][0] - pos.x[d];
            }
            if (!(pos.x[d] > range[d][1])) continue;
            penalty = penalty - range[d][1] + pos.x[d];
        }
        return penalty;
    }

    public void confCoeffUpdate(double c) {
        double c1New = 0.0;
        double cMin = 0.0;
        double cMax = 1.0;
        if (this.status <= 3) {
            c1New = cMin + (c - cMin) / 2.0;
        }
        if (this.status >= 7) {
            c1New = c + (cMax - c) / 2.0;
        }
        this.confCoeff[0] = c1New;
        this.confCoeff[1] = (c1New + 1.0) * (c1New + 2.0) / 4.0;
    }

    public void keepIn(double[][] range) {
        double alpha = 0.0;
        for (int d = 0; d < range.length; ++d) {
            if (this.position.x[d] < range[d][0]) {
                this.position.x[d] = range[d][0];
                this.velocity.x[d] = alpha * this.velocity.x[d];
                continue;
            }
            if (!(this.position.x[d] > range[d][1])) continue;
            this.position.x[d] = range[d][1];
            this.velocity.x[d] = alpha * this.velocity.x[d];
        }
    }

    public void constraint(int gNb, int hNb, double ups) {
        int d;
        boolean back = false;
        for (d = 0; d < gNb; ++d) {
            if (!(this.position.fitness[1 + d] > 0.0)) continue;
            back = true;
        }
        for (d = 0; d < hNb; ++d) {
            if (!(Math.abs(this.position.fitness[1 + gNb + d]) > ups)) continue;
            back = true;
        }
        if (back) {
            d = 0;
            while (d < this.position.x.length) {
                int n = d;
                this.position.x[n] = this.position.x[n] - this.velocity.x[d];
                int n2 = d++;
                this.velocity.x[n2] = this.velocity.x[n2] / 2.0;
            }
        }
    }

    public void changeVelocity(TribesPosition velocity, int fromTribe, TribesSwarm swarm, int strategy, double[] confCoeff) {
        int d;
        double lambda = 1.0;
        TribesPosition pos1 = this.position;
        TribesPosition pos2 = swarm.tribes[fromTribe].memory[this.contact].getPos();
        int rankTribe = this.iGroup[0][0];
        int rankMem = this.iGroup[0][1];
        TribesPosition pos3 = swarm.tribes[rankTribe].memory[rankMem].getPos();
        switch (strategy) {
            case 0: {
                double rho = pos1.distanceTo(pos2);
                double[] rand_i = RNG.randHypersphere(pos2.getDoubleArray(), rho, 1.5);
                for (d = 0; d < velocity.x.length; ++d) {
                    velocity.x[d] = rand_i[d] - pos1.x[d];
                }
                break;
            }
            case 2: {
                double c0 = (pos2.getTotalError() - pos1.getTotalError()) / (pos2.getTotalError() + pos1.getTotalError());
                lambda = 1.0 + RNG.gaussianDouble(c0);
            }
            case 1: {
                double dx;
                double rho;
                double rho2 = rho = pos2.distanceTo(pos3);
                double rho3 = rho;
                double[] rand_i = RNG.randHypersphere(pos2.getDoubleArray(), rho2, 0.0);
                double[] rand_g = RNG.randHypersphere(pos3.getDoubleArray(), rho3, 0.0);
                double c1 = 1.0 / pos2.getTotalError();
                double c2 = 1.0 / pos3.getTotalError();
                double c3 = c1 + c2;
                c1 /= c3;
                c2 /= c3;
                for (d = 0; d < velocity.x.length; ++d) {
                    dx = c1 * rand_i[d] + c2 * rand_g[d];
                    velocity.x[d] = dx - pos1.x[d];
                }
                break;
            }
            case 3: {
                double r;
                double rho2;
                for (d = 0; d < velocity.x.length; ++d) {
                    rho2 = Math.abs(pos3.x[d] - pos2.x[d]);
                    r = RNG.gaussianDouble(rho2);
                    velocity.x[d] = pos3.x[d] + r - pos1.x[d];
                }
                break;
            }
            case 4: {
                double f1 = pos1.getTotalError();
                double f2 = pos3.getTotalError();
                double gradient = -f1 / (f2 - f1);
                for (d = 0; d < velocity.x.length; ++d) {
                    velocity.x[d] = f2 == f1 ? 0.0 : gradient * (pos3.x[d] - pos1.x[d]);
                }
                break;
            }
            case 5: {
                double r2;
                double r1;
                double c1 = confCoeff[0];
                double c = confCoeff[1];
                for (d = 0; d < velocity.x.length; ++d) {
                    r1 = RNG.randomDouble();
                    r2 = RNG.randomDouble();
                    velocity.x[d] = c1 * velocity.x[d] + r1 * c * (pos2.x[d] - pos1.x[d]) + r2 * c * (pos3.x[d] - pos1.x[d]);
                }
                break;
            }
            case 6: {
                double r = RNG.randomDouble() / 2.0;
                for (d = 0; d < velocity.x.length; ++d) {
                    velocity.x[d] = r * velocity.x[d];
                }
                break;
            }
            case 7: {
                double dx;
                double rho;
                double z = 2.0 * Math.log(2.0);
                double c1 = 1.0 / z;
                double rho2 = rho = pos2.distanceTo(pos3);
                double rho3 = rho;
                double[] rand_i = RNG.randHypersphere(pos2.getDoubleArray(), rho2, 0.0);
                double[] rand_g = RNG.randHypersphere(pos3.getDoubleArray(), rho3, 0.0);
                double c2 = 1.0 / pos2.getTotalError();
                double c3 = 1.0 / pos3.getTotalError();
                double c = c2 + c3;
                c2 /= c;
                c3 /= c;
                for (d = 0; d < velocity.x.length; ++d) {
                    dx = c2 * rand_i[d] + c3 * rand_g[d];
                    velocity.x[d] = c1 * velocity.x[d] + dx - pos1.x[d];
                }
                break;
            }
            case 9: {
                double r2;
                double r1;
                double z = 2.0 * Math.log(2.0);
                double c1 = 1.0 / z;
                double c = (c1 + 1.0) * (c1 + 2.0) / 4.0;
                for (d = 0; d < velocity.x.length; ++d) {
                    r1 = RNG.randomDouble();
                    r2 = RNG.randomDouble();
                    velocity.x[d] = c1 * velocity.x[d] + r1 * c * (pos2.x[d] - pos1.x[d]) + r2 * c * (pos3.x[d] - pos1.x[d]);
                }
                break;
            }
        }
        if (strategy == 2) {
            d = 0;
            while (d < velocity.x.length) {
                int n = d++;
                velocity.x[n] = velocity.x[n] * lambda;
            }
        }
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        return this.position.distanceTo(((TribesExplorer)individual).position) == 0.0;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append("TribesExplorer [");
        for (int i = 0; i < this.position.x.length; ++i) {
            sb.append(this.position.x[i]);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void initialize(InterfaceOptimizationProblem opt) {
        for (int i = 0; i < this.position.x.length; ++i) {
            this.position.x[0] = 0.0;
        }
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        for (int i = 0; i < this.position.x.length; ++i) {
            this.position.x[0] = 0.0;
        }
    }

    @Override
    public void defaultMutate() {
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof double[]) {
            double[] x = (double[])obj;
            if (x.length != this.position.x.length) {
                System.err.println("Init value and requested length doesn't match!");
            }
            this.setDoubleGenotype(x);
        } else {
            this.initialize(opt);
            System.err.println("Initial value for ESIndividualDoubleData is not double[]!");
        }
    }

    @Override
    public AbstractEAIndividual[] mateWith(Population partners) {
        System.err.println("TRIBES: mating is not available!");
        return null;
    }

    @Override
    public void mutate() {
        System.err.println("TRIBES: mutation is not available!");
    }

    @Override
    public void setDoublePhenotype(double[] doubleData) {
        this.position.setDoubleArray(doubleData);
    }

    @Override
    public void setDoubleGenotype(double[] doubleData) {
        this.position.setDoubleArray(doubleData);
    }

    @Override
    public void setDoubleRange(double[][] range) {
        if (this.position.x.length != range.length) {
            this.initPositions(range.length);
        }
        this.range = range;
    }

    @Override
    public double[] getDoubleData() {
        return this.position.x;
    }

    public double[] getVelocity() {
        return this.velocity.x;
    }

    @Override
    public double[] getDoubleDataWithoutUpdate() {
        return this.position.x;
    }

    @Override
    public double[][] getDoubleRange() {
        return this.range;
    }

    @Override
    public void setDoubleDataLength(int length) {
        if (this.position.x.length != length) {
            this.initPositions(length);
        }
    }

    @Override
    public int size() {
        return this.position.x.length;
    }
}

