/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies.tribes;

import eva2.optimization.strategies.Tribes;
import eva2.optimization.strategies.tribes.Tribe;
import eva2.optimization.strategies.tribes.TribesExplorer;
import eva2.optimization.strategies.tribes.TribesMemory;
import eva2.optimization.strategies.tribes.TribesSwarm;
import eva2.tools.math.RNG;
import java.io.Serializable;
import java.util.Arrays;

public class TribesPosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[] x;
    int[][] maxIsoLink = null;
    double[] fitness;
    private double totalError;
    double isolation;

    public TribesPosition(int maxDimension) {
        this.x = new double[maxDimension];
        this.fitness = new double[1];
    }

    public TribesPosition clone() {
        TribesPosition Clone = new TribesPosition(this.x.length);
        System.arraycopy(this.x, 0, Clone.x, 0, this.x.length);
        Clone.fitness = (double[])this.fitness.clone();
        Clone.totalError = this.totalError;
        Clone.isolation = this.isolation;
        return Clone;
    }

    public double[] getDoubleArray() {
        return this.x;
    }

    public void setDoubleArray(double[] vals) {
        this.x = (double[])vals.clone();
    }

    public void setFitness(double[] fit) {
        this.fitness = fit;
    }

    public int getMaxDimension() {
        return this.x.length;
    }

    public double[] getFitness() {
        return this.fitness;
    }

    public double[] getPos() {
        return this.x;
    }

    public double distanceTo(TribesPosition pos) {
        double dist = 0.0;
        for (int d = 0; d < this.x.length; ++d) {
            double di = this.x[d] - pos.x[d];
            dist += di * di;
        }
        dist = Math.sqrt(dist);
        return dist;
    }

    private double isolation(double[][] range, TribesPosition pos, TribesSwarm swarm0) {
        double r;
        double rmin = Math.min(Math.abs(pos.x[0] - range[0][0]), Math.abs(pos.x[0] - range[0][1]));
        for (int d = 1; d < range.length; ++d) {
            r = Math.min(Math.abs(pos.x[d] - range[d][0]), Math.abs(pos.x[d] - range[d][1]));
            if (!(r < rmin)) continue;
            rmin = r;
        }
        for (int n = 0; n < swarm0.tribeNb; ++n) {
            for (int m = 0; m < swarm0.tribes[n].memoryNb; ++m) {
                r = pos.distanceTo(swarm0.tribes[n].memory[m].getPos());
                if (!(r < rmin)) continue;
                rmin = r;
            }
        }
        return rmin;
    }

    public TribesPosition maxIsolated(double[][] range, TribesSwarm swarm0) {
        int d;
        int n;
        Tribe tribe;
        int D = range.length;
        TribesSwarm swarm = new TribesSwarm(null, range, range);
        swarm.size = (int)Math.round(9.5 + 0.124 * (double)(D - 9));
        swarm.size = Math.min(swarm.size, Tribes.maxExplorerNb);
        swarm.tribeNb = 1;
        swarm.tribes[0] = tribe = new Tribe();
        swarm.tribes[0].explorerNb = swarm.size;
        swarm.tribes[0].memoryNb = swarm.size;
        swarm.tribes[0].status = 0;
        double c1 = 1.0 / (2.0 * Math.log(2.0));
        double cmax = c1 + 2.0 * Math.log(2.0) - 1.0;
        TribesExplorer explorer = new TribesExplorer(range, 0.0);
        TribesMemory memory = new TribesMemory(range.length);
        if (this.maxIsoLink == null || this.maxIsoLink.length != swarm.size) {
            this.maxIsoLink = new int[swarm.size][swarm.size];
        }
        for (int i = 0; i < swarm.size; ++i) {
            Arrays.fill(this.maxIsoLink[i], 0);
            this.maxIsoLink[i][i] = 1;
        }
        int iterMax = (int)Math.round(300.0 * Math.log(D));
        int neighbourhoodSize = 3;
        for (n = 0; n < swarm.size; ++n) {
            swarm.tribes[0].explorer[n] = explorer;
            for (d = 0; d < D; ++d) {
                double r = RNG.randomDouble();
                swarm.tribes[0].explorer[n].position.x[d] = range[d][0] + (range[d][1] - range[d][0]) * r;
                r = RNG.randomDouble();
                swarm.tribes[0].explorer[n].velocity.x[d] = (1.0 - 2.0 * r) * (range[d][1] - range[d][0]) / 2.0;
            }
            swarm.tribes[0].explorer[n].position.fitness[0] = this.isolation(range, swarm.tribes[0].explorer[n].position, swarm0);
            swarm.tribes[0].memory[n] = memory;
            swarm.tribes[0].memory[n].setPos(swarm.tribes[0].explorer[n].position.clone());
            swarm.tribes[0].memory[n].setPrevPos(swarm.tribes[0].memory[n].getPos().clone());
        }
        swarm.findBest();
        boolean stop = false;
        boolean improv = false;
        int iter = 0;
        while (!stop) {
            int m;
            boolean bl = improv = swarm.bestMem.getPos().fitness[0] > swarm.bestMem.getPrevPos().fitness[0];
            if (!improv) {
                for (n = 0; n < swarm.size; ++n) {
                    Arrays.fill(this.maxIsoLink[n], 0);
                    this.maxIsoLink[n][n] = 1;
                }
                for (n = 0; n < swarm.size; ++n) {
                    for (int k = 0; k < neighbourhoodSize; ++k) {
                        m = RNG.randomInt(swarm.size);
                        this.maxIsoLink[n][m] = 1;
                    }
                }
            }
            for (m = 0; m < swarm.size; ++m) {
                double f;
                double xd;
                int best = 0;
                double fBest = swarm.tribes[0].memory[best].getPos().fitness[0];
                for (n = 1; n < swarm.size; ++n) {
                    double f2;
                    if (this.maxIsoLink[n][m] != 1 || !((f2 = swarm.tribes[0].memory[n].getPos().fitness[0]) > fBest)) continue;
                    best = n;
                    fBest = f2;
                }
                for (d = 0; d < D; ++d) {
                    double r1 = RNG.randomDouble();
                    double r2 = RNG.randomDouble();
                    xd = swarm.tribes[0].explorer[m].position.x[d];
                    swarm.tribes[0].explorer[m].velocity.x[d] = c1 * swarm.tribes[0].explorer[m].velocity.x[d] + cmax * r1 * (swarm.tribes[0].memory[m].getPos().x[d] - xd) + cmax * r2 * (swarm.tribes[0].memory[best].getPos().x[d] - xd);
                    swarm.tribes[0].explorer[m].position.x[d] = xd + swarm.tribes[0].explorer[m].velocity.x[d];
                }
                for (d = 0; d < D; ++d) {
                    xd = swarm.tribes[0].explorer[m].position.x[d];
                    double vd = swarm.tribes[0].explorer[m].velocity.x[d];
                    if (xd < range[d][0]) {
                        swarm.tribes[0].explorer[m].position.x[d] = range[d][0];
                        swarm.tribes[0].explorer[m].velocity.x[d] = -vd / 2.0;
                    }
                    if (!(xd > range[d][1])) continue;
                    swarm.tribes[0].explorer[m].position.x[d] = range[d][1];
                    swarm.tribes[0].explorer[m].velocity.x[d] = -vd / 2.0;
                }
                swarm.tribes[0].explorer[m].position.fitness[0] = f = this.isolation(range, swarm.tribes[0].explorer[m].position, swarm0);
                if (f > swarm.tribes[0].memory[m].getPos().fitness[0]) {
                    swarm.tribes[0].memory[m].setPos(swarm.tribes[0].explorer[m].position.clone());
                }
                if (!(f > swarm.bestMem.getPos().fitness[0])) continue;
                swarm.bestMem.setPos(swarm.tribes[0].explorer[m].position.clone());
            }
            stop = ++iter >= iterMax;
        }
        swarm.bestMem.getPos().isolation = swarm.bestMem.getPos().fitness[0];
        return swarm.bestMem.getPos();
    }

    public boolean firstIsBetter(double[] f1, double[] f2) {
        if (!Tribes.testBC) {
            for (int n = 0; n < f1.length; ++n) {
                if (!(f1[n] > f2[n])) continue;
                return false;
            }
            return true;
        }
        return this.calcTotalError(f1) < this.calcTotalError(f2);
    }

    public double getTotalError() {
        return this.totalError == 0.0 ? 1.0E-17 : this.totalError;
    }

    public void setTotalError(double objectiveFirstDim) {
        this.totalError = this.calcTotalError(objectiveFirstDim, this.fitness);
    }

    public void setTotalError() {
        this.totalError = this.calcTotalError(this.fitness);
    }

    public double calcTotalError(double objectiveFirstDim, double[] fitness) {
        double t = Math.abs(fitness[0] - objectiveFirstDim);
        for (int n = 1; n < fitness.length; ++n) {
            t += Math.abs(fitness[n]);
        }
        return t;
    }

    public double calcTotalError(double[] fitness) {
        double t = 0.0;
        for (int n = 0; n < fitness.length; ++n) {
            t += Math.abs(fitness[n]);
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TribesMemory at [");
        for (int i = 0; i < this.x.length; ++i) {
            sb.append(this.x[i]);
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

