/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.strategies.tribes;

import eva2.optimization.population.Population;
import eva2.optimization.strategies.Tribes;
import eva2.optimization.strategies.tribes.Tribe;
import eva2.optimization.strategies.tribes.TribesExplorer;
import eva2.optimization.strategies.tribes.TribesMemory;
import eva2.optimization.strategies.tribes.TribesParam;
import eva2.optimization.strategies.tribes.TribesPosition;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TribesSwarm
implements Serializable {
    private static final long serialVersionUID = 1L;
    int tribeNb;
    int explorerLabel;
    int memoryLabel;
    Tribe[] tribes;
    Tribes masterTribe;
    private double[][] range;
    private double[][] initRange;
    TribesMemory bestMem = null;
    int explorerNb;
    int memoryNb;
    int size;
    TribesExplorer queen = null;

    public TribesSwarm(Tribes master, double[][] range, double[][] initRange) {
        this.masterTribe = master;
        this.tribes = new Tribe[Tribes.maxTribeNb];
        this.queen = new TribesExplorer(range, master == null ? 0.0 : master.getObjectiveFirstDim());
        this.bestMem = new TribesMemory(range.length);
        this.range = range;
        this.initRange = initRange != null ? initRange : (double[][])null;
    }

    public TribesSwarm(TribesSwarm other) {
        this.tribeNb = other.tribeNb;
        this.explorerLabel = other.explorerLabel;
        this.memoryLabel = other.memoryLabel;
        this.tribes = (Tribe[])other.tribes.clone();
        this.masterTribe = other.masterTribe;
        this.range = (double[][])other.range.clone();
        this.initRange = (double[][])other.initRange.clone();
        this.bestMem = other.bestMem.clone();
        this.size = other.size;
        this.queen = other.queen.clone();
    }

    public TribesSwarm clone() {
        return new TribesSwarm(this);
    }

    public Population toPopulation() {
        Population pop = new Population(this.numExplorers());
        for (int n = 0; n < this.tribeNb; ++n) {
            pop.addAll(Arrays.asList(this.tribes[n].explorer).subList(0, this.tribes[n].explorerNb));
        }
        pop.add(this.getBestMemory().asDummyExplorer(this.range, this.masterTribe.getObjectiveFirstDim()));
        pop.synchSize();
        return pop;
    }

    public TribesMemory getBestMemory() {
        return this.bestMem;
    }

    public int getTribeCnt() {
        return this.tribeNb;
    }

    public int getProblemDim() {
        return this.masterTribe.getProblemDim();
    }

    public void generateSwarm(int initNb, int swarmInitOption, int rangeInitType, InterfaceOptimizationProblem prob) {
        TribesExplorer[] explorer = new TribesExplorer[initNb];
        this.tribeNb = 0;
        this.explorerLabel = 0;
        this.memoryLabel = 0;
        for (int n = 0; n < initNb; ++n) {
            explorer[n] = this.generateExplorer(null, -1.0, swarmInitOption, -1, rangeInitType, prob, false);
            this.masterTribe.incEvalCnt();
        }
        this.addTribe(initNb, explorer);
    }

    public void moveSwarm(double[][] range, TribesParam pb, int informOption, InterfaceOptimizationProblem prob) {
        this.bestMem.setPrevPos(this.bestMem.getPos().clone());
        for (int n = 0; n < this.tribeNb; ++n) {
            this.tribes[n].moveTribe(range, pb, n, this, informOption, prob);
        }
        this.findBest();
        if (Tribes.adaptOption >= 3) {
            this.updateQueen(range, prob);
            if (this.queen.position.firstIsBetter(this.queen.position.getFitness(), this.bestMem.getPos().getFitness())) {
                int[] worst = this.findWorst();
                this.tribes[worst[0]].memory[worst[1]].setPos(this.queen.position.clone());
                this.bestMem.setPrevPos(this.bestMem.getPos().clone());
                this.bestMem.setPos(this.queen.position.clone());
            }
        }
    }

    public int[] find(boolean switchBest) {
        int[] found = new int[]{0, 0};
        double[] f = this.tribes[found[0]].memory[found[1]].getPos().getFitness();
        for (int n = 0; n < this.tribeNb; ++n) {
            for (int m = 0; m < this.tribes[n].memoryNb; ++m) {
                double[] f2 = this.tribes[n].memory[m].getPos().getFitness();
                if ((!switchBest || !this.tribes[n].memory[m].getPos().firstIsBetter(f2, f)) && (switchBest || !this.tribes[n].memory[m].getPos().firstIsBetter(f, f2))) continue;
                found[0] = n;
                found[1] = m;
                f = f2;
            }
        }
        return found;
    }

    public List<TribesPosition> collectMem() {
        ArrayList<TribesPosition> bestList = new ArrayList<TribesPosition>();
        for (int n = 0; n < this.tribeNb; ++n) {
            for (int m = 0; m < this.tribes[n].memoryNb; ++m) {
                bestList.add(this.tribes[n].memory[m].getPos());
            }
        }
        return bestList;
    }

    public int[] findBest() {
        int[] best = this.find(true);
        this.bestMem = this.tribes[best[0]].memory[best[1]].clone();
        return best;
    }

    public int[] findWorst() {
        return this.find(false);
    }

    public void addTribe(int explorerNb, TribesExplorer[] explorer) {
        Tribe t;
        int memoryNb = explorerNb;
        TribesMemory[] memo = new TribesMemory[memoryNb];
        for (int n = 0; n < memoryNb; ++n) {
            memo[n] = new TribesMemory(explorer[n].position.x.length);
            memo[n].status = 0;
            memo[n].setPos(explorer[n].position.clone());
            memo[n].setPrevPos(memo[n].getPos().clone());
        }
        this.tribes[this.tribeNb] = t = new Tribe();
        this.tribes[this.tribeNb].newTribe(explorerNb, explorer, memoryNb, memo);
        ++this.tribeNb;
        this.findBest();
    }

    public int numExplorers() {
        int size = 0;
        for (int n = 0; n < this.tribeNb; ++n) {
            size += this.tribes[n].getNumExplorers();
        }
        return size;
    }

    public int numParticles() {
        int size = 0;
        for (int n = 0; n < this.tribeNb; ++n) {
            size += this.tribes[n].getNumExplorers() + this.tribes[n].getNumMemories();
        }
        return size;
    }

    public void setSwarmSize() {
        this.size = this.numExplorers();
    }

    public void adaptSwarm(int initType, InterfaceOptimizationProblem prob) {
        int centerRank = 0;
        int gmax = 4;
        int[] gener = new int[]{0, 1, 1, 2};
        int gMode = RNG.randomInt(2);
        int explorerNb = 0;
        double radius = -1.0;
        TribesExplorer[] explorer = new TribesExplorer[Tribes.maxExplorerNb];
        block7: for (int n = 0; n < this.tribeNb; ++n) {
            switch (this.tribes[n].status) {
                default: {
                    continue block7;
                }
                case -1: {
                    int particlesToGenerate = Tribes.particleNb(this.range.length, this.tribeNb);
                    if (particlesToGenerate < 2) {
                        particlesToGenerate = 2;
                    }
                    if (explorerNb >= Tribes.maxExplorerNb - particlesToGenerate - 1) continue block7;
                    switch (gMode) {
                        default: {
                            int g;
                            int shaman = this.tribes[n].shaman;
                            for (g = 0; g < particlesToGenerate; ++g) {
                                int gOption = g % gmax;
                                explorer[explorerNb] = this.generateExplorer(this.tribes[n].memory[shaman].getPos(), -1.0, gener[gOption], n, 0, prob, true);
                                ++explorerNb;
                            }
                            continue block7;
                        }
                        case 1: {
                            int gMin;
                            int g;
                            if (explorerNb == 0) {
                                centerRank = 0;
                                explorer[explorerNb] = this.generateExplorer(null, -1.0, 2, n, initType, prob, true);
                                radius = explorer[explorerNb].position.isolation;
                                ++explorerNb;
                                gMin = 1;
                            } else {
                                gMin = 0;
                            }
                            for (g = gMin; g < particlesToGenerate; ++g) {
                                explorer[explorerNb] = this.generateExplorer(explorer[centerRank].position, radius, 3, n, initType, prob, true);
                                ++explorerNb;
                            }
                            continue block7;
                        }
                    }
                }
                case 1: {
                    if (this.tribes[n].explorerNb <= 0) continue block7;
                    this.tribes[n].worstExplorer();
                    int worstRank = this.tribes[n].worst;
                    int welcomeTribe = this.migrateCheck(worstRank, n);
                    if (welcomeTribe >= 0) {
                        this.tribes[welcomeTribe].migrateAccept(this.tribes[n].explorer[worstRank]);
                    }
                    this.tribes[n].deleteExplorer(worstRank);
                }
            }
        }
        if (explorerNb > 0) {
            this.addTribe(explorerNb, explorer);
        }
    }

    public int linkNb(TribesSwarm swarm) {
        int link = 0;
        for (int n = 0; n < swarm.tribeNb; ++n) {
            link += swarm.tribes[n].explorerNb * swarm.tribes[n].memoryNb;
        }
        return link += swarm.tribeNb * (swarm.tribeNb - 1);
    }

    public int migrateCheck(int explorerRank, int tribeRank) {
        double f1 = this.tribes[tribeRank].explorer[explorerRank].position.getTotalError();
        for (int m = 0; m < this.tribeNb; ++m) {
            if (m == tribeRank) continue;
            for (int k = 0; k < this.tribes[m].memoryNb; ++k) {
                double f2 = this.tribes[m].memory[k].getPos().getTotalError();
                if (!(f2 > f1)) continue;
                return m;
            }
        }
        return -1;
    }

    private void updateQueen(double[][] range, InterfaceOptimizationProblem prob) {
        int d;
        double mTot = 0.0;
        for (d = 0; d < range.length; ++d) {
            this.queen.position.x[d] = 0.0;
            for (int t = 0; t < this.tribeNb; ++t) {
                double w = 1.0 / this.tribes[t].memory[this.tribes[t].shaman].getPos().getTotalError();
                mTot += w;
                int n = d;
                this.queen.position.x[n] = this.queen.position.x[n] + w * this.tribes[t].memory[this.tribes[t].shaman].getPos().x[d];
            }
        }
        d = 0;
        while (d < range.length) {
            int n = d++;
            this.queen.position.x[n] = this.queen.position.x[n] / mTot;
        }
        this.queen.keepIn(range);
        prob.evaluate(this.queen);
        this.masterTribe.incEvalCnt();
    }

    public TribesExplorer generateExplorer(TribesPosition center, double radius, int option, int fromTribe, int initType, InterfaceOptimizationProblem prob, boolean notify) {
        TribesExplorer expl = new TribesExplorer(this.range, this.masterTribe.getObjectiveFirstDim());
        expl.setDoubleRange(this.range);
        int D = this.range.length;
        TribesPosition posTemp = new TribesPosition(this.range.length);
        switch (option) {
            case 3: {
                double rho;
                if (radius < 0.0) {
                    int m = RNG.randomInt(this.tribes[fromTribe].memoryNb);
                    rho = center.distanceTo(this.tribes[fromTribe].memory[m].getPos());
                } else {
                    rho = radius;
                }
                expl.position.setDoubleArray(RNG.randHypersphere(center.getDoubleArray(), rho, 1.5));
                double[] rand_i = RNG.randHypersphere(center.getDoubleArray(), rho, 1.5);
                for (int d = 0; d < D; ++d) {
                    expl.velocity.x[d] = rand_i[d] - expl.position.x[d];
                }
                break;
            }
            case 2: {
                expl.position = expl.position.maxIsolated(this.initRange == null ? this.range : this.initRange, this);
                double[] rand_i = RNG.randHypersphere(expl.position.getDoubleArray(), expl.position.fitness[0], 1.5);
                for (int d = 0; d < D; ++d) {
                    expl.velocity.x[d] = rand_i[d] - expl.position.x[d];
                }
                break;
            }
            default: {
                int d;
                if (initType == 1) {
                    if (this.initRange == null) {
                        System.err.println("unexpected null initRange!");
                    }
                    expl.initExplorerSpace(this.initRange);
                    posTemp = expl.position.clone();
                    expl.initExplorerSpace(this.initRange);
                } else {
                    expl.initExplorerSpace(this.range);
                    posTemp = expl.position.clone();
                    expl.initExplorerSpace(this.range);
                }
                for (d = 0; d < this.range.length; ++d) {
                    expl.velocity.x[d] = posTemp.x[d] - expl.position.x[d];
                }
                if (option != 1) break;
                int dmax = RNG.randomInt(D);
                for (int dmod = 0; dmod <= dmax; ++dmod) {
                    d = RNG.randomInt(D);
                    int m = RNG.randomInt(2);
                    expl.position.x[d] = this.initRange == null || initType == 0 ? this.range[d][m] : this.initRange[d][m];
                }
            }
        }
        prob.evaluate(expl);
        if (notify) {
            this.masterTribe.incEvalCnt();
        }
        expl.positionT_1 = expl.position.clone();
        expl.positionT_2 = expl.position.clone();
        expl.label = this.explorerLabel++;
        expl.status = 5;
        if (fromTribe >= 0) {
            expl.iGroup[0][0] = fromTribe;
            expl.iGroup[0][1] = this.tribes[fromTribe].shaman;
        } else {
            expl.iGroupNb = 0;
        }
        return expl;
    }

    public void reinitTribe(int tribeIndex, int initType, InterfaceOptimizationProblem prob) {
        this.tribes[tribeIndex].reinitTribe(this, prob, initType);
    }

    public double[][] getRange() {
        return this.range;
    }

    public double[][] getInitRange() {
        return this.initRange;
    }
}

