/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.tools;

import eva2.gui.BeanInspector;
import eva2.gui.HtmlDemo;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.PropertySheetPanel;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.tools.StringTools;
import eva2.util.annotation.Parameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class AbstractObjectEditor
implements PropertyEditor,
PropertyChangeListener {
    public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public Object object;
    public Object backupObject;
    public Hashtable editorTable = new Hashtable();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        System.out.println("------------- here-----------------");
        this.updateCenterComponent(evt);
        this.propertyChangeSupport.firePropertyChange("", this.backupObject, this.object);
    }

    @Override
    public abstract boolean isPaintable();

    @Override
    public abstract void paintValue(Graphics var1, Rectangle var2);

    @Override
    public abstract boolean supportsCustomEditor();

    @Override
    public abstract Component getCustomEditor();

    @Override
    public abstract String getAsText();

    @Override
    public abstract void setAsText(String var1) throws IllegalArgumentException;

    @Override
    public abstract String getJavaInitializationString();

    @Override
    public abstract String[] getTags();

    public abstract void makeBackup();

    public abstract void undoBackup();

    public void firePropertyChange(String s, Object old, Object n) {
        this.propertyChangeSupport.firePropertyChange(s, old, n);
    }

    @Override
    public abstract void setValue(Object var1);

    @Override
    public Object getValue() {
        return this.object;
    }

    public abstract Class getClassType();

    public JPanel getPropertyPanel() {
        GridBagLayout gbLayout = new GridBagLayout();
        JPanel result = new JPanel();
        JPanel centerWrapper = new JPanel();
        this.editorTable.clear();
        result.setLayout(new BorderLayout());
        result.setVisible(true);
        String globalInfo = this.getGlobalInfo();
        JTextArea jt = new JTextArea();
        String className = "Genetic Algorithm";
        StringBuffer helpText = new StringBuffer("NAME\n");
        helpText.append(className).append("\n\n");
        helpText.append("SYNOPSIS\n").append(globalInfo).append("\n\n");
        JButton helpButton = new JButton("Help");
        helpButton.setToolTipText("More information about " + className);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                HtmlDemo temp = new HtmlDemo(StringTools.cutClassName(AbstractObjectEditor.this.object.getClass().getName()) + ".html");
                temp.show();
            }
        });
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(globalInfo);
        jt.setBackground(result.getBackground());
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Info"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)jt, "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        if (HtmlDemo.resourceExists(this.getHelpFileName())) {
            p2.add((Component)helpButton, "North");
        }
        jp.add((Component)p2, "East");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets = new Insets(0, 5, 0, 5);
        gbLayout.setConstraints(jp, gbConstraints);
        result.add((Component)jp, "North");
        result.add((Component)this.getCenterComponent(), "Center");
        result.validate();
        return result;
    }

    public String getHelpFileName() {
        return StringTools.cutClassName(this.object.getClass().getName()) + ".html";
    }

    public abstract String getGlobalInfo();

    public abstract JComponent getCenterComponent();

    public abstract void updateCenterComponent(PropertyChangeEvent var1);

    public GeneralOptimizationEditorProperty getEditorFor(String prop, PropertyDescriptor[] propertyDescriptors, MethodDescriptor[] methods, Object target) {
        GeneralOptimizationEditorProperty result = null;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.getName().equalsIgnoreCase(prop)) continue;
            result = new GeneralOptimizationEditorProperty();
            Object[] args = new Object[]{};
            result.getMethod = propertyDescriptor.getReadMethod();
            result.setMethod = propertyDescriptor.getWriteMethod();
            result.propertyType = propertyDescriptor.getPropertyType();
            result.name = propertyDescriptor.getDisplayName();
            result.label = new JLabel(result.name, 4);
            if (propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getWriteMethod().isAnnotationPresent(Parameter.class)) {
                Parameter parameter = propertyDescriptor.getWriteMethod().getAnnotation(Parameter.class);
                result.tipText = parameter.description();
            } else {
                result.tipText = BeanInspector.getToolTipText(result.name, methods, target);
            }
            try {
                result.value = result.getMethod.invoke(target, args);
                result.editor = PropertyEditorProvider.findEditor(propertyDescriptor, result.value);
                if (result.editor == null) {
                    result.editor = PropertyEditorProvider.findEditor(result.propertyType);
                }
                if (result.editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)result.editor).setClassType(result.propertyType);
                }
                result.editor.setValue(result.value);
                result.editor.addPropertyChangeListener(this);
                AbstractObjectEditor.findViewFor(result);
                if (result.view != null) {
                    result.view.repaint();
                }
            }
            catch (Exception e) {
                System.out.println("Darn cant read the value...");
            }
            return result;
        }
        if (result == null) {
            System.err.println("Warning: unknown property or unable to create editor for property " + prop + ", object " + this.getClass().getName());
        }
        return result;
    }

    public static void findViewFor(GeneralOptimizationEditorProperty editor) {
        editor.view = PropertySheetPanel.getView(editor.editor);
        if (editor.view == null) {
            System.out.println("Warning: Property \"" + editor.name + "\" has non-displayabale editor.  Skipping.");
        }
    }
}

