/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.tools;

import eva2.gui.BeanInspector;
import eva2.tools.BasicResourceLoader;
import eva2.tools.StringTools;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.yaml.snakeyaml.Yaml;

public class FileTools {
    public static String[] loadStringsFromFile(String file) {
        String[] result = null;
        BasicResourceLoader loader = BasicResourceLoader.getInstance();
        byte[] bytes = loader.getBytesFromResourceLocation(file, false);
        if (bytes != null) {
            String data = new String(bytes);
            result = data.split("\n");
        } else {
            System.err.println("BasicResourceLoader failed to read " + file);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not find " + file);
                return result;
            }
            try {
                String currentLine;
                ArrayList<String> tmpA = new ArrayList<String>();
                while ((currentLine = reader.readLine()) != null && currentLine.length() != 0) {
                    currentLine = currentLine.trim();
                    tmpA.add(currentLine);
                }
                result = new String[tmpA.size()];
                for (int i = 0; i < tmpA.size(); ++i) {
                    result[i] = (String)tmpA.get(i);
                }
                reader.close();
            }
            catch (IOException e) {
                System.err.println("Java.io.IOExeption: " + e.getMessage());
            }
        }
        return result;
    }

    public static File writeString(String filename, String str) {
        File f = null;
        try {
            f = FileTools.createNewFile(filename);
            PrintWriter Out = new PrintWriter(new FileOutputStream(f));
            Out.println(str);
            Out.flush();
            Out.close();
        }
        catch (Exception e) {
            System.err.println("Error:" + e.getMessage());
            return null;
        }
        return f;
    }

    public static File createNewFile(String filename) {
        File f = new File(filename);
        try {
            if (!f.createNewFile()) {
                int i = 1;
                while (!(f = new File(filename + "." + i)).createNewFile()) {
                }
                return f;
            }
            return f;
        }
        catch (IOException e) {
            System.err.println("IOException when trying to create new file!");
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static boolean saveObjectWithFileChooser(Component parentComponent, Object object, FileFilter filter) {
        File sFile;
        int returnVal;
        boolean finished = false;
        do {
            JFileChooser fc = FileTools.createFileChooser();
            fc.setFileFilter(filter);
            returnVal = fc.showSaveDialog(parentComponent);
            if (returnVal == 0) {
                sFile = fc.getSelectedFile();
                if (sFile.exists()) {
                    int opt = JOptionPane.showConfirmDialog(parentComponent, "File " + sFile.getName() + " exists! Overwrite?", "Confirm to overwrite file", 1);
                    if (opt == 0) {
                        finished = true;
                    }
                    if (opt != 2) continue;
                    return false;
                }
                finished = true;
                continue;
            }
            return false;
        } while (!finished);
        if (returnVal == 0) {
            try {
                if (object instanceof String) {
                    PrintWriter Out = new PrintWriter(new FileOutputStream(sFile));
                    Out.println((String)object);
                    Out.flush();
                    Out.close();
                } else {
                    ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                    oo.writeObject(object);
                    oo.close();
                }
                return true;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(parentComponent, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
                return false;
            }
        }
        return false;
    }

    public static Object openObject(Component parentComponent, Class clazz, FileFilter filter) {
        Object obj = null;
        JFileChooser fc = FileTools.createFileChooser();
        fc.setFileFilter(filter);
        int returnVal = fc.showOpenDialog(parentComponent);
        if (returnVal == 0) {
            File selected = fc.getSelectedFile();
            try {
                obj = new Yaml().load((InputStream)new FileInputStream(selected.getAbsolutePath()));
                if (!clazz.isAssignableFrom(obj.getClass())) {
                    throw new Exception("Object not of type: " + clazz.getName());
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(parentComponent, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
            }
        }
        if (fc != null) {
            fc = null;
        }
        return obj;
    }

    public static JFileChooser createFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("resources"));
        fileChooser.setFileSelectionMode(0);
        return fileChooser;
    }

    public static boolean saveObjectToFolder(Object object, File folder, boolean forceOverwrite, Component parentComponent) {
        int opt;
        String predefName;
        try {
            predefName = (String)BeanInspector.callIfAvailable(object, "getName", null);
            predefName = StringTools.simplifySymbols(predefName) + ".yml";
        }
        catch (Exception e) {
            predefName = object.getClass().getName();
            predefName = StringTools.simplifySymbols(predefName) + ".yml";
        }
        if (!folder.exists()) {
            System.err.println("Error, folder " + folder + " does not exist, aborting saveObjectToFolder.");
            return false;
        }
        File outFile = new File(folder, predefName);
        if (outFile.exists() && !forceOverwrite && (opt = JOptionPane.showConfirmDialog(parentComponent, "File " + outFile.getName() + " exists! Overwrite?", "Confirm to overwrite file", 1)) != 0) {
            return false;
        }
        String msg = FileTools.saveObject(object, outFile);
        if (msg != null) {
            JOptionPane.showMessageDialog(parentComponent, "Couldn't save object: " + object + "\n" + msg, "Save object to folder", 0);
            return false;
        }
        return true;
    }

    public static String saveObject(Object object, File target) {
        try {
            if (object instanceof String) {
                PrintWriter Out = new PrintWriter(new FileOutputStream(target));
                Out.println((String)object);
                Out.flush();
                Out.close();
            } else {
                ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
                oo.writeObject(object);
                oo.close();
            }
            return null;
        }
        catch (Exception ex) {
            System.err.println("Unable to write to file " + target.getAbsolutePath());
            return ex.getMessage();
        }
    }
}

