/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GeneralGEOFaker
extends JPanel {
    private JButton openButton;
    private JButton saveButton;
    private JButton okButton;
    private JButton editButton;
    private JFileChooser fileChooser;
    private PropertyEditor editor;
    private JPanel interiorPanel;
    private Class classType;

    public GeneralGEOFaker(PropertyEditor e, JPanel i) {
        this.interiorPanel = i;
        this.editor = e;
        this.classType = this.editor.getValue().getClass();
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.openButton = new JButton("Open...");
        this.openButton.setToolTipText("Load a configured object");
        this.openButton.setEnabled(true);
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = GeneralGEOFaker.this.openObject();
                if (object != null) {
                    GeneralGEOFaker.this.editor.setValue(object);
                    GeneralGEOFaker.this.editor.setValue(object);
                }
            }
        });
        this.saveButton = new JButton("Save...");
        this.saveButton.setToolTipText("Save the current configured object");
        this.saveButton.setEnabled(true);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralGEOFaker.this.saveObject(GeneralGEOFaker.this.editor.getValue());
            }
        });
        this.editButton = new JButton("Edit Source");
        this.editButton.setToolTipText("Edit the Source");
        this.editButton.setEnabled(false);
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(true);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneralGEOFaker.this.getTopLevelAncestor() != null && GeneralGEOFaker.this.getTopLevelAncestor() instanceof Window) {
                    Window w = (Window)GeneralGEOFaker.this.getTopLevelAncestor();
                    w.dispose();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.interiorPanel, "Center");
        JPanel okcButs = new JPanel();
        okcButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        okcButs.setLayout(new GridLayout(1, 4, 5, 5));
        okcButs.add(this.openButton);
        okcButs.add(this.saveButton);
        okcButs.add(this.okButton);
        okcButs.add(this.editButton);
        this.add((Component)okcButs, "South");
    }

    protected Object openObject() {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
            File selected = this.fileChooser.getSelectedFile();
            try {
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
                Object obj = oi.readObject();
                oi.close();
                if (!this.classType.isAssignableFrom(obj.getClass())) {
                    throw new Exception("Object not of type: " + this.classType.getName());
                }
                return obj;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
            }
        }
        return null;
    }

    protected void saveObject(Object object) {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showSaveDialog(this)) == 0) {
            File sFile = this.fileChooser.getSelectedFile();
            try {
                ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                oo.writeObject(object);
                oo.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
            }
        }
    }

    protected void createFileChooser() {
        this.fileChooser = new JFileChooser(new File("/resources"));
        this.fileChooser.setFileSelectionMode(0);
    }
}

