/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.tools;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.tools.AbstractObjectEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GeneralGenericObjectEditorPanel
extends JPanel
implements ItemListener {
    private AbstractObjectEditor objectEditor;
    private JComboBox objectChooser;
    private JPanel propertyPanelWrapper;
    private JPanel propertyPanel;
    private DefaultComboBoxModel objectNames;
    private JButton openButton;
    private JButton saveButton;
    public JButton okButton;
    private JButton cancelButton;
    private JFileChooser fileChooser;
    private ArrayList<String> longClassNames;

    public GeneralGenericObjectEditorPanel(AbstractObjectEditor oe) {
        this.objectEditor = oe;
        oe.makeBackup();
        this.objectNames = new DefaultComboBoxModel<String>(new String[0]);
        this.objectChooser = new JComboBox(this.objectNames);
        this.objectChooser.setEditable(false);
        this.propertyPanelWrapper = new JPanel();
        this.propertyPanel = this.objectEditor.getPropertyPanel();
        this.propertyPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GeneralGenericObjectEditorPanel.this.objectEditor.firePropertyChange("", null, GeneralGenericObjectEditorPanel.this.objectEditor.getValue());
            }
        });
        this.openButton = new JButton("Open...");
        this.openButton.setToolTipText("Load a configured object");
        this.openButton.setEnabled(true);
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = GeneralGenericObjectEditorPanel.this.openObject();
                if (object != null) {
                    GeneralGenericObjectEditorPanel.this.objectEditor.setValue(object);
                    GeneralGenericObjectEditorPanel.this.objectEditor.setValue(object);
                }
            }
        });
        this.saveButton = new JButton("Save...");
        this.saveButton.setToolTipText("Save the current configured object");
        this.saveButton.setEnabled(true);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralGenericObjectEditorPanel.this.saveObject(GeneralGenericObjectEditorPanel.this.objectEditor.getValue());
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(true);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralGenericObjectEditorPanel.this.objectEditor.makeBackup();
                if (GeneralGenericObjectEditorPanel.this.getTopLevelAncestor() != null && GeneralGenericObjectEditorPanel.this.getTopLevelAncestor() instanceof Window) {
                    Window w = (Window)GeneralGenericObjectEditorPanel.this.getTopLevelAncestor();
                    w.dispose();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralGenericObjectEditorPanel.this.objectEditor.undoBackup();
                GeneralGenericObjectEditorPanel.this.updateClassType();
                GeneralGenericObjectEditorPanel.this.updateChooser();
                GeneralGenericObjectEditorPanel.this.updateChildPropertySheet();
                if (GeneralGenericObjectEditorPanel.this.getTopLevelAncestor() != null && GeneralGenericObjectEditorPanel.this.getTopLevelAncestor() instanceof Window) {
                    Window w = (Window)GeneralGenericObjectEditorPanel.this.getTopLevelAncestor();
                    w.dispose();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.objectChooser, "North");
        this.propertyPanelWrapper.add(this.propertyPanel);
        this.add((Component)this.propertyPanelWrapper, "Center");
        JPanel okcButs = new JPanel();
        okcButs.setBorder(BorderFactory.createEmptyBorder());
        okcButs.setLayout(new GridLayout(1, 4, 5, 5));
        okcButs.add(this.openButton);
        okcButs.add(this.saveButton);
        okcButs.add(this.okButton);
        this.add((Component)okcButs, "South");
        if (this.objectEditor.getClassType() != null) {
            this.updateClassType();
            this.updateChooser();
            this.updateChildPropertySheet();
        }
        this.objectChooser.addItemListener(this);
    }

    protected Object openObject() {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this)) == 0) {
            File selected = this.fileChooser.getSelectedFile();
            try {
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
                Object obj = oi.readObject();
                oi.close();
                if (!this.objectEditor.getClassType().isAssignableFrom(obj.getClass())) {
                    throw new Exception("Object not of type: " + this.objectEditor.getClassType().getName());
                }
                return obj;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
            }
        }
        return null;
    }

    protected void saveObject(Object object) {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showSaveDialog(this)) == 0) {
            File sFile = this.fileChooser.getSelectedFile();
            try {
                ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                oo.writeObject(object);
                oo.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
            }
        }
    }

    protected void createFileChooser() {
        this.fileChooser = new JFileChooser(new File("/resources"));
        this.fileChooser.setFileSelectionMode(0);
    }

    public void addOkListener(ActionListener a) {
        this.okButton.addActionListener(a);
    }

    public void addCancelListener(ActionListener a) {
        this.cancelButton.addActionListener(a);
    }

    public void removeOkListener(ActionListener a) {
        this.okButton.removeActionListener(a);
    }

    public void removeCancelListener(ActionListener a) {
        this.cancelButton.removeActionListener(a);
    }

    protected void updateClassType() {
        this.longClassNames = GenericObjectEditor.getClassesFromProperties(this.objectEditor.getClassType().getName(), null);
        this.objectChooser.setModel(new DefaultComboBoxModel<Object>(this.longClassNames.toArray()));
        if (this.longClassNames.size() > 1) {
            this.add((Component)this.objectChooser, "North");
        } else {
            this.remove(this.objectChooser);
        }
    }

    protected void updateChooser() {
        String objectName = this.objectEditor.getValue().getClass().getName();
        boolean found = false;
        for (int i = 0; i < this.objectNames.getSize(); ++i) {
            if (!objectName.equals(this.objectNames.getElementAt(i))) continue;
            found = true;
            break;
        }
        if (!found) {
            this.objectNames.addElement(objectName);
        }
        this.objectChooser.getModel().setSelectedItem(objectName);
    }

    public void updateChildPropertySheet() {
        this.propertyPanelWrapper.removeAll();
        this.propertyPanelWrapper.add(this.objectEditor.getPropertyPanel());
        if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
            ((Window)this.getTopLevelAncestor()).pack();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String className = (String)this.objectChooser.getSelectedItem();
        if (e.getSource() == this.objectChooser && e.getStateChange() == 1) {
            className = (String)this.objectChooser.getSelectedItem();
            try {
                System.out.println(className);
                Object n = Class.forName(className).newInstance();
                this.objectEditor.setValue(n);
            }
            catch (Exception ex) {
                System.out.println("Exeption in itemStateChanged" + ex.getMessage());
                this.objectChooser.hidePopup();
                this.objectChooser.setSelectedIndex(0);
                JOptionPane.showMessageDialog(this, "Could not create an example of\n" + className + "\n" + "from the current classpath", "GenericObjectEditor", 0);
            }
        }
    }
}

