/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.tools;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.archiving.ArchivingAllDominating;
import eva2.optimization.population.Population;
import eva2.tools.chart2d.DPoint;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class ImpactOfDimensionOnMOEAs {
    public static void main(String[] args) {
        ImpactOfDimensionOnMOEAs ikel = new ImpactOfDimensionOnMOEAs();
        int maxDim = 21;
        int multiRuns = 25;
        int popSize = 100;
        int numberofVariables = 30;
        double[][] log = new double[maxDim][5];
        double[] tmpD = new double[]{1.0, 1.0};
        Plot mPlot = new Plot("ImpactOfDimensionOnMOEAs", "ProblemDimensin", "No. of Pareto-opt solutions", true);
        for (int l = 0; l < 5; ++l) {
            popSize = 100 + l * 100;
            GraphPointSet mySet = new GraphPointSet(l, mPlot.getFunctionArea());
            mySet.setConnectedMode(true);
            DPoint myPoint = new DPoint(0.0, 0.0);
            mySet.addDPoint(myPoint);
            myPoint = new DPoint(1.0, 1.0 / (double)popSize);
            mySet.addDPoint(myPoint);
            log[0][l] = 0.0;
            log[1][l] = 1.0 / (double)popSize;
            for (int i = 2; i < maxDim; ++i) {
                double mean = 0.0;
                for (int j = 0; j < multiRuns; ++j) {
                    Population pop = new Population();
                    ikel.initializePopulation(pop, popSize, numberofVariables);
                    ikel.evaluatePopulation(pop, i);
                    mean += (double)ikel.numberOfParetoOptimalSolutions(pop) / (double)pop.size();
                }
                myPoint = new DPoint(i, mean /= (double)multiRuns);
                log[i][l] = mean;
                mySet.addDPoint(myPoint);
            }
        }
        ikel.save(log);
    }

    public void save(double[][] log) {
        BufferedWriter outputFile = null;
        try {
            outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("Impact_Of_Dimension_On_MOEAs.dat")));
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not open output file! Filename: Impact_Of_Dimension_On_MOEAs.dat");
        }
        try {
            String tmpS = "Dim;P100;P200;P300;P400;P500\n";
            outputFile.write(tmpS);
            for (int i = 0; i < log.length; ++i) {
                tmpS = "" + i + ";";
                for (int j = 0; j < log[i].length; ++j) {
                    tmpS = tmpS + log[i][j];
                    if (j >= log[i].length - 1) continue;
                    tmpS = tmpS + ";";
                }
                tmpS = tmpS + "\n";
                outputFile.write(tmpS);
            }
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
        try {
            outputFile.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void initializePopulation(Population pop, int popSize, int numberOfVariables) {
        pop.clear();
        ESIndividualDoubleData template = new ESIndividualDoubleData();
        ((InterfaceDataTypeDouble)template).setDoubleDataLength(numberOfVariables);
        for (int i = 0; i < popSize; ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)((AbstractEAIndividual)template).clone();
            tmpIndy.initialize(null);
            pop.add(tmpIndy);
        }
    }

    public void evaluatePopulation(Population pop, int objectives) {
        for (int i = 0; i < pop.size(); ++i) {
            double[] x = ((InterfaceDataTypeDouble)pop.get(i)).getDoubleData();
            double[] fitness = new double[objectives];
            for (int j = 0; j < objectives; ++j) {
                fitness[j] = 1.0;
                for (int k = 0; k < x.length; ++k) {
                    if (k == j) continue;
                    int n = j;
                    fitness[n] = fitness[n] + x[k];
                }
                fitness[j] = j < x.length ? 1.0 / fitness[j] + x[j] : 1.0 / fitness[j] + x[j % objectives] + x[(j + 1) % objectives];
            }
            ((AbstractEAIndividual)pop.get(i)).setFitness(fitness);
        }
    }

    public int numberOfParetoOptimalSolutions(Population pop) {
        ArchivingAllDominating arch = new ArchivingAllDominating();
        pop.SetArchive(new Population());
        arch.addElementsToArchive(pop);
        return pop.getArchive().size();
    }
}

