/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.tools;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class PortfolioFrontTester {
    private Plot plot;
    private int index = 0;
    private BufferedWriter outputFile = null;
    private double[] loss;
    private double[][] risk;

    private void show() {
        this.loss = new double[5];
        this.loss[0] = 1.0;
        this.loss[1] = 0.4;
        this.loss[2] = 0.7;
        this.loss[3] = 0.5;
        this.loss[4] = 0.2;
        this.risk = new double[5][5];
        this.risk[0][0] = 1.0;
        this.risk[1][1] = 0.3;
        this.risk[2][2] = 0.7;
        this.risk[3][3] = 0.5;
        this.risk[4][4] = 0.2;
        this.risk[0][1] = 0.0;
        this.risk[0][2] = 0.2;
        this.risk[0][3] = -0.1;
        this.risk[0][4] = 0.3;
        this.risk[1][2] = 0.0;
        this.risk[1][3] = 0.0;
        this.risk[1][4] = 0.0;
        this.risk[2][3] = 0.3;
        this.risk[2][4] = -0.1;
        this.risk[3][4] = 0.0;
        for (int i = 0; i < this.risk.length; ++i) {
            for (int j = i + 1; j < this.risk.length; ++j) {
                this.risk[j][i] = this.risk[i][j];
            }
        }
        this.initShow();
        this.limitK3(0.283);
    }

    private void fullK2() {
        ArrayList<double[]> complete = new ArrayList<double[]>();
        ArrayList<double[][]> elements = new ArrayList<double[][]>();
        int res = 25;
        for (int i = 0; i < this.loss.length; ++i) {
            for (int j = i + 1; j < this.loss.length; ++j) {
                double[][] tmpElem = new double[res + 1][2];
                double w = 0.0;
                for (int k = 0; k < res + 1; ++k) {
                    tmpElem[k][0] = w * this.loss[i] + (1.0 - w) * this.loss[j];
                    tmpElem[k][1] = w * w * this.risk[i][i] + (1.0 - w) * (1.0 - w) * this.risk[j][j] + 2.0 * (w * (1.0 - w) * this.risk[i][j]);
                    double[] tmpD = new double[]{tmpElem[k][0], tmpElem[k][1]};
                    w += 1.0 / (double)res;
                    complete.add(tmpD);
                }
                this.showLine(tmpElem);
                elements.add(tmpElem);
            }
        }
        this.saveThisStuff(complete, elements);
    }

    private void limitK2(double limit) {
        ArrayList<double[]> complete = new ArrayList<double[]>();
        ArrayList<double[][]> elements = new ArrayList<double[][]>();
        int res = 100;
        for (int i = 0; i < this.loss.length; ++i) {
            for (int j = i + 1; j < this.loss.length; ++j) {
                double[][] tmpElem = new double[res + 1][2];
                double w = 0.0;
                for (int k = 0; k < res + 1; ++k) {
                    if (!(w > limit) || !(1.0 - w > limit)) {
                        tmpElem[k][0] = w * this.loss[i] + (1.0 - w) * this.loss[j];
                        tmpElem[k][1] = w * w * this.risk[i][i] + (1.0 - w) * (1.0 - w) * this.risk[j][j] + 2.0 * (w * (1.0 - w) * this.risk[i][j]);
                        double[] tmpD = new double[]{tmpElem[k][0], tmpElem[k][1]};
                        complete.add(tmpD);
                    } else {
                        tmpElem[k][0] = this.loss[i];
                        tmpElem[k][1] = this.risk[i][i];
                    }
                    w += 1.0 / (double)res;
                }
                this.showLine(tmpElem);
                elements.add(tmpElem);
            }
        }
        this.saveThisStuff(complete, elements);
    }

    private void fullK3() {
        ArrayList<double[]> complete = new ArrayList<double[]>();
        ArrayList elements = new ArrayList();
        int res = 20;
        for (int i = 0; i < this.loss.length; ++i) {
            for (int j = i + 1; j < this.loss.length; ++j) {
                for (int k = j + 1; k < this.loss.length; ++k) {
                    ArrayList<double[]> tmpElem = new ArrayList<double[]>();
                    for (double t1 = 0.0; t1 < 1.0; t1 += 1.0 / (double)res) {
                        for (double t2 = 0.0; t2 < 1.0 - t1; t2 += 1.0 / (double)res) {
                            double[] tmpD = new double[]{t1 * this.loss[i] + t2 * this.loss[j] + (1.0 - t1 - t2) * this.loss[k], t1 * t1 * this.risk[i][i] + t2 * t2 * this.risk[j][j] + (1.0 - t1 - t2) * (1.0 - t1 - t2) * this.risk[k][k] + 2.0 * (t1 * t2 * this.risk[i][j]) + 2.0 * ((1.0 - t1 - t2) * t2 * this.risk[k][j]) + 2.0 * (t1 * (1.0 - t1 - t2) * this.risk[i][k])};
                            tmpElem.add(tmpD);
                            complete.add(tmpD);
                        }
                    }
                    this.showLine(tmpElem);
                    elements.add(tmpElem);
                }
            }
        }
        this.saveThisStuffK3(complete, elements);
    }

    private void limitK3(double limit) {
        ArrayList<double[]> complete = new ArrayList<double[]>();
        ArrayList elements = new ArrayList();
        int res = 35;
        for (int i = 0; i < this.loss.length; ++i) {
            for (int j = i + 1; j < this.loss.length; ++j) {
                for (int k = j + 1; k < this.loss.length; ++k) {
                    ArrayList<double[]> tmpElem = new ArrayList<double[]>();
                    for (double t1 = 0.0; t1 < 1.0; t1 += 1.0 / (double)res) {
                        for (double t2 = 0.0; t2 < 1.0 - t1; t2 += 1.0 / (double)res) {
                            if (this.exceedingLimit(limit, t1, t2, 1.0 - t1 - t2) > 1) continue;
                            double[] tmpD = new double[]{t1 * this.loss[i] + t2 * this.loss[j] + (1.0 - t1 - t2) * this.loss[k], t1 * t1 * this.risk[i][i] + t2 * t2 * this.risk[j][j] + (1.0 - t1 - t2) * (1.0 - t1 - t2) * this.risk[k][k] + 2.0 * (t1 * t2 * this.risk[i][j]) + 2.0 * ((1.0 - t1 - t2) * t2 * this.risk[k][j]) + 2.0 * (t1 * (1.0 - t1 - t2) * this.risk[i][k])};
                            tmpElem.add(tmpD);
                            complete.add(tmpD);
                        }
                    }
                    this.showLine(tmpElem);
                    elements.add(tmpElem);
                }
            }
        }
        this.saveThisStuffK3(complete, elements);
    }

    private int exceedingLimit(double limit, double x1, double x2, double x3) {
        int result = 0;
        if (x1 > limit) {
            ++result;
        }
        if (x2 > limit) {
            ++result;
        }
        if (x3 > limit) {
            ++result;
        }
        return result;
    }

    private void saveThisStuff(ArrayList c, ArrayList e) {
        int i;
        try {
            this.outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("PortX_K2_Limits045_CompleteList.txt")));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Could not open output file!");
        }
        String line = "Risk \t Loss";
        this.writeToFile(line);
        for (int i2 = 0; i2 < c.size(); ++i2) {
            double[] tmpD = (double[])c.get(i2);
            line = tmpD[1] + "\t" + tmpD[0];
            this.writeToFile(line);
        }
        try {
            this.outputFile.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            this.outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("PortX_K2_Limits045_ListElements.txt")));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Could not open output file!");
        }
        int length = e.size();
        double[][][] cara = new double[length][][];
        for (i = 0; i < e.size(); ++i) {
            cara[i] = (double[][])e.get(i);
        }
        line = "";
        for (i = 0; i < cara.length; ++i) {
            line = "Risk" + i + "\t" + "Loss" + i;
        }
        this.writeToFile(line);
        for (i = 0; i < cara[0].length; ++i) {
            line = "";
            for (int j = 0; j < cara.length; ++j) {
                line = line + cara[j][i][1] + "\t" + cara[j][i][0] + "\t";
            }
            this.writeToFile(line);
        }
        try {
            this.outputFile.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void saveThisStuffK3(ArrayList c, ArrayList e) {
        int j;
        int i;
        try {
            this.outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("PortX_K3_Limits0283_CompleteList.txt")));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Could not open output file!");
        }
        String line = "Risk \t Loss";
        this.writeToFile(line);
        for (int i2 = 0; i2 < c.size(); ++i2) {
            double[] tmpD = (double[])c.get(i2);
            line = tmpD[1] + "\t" + tmpD[0];
            this.writeToFile(line);
        }
        try {
            this.outputFile.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            this.outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("PortX_K3_Limits0283_ListElements.txt")));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Could not open output file!");
        }
        int length = e.size();
        double[][][] cara = new double[length][][];
        for (i = 0; i < e.size(); ++i) {
            ArrayList tmpA = (ArrayList)e.get(i);
            cara[i] = new double[tmpA.size()][];
            for (j = 0; j < tmpA.size(); ++j) {
                cara[i][j] = (double[])tmpA.get(j);
            }
        }
        line = "";
        for (i = 0; i < cara.length; ++i) {
            line = "Risk" + i + "\t" + "Loss" + i;
        }
        this.writeToFile(line);
        for (i = 0; i < cara[0].length; ++i) {
            line = "";
            for (j = 0; j < cara.length; ++j) {
                try {
                    line = line + cara[j][i][1] + "\t" + cara[j][i][0] + "\t";
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.out.print(".");
                    line = line + "-1 \t - 1\t";
                }
            }
            this.writeToFile(line);
        }
        try {
            this.outputFile.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void writeToFile(String line) {
        String write = line + "\n";
        if (this.outputFile == null) {
            return;
        }
        try {
            this.outputFile.write(write, 0, write.length());
            this.outputFile.flush();
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
    }

    private void initShow() {
        double[] tmpD = new double[]{0.0, 0.0};
        this.plot = new Plot("Multiobjective Optimization", "Y1", "Y2", tmpD, tmpD);
    }

    private void showLine(double[][] elm) {
        GraphPointSet mySet = new GraphPointSet(this.index, this.plot.getFunctionArea());
        mySet.setConnectedMode(false);
        ++this.index;
        for (int i = 0; i < elm.length; ++i) {
            mySet.addDPoint(elm[i][1], elm[i][0]);
        }
    }

    private void showLine(ArrayList elm) {
        double[][] res = new double[elm.size()][];
        for (int i = 0; i < elm.size(); ++i) {
            res[i] = (double[])elm.get(i);
        }
        this.showLine(res);
    }

    public static void main(String[] args) {
        PortfolioFrontTester t = new PortfolioFrontTester();
        t.show();
    }
}

