/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.AbstractSynchronousOptimizationProblem;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import java.util.Random;

public abstract class AbstractDynTransProblem
extends AbstractSynchronousOptimizationProblem {
    private static final long serialVersionUID = 2361612076300958044L;
    protected InterfaceOptimizationProblem prob;
    protected AbstractEAIndividual bestIndividual = null;
    protected int seed = 1;
    protected Random rand = new Random(this.seed);
    protected int problemDimension;
    protected double[][] range;

    public AbstractDynTransProblem() {
        this.setProblem(new F1Problem());
        this.setFrequencyRelative(true);
    }

    protected AbstractOptimizationProblem getInstance() {
        return this;
    }

    @Override
    public void evaluateAt(AbstractEAIndividual individual, double time) {
        AbstractEAIndividual tussy = (AbstractEAIndividual)individual.clone();
        this.transform(tussy, time);
        this.getProblem().evaluate(tussy);
        individual.setFitness(tussy.getFitness());
    }

    @Override
    public void evaluatePopulationEnd(Population population) {
        double delta = this.transLength(this.getCurrentProblemTime());
        if (this.isExtraPlot()) {
            if (this.myplot != null) {
                this.myplot.jump();
            } else {
                double[] tmpD = new double[]{0.0, 0.0};
                this.myplot = new Plot("population measures", "x1", "x2", tmpD, tmpD);
            }
            this.myplot.setConnectedPoint(population.getFunctionCalls(), delta, 0);
        } else {
            this.myplot = null;
        }
    }

    private double transLength(double time) {
        double ret = 0.0;
        for (int i = 0; i < this.getProblemDimension(); ++i) {
            ret += Math.pow(this.getTranslation(i, time), 2.0);
        }
        return Math.sqrt(ret);
    }

    protected abstract double getTranslation(int var1, double var2);

    protected void transform(AbstractEAIndividual individual, double time) {
        double[] indyData = ((InterfaceDataTypeDouble)((Object)individual)).getDoubleData();
        for (int i = 0; i < indyData.length; ++i) {
            int n = i;
            indyData[n] = indyData[n] - this.getTranslation(i, time);
        }
        ((InterfaceDataTypeDouble)((Object)individual)).setDoubleGenotype(indyData);
    }

    @Override
    public void initializeProblem() {
        super.initializeProblem();
        this.bestIndividual = null;
        this.getProblem().initializeProblem();
    }

    @Override
    public void resetProblem(double severity) {
        if (this.prob != null && this.bestIndividual != null) {
            this.evaluateAt(this.bestIndividual, this.getCurrentProblemTime());
        }
    }

    @Override
    public void initializePopulationAt(Population population, double time) {
        this.getProblem().initializePopulation(population);
        for (Object individuum : population) {
            ((AbstractEAIndividual)individuum).setAge(0);
        }
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        return "DynTransProblem";
    }

    public InterfaceOptimizationProblem getProblem() {
        return this.prob;
    }

    public void setProblem(InterfaceOptimizationProblem prob) {
        this.prob = prob;
        Population pop = new Population();
        pop.setTargetSize(1);
        prob.initializePopulation(pop);
        AbstractEAIndividual indy = (AbstractEAIndividual)pop.get(0);
        if (indy instanceof InterfaceDataTypeDouble) {
            this.problemDimension = ((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange().length;
            this.range = ((InterfaceDataTypeDouble)((Object)indy)).getDoubleRange();
        } else {
            System.out.println("Wrong Problem");
        }
        pop.clear();
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
        this.rand = new Random(seed);
    }
}

