/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.population.Population;
import eva2.problems.AbstractOptimizationProblem;
import java.io.Serializable;

public abstract class AbstractDynamicOptimizationProblem
extends AbstractOptimizationProblem
implements Serializable {
    protected double startTime;
    protected double currentProblemTime;
    protected double severity;
    protected double frequency;
    protected boolean frequencyRelative;
    private AbstractEAIndividual idealInd = null;
    private boolean bExtraPlot = false;
    protected transient Plot myplot = null;

    public void initialize(double startT, double sev, double freq) {
        this.setCurrentProblemTime(startT);
        this.setSeverity(sev);
        this.setFrequency(freq);
        if (this.bExtraPlot) {
            this.makePlot();
        }
    }

    @Override
    public void initializeProblem() {
        this.setCurrentProblemTime(this.getStartTime());
        if (this.myplot != null) {
            try {
                this.myplot.jump();
            }
            catch (NullPointerException e) {
                this.makePlot();
            }
        }
    }

    public abstract void resetProblem(double var1);

    @Override
    public void initializePopulation(Population population) {
        this.initializePopulationAt(population, this.getCurrentProblemTime());
    }

    public abstract void initializePopulationAt(Population var1, double var2);

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    protected void setCurrentProblemTime(double newTime) {
        double sev = newTime - this.currentProblemTime;
        this.currentProblemTime = newTime;
        if (sev != 0.0) {
            this.resetProblem(sev);
        }
    }

    protected double getCurrentProblemTime() {
        return this.currentProblemTime;
    }

    public String problemTimeTipText() {
        return "simulated starting time for the run";
    }

    public void setSeverity(double sev) {
        this.severity = sev;
    }

    public double getSeverity() {
        return this.severity;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public boolean isFrequencyRelative() {
        return this.frequencyRelative;
    }

    public String frequencyTipText() {
        return "The frequency of changes in the target function, should be <= 1";
    }

    public void setFrequencyRelative(boolean frequencyRelative) {
        this.frequencyRelative = frequencyRelative;
    }

    public String frequencyRelativeTipText() {
        return "If marked, frequency is interpreted relative to population size, else it refers to absolute evaluations.";
    }

    protected void incProblemTime(double dt) {
        this.currentProblemTime += dt;
        this.resetProblem(dt);
    }

    public abstract AbstractEAIndividual getCurrentOptimum();

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        if (this.problemToChangeAt(this.getCurrentProblemTime())) {
            this.changeProblemAt(this.getCurrentProblemTime());
        }
        this.evaluateAt(individual, this.getCurrentProblemTime());
        this.countEvaluation();
    }

    protected abstract void countEvaluation();

    protected abstract void changeProblemAt(double var1);

    protected abstract boolean problemToChangeAt(double var1);

    protected abstract void evaluateAt(AbstractEAIndividual var1, double var2);

    public void evaluateInstantly(AbstractEAIndividual individual) {
        this.evaluateAt(individual, this.getCurrentProblemTime());
    }

    @Override
    public void evaluatePopulationEnd(Population population) {
        AbstractEAIndividual popBest = (AbstractEAIndividual)population.getBestIndividual();
        if (this.idealInd == null) {
            this.idealInd = (AbstractEAIndividual)popBest.clone();
        }
    }

    protected void setExtraPlot(boolean doPlot) {
        if (this.bExtraPlot && !doPlot) {
            this.myplot = null;
        } else if (!this.bExtraPlot && doPlot) {
            if (this.myplot != null) {
                this.myplot.jump();
            } else {
                this.makePlot();
            }
        }
        this.bExtraPlot = doPlot;
    }

    protected boolean isExtraPlot() {
        return this.bExtraPlot;
    }

    private void makePlot() {
        double[] tmpD = new double[]{0.0, 0.0};
        this.myplot = new Plot("population measures", "x1", "x2", tmpD, tmpD);
    }

    @Override
    public String getName() {
        return "AbstractDynamicOptimizationProblem";
    }
}

