/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.AbstractProblemDouble;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.tools.EVAERROR;
import eva2.tools.ToolBox;
import eva2.tools.math.Mathematics;

public abstract class AbstractMultiModalProblemKnown
extends AbstractProblemDouble
implements Interface2DBorderProblem,
InterfaceMultimodalProblemKnown {
    protected static InterfaceDistanceMetric distanceMetric = new PhenotypeMetric();
    private double globalOptimum = 0.0;
    protected Population listOfOptima;
    protected double epsilon = 0.05;
    protected int problemDimension = 2;
    protected boolean makeGlobalOptUnreachable = false;

    public AbstractMultiModalProblemKnown() {
        this.problemDimension = 2;
        this.template = new ESIndividualDoubleData();
    }

    protected void cloneObjects(AbstractMultiModalProblemKnown b) {
        super.cloneObjects(b);
        if (b.listOfOptima != null) {
            this.listOfOptima = (Population)b.listOfOptima.clone();
        }
        this.globalOptimum = b.globalOptimum;
        this.epsilon = b.epsilon;
    }

    public AbstractMultiModalProblemKnown(AbstractMultiModalProblemKnown b) {
        this.cloneObjects(b);
    }

    @Override
    public void initializePopulation(Population population) {
        population.clear();
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.problemDimension);
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(this.makeRange());
        for (int i = 0; i < population.getTargetSize(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)this.template.clone();
            tmpIndy.initialize(this);
            population.add(tmpIndy);
        }
        population.initialize();
        if (this.listOfOptima == null) {
            this.globalOptimum = Double.NEGATIVE_INFINITY;
            this.listOfOptima = new Population();
            this.initListOfOptima();
        }
    }

    @Override
    public void initializeProblem() {
        super.initializeProblem();
        this.globalOptimum = Double.NEGATIVE_INFINITY;
        this.listOfOptima = new Population();
        this.initListOfOptima();
        if (!this.fullListAvailable() && Double.isInfinite(this.globalOptimum)) {
            this.globalOptimum = 0.0;
        }
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.globalOptimum - this.evalUnnormalized(x)[0]};
        return result;
    }

    public abstract double[] evalUnnormalized(double[] var1);

    @Override
    public String[] getAdditionalDataHeader() {
        return ToolBox.appendArrays(new String[]{"numOptsFound", "maxPeakRatio"}, new String[][]{super.getAdditionalDataHeader()});
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return ToolBox.appendArrays(new String[]{"The number of optima identified with default accuracy", "The maximum peak ratio measure in [0,1], best at 1, if multiple local optima are known."}, new String[][]{super.getAdditionalDataInfo()});
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        Object[] result = new Object[]{this.getNumberOfFoundOptima((Population)pop), this.getMaximumPeakRatio((Population)pop)};
        return ToolBox.appendArrays(result, new Object[][]{super.getAdditionalDataValue(pop)});
    }

    protected void add2DOptimum(double x, double y) {
        double[] point = new double[]{x, y};
        this.addOptimum(point);
    }

    protected void addOptimum(double[] point) {
        AbstractEAIndividual tmpIndy = (AbstractEAIndividual)this.template.clone();
        ((InterfaceDataTypeDouble)((Object)tmpIndy)).setDoubleGenotype(point);
        tmpIndy.setFitness(this.evalUnnormalized(point));
        if (tmpIndy.getFitness(0) >= this.globalOptimum) {
            this.globalOptimum = tmpIndy.getFitness(0);
            if (this.makeGlobalOptUnreachable) {
                double tmp = this.globalOptimum;
                double dx = 1.0E-30;
                while (tmp == this.globalOptimum) {
                    tmp += dx;
                    dx *= 10.0;
                }
                this.globalOptimum = tmp;
            }
        }
        if (this.isDoRotation()) {
            point = this.inverseRotateMaybe(point);
            ((InterfaceDataTypeDouble)((Object)tmpIndy)).setDoubleGenotype(point);
        }
        this.listOfOptima.add(tmpIndy);
    }

    @Override
    public abstract void initListOfOptima();

    @Override
    public Population getRealOptima() {
        return this.listOfOptima;
    }

    @Override
    public boolean fullListAvailable() {
        return this.getRealOptima() != null && this.getRealOptima().size() > 0;
    }

    @Override
    public int getNumberOfFoundOptima(Population pop) {
        return AbstractMultiModalProblemKnown.getNoFoundOptimaOf(this, pop);
    }

    public static int getNoFoundOptimaOf(InterfaceMultimodalProblemKnown mmProb, Population pop) {
        Population sols = PostProcess.getFoundOptima(pop, mmProb.getRealOptima(), mmProb.getDefaultAccuracy(), true);
        return sols.size();
    }

    @Override
    public double getMaximumPeakRatio(Population pop) {
        if (!this.fullListAvailable()) {
            return -1.0;
        }
        return AbstractMultiModalProblemKnown.getMaximumPeakRatio(this.getRealOptima(), pop, this.epsilon);
    }

    public static double getMaximumPeakRatio(Population realOpts, Population pop, double epsilon) {
        double maxOpt;
        double foundInvertedSum = 0.0;
        double sumRealMaxima = 0.0;
        if (realOpts == null || realOpts.size() == 0) {
            return -1.0;
        }
        sumRealMaxima = maxOpt = realOpts.getEAIndividual(0).getFitness(0);
        for (int i = 1; i < realOpts.size(); ++i) {
            maxOpt = Math.max(maxOpt, realOpts.getEAIndividual(i).getFitness(0));
            sumRealMaxima += realOpts.getEAIndividual(i).getFitness(0);
            if (!(realOpts.getEAIndividual(i).getFitness(0) < 0.0)) continue;
            EVAERROR.errorMsgOnce("Warning: avoid negative maxima in AbstractMultiModalProblemKnown!");
        }
        AbstractEAIndividual[] optsFound = PostProcess.getFoundOptimaArray(pop, realOpts, epsilon, true);
        for (int i = 0; i < realOpts.size(); ++i) {
            if (optsFound[i] == null) continue;
            double tmp = maxOpt - optsFound[i].getFitness(0);
            if (tmp < 0.0) {
                EVAERROR.errorMsgOnce("warning: for the MPR calculation, negative fitness values may disturb the allover result (AbstractMultiModalProblemKnown)");
            }
            foundInvertedSum += Math.max(0.0, tmp);
        }
        return foundInvertedSum / sumRealMaxima;
    }

    public static double getMaximumPeakRatioMaximization(Population realOpts, Population pop, double epsilon, int fitCrit) {
        AbstractEAIndividual[] optsFound = PostProcess.getFoundOptimaArray(pop, realOpts, epsilon, true);
        double mpr = 0.0;
        for (int i = 0; i < realOpts.size(); ++i) {
            if (optsFound[i] == null) continue;
            double tmp = optsFound[i].getFitness(fitCrit);
            if (tmp < 0.0) {
                EVAERROR.errorMsgOnce("warning: for the MPR calculation, negative fitness values may disturb the allover result (AbstractMultiModalProblemKnown)");
            }
            mpr += Math.max(0.0, tmp) / realOpts.getEAIndividual(i).getFitness(fitCrit);
        }
        return mpr;
    }

    public static double getMaximumPeakRatioMaximization(double[] realFits, double[] foundFits) {
        double mpr = Mathematics.sum(foundFits) / Mathematics.sum(realFits);
        return mpr;
    }

    public static double getMaximumPeakRatioMinimization(Population realOpts, Population pop, double epsilon, int fitCrit, double fitThreshold) {
        int i;
        AbstractEAIndividual[] optsFound = PostProcess.getFoundOptimaArray(pop, realOpts, epsilon, true);
        double[] realFits = new double[realOpts.size()];
        double[] foundFits = new double[realOpts.size()];
        double minOpt = Double.MAX_VALUE;
        for (i = 0; i < realOpts.size(); ++i) {
            realFits[i] = realOpts.getEAIndividual(i).getFitness(fitCrit);
            if (realFits[i] > fitThreshold) {
                EVAERROR.errorMsgOnce("Warning: The fitness threshold to turn minimization fitness values into maximization values should be larger than any optimal fitness! (AbstractMultiModalProblemKnown)");
            }
            if (i == 0 || minOpt > realFits[i]) {
                minOpt = realFits[i];
            }
            foundFits[i] = optsFound[i] != null ? optsFound[i].getFitness(fitCrit) : fitThreshold;
        }
        for (i = 0; i < realOpts.size(); ++i) {
            realFits[i] = fitThreshold - realFits[i];
            foundFits[i] = fitThreshold - foundFits[i];
            if (foundFits[i] > realFits[i] && foundFits[i] - realFits[i] > 1.0E-10) {
                System.err.println("Warning: found fitness is better than real fitness - wrong predefined solution or suboptimal epsilon-criterion? Diff was: " + (foundFits[i] - realFits[i]));
            }
            if (!(realFits[i] < 0.0) && !(foundFits[i] < 0.0)) continue;
            EVAERROR.errorMsgOnce("warning: for the MPR calculation, negative fitness values may disturb the allover result (AbstractMultiModalProblemKnown)");
        }
        return AbstractMultiModalProblemKnown.getMaximumPeakRatioMaximization(realFits, foundFits);
    }

    @Override
    public void setDefaultAccuracy(double epsilon) {
        super.setDefaultAccuracy(epsilon);
    }
}

