/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.operator.archiving.ArchivingAllDominating;
import eva2.optimization.operator.archiving.ArchivingNSGA;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.operator.moso.MOSONoConvert;
import eva2.optimization.operator.paretofrontmetrics.InterfaceParetoFrontMetric;
import eva2.optimization.operator.paretofrontmetrics.MetricS;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.tools.ToolBox;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.swing.JFrame;

public abstract class AbstractMultiObjectiveOptimizationProblem
extends AbstractOptimizationProblem {
    private static final long serialVersionUID = -6882081673229946521L;
    protected InterfaceMOSOConverter mosoConverter = new MOSONoConvert();
    protected InterfaceParetoFrontMetric metric = new MetricS();
    protected transient Population paretoFront = new Population();
    public ArrayList areaConst4Parallelization = new ArrayList();
    protected int outputDimension = 2;
    double defaultBorderLow = 0.0;
    double defaultBorderHigh = 5.0;
    protected transient double[][] border;
    protected transient Plot plot;
    protected transient JFrame resultFrame;
    protected transient boolean show = false;

    public AbstractMultiObjectiveOptimizationProblem(double borderHigh) {
        this.defaultBorderHigh = borderHigh;
        this.template = new ESIndividualDoubleData();
        this.makeBorder();
        if (this.show) {
            this.initializeProblemFrame();
        }
    }

    public AbstractMultiObjectiveOptimizationProblem() {
        this(5.0);
    }

    public void setShowParetoFront(boolean b) {
        this.show = b;
        if (this.show) {
            this.initializeProblemFrame();
        } else if (this.plot != null) {
            this.plot.dispose();
            this.plot = null;
        }
    }

    public boolean isShowParetoFront() {
        return this.show;
    }

    public String showParetoFrontTipText() {
        return "Toggles the pareto-front visualisation.";
    }

    @Override
    public abstract Object clone();

    @Override
    public void initializeProblem() {
        this.makeBorder();
        this.paretoFront = new Population();
        if (this.show) {
            this.initializeProblemFrame();
        }
    }

    protected void makeBorder() {
        if (this.border == null) {
            this.border = new double[this.outputDimension][2];
        }
        for (int i = 0; i < this.border.length; ++i) {
            this.border[i][0] = this.getLowerBorder(i);
            this.border[i][1] = this.getUpperBorder(i);
        }
    }

    protected double getUpperBorder(int i) {
        return this.defaultBorderHigh;
    }

    protected double getLowerBorder(int i) {
        return this.defaultBorderLow;
    }

    public static boolean isPopulationMultiObjective(Population pop) {
        if (pop == null) {
            return false;
        }
        if (pop.size() == 0) {
            return false;
        }
        int bestFitLen = pop.getBestFitness().length;
        for (int i = 0; i < pop.size(); ++i) {
            int tmpFitLen = ((AbstractEAIndividual)pop.get(i)).getFitness().length;
            if (tmpFitLen <= 1) {
                return false;
            }
            if (tmpFitLen == bestFitLen) continue;
            return false;
        }
        return true;
    }

    public void resetParetoFront() {
        this.paretoFront = new Population();
    }

    @Override
    public void evaluatePopulationStart(Population population) {
        super.evaluatePopulationStart(population);
        if (this.show && this.plot == null) {
            this.initializeProblemFrame();
        }
    }

    @Override
    public void evaluatePopulationEnd(Population population) {
        super.evaluatePopulationEnd(population);
        for (int i = 0; i < population.size(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
            double[] fitness = tmpIndy.getFitness();
            if (this.border == null) {
                this.border = new double[fitness.length][2];
            } else if (fitness.length != this.border.length) {
                this.border = new double[fitness.length][2];
            }
            for (int j = 0; j < fitness.length; ++j) {
                this.border[j][0] = Math.min(this.border[j][0], fitness[j]);
                this.border[j][1] = Math.max(this.border[j][1], fitness[j]);
            }
        }
        AbstractMultiObjectiveOptimizationProblem.logPopToParetoFront(this.paretoFront, population);
        this.mosoConverter.convertMultiObjective2SingleObjective(population);
        if (this.show && this.plot.isValid()) {
            AbstractMultiObjectiveOptimizationProblem.drawProblem(population, this.plot, this);
        }
    }

    public static void logPopToParetoFront(Population pFront, Population pop) {
        if (AbstractMultiObjectiveOptimizationProblem.isPopulationMultiObjective(pop)) {
            if (pFront == null) {
                System.err.println("Error, give at least an empty population as initial pareto front");
            }
            if (pFront.getArchive() == null) {
                pFront.SetArchive(new Population(100));
            }
            Population tmpPop = new Population(pop.size());
            tmpPop.addPopulation(pop);
            tmpPop.addPopulation(pFront);
            ArchivingNSGA archiving = new ArchivingNSGA();
            archiving.addElementsToArchive(tmpPop);
            pFront.clear();
            pFront.addPopulation(tmpPop.getArchive());
        }
    }

    public void initializeProblemFrame() {
        double[] tmpD = new double[]{0.0, 0.0};
        if (this.plot == null) {
            this.plot = new Plot("Multiobjective Optimization", "Y1", "Y2", tmpD, tmpD);
        }
        this.initAdditionalData(this.plot, 10);
    }

    public void initAdditionalData(Plot plot, int index) {
        plot.clearGraph(index);
        plot.setUnconnectedPoint(0.0, 0.0, index);
    }

    public static void drawProblem(Population pFront, Population archive, Plot plot) {
        ArchivingAllDominating tmpArch = new ArchivingAllDominating();
        if (pFront != null && plot != null) {
            plot.clearAll();
            tmpArch.plotParetoFront(pFront, plot);
            if (archive != null) {
                GraphPointSet mySet = new GraphPointSet(10, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                for (int i = 0; i < archive.size(); ++i) {
                    DPointIconCircle icon = new DPointIconCircle();
                    double[] tmpD = ((AbstractEAIndividual)archive.get(i)).getFitness();
                    if (tmpD.length < 2) {
                        throw new RuntimeException("Error, problem seems not to be multi-objective, pareto front plot not possible!");
                    }
                    DPoint myPoint = new DPoint(tmpD[0], tmpD[1]);
                    if (((AbstractEAIndividual)archive.get(i)).getConstraintViolation() > 0.0) {
                        icon.setBorderColor(Color.RED);
                        icon.setFillColor(Color.RED);
                    } else {
                        icon.setBorderColor(Color.BLACK);
                        icon.setFillColor(Color.BLACK);
                    }
                    myPoint.setIcon(icon);
                    mySet.addDPoint(myPoint);
                }
            }
        }
    }

    public static void drawProblem(Population p, Plot plot, AbstractMultiObjectiveOptimizationProblem moProblem) {
        ArchivingAllDominating tmpArch = new ArchivingAllDominating();
        Population tmpPop = null;
        if (p.getGeneration() > 2) {
            if (AbstractMultiObjectiveOptimizationProblem.isPopulationMultiObjective(p)) {
                tmpPop = moProblem.paretoFront;
            } else {
                tmpPop = new Population();
                tmpPop.addPopulation(p);
                if (p.getArchive() != null) {
                    tmpPop.addPopulation(p.getArchive());
                }
                tmpArch.addElementsToArchive(tmpPop);
                tmpPop = tmpPop.getArchive();
            }
            if (tmpPop != null) {
                AbstractMultiObjectiveOptimizationProblem.drawProblem(tmpPop, p.getArchive(), plot);
            }
            moProblem.drawAdditionalData(plot, p, 10);
        }
    }

    public void drawAdditionalData(Plot plot, Population pop, int index) {
        plot.clearGraph(index);
        for (int i = 0; i < pop.size(); ++i) {
            double[] tmpFitness = ((AbstractEAIndividual)pop.get(i)).getFitness();
            if (tmpFitness.length <= 1) {
                tmpFitness = (double[])((AbstractEAIndividual)pop.get(i)).getData("MOFitness");
            }
            plot.setUnconnectedPoint(tmpFitness[0], tmpFitness[1], index);
        }
        plot.setUnconnectedPoint(this.border[0][1], this.border[1][1], index);
        plot.setUnconnectedPoint(this.border[0][0], this.border[1][0], index);
    }

    public static void drawWithConstraints(Plot plot, Population pop, double[][] border, int index) {
        int i;
        GraphPointSet mySet = new GraphPointSet(index, plot.getFunctionArea());
        double[][] trueFitness = new double[pop.size()][];
        double[] constraint = new double[pop.size()];
        Object moFitness = ((AbstractEAIndividual)pop.get(0)).hasData("MOFitness") ? (Object)new double[pop.size()][] : (double[][])null;
        for (i = 0; i < pop.size(); ++i) {
            constraint[i] = ((AbstractEAIndividual)pop.get(i)).getConstraintViolation();
            trueFitness[i] = ((AbstractEAIndividual)pop.get(i)).getFitness();
            if (moFitness == null) continue;
            moFitness[i] = (double[])((AbstractEAIndividual)pop.get(i)).getData("MOFitness");
        }
        mySet.setConnectedMode(false);
        for (i = 0; i < trueFitness.length; ++i) {
            DPoint myPoint;
            if (moFitness != null) {
                if (!AbstractMultiObjectiveOptimizationProblem.checkValidAt((double[][])moFitness, i)) continue;
                myPoint = new DPoint(moFitness[i][0], moFitness[i][1]);
                double tmp1 = (double)Math.round(trueFitness[i][0] * 100.0) / 100.0;
                AbstractMultiObjectiveOptimizationProblem.addPoint(constraint, mySet, myPoint, i, "" + tmp1);
                continue;
            }
            if (!AbstractMultiObjectiveOptimizationProblem.checkValidAt(trueFitness, i)) continue;
            myPoint = new DPoint(trueFitness[i][0], trueFitness[i][1]);
            AbstractMultiObjectiveOptimizationProblem.addPoint(constraint, mySet, myPoint, i, "");
        }
        if (border != null) {
            plot.setUnconnectedPoint(border[0][1], border[1][1], index + 1);
            plot.setUnconnectedPoint(border[0][0], border[1][0], index + 1);
        }
    }

    private static boolean checkValidAt(double[][] fitArray, int i) {
        return !new Double(fitArray[i][0]).isNaN() && !new Double(fitArray[i][1]).isNaN() && !new Double(fitArray[i][0]).isInfinite() && !new Double(fitArray[i][1]).isInfinite();
    }

    private static void addPoint(double[] constraint, GraphPointSet mySet, DPoint myPoint, int i, String text) {
        DPointIconText tmp = new DPointIconText(text);
        DPointIconCircle icon = new DPointIconCircle();
        if (constraint[i] > 0.0) {
            icon.setBorderColor(Color.RED);
            icon.setFillColor(Color.RED);
        } else {
            icon.setBorderColor(Color.BLUE);
            icon.setFillColor(Color.BLUE);
        }
        tmp.setIcon(icon);
        myPoint.setIcon(tmp);
        mySet.addDPoint(myPoint);
    }

    @Override
    public Double getDoublePlotValue(Population pop) {
        if (AbstractMultiObjectiveOptimizationProblem.isPopulationMultiObjective(pop)) {
            return this.calculateMetric(pop);
        }
        if (AbstractMultiObjectiveOptimizationProblem.isPopulationMultiObjective(this.paretoFront)) {
            return this.calculateMetric(this.paretoFront);
        }
        return pop.getBestEAIndividual().getFitness(0);
    }

    public Population getLocalParetoFront() {
        return this.paretoFront;
    }

    @Override
    public String[] getAdditionalDataHeader() {
        String[] superHd = super.getAdditionalDataHeader();
        return ToolBox.appendArrays(new String[]{"paretoMetricCurrent", "paretoMetricFront"}, new String[][]{superHd});
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        Object[] result = new Object[2];
        if (this.mosoConverter != null && !(this.mosoConverter instanceof MOSONoConvert)) {
            result[0] = Double.NaN;
            result[1] = Double.NaN;
        } else {
            result[0] = this.calculateMetric((Population)pop);
            result[1] = this.calculateMetric(this.getLocalParetoFront());
        }
        return ToolBox.appendArrays(result, new Object[][]{super.getAdditionalDataValue(pop)});
    }

    @Override
    public String[] getAdditionalDataInfo() {
        String[] superInfo = super.getAdditionalDataInfo();
        return ToolBox.appendArrays(new String[]{"Pareto metric on the current population (per generation)", "Pareto metric on the collected pareto front"}, new String[][]{superInfo});
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        return null;
    }

    public double calculateMetric(Population pop) {
        if (pop == null || pop.size() == 0) {
            return Double.NaN;
        }
        return this.metric.calculateMetricOn(pop, this);
    }

    public double[][] getObjectiveSpaceRange() {
        return this.border;
    }

    public int getOutputDimension() {
        return this.outputDimension;
    }

    public void setMOSOConverter(InterfaceMOSOConverter b) {
        this.mosoConverter = b;
        this.mosoConverter.setOutputDimension(this.outputDimension);
    }

    public InterfaceMOSOConverter getMOSOConverter() {
        return this.mosoConverter;
    }

    public String mOSOConverterTipText() {
        return "Choose a Multiobjective to Singleobjective converter.";
    }

    public void setMetric(InterfaceParetoFrontMetric b) {
        this.metric = b;
    }

    public InterfaceParetoFrontMetric getMetric() {
        return this.metric;
    }

    public String metricTipText() {
        return "Choose the metric to use.";
    }

    class MultiObjectiveEvalThread
    extends Thread {
        AbstractMultiObjectiveOptimizationProblem prob;
        AbstractEAIndividual ind;
        Vector<AbstractEAIndividual> resultrep;
        Population pop;
        Semaphore semaphore = null;

        public MultiObjectiveEvalThread(AbstractMultiObjectiveOptimizationProblem prob, AbstractEAIndividual ind, Vector<AbstractEAIndividual> resultrep, Population pop, Semaphore sema) {
            this.ind = ind;
            this.prob = prob;
            this.resultrep = resultrep;
            this.pop = pop;
            this.semaphore = sema;
        }

        @Override
        public void run() {
            this.prob.evaluate(this.ind);
            this.resultrep.add(this.ind);
            double[] fitness = this.ind.getFitness();
            if (AbstractMultiObjectiveOptimizationProblem.this.border == null) {
                this.prob.border = new double[fitness.length][2];
            } else if (fitness.length != this.prob.border.length) {
                this.prob.border = new double[fitness.length][2];
            }
            for (int j = 0; j < fitness.length; ++j) {
                this.prob.border[j][0] = Math.min(this.prob.border[j][0], fitness[j]);
                this.prob.border[j][1] = Math.max(this.prob.border[j][1], fitness[j]);
            }
            this.pop.incrFunctionCalls();
            this.semaphore.release();
        }
    }
}

