/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.enums.PostProcessMethod;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.distancemetric.IndividualDataMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.moso.MOSONoConvert;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.optimization.operator.terminators.CombinedTerminator;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.operator.terminators.PhenotypeConvergenceTerminator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.ToolBox;
import eva2.util.annotation.Parameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractOptimizationProblem
implements InterfaceOptimizationProblem,
Serializable {
    public static final String STAT_SOLUTION_HEADER = "solution";
    public static final String OLD_FITNESS_KEY = "oldFitness";
    private int parallelThreads = 1;
    protected AbstractEAIndividual template = null;
    private double defaultAccuracy = 0.001;
    protected int problemDimension = 10;

    @Override
    public abstract Object clone();

    public int getParallelThreads() {
        return this.parallelThreads;
    }

    @Parameter(name="parallel", description="Set the number of threaded parallel function evaluations - interesting for slow functions and generational optimizers.")
    public void setParallelThreads(int parallelThreads) {
        this.parallelThreads = parallelThreads;
    }

    @Override
    public abstract void initializeProblem();

    @Override
    public abstract void initializePopulation(Population var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(Population population) {
        this.evaluatePopulationStart(population);
        if (this.parallelThreads > 1) {
            int cntIndies;
            Semaphore sema = new Semaphore(0);
            ExecutorService pool = Executors.newFixedThreadPool(this.parallelThreads);
            for (cntIndies = 0; cntIndies < population.size(); ++cntIndies) {
                AbstractEAIndividual tmpindy = (AbstractEAIndividual)population.get(cntIndies);
                tmpindy.resetConstraintViolation();
                EvalThread evalthread = new EvalThread(this, tmpindy, population, sema);
                pool.execute(evalthread);
            }
            try {
                sema.acquire(cntIndies);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException("Threading error in AbstractOptimizationProblem: " + e.getMessage());
            }
            pool.shutdownNow();
        } else {
            for (int i = 0; i < population.size(); ++i) {
                AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
                tmpIndy.putData(OLD_FITNESS_KEY, tmpIndy.getFitness());
                AbstractEAIndividual abstractEAIndividual = tmpIndy;
                synchronized (abstractEAIndividual) {
                    tmpIndy.resetConstraintViolation();
                    this.evaluate(tmpIndy);
                }
                population.incrFunctionCalls();
            }
        }
        this.evaluatePopulationEnd(population);
    }

    public void evaluatePopulationStart(Population population) {
    }

    public void evaluatePopulationEnd(Population population) {
    }

    @Override
    public abstract void evaluate(AbstractEAIndividual var1);

    public static void defaultInitializePopulation(Population population, AbstractEAIndividual template, InterfaceOptimizationProblem prob) {
        population.clear();
        for (int i = 0; i < population.getTargetSize(); ++i) {
            AbstractEAIndividual tmpIndy = (AbstractEAIndividual)template.clone();
            tmpIndy.initialize(prob);
            population.add(tmpIndy);
        }
        population.initialize();
    }

    @Override
    public String getSolutionRepresentationFor(AbstractEAIndividual individual) {
        return AbstractEAIndividual.getDefaultStringRepresentation(individual);
    }

    @Override
    public Double getDoublePlotValue(Population pop) {
        return pop.getBestEAIndividual().getFitness(0);
    }

    @Override
    public String[] getAdditionalDataHeader() {
        Object[] header = null;
        header = this instanceof InterfaceInterestingHistogram ? new String[]{STAT_SOLUTION_HEADER, "histogram", "score"} : new String[]{STAT_SOLUTION_HEADER};
        header = (String[])AbstractOptimizationProblem.checkAndAppendAdd(0, this.getIndividualTemplate(), header, null);
        header = (String[])AbstractOptimizationProblem.checkAndAppendAdd(0, this.getIndividualTemplate().getCrossoverOperator(), header, null);
        header = (String[])AbstractOptimizationProblem.checkAndAppendAdd(0, this.getIndividualTemplate().getMutationOperator(), header, null);
        return header;
    }

    private static Object[] checkAndAppendAdd(int type, Object o, Object[] dat, PopulationInterface pop) {
        if (o instanceof InterfaceAdditionalPopulationInformer) {
            switch (type) {
                case 0: {
                    return ToolBox.appendArrays((String[])dat, new String[][]{((InterfaceAdditionalPopulationInformer)o).getAdditionalDataHeader()});
                }
                case 1: {
                    return ToolBox.appendArrays((String[])dat, new String[][]{((InterfaceAdditionalPopulationInformer)o).getAdditionalDataInfo()});
                }
                case 2: {
                    return ToolBox.appendArrays(dat, new Object[][]{((InterfaceAdditionalPopulationInformer)o).getAdditionalDataValue(pop)});
                }
            }
            System.err.println("Error, invalid type in AbstractOptimizationProblem.appendAdd");
            return dat;
        }
        return dat;
    }

    @Override
    public String[] getAdditionalDataInfo() {
        Object[] info = this instanceof InterfaceInterestingHistogram ? new String[]{"Representation of the current best individual", "Fitness histogram of the current population", "Fitness threshold based score of the current population"} : new String[]{"Representation of the current best individual"};
        info = (String[])AbstractOptimizationProblem.checkAndAppendAdd(1, this.getIndividualTemplate(), info, null);
        info = (String[])AbstractOptimizationProblem.checkAndAppendAdd(1, this.getIndividualTemplate().getCrossoverOperator(), info, null);
        info = (String[])AbstractOptimizationProblem.checkAndAppendAdd(1, this.getIndividualTemplate().getMutationOperator(), info, null);
        return info;
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        String solStr = AbstractEAIndividual.getDefaultDataString(pop.getBestIndividual());
        Object[] vals = null;
        if (this instanceof InterfaceInterestingHistogram) {
            int fitCrit = 0;
            SolutionHistogram hist = ((InterfaceInterestingHistogram)((Object)this)).getHistogram();
            if (pop.getBestFitness()[fitCrit] < hist.getUpperBound()) {
                Population maybeFiltered = (Population)pop;
                if (pop.size() > 100) {
                    maybeFiltered = maybeFiltered.filterByFitness(hist.getUpperBound(), fitCrit);
                }
                Population sols = PostProcess.clusterBestUpdateHistogram(maybeFiltered, this, hist, fitCrit, this.getDefaultAccuracy());
            }
            vals = new Object[]{solStr, hist, hist.getScore()};
        } else {
            vals = new Object[]{solStr};
        }
        vals = AbstractOptimizationProblem.checkAndAppendAdd(2, pop.getBestIndividual(), vals, pop);
        vals = AbstractOptimizationProblem.checkAndAppendAdd(2, ((AbstractEAIndividual)pop.getBestIndividual()).getCrossoverOperator(), vals, pop);
        vals = AbstractOptimizationProblem.checkAndAppendAdd(2, ((AbstractEAIndividual)pop.getBestIndividual()).getMutationOperator(), vals, pop);
        return vals;
    }

    public JComponent drawIndividual(AbstractEAIndividual indy) {
        return this.drawIndividual(-1, -1, indy);
    }

    @Override
    public JComponent drawIndividual(int generation, int funCalls, AbstractEAIndividual indy) {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        JTextArea area = new JTextArea();
        JScrollPane scroll = new JScrollPane(area);
        String text = "Best Solution:\n";
        if (generation >= 0) {
            text = text + " Generation: " + generation + "\n";
        }
        if (funCalls >= 0) {
            text = text + " Evaluations: " + funCalls + "\n";
        }
        text = text + this.getSolutionRepresentationFor(indy);
        area.setLineWrap(true);
        area.setText(text);
        area.setEditable(false);
        result.add((Component)scroll, "Center");
        return result;
    }

    @Override
    public boolean isMultiObjective() {
        if (this instanceof AbstractMultiObjectiveOptimizationProblem) {
            return ((AbstractMultiObjectiveOptimizationProblem)this).getMOSOConverter() instanceof MOSONoConvert;
        }
        return false;
    }

    public void informAboutOptimizer(InterfaceOptimizer opt) {
    }

    public AbstractEAIndividual getIndividualTemplate() {
        return this.template;
    }

    public static Population extractPotentialOptima(AbstractOptimizationProblem prob, Population pop, double epsilonPhenoSpace, double epsilonFitConv, double clusterSigma, int maxEvalsPerIndy) {
        Population potOptima = new Population();
        for (int i = 0; i < pop.size(); ++i) {
            AbstractEAIndividual indy = pop.getEAIndividual(i);
            boolean isConverged = AbstractOptimizationProblem.isPotentialOptimumNMS(prob, indy, epsilonPhenoSpace, epsilonFitConv, maxEvalsPerIndy);
            if (!isConverged) continue;
            potOptima.addIndividual(indy);
            if (indy.hasData("PostProcessingMovedBy")) continue;
            System.err.println("Error, missing distance information in individual (AbstractOptimizationProblem.extractPotentialOptimum)");
        }
        ClusteringDensityBased clustering = new ClusteringDensityBased(clusterSigma, 2, new IndividualDataMetric("PostProcessingMovedTo"));
        clustering = new ClusteringDensityBased(clusterSigma, 2);
        if (clusterSigma > 0.0) {
            return (Population)PostProcess.clusterBest(potOptima, clustering, 0.0, 11, 1).clone();
        }
        return potOptima;
    }

    public boolean isPotentialOptimum(AbstractEAIndividual orig, double epsilon, double mutationStepSize, int numOfFailures) {
        int stepsCounter = 0;
        if (mutationStepSize < 0.0) {
            mutationStepSize = 1.0E-4;
        }
        if (numOfFailures < 0) {
            numOfFailures = 100 * AbstractEAIndividual.getDoublePositionShallow(this.template).length;
        }
        AbstractEAIndividual indy = (AbstractEAIndividual)orig.clone();
        this.evaluate(indy);
        PhenotypeMetric metric = new PhenotypeMetric();
        double overallDist = 0.0;
        MutateESFixedStepSize mutator = new MutateESFixedStepSize(mutationStepSize);
        for (int i = 0; i < numOfFailures; ++i) {
            AbstractEAIndividual old = (AbstractEAIndividual)indy.clone();
            double tmpD = indy.getMutationProbability();
            indy.setMutationProbability(1.0);
            mutator.mutate(indy);
            ++stepsCounter;
            indy.setMutationProbability(tmpD);
            this.evaluate(indy);
            if (old.isDominatingDebConstraints(indy)) {
                indy = (AbstractEAIndividual)old.clone();
            } else {
                i = 0;
                overallDist = metric.distance(orig, indy);
            }
            if (!(overallDist > epsilon)) continue;
            return false;
        }
        return overallDist < epsilon;
    }

    public static boolean isPotentialOptimumNMS(AbstractOptimizationProblem prob, AbstractEAIndividual orig, double epsilonPhenoSpace, double epsilonFitConv, int maxEvaluations) {
        AbstractEAIndividual indy = (AbstractEAIndividual)orig.clone();
        prob.evaluate(indy);
        PhenotypeMetric metric = new PhenotypeMetric();
        double overallDist = 0.0;
        double initRelPerturb = -1.0;
        int dim = -1;
        if (orig instanceof InterfaceDataTypeDouble) {
            initRelPerturb = epsilonPhenoSpace * 0.5;
            dim = ((InterfaceDataTypeDouble)((Object)orig)).getDoubleRange().length;
            if (maxEvaluations < 0) {
                maxEvaluations = 500 * AbstractEAIndividual.getDoublePositionShallow(prob.template).length;
            }
        } else {
            System.err.println("Cannot initialize NMS on non-double valued individuals!");
            return false;
        }
        Population pop = new Population(1);
        pop.add(orig);
        Serializable term = new EvaluationTerminator(maxEvaluations);
        if (epsilonFitConv > 0.0) {
            term = new CombinedTerminator(new PhenotypeConvergenceTerminator(epsilonFitConv, 100 * dim, PopulationMeasureTerminator.StagnationTypeEnum.fitnessCallBased, PopulationMeasureTerminator.ChangeTypeEnum.absoluteChange, PopulationMeasureTerminator.DirectionTypeEnum.decrease), (InterfaceTerminator)((Object)term), false);
        }
        int evalsPerf = PostProcess.processSingleCandidatesNMCMA(PostProcessMethod.nelderMead, pop, term, initRelPerturb, prob);
        overallDist = metric.distance(indy, pop.getBestEAIndividual());
        orig.putData("PostProcessingMovedBy", overallDist);
        orig.putData("PostProcessingMovedTo", pop.getBestEAIndividual().getDoublePosition());
        return overallDist < epsilonPhenoSpace;
    }

    public double getDefaultAccuracy() {
        return this.defaultAccuracy;
    }

    @Parameter(name="accuracy", description="A default threshold to identify optima - e.g. the assumed minimal distance between any two optima.")
    public void setDefaultAccuracy(double defAcc) {
        this.defaultAccuracy = defAcc;
    }

    @Override
    public String getName() {
        return "AbstractOptimizationProblem";
    }

    @Override
    public int getProblemDimension() {
        return this.problemDimension;
    }

    public void setProblemDimension(int t) {
        this.problemDimension = t;
    }

    class EvalThread
    extends Thread {
        AbstractOptimizationProblem prob;
        AbstractEAIndividual ind;
        Population population;
        Semaphore semaphore;

        public EvalThread(AbstractOptimizationProblem prob, AbstractEAIndividual ind, Population pop, Semaphore sema) {
            this.ind = ind;
            this.prob = prob;
            this.population = pop;
            this.semaphore = sema;
        }

        @Override
        public void run() {
            this.prob.evaluate(this.ind);
            this.population.incrFunctionCalls();
            this.semaphore.release();
        }
    }
}

