/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import java.util.BitSet;

public abstract class AbstractProblemBinary
extends AbstractOptimizationProblem {
    public AbstractProblemBinary() {
        this.initTemplate();
    }

    protected void initTemplate() {
        if (this.template == null) {
            this.template = new GAIndividualBinaryData();
        }
        if (((InterfaceGAIndividual)((Object)this.template)).getGenotypeLength() != this.getProblemDimension()) {
            ((InterfaceDataTypeBinary)((Object)this.template)).setBinaryDataLength(this.getProblemDimension());
        }
    }

    public void cloneObjects(AbstractProblemBinary o) {
        if (o.template != null) {
            this.template = (AbstractEAIndividual)o.template.clone();
        }
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        BitSet tmpBitSet = ((InterfaceDataTypeBinary)((Object)individual)).getBinaryData();
        double[] result = this.evaluate(tmpBitSet);
        individual.setFitness(result);
    }

    public abstract double[] evaluate(BitSet var1);

    @Override
    public void initializePopulation(Population population) {
        ((InterfaceDataTypeBinary)((Object)this.template)).setBinaryDataLength(this.getProblemDimension());
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    @Override
    public void initializeProblem() {
        this.initTemplate();
    }

    @Override
    public String getName() {
        return "AbstractProblemBinary";
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("A binary valued problem:\n");
        sb.append("Dimension   : ");
        sb.append(this.getProblemDimension());
        return sb.toString();
    }
}

