/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import Jama.Matrix;
import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.plot.TopoPlot;
import eva2.optimization.enums.PostProcessMethod;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.optimization.operator.constraint.GenericConstraint;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.operator.terminators.FitnessConvergenceTerminator;
import eva2.optimization.operator.terminators.PopulationMeasureTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceMultimodalProblemKnown;
import eva2.problems.InterfaceProblemDouble;
import eva2.tools.Pair;
import eva2.tools.ToolBox;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Parameter;

public abstract class AbstractProblemDouble
extends AbstractOptimizationProblem
implements InterfaceProblemDouble,
Interface2DBorderProblem {
    private static final long serialVersionUID = -3904130243174390134L;
    private double defaultRange = 10.0;
    private double noise = 0.0;
    private boolean doRotation = false;
    private Matrix rotation;
    private AbstractConstraint[] constraintArray = new AbstractConstraint[]{new GenericConstraint()};
    private boolean withConstraints = false;
    private transient boolean isShowing = false;
    private double rotAngle = 22.5;
    public static String rawFitKey = "UnconstrainedFitnessValue";

    public AbstractProblemDouble() {
        this.initializeTemplate();
    }

    public AbstractProblemDouble(AbstractProblemDouble o) {
        this.cloneObjects(o);
    }

    protected void initializeTemplate() {
        if (this.template == null) {
            this.template = new ESIndividualDoubleData();
        }
        if (this.getProblemDimension() > 0) {
            ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.getProblemDimension());
            ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(this.makeRange());
        }
    }

    public void hideHideable() {
        this.setWithConstraints(this.isWithConstraints());
    }

    protected void cloneObjects(AbstractProblemDouble o) {
        this.defaultRange = o.defaultRange;
        this.noise = o.noise;
        this.setDefaultAccuracy(o.getDefaultAccuracy());
        if (o.template != null) {
            this.template = (AbstractEAIndividual)o.template.clone();
        }
        if (o.constraintArray != null) {
            this.constraintArray = (AbstractConstraint[])o.constraintArray.clone();
            for (int i = 0; i < this.constraintArray.length; ++i) {
                this.constraintArray[i] = (AbstractConstraint)o.constraintArray[i].clone();
            }
        }
        this.withConstraints = o.withConstraints;
        this.doRotation = o.doRotation;
        this.rotation = o.rotation == null ? null : (Matrix)o.rotation.clone();
        this.rotAngle = o.rotAngle;
    }

    protected double[] getEvalArray(AbstractEAIndividual individual) {
        double[] x = new double[((InterfaceDataTypeDouble)((Object)individual)).getDoubleData().length];
        System.arraycopy(((InterfaceDataTypeDouble)((Object)individual)).getDoubleData(), 0, x, 0, x.length);
        return x;
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        double[] x = this.getEvalArray(individual);
        ((InterfaceDataTypeDouble)((Object)individual)).setDoublePhenotype(x);
        double[] fitness = this.evaluate(x);
        if (this.noise != 0.0) {
            RNG.addNoise(fitness, this.noise);
        }
        this.setEvalFitness(individual, x, fitness);
        if (this.isWithConstraints()) {
            individual.putData(rawFitKey, individual.getFitness().clone());
            this.addConstraints(individual, x);
        }
    }

    protected double[] rotateMaybe(double[] x) {
        if (this.isDoRotation()) {
            if (this.rotation == null) {
                this.initializeProblem();
            }
            x = Mathematics.rotate(x, this.rotation);
        }
        return x;
    }

    protected double[] inverseRotateMaybe(double[] x) {
        if (this.isDoRotation()) {
            if (this.rotation == null) {
                this.initializeProblem();
            }
            x = Mathematics.rotate(x, this.rotation.inverse());
        }
        return x;
    }

    protected void addConstraints(AbstractEAIndividual individual, double[] indyPos) {
        AbstractConstraint[] constraints;
        for (AbstractConstraint constraint : constraints = this.getConstraints()) {
            constraint.addViolation(individual, indyPos);
        }
    }

    protected void setEvalFitness(AbstractEAIndividual individual, double[] x, double[] fit) {
        individual.setFitness(fit);
    }

    @Override
    public abstract double[] evaluate(double[] var1);

    @Override
    public void initializePopulation(Population population) {
        this.initializeTemplate();
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    @Override
    public double[][] makeRange() {
        double[][] range = new double[this.getProblemDimension()][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = this.getRangeLowerBound(i);
            range[i][1] = this.getRangeUpperBound(i);
        }
        return range;
    }

    @Override
    public double getRangeLowerBound(int dim) {
        return -this.getDefaultRange();
    }

    @Override
    public double getRangeUpperBound(int dim) {
        return this.getDefaultRange();
    }

    @Override
    public void initializeProblem() {
        this.initializeTemplate();
        this.rotation = this.isDoRotation() ? AbstractProblemDouble.initializeDefaultRotationMatrix(this.rotAngle, this.getProblemDimension()) : null;
    }

    public static Matrix initializeDefaultRotationMatrix(double rotAngle, int dim) {
        return Mathematics.getRotationMatrix(rotAngle * Math.PI / 180.0, dim).transpose();
    }

    @Parameter(description="Gaussian noise level on the fitness value.")
    public void setNoise(double noise) {
        if (noise < 0.0) {
            noise = 0.0;
        }
        this.noise = noise;
    }

    public double getNoise() {
        return this.noise;
    }

    @Parameter(name="individual", description="Base individual type defining the data representation and mutation/crossover operators")
    public void setEAIndividual(InterfaceDataTypeDouble indy) {
        this.template = (AbstractEAIndividual)((Object)indy);
    }

    @Override
    public InterfaceDataTypeDouble getEAIndividual() {
        return (InterfaceDataTypeDouble)((Object)this.template);
    }

    public double getDefaultRange() {
        return this.defaultRange;
    }

    public void setDefaultRange(double defaultRange) {
        this.defaultRange = defaultRange;
        this.initializeTemplate();
    }

    public String defaultRangeTipText() {
        return "Absolute limit for the symmetric range in any dimension";
    }

    @Parameter(name="rotate", description="If marked, the function is rotated by 22.5 degrees along every axis.")
    public void setDoRotation(boolean doRotation) {
        this.doRotation = doRotation;
        if (!doRotation) {
            this.rotation = null;
        }
    }

    public boolean isDoRotation() {
        return this.doRotation;
    }

    public Object[] getParamControl() {
        if (this.isWithConstraints()) {
            return this.constraintArray;
        }
        return null;
    }

    @Override
    public double[][] get2DBorder() {
        return this.makeRange();
    }

    @Override
    public double[] project2DPoint(double[] point) {
        return Mathematics.expandVector(point, this.getProblemDimension(), 0.0);
    }

    @Override
    public double functionValue(double[] point) {
        double[] x = this.project2DPoint(point);
        double v = this.evaluate(x)[0];
        return v;
    }

    public static void addUnrotatedOptimum(Population optimas, AbstractProblemDouble prob, double[] pos) {
        InterfaceDataTypeDouble tmpIndy = (InterfaceDataTypeDouble)prob.getIndividualTemplate().clone();
        tmpIndy.setDoubleGenotype(pos);
        if (prob.isDoRotation()) {
            pos = prob.inverseRotateMaybe(pos);
            tmpIndy.setDoubleGenotype(pos);
        }
        ((AbstractEAIndividual)((Object)tmpIndy)).setFitness(prob.evaluate(pos));
        if (!Mathematics.isInRange(pos, prob.makeRange())) {
            System.err.println("Warning, add optimum which is out of range!");
        }
        optimas.add((AbstractEAIndividual)((Object)tmpIndy));
    }

    public static double[] refineSolutionNMS(AbstractProblemDouble prob, double[] pos) {
        Population pop = new Population();
        InterfaceDataTypeDouble tmpIndy = (InterfaceDataTypeDouble)prob.getIndividualTemplate().clone();
        tmpIndy.setDoubleGenotype(pos);
        ((AbstractEAIndividual)((Object)tmpIndy)).setFitness(prob.evaluate(pos));
        pop.add((AbstractEAIndividual)((Object)tmpIndy));
        FitnessConvergenceTerminator convTerm = new FitnessConvergenceTerminator(1.0E-25, 10, PopulationMeasureTerminator.StagnationTypeEnum.generationBased, PopulationMeasureTerminator.ChangeTypeEnum.absoluteChange, PopulationMeasureTerminator.DirectionTypeEnum.decrease);
        int calls = PostProcess.processSingleCandidatesNMCMA(PostProcessMethod.nelderMead, pop, convTerm, 0.001, prob);
        return ((InterfaceDataTypeDouble)((Object)pop.getBestEAIndividual())).getDoubleData();
    }

    public static int refineWithRotation(double[] pos, AbstractProblemDouble prob) {
        double[] res = prob.inverseRotateMaybe(pos);
        int modifiedInPrjct = Mathematics.projectToRange(res, prob.makeRange());
        res = AbstractProblemDouble.refineSolutionNMS(prob, res);
        res = prob.rotateMaybe(res);
        System.arraycopy(res, 0, pos, 0, res.length);
        return modifiedInPrjct;
    }

    @Override
    public String getName() {
        return "AbstractProblemDouble";
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("A double valued problem: ");
        sb.append(this.getName());
        sb.append("\n");
        sb.append("Dimension   : ");
        sb.append(this.getProblemDimension());
        sb.append("\nNoise level : ");
        sb.append(this.noise);
        return sb.toString();
    }

    public AbstractConstraint[] getConstraints() {
        return this.constraintArray;
    }

    @Parameter(description="Add constraints to the problem.")
    public void setConstraints(AbstractConstraint[] constrArray) {
        this.constraintArray = constrArray;
    }

    public boolean isWithConstraints() {
        return this.withConstraints;
    }

    @Parameter(description="(De-)Activate constraints for the problem.")
    public void setWithConstraints(boolean withConstraints) {
        this.withConstraints = withConstraints;
        GenericObjectEditor.setShowProperty(this.getClass(), "constraints", withConstraints);
    }

    @Override
    public String[] getAdditionalDataHeader() {
        String[] superHeader = super.getAdditionalDataHeader();
        if (this.isWithConstraints()) {
            return ToolBox.appendArrays(superHeader, new String[][]{{"rawFit", "numViol", "sumViol"}});
        }
        return superHeader;
    }

    @Override
    public String[] getAdditionalDataInfo() {
        String[] superInfo = super.getAdditionalDataInfo();
        if (this.isWithConstraints()) {
            return ToolBox.appendArrays(superInfo, new String[][]{{"Raw fitness (unpenalized) of the current best individual", "The number of constraints violated by the current best individual", "The sum of constraint violations of the current best individual"}});
        }
        return superInfo;
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        Object[] superVal = super.getAdditionalDataValue(pop);
        if (this.isWithConstraints()) {
            AbstractEAIndividual indy = (AbstractEAIndividual)pop.getBestIndividual();
            Pair<Integer, Double> violation = this.getConstraintViolation(indy);
            return ToolBox.appendArrays(superVal, new Object[][]{{indy.getData(rawFitKey), violation.head(), violation.tail()}});
        }
        return superVal;
    }

    protected Pair<Integer, Double> getConstraintViolation(AbstractEAIndividual indy) {
        double sum = 0.0;
        int numViol = 0;
        for (AbstractConstraint constr : this.constraintArray) {
            double v = constr.getViolation(this.getEvalArray(indy));
            if (v > 0.0) {
                ++numViol;
            }
            sum += v;
        }
        return new Pair<Integer, Double>(numViol, sum);
    }

    public boolean isShowPlot() {
        return this.isShowing;
    }

    @Parameter(description="Produce an exemplary 2D plot of the function (dimensional cut at x_i=0 for n>1).")
    public void setShowPlot(boolean showP) {
        if (!this.isShowing && showP) {
            TopoPlot plot = new TopoPlot(this.getName(), "x1", "x2");
            plot.setParams(100, 100, 0);
            this.initializeProblem();
            plot.setTopology(this, this.makeRange(), true);
            if (this instanceof InterfaceMultimodalProblemKnown && ((InterfaceMultimodalProblemKnown)((Object)this)).fullListAvailable()) {
                plot.drawPopulation("Opt", ((InterfaceMultimodalProblemKnown)((Object)this)).getRealOptima());
            }
        }
        this.isShowing = showP;
    }
}

