/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GIIndividualIntegerData;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import java.io.Serializable;

public abstract class AbstractProblemInteger
extends AbstractOptimizationProblem
implements Serializable {
    protected AbstractEAIndividual bestIndividuum = null;
    protected int problemDimension = 10;

    public AbstractProblemInteger() {
        this.initTemplate();
    }

    protected void initTemplate() {
        if (this.template == null) {
            this.template = new GIIndividualIntegerData();
        }
        if (((InterfaceDataTypeInteger)((Object)this.template)).size() != this.getProblemDimension()) {
            ((InterfaceDataTypeInteger)((Object)this.template)).setIntegerDataLength(this.getProblemDimension());
        }
    }

    public void cloneObjects(AbstractProblemInteger o) {
        if (o.template != null) {
            this.template = (AbstractEAIndividual)o.template.clone();
        }
        if (o.bestIndividuum != null) {
            this.bestIndividuum = (AbstractEAIndividual)o.bestIndividuum.clone();
        }
        this.problemDimension = o.problemDimension;
    }

    @Override
    public void initializeProblem() {
        this.initTemplate();
        this.bestIndividuum = null;
    }

    @Override
    public void initializePopulation(Population population) {
        this.bestIndividuum = null;
        ((InterfaceDataTypeInteger)((Object)this.template)).setIntegerDataLength(this.problemDimension);
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        int[] x = new int[((InterfaceDataTypeInteger)((Object)individual)).getIntegerData().length];
        System.arraycopy(((InterfaceDataTypeInteger)((Object)individual)).getIntegerData(), 0, x, 0, x.length);
        double[] fitness = this.evaluate(x);
        for (int i = 0; i < fitness.length; ++i) {
            individual.SetFitness(i, fitness[i]);
        }
        if (this.bestIndividuum == null || this.bestIndividuum.getFitness(0) > individual.getFitness(0)) {
            this.bestIndividuum = (AbstractEAIndividual)individual.clone();
        }
    }

    public abstract double[] evaluate(int[] var1);

    @Override
    public String getName() {
        return "AbstractProblemInteger";
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("An integer valued problem:\n");
        sb.append("Dimension   : ");
        sb.append(this.getProblemDimension());
        return sb.toString();
    }

    @Override
    public void setProblemDimension(int n) {
        this.problemDimension = n;
    }

    public void setIndividualTemplate(AbstractEAIndividual indy) {
        this.template = indy;
    }
}

