/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.population.Population;
import eva2.problems.AbstractDynamicOptimizationProblem;

public abstract class AbstractSynchronousOptimizationProblem
extends AbstractDynamicOptimizationProblem {
    protected double evalsSinceChange = 0.0;
    protected double constantProblemEvals = 99999.0;
    protected double shiftPerChange = 1.0;

    @Override
    public void initializeProblem() {
        super.initializeProblem();
        this.evalsSinceChange = 0.0;
    }

    @Override
    protected void changeProblemAt(double problemTime) {
        this.incProblemTime(this.shiftPerChange);
        this.evalsSinceChange = 0.0;
    }

    @Override
    protected boolean problemToChangeAt(double problemTime) {
        return this.evalsSinceChange >= this.constantProblemEvals;
    }

    protected void setConstantProblemEvals(double constEvals) {
        this.constantProblemEvals = constEvals;
    }

    @Override
    protected void countEvaluation() {
        this.evalsSinceChange += 1.0;
    }

    protected double getConstantProblemEvals() {
        return this.constantProblemEvals;
    }

    @Override
    public void setFrequency(double frequency) {
        super.setFrequency(frequency);
        if (this.isFrequencyRelative()) {
            this.setConstantProblemEvals(9999999.0);
        } else {
            this.setConstantProblemEvals(1.0 / frequency);
        }
    }

    @Override
    public void setFrequencyRelative(boolean frequencyRelative) {
        super.setFrequencyRelative(frequencyRelative);
        this.setFrequency(this.getFrequency());
    }

    @Override
    public void evaluatePopulationStart(Population population) {
        if (this.isFrequencyRelative()) {
            this.setConstantProblemEvals((double)population.size() / this.getFrequency());
        }
    }
}

