/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateEAMixer;
import eva2.optimization.operator.mutation.MutateGAGISwapBits;
import eva2.optimization.operator.mutation.MutateGAUniform;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractProblemBinary;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="The task in this problem is to maximize the number of false bits in a BitSet.")
public class B1Problem
extends AbstractProblemBinary
implements Serializable {
    public int problemDimension = 30;

    public B1Problem() {
        this.getIndividualTemplate().setMutationOperator(new MutateEAMixer((InterfaceMutation)new MutateGAGISwapBits(), (InterfaceMutation)new MutateGAUniform()));
    }

    public B1Problem(B1Problem b) {
        super.cloneObjects(b);
        this.problemDimension = b.problemDimension;
    }

    @Override
    public Object clone() {
        return new B1Problem(this);
    }

    @Override
    public double[] evaluate(BitSet b) {
        double[] result = new double[1];
        int fitness = 0;
        for (int i = 0; i < this.getProblemDimension(); ++i) {
            if (!b.get(i)) continue;
            ++fitness;
        }
        result[0] = fitness;
        return result;
    }

    @Override
    public String getSolutionRepresentationFor(AbstractEAIndividual individual) {
        this.evaluate(individual);
        String result = "Minimize Number of Bits problem:\n";
        result = result + individual.getStringRepresentation() + "\n";
        result = result + "Scores " + ((double)this.problemDimension - individual.getFitness(0)) + " zero bits!";
        return result;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        String result = "";
        result = result + "Minimize Bits Problem:\n";
        result = result + "The task is to reduce the number of TRUE Bits in the given bit string.\n";
        result = result + "Parameters:\n";
        result = result + "Number of Bits: " + this.problemDimension + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Maximize number of bits";
    }

    @Override
    public void setProblemDimension(int dim) {
        this.problemDimension = dim;
    }

    public String multiRunsTipText() {
        return "Length of the BitSet that is to be optimized.";
    }

    public void setEAIndividual(InterfaceDataTypeBinary indy) {
        this.template = (AbstractEAIndividual)((Object)indy);
    }

    public InterfaceDataTypeBinary getEAIndividual() {
        return (InterfaceDataTypeBinary)((Object)this.template);
    }

    public String EAIndividualTipText() {
        return "Choose the EAIndividual to use.";
    }
}

