/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.constraint.AbstractConstraint;
import eva2.optimization.operator.constraint.ConstraintCollection;
import eva2.optimization.operator.constraint.ConstraintHandlingEnum;
import eva2.optimization.operator.constraint.ConstraintRelationEnum;
import eva2.optimization.operator.constraint.GenericConstraint;
import eva2.problems.AbstractProblemDouble;
import eva2.util.annotation.Description;
import java.util.Vector;

@Description(value="Minimize the material cost of a pressure vessel")
public class ConstrPressureVessel
extends AbstractProblemDouble {
    private boolean discreteThickness = true;
    private double minThickness = 0.0625;
    private double maxThickness = 2.0;
    private double minRad = 10.0;
    private double maxRad = 300.0;
    private double minLen = 10.0;
    private double maxLen = 300.0;

    public ConstrPressureVessel() {
        this.setWithConstraints(true);
        this.setConstraints(new AbstractConstraint[]{new ConstraintCollection(ConstrPressureVessel.makeDefaultConstraints(), ConstraintHandlingEnum.penaltyAdditive, 1000.0)});
    }

    public ConstrPressureVessel(ConstrPressureVessel o) {
        super.cloneObjects(o);
    }

    public static AbstractConstraint[] makeDefaultConstraints() {
        Vector<GenericConstraint> constraints = new Vector<GenericConstraint>();
        constraints.add(new GenericConstraint("-(*(0.0193,x2),x0)", ConstraintRelationEnum.lessEqZero));
        constraints.add(new GenericConstraint("-(*(0.00954,x2),x1)", ConstraintRelationEnum.lessEqZero));
        constraints.add(new GenericConstraint("-(1296000, +(*(pi, *(pow2(x2),x3)),*(/(4,3),*(pi,pow3(x2))))))", ConstraintRelationEnum.lessEqZero));
        constraints.add(new GenericConstraint("-(x3,240)", ConstraintRelationEnum.lessEqZero));
        return constraints.toArray(new AbstractConstraint[constraints.size()]);
    }

    @Override
    protected double[] getEvalArray(AbstractEAIndividual individual) {
        double[] x = super.getEvalArray(individual);
        if (this.discreteThickness) {
            int n = (int)(x[0] / this.minThickness);
            x[0] = (double)n * this.minThickness;
            n = (int)(x[1] / this.minThickness);
            x[1] = (double)n * this.minThickness;
        }
        return x;
    }

    @Override
    public double[] evaluate(double[] x) {
        double thickS = x[0];
        double thickH = x[1];
        double R = x[2];
        double L = x[3];
        double v = 0.6224 * thickS * R * L + 1.7781 * thickH * R * R + 3.1661 * thickS * thickS * L + 19.84 * thickS * thickS * R;
        return new double[]{v};
    }

    @Override
    public int getProblemDimension() {
        return 4;
    }

    @Override
    public Object clone() {
        return new ConstrPressureVessel(this);
    }

    @Override
    public double getRangeLowerBound(int dim) {
        switch (dim) {
            case 0: 
            case 1: {
                return this.minThickness / 2.0;
            }
            case 2: {
                return this.minRad;
            }
            case 3: {
                return this.minLen;
            }
        }
        System.err.println("Invalid dimension for lower bound (ConstrPressureVessel)");
        return 0.0;
    }

    @Override
    public double getRangeUpperBound(int dim) {
        switch (dim) {
            case 0: 
            case 1: {
                return this.maxThickness;
            }
            case 2: {
                return this.maxRad;
            }
            case 3: {
                return this.maxLen;
            }
        }
        System.err.println("Invalid dimension for upper bound (ConstrPressureVessel)");
        return 100.0;
    }

    @Override
    public String getName() {
        return "Constrained-Pressure-Vessel";
    }

    @Override
    public void hideHideable() {
        super.hideHideable();
        GenericObjectEditor.setHideProperty(this.getClass(), "defaultRange", true);
    }

    public boolean isDiscreteThickness() {
        return this.discreteThickness;
    }

    public void setDiscreteThickness(boolean discreteThickness) {
        this.discreteThickness = discreteThickness;
    }
}

