/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractDynTransProblem;
import eva2.util.annotation.Description;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

@Description(value="A real valued problem jumping dynamically.")
public class DynJumpProblem
extends AbstractDynTransProblem {
    private static final long serialVersionUID = 2693154860448970283L;
    private double lambda = 0.0;
    protected double[] translation;
    private double[] previousMovement;
    protected double[] randomNumber;
    private double evaluations = 0.0;
    private int changeCounter;
    private Writer fw = null;
    private String s = "";

    public DynJumpProblem() {
        this.translation = new double[this.getProblemDimension()];
        this.randomNumber = new double[this.getProblemDimension()];
        this.initialize(0.0, 0.1, 0.1);
        this.changeCounter = 0;
    }

    public DynJumpProblem(DynJumpProblem other) {
        other.clone();
    }

    @Override
    protected double getTranslation(int dim, double time) {
        return this.translation[dim];
    }

    @Override
    protected void changeProblemAt(double problemTime) {
        super.changeProblemAt(problemTime);
        this.makeTranslation();
        ++this.changeCounter;
    }

    @Override
    protected void countEvaluation() {
        super.countEvaluation();
        this.evaluations += 1.0;
    }

    protected void makeTranslation() {
        int i;
        double[] shift = new double[this.getProblemDimension()];
        double norm = 0.0;
        for (int i2 = 0; i2 < this.getProblemDimension(); ++i2) {
            shift[i2] = this.rand.nextGaussian();
            norm += Math.pow(shift[i2], 2.0);
        }
        norm = norm > 0.0 ? this.getSeverity() / Math.sqrt(norm) : 0.0;
        double norm2 = 0.0;
        for (i = 0; i < this.getProblemDimension(); ++i) {
            shift[i] = (1.0 - this.getLambda()) * (norm * shift[i]) + this.getLambda() * this.previousMovement[i];
            norm2 += Math.pow(shift[i], 2.0);
        }
        norm2 = norm2 > 0.0 ? this.getSeverity() / Math.sqrt(norm2) : 0.0;
        for (i = 0; i < this.getProblemDimension(); ++i) {
            shift[i] = norm2 * shift[i];
            if (this.translation[i] + shift[i] < this.range[0][0]) {
                this.translation[i] = 2.0 * this.range[0][0] - this.translation[i] - shift[i];
                int n = i;
                shift[n] = shift[n] * -1.0;
            } else if (this.translation[i] + shift[i] > this.range[0][1]) {
                this.translation[i] = 2.0 * this.range[0][1] - this.translation[i] - shift[i];
                int n = i;
                shift[n] = shift[n] * -1.0;
            } else {
                int n = i;
                this.translation[n] = this.translation[n] + shift[i];
            }
            this.previousMovement[i] = shift[i];
        }
    }

    @Override
    public void initializeProblem() {
        int i;
        super.initializeProblem();
        this.translation = new double[this.getProblemDimension()];
        this.evalsSinceChange = 0.0;
        this.evaluations = 0.0;
        this.changeCounter = 0;
        this.previousMovement = new double[this.getProblemDimension()];
        double norm = 0.0;
        for (i = 0; i < this.getProblemDimension(); ++i) {
            this.previousMovement[i] = this.rand.nextGaussian();
            norm += Math.pow(this.previousMovement[i], 2.0);
        }
        norm = norm > 0.0 ? this.getSeverity() / Math.sqrt(norm) : 0.0;
        for (i = 0; i < this.getProblemDimension(); ++i) {
            this.previousMovement[i] = norm * this.previousMovement[i];
        }
    }

    @Override
    public Object clone() {
        return new DynJumpProblem(this);
    }

    @Override
    public AbstractEAIndividual getCurrentOptimum() {
        return null;
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        return "DynJumpProblem";
    }

    @Override
    public String getName() {
        return "DynJumpProblem";
    }

    public String severityTipText() {
        return "length of the jump";
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public String lambdaTipText() {
        return "direction of movement: [0,1] 0 = random, 1 = dependent";
    }

    public void myPrint(double[] toPrint) {
        for (int i = 0; i < toPrint.length; ++i) {
            System.out.print(toPrint[i] + " ");
        }
        System.out.println("");
    }

    public void myPrint(double[][] toPrint) {
        for (int i = 0; i < toPrint.length; ++i) {
            for (int j = 0; j < toPrint[i].length; ++j) {
                System.out.print(toPrint[i][j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public void writeFile() {
        if (this.fw == null) {
            try {
                this.fw = new FileWriter("DynJumpProblem.txt");
            }
            catch (IOException e) {
                System.err.println("Konnte Datei nicht erstellen");
            }
        } else {
            try {
                this.fw.write("Problem wurde " + this.changeCounter + " mal geaendert!\n");
                this.fw.write(this.evaluations + " Evaluierungen wurden gemacht\n");
                this.fw.write(this.myPrints(this.translation));
            }
            catch (IOException e) {
            }
            finally {
                if (this.fw != null) {
                    try {
                        this.fw.flush();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public String myPrints(double[][] toPrint) {
        for (int i = 0; i < toPrint.length; ++i) {
            for (int j = 0; j < toPrint[i].length; ++j) {
                if (j == this.getProblemDimension()) continue;
                this.s = this.s + toPrint[i][j] + "\t";
            }
            this.s = this.s + "\n";
        }
        this.s = this.s + "\n";
        return this.s;
    }

    public String myPrints(double[] toPrint) {
        for (int i = 0; i < toPrint.length; ++i) {
            this.s = this.s + toPrint[i] + "\t";
            this.s = this.s + "\n";
        }
        this.s = this.s + "\n";
        return this.s;
    }
}

