/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.OptimizerFactory;
import eva2.OptimizerRunnable;
import eva2.gui.BeanInspector;
import eva2.gui.MainFrame;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.moso.MOSONoConvert;
import eva2.optimization.operator.moso.MOSOWeightedFitness;
import eva2.optimization.operator.mutation.MutateESRankMuCMA;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.population.InterfaceSolutionSet;
import eva2.optimization.population.Population;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.StatisticsStandalone;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.ExternalRuntimeProblem;
import eva2.tools.BasicResourceLoader;
import eva2.tools.StringTools;
import eva2.tools.ToolBox;
import eva2.tools.math.Mathematics;

public class ERPStarter {
    public static void main(String[] args) {
        boolean useMultiObjective = false;
        boolean startGUI = false;
        int maxEvals = 5000;
        String outputFilePrefix = "erpTest";
        String[] keys = new String[]{"--gui", "--multiObjective", "--csv", "--cmd", "--maxEvals"};
        int[] arities = new int[]{0, 0, 1, 1, 1};
        Object[] values = new Object[6];
        Integer[] unknownArgs = StringTools.parseArguments(args, keys, arities, values, true);
        if (unknownArgs.length > 0 || values[2] == null || values[3] == null || values[4] == null) {
            System.err.println("Missing or unrecognized command line options: ");
            for (int i = 0; i < unknownArgs.length; ++i) {
                System.err.println("   " + args[unknownArgs[i]]);
            }
            System.err.println("Use with: --csv <path-to-csv-config-file> --cmd <command-with-full-path> --maxEvals <maxEvals> [--multiObjective] [--gui]");
            return;
        }
        System.out.println("Parsing file: " + values[2]);
        ExternalRuntimeProblem erp = ERPStarter.parseCSV((String)values[2]);
        String cmd = (String)values[3];
        maxEvals = Integer.parseInt((String)values[4]);
        System.out.println("Setting maxEvals: " + maxEvals);
        useMultiObjective = values[1] != null;
        startGUI = values[0] != null;
        System.out.println("Setting target function command: " + cmd);
        erp.setCommand(cmd);
        int indexOfLastSlash = cmd.lastIndexOf(System.getProperty("file.separator"));
        erp.setWorkingDirectory(cmd.substring(0, indexOfLastSlash));
        InterfaceOptimizer opt = null;
        if (useMultiObjective) {
            erp.setMosoConverter(new MOSONoConvert());
            opt = OptimizerFactory.createMultiObjectiveEA(new GeneticAlgorithm(), 50, erp, null);
        } else {
            opt = OptimizerFactory.createEvolutionStrategy(5, 20, false, new MutateESRankMuCMA(), 1.0, new CrossoverESDefault(), 0.0, new SelectBestIndividuals(), erp, null);
        }
        System.out.println("Optimizer instance: " + BeanInspector.toString(opt));
        System.out.println("Problem instance: " + BeanInspector.toString(erp));
        OptimizationParameters params = new OptimizationParameters(opt, erp, new EvaluationTerminator(maxEvals));
        if (startGUI) {
            MainFrame.initClientGUI(params, null, null, null);
        } else {
            OptimizerRunnable rnbl = new OptimizerRunnable((InterfaceOptimizationParameters)params, new StatisticsStandalone(outputFilePrefix, 1, InterfaceStatisticsParameters.OutputVerbosity.ALL, true), false);
            OptimizerFactory.optimize(rnbl);
            InterfaceSolutionSet solSet = opt.getAllSolutions();
            Population sols = solSet.getSolutions();
            System.out.println("*** Solutions found: " + sols.size());
            System.out.println("Best allover solution: " + AbstractEAIndividual.getDefaultStringRepresentation((AbstractEAIndividual)rnbl.getResult()));
            System.out.println("Best last solution: " + AbstractEAIndividual.getDefaultStringRepresentation(solSet.getCurrentPopulation().getBestEAIndividual()));
            System.out.println("Last solution set:");
            for (int i = 0; i < sols.size(); ++i) {
                System.out.println(AbstractEAIndividual.getDefaultStringRepresentation(sols.getEAIndividual(i)));
            }
        }
    }

    public static ExternalRuntimeProblem parseCSV(String fname) {
        return ERPStarter.parseCSV(fname, 5, 2, 4, 3, -1, 7, 9);
    }

    public static ExternalRuntimeProblem parseCSV(String fname, int isVariableColIndex, int lowerBoundIndex, int upperBoundIndex, int initialPosColIndex, int initialPosBoxLenColIndex, int isObjectiveColIndex, int fitWeightsColIndex) {
        double[][] weights;
        double defaultInitialBoxLenRatio = 0.05;
        int[] filterCols = new int[]{isVariableColIndex, lowerBoundIndex, upperBoundIndex, initialPosColIndex, initialPosBoxLenColIndex, isObjectiveColIndex, fitWeightsColIndex};
        double[][] dat = BasicResourceLoader.loadDoubleData(fname, null, ";", 1, -1, filterCols);
        double[][] filteredVars = ToolBox.filterBy(dat, 0, 1.0, 1.0);
        double[][] range = ToolBox.getCols(filteredVars, 1, 2);
        double[][] initPos = ToolBox.getCols(filteredVars, 3);
        double[][] initBoxLen = ToolBox.getCols(filteredVars, 4);
        double[][] filteredObjectives = ToolBox.filterBy(dat, 5, 1.0, 1.0);
        ExternalRuntimeProblem erp = new ExternalRuntimeProblem();
        if (filteredObjectives != null && filteredObjectives.length > 1 && Mathematics.areFinite(weights = ToolBox.getCols(filteredObjectives, 6)) < 0) {
            erp.setMosoConverter(new MOSOWeightedFitness(weights));
        }
        erp.setProblemDimension(filteredVars.length);
        erp.setRange(range);
        double[][] initialRange = new double[filteredVars.length][2];
        for (int i = 0; i < filteredVars.length; ++i) {
            if (Mathematics.isFinite(initPos[i][0])) {
                double dv = defaultInitialBoxLenRatio * (range[i][1] - range[i][0]);
                if (Mathematics.isFinite(initBoxLen[i][0])) {
                    dv = initBoxLen[i][0];
                }
                if (!Mathematics.isInRange(initPos[i][0], range[i][0], range[i][1])) {
                    System.err.println("Warning: initial seed is not in range in dim. " + i + " when parsing from " + fname);
                }
                initialRange[i][0] = initPos[i][0] - dv;
                initialRange[i][1] = initPos[i][0] + dv;
                continue;
            }
            initialRange[i][0] = range[i][0];
            initialRange[i][1] = range[i][1];
        }
        erp.setInitialRange(initialRange);
        return erp;
    }
}

