/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.BeanInspector;
import eva2.gui.PropertyDoubleArray;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.operator.moso.MOSONoConvert;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.InterfaceProblemDouble;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="Use an external command as target function.")
public class ExternalRuntimeProblem
extends AbstractOptimizationProblem
implements Interface2DBorderProblem,
InterfaceProblemDouble,
InterfaceHasInitRange {
    protected AbstractEAIndividual bestIndividuum = null;
    protected int problemDimension = 10;
    protected String command = "";
    protected String workingDir = "";
    PropertyDoubleArray range = new PropertyDoubleArray(this.problemDimension, 2, -10.0, 10.0);
    PropertyDoubleArray initializationRange = new PropertyDoubleArray(this.problemDimension, 2, -10.0, 10.0);
    private String additionalArg = "";
    protected InterfaceMOSOConverter mosoConverter = new MOSONoConvert();

    public ExternalRuntimeProblem() {
        this.template = new ESIndividualDoubleData();
        ((ESIndividualDoubleData)this.template).setDoubleDataLength(this.problemDimension);
        ((ESIndividualDoubleData)this.template).setDoubleRange(this.makeRange());
    }

    public ExternalRuntimeProblem(ExternalRuntimeProblem b) {
        if (b.template != null) {
            this.template = (AbstractEAIndividual)b.template.clone();
        }
        if (b.bestIndividuum != null) {
            this.bestIndividuum = (AbstractEAIndividual)b.bestIndividuum.clone();
        }
        this.problemDimension = b.problemDimension;
        this.command = b.command;
        this.range = b.range != null ? (PropertyDoubleArray)b.range.clone() : null;
        this.initializationRange = b.initializationRange != null ? (PropertyDoubleArray)b.initializationRange.clone() : null;
        this.mosoConverter = b.mosoConverter != null ? (InterfaceMOSOConverter)b.mosoConverter.clone() : null;
        this.workingDir = b.workingDir;
    }

    @Override
    public Object clone() {
        return new ExternalRuntimeProblem(this);
    }

    @Override
    public void initializeProblem() {
        this.bestIndividuum = null;
        File f = new File(this.command);
        if (f.exists()) {
            this.command = f.getAbsolutePath();
        } else {
            String sep = System.getProperty("file.separator");
            f = this.workingDir.endsWith(sep) ? new File(this.workingDir + this.command) : new File(this.workingDir + sep + this.command);
            if (f.exists()) {
                this.command = f.getAbsolutePath();
            } else {
                System.err.println("Warning, " + this.getClass() + " could not find command " + this.command + " in " + this.workingDir);
            }
        }
    }

    @Override
    public void initializePopulation(Population population) {
        this.bestIndividuum = null;
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleDataLength(this.problemDimension);
        ((InterfaceDataTypeDouble)((Object)this.template)).setDoubleRange(this.makeRange());
        AbstractOptimizationProblem.defaultInitializePopulation(population, this.template, this);
    }

    @Override
    public double[][] makeRange() {
        if (this.range == null) {
            System.err.println("Warning, range not set in ExternalRuntimeProblem.makeRange!");
        }
        if (this.range.getNumRows() != this.getProblemDimension()) {
            System.err.println("Warning, problem dimension and range dimension dont match in ExternalRuntimeProblem.makeRange!");
        }
        return (double[][])this.range.getDoubleArrayShallow().clone();
    }

    public void setRange(double[][] range) {
        PropertyDoubleArray pRange = new PropertyDoubleArray(range);
        this.setRange(pRange);
    }

    public void setRange(PropertyDoubleArray range) {
        if (range.getNumRows() < this.problemDimension) {
            System.err.println("Warning, expected range of dimension " + this.problemDimension + " in setRange!");
        }
        this.range.setDoubleArray(range.getDoubleArrayShallow());
    }

    public PropertyDoubleArray getRange() {
        return this.range;
    }

    public String rangeTipText() {
        return "The domain bounds for the problem";
    }

    @Override
    public double getRangeLowerBound(int dim) {
        return this.range.getValue(dim, 0);
    }

    @Override
    public double getRangeUpperBound(int dim) {
        return this.range.getValue(dim, 1);
    }

    @Override
    public void evaluate(AbstractEAIndividual individual) {
        double[] x = this.getXVector(individual);
        double[] fit = this.evaluate(x);
        individual.setFitness(fit);
        if (this.bestIndividuum == null || this.bestIndividuum.getFitness(0) > individual.getFitness(0)) {
            this.bestIndividuum = (AbstractEAIndividual)individual.clone();
        }
    }

    @Override
    public void evaluatePopulationEnd(Population population) {
        super.evaluatePopulationEnd(population);
        if (this.mosoConverter != null) {
            this.mosoConverter.convertMultiObjective2SingleObjective(population);
        }
    }

    protected double[] getXVector(AbstractEAIndividual individual) {
        double[] x = new double[((InterfaceDataTypeDouble)((Object)individual)).getDoubleData().length];
        System.arraycopy(((InterfaceDataTypeDouble)((Object)individual)).getDoubleData(), 0, x, 0, x.length);
        return x;
    }

    public static List<String> runProcess(String[] parameters, String workingDir) {
        ArrayList<String> params = new ArrayList<String>(parameters.length);
        Collections.addAll(params, parameters);
        return ExternalRuntimeProblem.runProcess(params, workingDir);
    }

    public static List<String> runProcess(List<String> parameters, String workingDir) {
        String colSepRegExp = "[\\s;:|]";
        ArrayList<String> results = new ArrayList<String>();
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(parameters);
            pb.directory(new File(workingDir));
            Process process = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            MonitorInputStreamThread thread = new MonitorInputStreamThread(process.getErrorStream());
            thread.start();
            while ((line = br.readLine()) != null) {
                line = line.trim();
                String[] parts = line.split(colSepRegExp);
                Collections.addAll(results, parts);
            }
            br.close();
        }
        catch (IOException e) {
            String msg = "IO Error when calling external command! Invalid command for ExternalRuntimeProblem?";
            System.err.println(msg);
            e.printStackTrace();
            throw new RuntimeException(msg);
        }
        return results;
    }

    @Override
    public double[] evaluate(double[] x) {
        if (x == null) {
            throw new RuntimeException("Error, x=null value received in ExternalRuntimeProblem.evaluate");
        }
        ArrayList<Double> fitList = new ArrayList<Double>();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(this.command);
        if (this.additionalArg != null && this.additionalArg.length() > 0) {
            parameters.add(this.additionalArg);
        }
        for (int i = 0; i < this.problemDimension; ++i) {
            String p = this.prepareParameter(x, i);
            parameters.add(p);
        }
        List<String> res = ExternalRuntimeProblem.runProcess(parameters, this.workingDir);
        try {
            for (String str : res) {
                fitList.add(new Double(str));
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Error: " + this.command + " delivered malformatted output for " + BeanInspector.toString(x));
            e.printStackTrace();
        }
        double[] fit = new double[fitList.size()];
        for (int i = 0; i < fit.length; ++i) {
            fit[i] = (Double)fitList.get(i);
        }
        return fit;
    }

    protected String prepareParameter(double[] x, int i) {
        return "" + x[i];
    }

    @Override
    public String getStringRepresentationForProblem(InterfaceOptimizer opt) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("External Runtime Problem:\n");
        sb.append("Here the individual codes a vector of real number x is to be minimized on a user given external problem.\nParameters:\n");
        sb.append("Dimension   : ");
        sb.append(this.problemDimension);
        return sb.toString();
    }

    @Override
    public String getName() {
        return "External Runtime Problem";
    }

    public String[] getGOEPropertyUpdateLinks() {
        return new String[]{"problemDimension", "initialRange", "problemDimension", "range"};
    }

    @Override
    public void setProblemDimension(int t) {
        this.problemDimension = t;
        this.range.adaptRowCount(t);
        this.initializationRange.adaptRowCount(t);
    }

    public void setCommand(String t) {
        this.command = t;
    }

    public String getCommand() {
        return this.command;
    }

    public String commandTipText() {
        return "External command to be called for evaluation";
    }

    public void setWorkingDirectory(String t) {
        this.workingDir = t;
    }

    public String getWorkingDirectory() {
        return this.workingDir;
    }

    public String workingDirectoryTipText() {
        return "The working directory";
    }

    public InterfaceMOSOConverter getMosoConverter() {
        return this.mosoConverter;
    }

    public void setMosoConverter(InterfaceMOSOConverter mMosoConverter) {
        this.mosoConverter = mMosoConverter;
    }

    public String mosoConverterTipText() {
        return "Possible conversion of multi-objective fitness to single objective fitness.";
    }

    public void setEAIndividual(InterfaceDataTypeDouble indy) {
        this.template = (AbstractEAIndividual)((Object)indy);
    }

    @Override
    public InterfaceDataTypeDouble getEAIndividual() {
        return (InterfaceDataTypeDouble)((Object)this.template);
    }

    @Override
    public double functionValue(double[] point) {
        return this.evaluate(this.project2DPoint(point))[0];
    }

    @Override
    public double[] project2DPoint(double[] point) {
        return Mathematics.expandVector(point, this.getProblemDimension(), 0.0);
    }

    @Override
    public double[][] get2DBorder() {
        return this.getRange().getDoubleArrayShallow();
    }

    public String additionalArgumentTipText() {
        return "Optionally define an additional (first) argument for the command line command.";
    }

    public String getAdditionalArgument() {
        return this.additionalArg;
    }

    public void setAdditionalArgument(String additionalArg) {
        this.additionalArg = additionalArg;
    }

    @Override
    public Object getInitializationRange() {
        if (this.initializationRange == null) {
            if (this.range == null) {
                System.err.println("Warning, neither range nor initRange has been set in ExternalRuntimeProblem!");
            }
            return this.range.getDoubleArrayShallow();
        }
        return this.initializationRange.getDoubleArrayShallow();
    }

    public void setInitialRange(double[][] range) {
        PropertyDoubleArray pRange = new PropertyDoubleArray(range);
        this.setInitialRange(pRange);
    }

    public void setInitialRange(PropertyDoubleArray range) {
        if (range.getNumRows() < this.problemDimension) {
            System.err.println("Warning, expected range of dimension " + this.problemDimension + " in setInitRange!");
        }
        this.initializationRange = new PropertyDoubleArray(range);
    }

    public PropertyDoubleArray getInitialRange() {
        return this.initializationRange;
    }

    public String initialRangeTipText() {
        return "Initialization range for the problem";
    }

    public String[] customPropertyOrder() {
        return new String[]{"workingDirectory", "command", "additionalArgument", "problemDimension", "initialRange", "range"};
    }

    private static class MonitorInputStreamThread
    extends Thread {
        private Reader reader;
        private Writer writer;

        public MonitorInputStreamThread(InputStream in) {
            this.reader = new InputStreamReader(new BufferedInputStream(in));
            this.writer = new OutputStreamWriter(System.err);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.reader.read()) != -1) {
                    this.writer.write(c);
                    this.writer.flush();
                }
            }
            catch (IOException ioe) {
                System.err.println("IOException in MonitorInputStreamThread/ExternalRuntimeProblem: " + ioe.getMessage());
                ioe.printStackTrace(System.err);
            }
            finally {
                try {
                    this.reader.close();
                    this.writer.close();
                }
                catch (IOException e) {
                    System.err.println("IOException in MonitorInputStreamThread/ExternalRuntimeProblem: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

