/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Weierstrass-Mandelbrot Fractal Function")
public class F10Problem
extends AbstractProblemDoubleOffset
implements InterfaceMultimodalProblem,
Serializable {
    private double d = 1.5;
    private double b = 2.3;
    private int iterations = 20;

    public F10Problem() {
        this.template = new ESIndividualDoubleData();
    }

    public F10Problem(F10Problem b) {
        super(b);
        this.d = b.d;
        this.b = b.b;
        this.iterations = b.iterations;
    }

    @Override
    public Object clone() {
        return new F10Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[1];
        double c1 = this.calculateC(1.0);
        result[0] = this.yOffset;
        for (int i = 0; i < x.length - 1; ++i) {
            double xi = x[i] - this.xOffset;
            result[0] = result[0] + (this.calculateC(xi) / (c1 * Math.pow(Math.abs(xi), 2.0 - this.d)) + Math.pow(xi, 2.0) - 1.0);
        }
        return result;
    }

    private double calculateC(double x) {
        double result = 0.0;
        for (int i = -this.iterations; i < this.iterations + 1; ++i) {
            result += (1.0 - Math.cos(Math.pow(this.b, i) * x)) / Math.pow(this.b, (2.0 - this.d) * (double)i);
        }
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F10 Weierstrass-Mandelbrot Fractal Function:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Weierstrass-Mandelbrot Fractal";
    }

    public void setD(double d) {
        if (d < 1.0) {
            d = 1.0;
        }
        if (d > 2.0) {
            d = 2.0;
        }
        this.d = d;
    }

    public double getD() {
        return this.d;
    }

    public String dTipText() {
        return "Set 1 < D < 2.";
    }

    public void setb(double b) {
        if (b < 1.000001) {
            b = 1.000001;
        }
        this.b = b;
    }

    public double getb() {
        return this.b;
    }

    public String bTipText() {
        return "Choose b > 1.";
    }

    public void setIterations(int iters) {
        if (iters < 2) {
            iters = 2;
        }
        this.iterations = iters;
    }

    public int getIterations() {
        return this.iterations;
    }

    public String iterationsTipText() {
        return "Choose the number of iterations per evaluation.";
    }
}

