/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Griewank Function")
public class F11Problem
extends AbstractProblemDoubleOffset
implements InterfaceMultimodalProblem,
Serializable {
    private double d = 4000.0;

    public F11Problem() {
        this.problemDimension = 10;
        this.template = new ESIndividualDoubleData();
        this.setDefaultRange(600.0);
    }

    public F11Problem(F11Problem b) {
        super(b);
        this.d = b.d;
    }

    @Override
    public Object clone() {
        return new F11Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[1];
        double tmpProd = 1.0;
        for (int i = 0; i < x.length; ++i) {
            double xi = x[i] - this.xOffset;
            result[0] = result[0] + Math.pow(xi, 2.0);
            tmpProd *= Math.cos(xi / Math.sqrt(i + 1));
        }
        result[0] = result[0] / this.d - tmpProd + 1.0 + this.yOffset;
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F11 Griewank Function:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        return result;
    }

    @Override
    public String getName() {
        return "Griewank";
    }

    public void setD(double d) {
        this.d = d;
    }

    public double getD() {
        return this.d;
    }

    public String dTipText() {
        return "Set D (=4000).";
    }
}

