/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.problems.AbstractProblemDoubleOffset;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Galar Function")
public class F12Problem
extends AbstractProblemDoubleOffset
implements Serializable {
    private static final double f12range = 5.0;

    public F12Problem() {
        this.setDefaultRange(5.0);
    }

    public F12Problem(F12Problem b) {
        super(b);
    }

    @Override
    public Object clone() {
        return new F12Problem(this);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[1];
        double tmp = 0.0;
        for (int i = 1; i < x.length - 1; ++i) {
            tmp += Math.pow(x[i] - this.xOffset, 2.0);
        }
        double x0 = x[0] - this.xOffset;
        result[0] = this.yOffset + (Math.exp(-5.0 * x0 * x0) + 2.0 * Math.exp(-5.0 * Math.pow(1.0 - x0, 2.0))) * Math.exp(-5.0 * tmp);
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F12 Galar:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public String getName() {
        return "Galar";
    }
}

