/*
 * Decompiled with CFR 0.152.
 */
package eva2.problems;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.operator.postprocess.SolutionHistogram;
import eva2.problems.AbstractProblemDoubleOffset;
import eva2.problems.InterfaceInterestingHistogram;
import eva2.problems.InterfaceMultimodalProblem;
import eva2.util.annotation.Description;

@Description(value="Schwefel's sine-root Function (multimodal, 1981). Remember to use range check! Note that rotating the function may make it easier because new, and better, minima may enter the search space.")
public class F13Problem
extends AbstractProblemDoubleOffset
implements InterfaceMultimodalProblem,
InterfaceInterestingHistogram {
    public F13Problem() {
        this.template = new ESIndividualDoubleData();
        this.setDefaultRange(500.0);
    }

    public F13Problem(F13Problem b) {
        super(b);
    }

    public F13Problem(int dim) {
        this.setProblemDimension(dim);
    }

    @Override
    public Object clone() {
        return new F13Problem(this);
    }

    @Override
    public double getRangeLowerBound(int dim) {
        return -500.0;
    }

    @Override
    public double getRangeUpperBound(int dim) {
        return 500.0;
    }

    @Override
    public void hideHideable() {
        super.hideHideable();
        GenericObjectEditor.setHideProperty(this.getClass(), "defaultRange", true);
    }

    @Override
    public double[] evaluate(double[] x) {
        x = this.rotateMaybe(x);
        double[] result = new double[]{this.yOffset};
        for (int i = 0; i < x.length; ++i) {
            double xi = x[i] - this.xOffset;
            result[0] = result[0] - xi * Math.sin(Math.sqrt(Math.abs(xi)));
        }
        result[0] = result[0] + 418.9829 * (double)this.problemDimension;
        return result;
    }

    public String getStringRepresentationForProblem() {
        String result = "";
        result = result + "F13 Schwefel:\n";
        result = result + "Parameters:\n";
        result = result + "Dimension   : " + this.problemDimension + "\n";
        result = result + "Noise level : " + this.getNoise() + "\n";
        result = result + "Solution representation:\n";
        return result;
    }

    @Override
    public SolutionHistogram getHistogram() {
        if (this.getProblemDimension() < 15) {
            return new SolutionHistogram(0.0, 800.0, 16);
        }
        if (this.getProblemDimension() < 25) {
            return new SolutionHistogram(0.0, 1600.0, 16);
        }
        return new SolutionHistogram(0.0, 3200.0, 12);
    }

    @Override
    public String getName() {
        return "Schwefel 2.26";
    }

    @Override
    public void setDefaultAccuracy(double v) {
        super.setDefaultAccuracy(v);
    }
}

